/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.routes.RouteManagerXml;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.setup.backup.AutoBackup;
import jmri.jmrit.operations.setup.backup.BackupDialog;
import jmri.jmrit.operations.setup.backup.RestoreDialog;
import jmri.jmrit.operations.setup.gui.Bundle;
import jmri.jmrit.operations.setup.gui.OperationsPreferencesPanel;
import jmri.jmrit.operations.setup.gui.OperationsSettingsFrame;
import jmri.util.swing.ExceptionDisplayFrame;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.UnexpectedExceptionContext;
import jmri.web.server.WebServerPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationsSettingsPanel
extends OperationsPreferencesPanel
implements PropertyChangeListener {
    private final JLabel textIconNorth = new JLabel(Bundle.getMessage("IconNorth"));
    private final JLabel textIconSouth = new JLabel(Bundle.getMessage("IconSouth"));
    private final JLabel textIconEast = new JLabel(Bundle.getMessage("IconEast"));
    private final JLabel textIconWest = new JLabel(Bundle.getMessage("IconWest"));
    private final JLabel textIconLocal = new JLabel(Bundle.getMessage("IconLocal"));
    private final JLabel textIconTerminate = new JLabel(Bundle.getMessage("IconTerminate"));
    private final JButton backupButton = new JButton(Bundle.getMessage("Backup"));
    private final JButton restoreButton = new JButton(Bundle.getMessage("Restore"));
    private final JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    private final JRadioButton scaleZ = new JRadioButton("Z");
    private final JRadioButton scaleN = new JRadioButton("N");
    private final JRadioButton scaleTT = new JRadioButton("TT");
    private final JRadioButton scaleHOn3 = new JRadioButton("HOn3");
    private final JRadioButton scaleOO = new JRadioButton("OO");
    private final JRadioButton scaleHO = new JRadioButton("HO");
    private final JRadioButton scaleSn3 = new JRadioButton("Sn3");
    private final JRadioButton scaleS = new JRadioButton("S");
    private final JRadioButton scaleOn3 = new JRadioButton("On3");
    private final JRadioButton scaleO = new JRadioButton("O");
    private final JRadioButton scaleG = new JRadioButton("G");
    private final JRadioButton typeDesc = new JRadioButton(Bundle.getMessage("Descriptive"));
    private final JRadioButton typeAAR = new JRadioButton(Bundle.getMessage("AAR"));
    private final JRadioButton feetUnit = new JRadioButton(Bundle.getMessage("Feet"));
    private final JRadioButton meterUnit = new JRadioButton(Bundle.getMessage("Meter"));
    final JCheckBox eastCheckBox = new JCheckBox(Bundle.getMessage("eastwest"));
    final JCheckBox northCheckBox = new JCheckBox(Bundle.getMessage("northsouth"));
    private final JCheckBox mainMenuCheckBox = new JCheckBox(Bundle.getMessage("MainMenu"));
    private final JCheckBox closeOnSaveCheckBox = new JCheckBox(Bundle.getMessage("CloseOnSave"));
    private final JCheckBox autoSaveCheckBox = new JCheckBox(Bundle.getMessage("AutoSave"));
    private final JCheckBox autoBackupCheckBox = new JCheckBox(Bundle.getMessage("AutoBackup"));
    private final JCheckBox iconCheckBox = new JCheckBox(Bundle.getMessage("trainIcon"));
    private final JCheckBox appendCheckBox = new JCheckBox(Bundle.getMessage("trainIconAppend"));
    JTextField panelTextField = new JTextField(30);
    JTextField railroadNameTextField = new JTextField(35);
    JTextField maxLengthTextField = new JTextField(5);
    JTextField maxEngineSizeTextField = new JTextField(3);
    JTextField hptTextField = new JTextField(3);
    JTextField switchTimeTextField = new JTextField(3);
    JTextField travelTimeTextField = new JTextField(3);
    JTextField yearTextField = new JTextField(4);
    private final JComboBox<String> northComboBox = new JComboBox();
    private final JComboBox<String> southComboBox = new JComboBox();
    private final JComboBox<String> eastComboBox = new JComboBox();
    private final JComboBox<String> westComboBox = new JComboBox();
    private final JComboBox<String> localComboBox = new JComboBox();
    private final JComboBox<String> terminateComboBox = new JComboBox();
    private final JTextArea commentTextArea = new JTextArea(2, 80);
    private static final Logger log = LoggerFactory.getLogger(OperationsSettingsPanel.class);

    public OperationsSettingsPanel() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        this.maxLengthTextField.setText(Integer.toString(Setup.getMaxTrainLength()));
        this.maxEngineSizeTextField.setText(Integer.toString(Setup.getMaxNumberEngines()));
        this.hptTextField.setText(Double.toString(Setup.getHorsePowerPerTon()));
        this.switchTimeTextField.setText(Integer.toString(Setup.getSwitchTime()));
        this.travelTimeTextField.setText(Integer.toString(Setup.getTravelTime()));
        this.panelTextField.setText(Setup.getPanelName());
        this.yearTextField.setText(Setup.getYearModeled());
        this.commentTextArea.setText(Setup.getComment());
        this.mainMenuCheckBox.setSelected(Setup.isMainMenuEnabled());
        this.closeOnSaveCheckBox.setSelected(Setup.isCloseWindowOnSaveEnabled());
        this.autoSaveCheckBox.setSelected(Setup.isAutoSaveEnabled());
        this.autoBackupCheckBox.setSelected(Setup.isAutoBackupEnabled());
        this.iconCheckBox.setSelected(Setup.isTrainIconCordEnabled());
        this.appendCheckBox.setSelected(Setup.isTrainIconAppendEnabled());
        this.backupButton.setToolTipText(Bundle.getMessage("BackupToolTip"));
        this.restoreButton.setToolTipText(Bundle.getMessage("RestoreToolTip"));
        this.saveButton.setToolTipText(Bundle.getMessage("SaveToolTip"));
        this.panelTextField.setToolTipText(Bundle.getMessage("EnterPanelName"));
        this.yearTextField.setToolTipText(Bundle.getMessage("EnterYearModeled"));
        this.autoSaveCheckBox.setToolTipText(Bundle.getMessage("AutoSaveTip"));
        this.autoBackupCheckBox.setToolTipText(Bundle.getMessage("AutoBackUpTip"));
        this.maxLengthTextField.setToolTipText(Bundle.getMessage("MaxLengthTip"));
        this.maxEngineSizeTextField.setToolTipText(Bundle.getMessage("MaxEngineTip"));
        this.hptTextField.setToolTipText(Bundle.getMessage("HPperTonTip"));
        this.switchTimeTextField.setToolTipText(Bundle.getMessage("SwitchTimeTip"));
        this.travelTimeTextField.setToolTipText(Bundle.getMessage("TravelTimeTip"));
        this.railroadNameTextField.setToolTipText(Bundle.getMessage("RailroadNameTip"));
        this.commentTextArea.setToolTipText(Bundle.getMessage("CommentTip"));
        this.setLayout(new BoxLayout(this, 1));
        JPanel panel = new JPanel();
        JScrollPane panelPane = new JScrollPane(panel);
        panel.setLayout(new BoxLayout(panel, 1));
        panelPane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel pRailroadName = new JPanel();
        pRailroadName.setLayout(new GridBagLayout());
        pRailroadName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RailroadName")));
        this.addItem(pRailroadName, this.railroadNameTextField, 0, 0);
        p1.add(pRailroadName);
        JPanel pTrainDir = new JPanel();
        pTrainDir.setLayout(new GridBagLayout());
        pTrainDir.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("direction")));
        this.addItemLeft(pTrainDir, this.northCheckBox, 1, 2);
        this.addItemLeft(pTrainDir, this.eastCheckBox, 2, 2);
        p1.add(pTrainDir);
        this.setDirectionCheckBox(Setup.getTrainDirection());
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, 0));
        JPanel pTrainLength = new JPanel();
        pTrainLength.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("MaxLength")));
        this.addItem(pTrainLength, this.maxLengthTextField, 0, 0);
        p3.add(pTrainLength);
        JPanel pMaxEngine = new JPanel();
        pMaxEngine.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("MaxEngine")));
        this.addItem(pMaxEngine, this.maxEngineSizeTextField, 0, 0);
        p3.add(pMaxEngine);
        JPanel pHPT = new JPanel();
        pHPT.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("HPT")));
        this.addItem(pHPT, this.hptTextField, 0, 0);
        p3.add(pHPT);
        JPanel pSwitchTime = new JPanel();
        pSwitchTime.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("MoveTime")));
        this.addItem(pSwitchTime, this.switchTimeTextField, 0, 0);
        p3.add(pSwitchTime);
        JPanel pTravelTime = new JPanel();
        pTravelTime.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TravelTime")));
        this.addItem(pTravelTime, this.travelTimeTextField, 0, 0);
        p3.add(pTravelTime);
        JPanel pScale = new JPanel();
        pScale.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Scale")));
        ButtonGroup scaleGroup = new ButtonGroup();
        scaleGroup.add(this.scaleZ);
        scaleGroup.add(this.scaleN);
        scaleGroup.add(this.scaleTT);
        scaleGroup.add(this.scaleHOn3);
        scaleGroup.add(this.scaleOO);
        scaleGroup.add(this.scaleHO);
        scaleGroup.add(this.scaleSn3);
        scaleGroup.add(this.scaleS);
        scaleGroup.add(this.scaleOn3);
        scaleGroup.add(this.scaleO);
        scaleGroup.add(this.scaleG);
        pScale.add(this.scaleZ);
        pScale.add(this.scaleN);
        pScale.add(this.scaleTT);
        pScale.add(this.scaleHOn3);
        pScale.add(this.scaleOO);
        pScale.add(this.scaleHO);
        pScale.add(this.scaleSn3);
        pScale.add(this.scaleS);
        pScale.add(this.scaleOn3);
        pScale.add(this.scaleO);
        pScale.add(this.scaleG);
        this.setScale();
        JPanel p9 = new JPanel();
        p9.setLayout(new BoxLayout(p9, 0));
        JPanel pCarTypeButtons = new JPanel();
        pCarTypeButtons.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CarTypes")));
        ButtonGroup carTypeGroup = new ButtonGroup();
        carTypeGroup.add(this.typeDesc);
        carTypeGroup.add(this.typeAAR);
        pCarTypeButtons.add(this.typeDesc);
        pCarTypeButtons.add(this.typeAAR);
        p9.add(pCarTypeButtons);
        this.setCarTypes();
        JPanel pLengthUnit = new JPanel();
        pLengthUnit.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLength")));
        ButtonGroup lengthUnitGroup = new ButtonGroup();
        lengthUnitGroup.add(this.feetUnit);
        lengthUnitGroup.add(this.meterUnit);
        pLengthUnit.add(this.feetUnit);
        pLengthUnit.add(this.meterUnit);
        p9.add(pLengthUnit);
        this.setLengthUnit();
        JPanel pYearModeled = new JPanel();
        pYearModeled.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutYearModeled")));
        pYearModeled.add(this.yearTextField);
        p9.add(pYearModeled);
        JPanel options = new JPanel();
        options.setLayout(new GridBagLayout());
        options.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOptions")));
        this.addItem(options, this.mainMenuCheckBox, 0, 0);
        this.addItem(options, this.closeOnSaveCheckBox, 1, 0);
        this.addItem(options, this.autoSaveCheckBox, 2, 0);
        this.addItem(options, this.autoBackupCheckBox, 3, 0);
        panel.add(p1);
        panel.add(pScale);
        panel.add(p3);
        panel.add(p9);
        JPanel pIcon = new JPanel();
        pIcon.setLayout(new BoxLayout(pIcon, 1));
        JScrollPane pIconPane = new JScrollPane(pIcon);
        pIconPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutPanelOptions")));
        JPanel p1Icon = new JPanel();
        p1Icon.setLayout(new BoxLayout(p1Icon, 0));
        JPanel pPanelName = new JPanel();
        pPanelName.setLayout(new GridBagLayout());
        pPanelName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutPanelName")));
        this.addItem(pPanelName, this.panelTextField, 0, 0);
        p1Icon.add(pPanelName);
        JPanel pIconControl = new JPanel();
        pIconControl.setLayout(new GridBagLayout());
        pIconControl.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutIconOptions")));
        this.addItem(pIconControl, this.appendCheckBox, 0, 0);
        this.addItem(pIconControl, this.iconCheckBox, 1, 0);
        p1Icon.add(pIconControl);
        pIcon.add(p1Icon);
        JPanel pIconColors = new JPanel();
        pIconColors.setLayout(new GridBagLayout());
        pIconColors.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutIconColors")));
        this.textIconNorth.setLabelFor(this.northComboBox);
        this.addItem(pIconColors, this.textIconNorth, 0, 4);
        this.addItemLeft(pIconColors, this.northComboBox, 1, 4);
        this.textIconSouth.setLabelFor(this.southComboBox);
        this.addItem(pIconColors, this.textIconSouth, 0, 5);
        this.addItemLeft(pIconColors, this.southComboBox, 1, 5);
        this.textIconEast.setLabelFor(this.eastComboBox);
        this.addItem(pIconColors, this.textIconEast, 0, 8);
        this.addItemLeft(pIconColors, this.eastComboBox, 1, 8);
        this.textIconWest.setLabelFor(this.westComboBox);
        this.addItem(pIconColors, this.textIconWest, 0, 9);
        this.addItemLeft(pIconColors, this.westComboBox, 1, 9);
        this.textIconLocal.setLabelFor(this.localComboBox);
        this.addItem(pIconColors, this.textIconLocal, 0, 10);
        this.addItemLeft(pIconColors, this.localComboBox, 1, 10);
        this.textIconTerminate.setLabelFor(this.terminateComboBox);
        this.addItem(pIconColors, this.textIconTerminate, 0, 11);
        this.addItemLeft(pIconColors, this.terminateComboBox, 1, 11);
        pIcon.add(pIconColors);
        this.loadIconComboBox(this.northComboBox);
        this.loadIconComboBox(this.southComboBox);
        this.loadIconComboBox(this.eastComboBox);
        this.loadIconComboBox(this.westComboBox);
        this.loadIconComboBox(this.localComboBox);
        this.loadIconComboBox(this.terminateComboBox);
        this.northComboBox.setSelectedItem(Setup.getTrainIconColorNorth());
        this.southComboBox.setSelectedItem(Setup.getTrainIconColorSouth());
        this.eastComboBox.setSelectedItem(Setup.getTrainIconColorEast());
        this.westComboBox.setSelectedItem(Setup.getTrainIconColorWest());
        this.localComboBox.setSelectedItem(Setup.getTrainIconColorLocal());
        this.terminateComboBox.setSelectedItem(Setup.getTrainIconColorTerminate());
        JPanel pC = new JPanel();
        pC.setLayout(new GridBagLayout());
        pC.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Comment")));
        JScrollPane commentScroller = new JScrollPane(this.commentTextArea, 20, 30);
        this.addItem(pC, commentScroller, 0, 0);
        pIcon.add(pC);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        this.addItem(pControl, this.restoreButton, 0, 9);
        this.addItem(pControl, this.backupButton, 1, 9);
        this.addItem(pControl, this.saveButton, 3, 9);
        this.add(panelPane);
        this.add(options);
        this.add(pIconPane);
        this.add(pControl);
        this.addButtonAction(this.backupButton);
        this.addButtonAction(this.restoreButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.eastCheckBox);
        this.addCheckBoxAction(this.northCheckBox);
        this.railroadNameTextField.setText(Setup.getRailroadName());
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.backupButton) {
            BackupDialog bd = new BackupDialog();
            bd.pack();
            bd.setLocationRelativeTo(null);
            bd.setVisible(true);
        }
        if (ae.getSource() == this.restoreButton) {
            RestoreDialog rd = new RestoreDialog();
            rd.pack();
            rd.setLocationRelativeTo(null);
            rd.setVisible(true);
        }
        if (ae.getSource() == this.saveButton) {
            this.save();
        }
    }

    private void save() {
        int maxTrainLength;
        try {
            maxTrainLength = Integer.parseInt(this.maxLengthTextField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MaxLength"), Bundle.getMessage("CanNotAcceptNumber"), 0);
            return;
        }
        if (maxTrainLength != Setup.getMaxTrainLength() && (maxTrainLength < 500 && Setup.getLengthUnit().equals(Setup.FEET) || maxTrainLength < 160 && Setup.getLengthUnit().equals(Setup.METER))) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LimitTrainLength", maxTrainLength, Setup.getLengthUnit().toLowerCase()), Bundle.getMessage("WarningTooShort"), 2);
        }
        try {
            Integer.parseInt(this.maxEngineSizeTextField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MaxEngine"), Bundle.getMessage("CanNotAcceptNumber"), 0);
            return;
        }
        try {
            Double.parseDouble(this.hptTextField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("HPT"), Bundle.getMessage("CanNotAcceptNumber"), 0);
            return;
        }
        try {
            Integer.parseInt(this.switchTimeTextField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("MoveTime"), Bundle.getMessage("CanNotAcceptNumber"), 0);
            return;
        }
        try {
            Integer.parseInt(this.travelTimeTextField.getText());
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TravelTime"), Bundle.getMessage("CanNotAcceptNumber"), 0);
            return;
        }
        try {
            if (!this.yearTextField.getText().trim().isEmpty()) {
                Integer.parseInt(this.yearTextField.getText().trim());
            }
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("BorderLayoutYearModeled"), Bundle.getMessage("CanNotAcceptNumber"), 0);
            return;
        }
        this.checkRoutes();
        if (this.typeDesc.isSelected() && !Setup.getCarTypes().equals(Setup.DESCRIPTIVE) || this.typeAAR.isSelected() && !Setup.getCarTypes().equals(Setup.AAR)) {
            AutoBackup backup = new AutoBackup();
            try {
                backup.autoBackup();
            }
            catch (IOException ex) {
                UnexpectedExceptionContext context = new UnexpectedExceptionContext(ex, "Auto backup before changing Car types");
                ExceptionDisplayFrame.displayExceptionDisplayFrame((Component)this, context);
            }
            if (this.typeDesc.isSelected()) {
                InstanceManager.getDefault(CarTypes.class).changeDefaultNames(Setup.DESCRIPTIVE);
                Setup.setCarTypes(Setup.DESCRIPTIVE);
            } else {
                InstanceManager.getDefault(CarTypes.class).changeDefaultNames(Setup.AAR);
                Setup.setCarTypes(Setup.AAR);
            }
            OperationsXml.save();
        }
        Setup.setMainMenuEnabled(this.mainMenuCheckBox.isSelected());
        Setup.setCloseWindowOnSaveEnabled(this.closeOnSaveCheckBox.isSelected());
        Setup.setAutoSaveEnabled(this.autoSaveCheckBox.isSelected());
        Setup.setAutoBackupEnabled(this.autoBackupCheckBox.isSelected());
        Setup.setPanelName(this.panelTextField.getText());
        Setup.setTrainIconCordEnabled(this.iconCheckBox.isSelected());
        Setup.setTrainIconAppendEnabled(this.appendCheckBox.isSelected());
        Setup.setTrainIconColorNorth((String)this.northComboBox.getSelectedItem());
        Setup.setTrainIconColorSouth((String)this.southComboBox.getSelectedItem());
        Setup.setTrainIconColorEast((String)this.eastComboBox.getSelectedItem());
        Setup.setTrainIconColorWest((String)this.westComboBox.getSelectedItem());
        Setup.setTrainIconColorLocal((String)this.localComboBox.getSelectedItem());
        Setup.setTrainIconColorTerminate((String)this.terminateComboBox.getSelectedItem());
        int direction = 0;
        if (this.eastCheckBox.isSelected()) {
            direction = 3;
        }
        if (this.northCheckBox.isSelected()) {
            direction += 12;
        }
        Setup.setTrainDirection(direction);
        Setup.setMaxNumberEngines(Integer.parseInt(this.maxEngineSizeTextField.getText()));
        Setup.setHorsePowerPerTon(Double.parseDouble(this.hptTextField.getText()));
        Setup.setSwitchTime(Integer.parseInt(this.switchTimeTextField.getText()));
        Setup.setTravelTime(Integer.parseInt(this.travelTimeTextField.getText()));
        Setup.setScale(this.getSelectedScale());
        if (!this.railroadNameTextField.getText().equals(InstanceManager.getDefault(WebServerPreferences.class).getRailroadName())) {
            Setup.setRailroadName(this.railroadNameTextField.getText());
            int results = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ChangeRailroadName", InstanceManager.getDefault(WebServerPreferences.class).getRailroadName(), Setup.getRailroadName()), Bundle.getMessage("ChangeJMRIRailroadName"), 0);
            if (results == 0) {
                InstanceManager.getDefault(WebServerPreferences.class).setRailroadName(Setup.getRailroadName());
                InstanceManager.getDefault(WebServerPreferences.class).save();
            }
        }
        if (this.feetUnit.isSelected()) {
            Setup.setLengthUnit(Setup.FEET);
        }
        if (this.meterUnit.isSelected()) {
            Setup.setLengthUnit(Setup.METER);
        }
        Setup.setYearModeled(this.yearTextField.getText().trim());
        Setup.setMaxTrainLength(Integer.parseInt(this.maxLengthTextField.getText()));
        Setup.setComment(this.commentTextArea.getText());
        InstanceManager.getDefault(OperationsSetupXml.class).writeOperationsFile();
        Container topLevelAncestor = this.getTopLevelAncestor();
        if (Setup.isCloseWindowOnSaveEnabled() && topLevelAncestor instanceof OperationsSettingsFrame) {
            ((OperationsSettingsFrame)topLevelAncestor).dispose();
        }
    }

    private void checkRoutes() {
        int maxLength = Integer.parseInt(this.maxLengthTextField.getText());
        if (maxLength > Setup.getMaxTrainLength()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("RouteLengthNotModified"), Bundle.getMessage("MaxTrainLengthIncreased", maxLength, Setup.getLengthUnit().toLowerCase()), 1);
        }
        if (maxLength < Setup.getMaxTrainLength()) {
            StringBuilder sb = new StringBuilder();
            List<Route> routes = InstanceManager.getDefault(RouteManager.class).getRoutesByNameList();
            int count = 0;
            for (Route route2 : routes) {
                for (RouteLocation rl : route2.getLocationsBySequenceList()) {
                    if (rl.getMaxTrainLength() <= maxLength) continue;
                    String s = Bundle.getMessage("RouteMaxLengthExceeds", route2.getName(), rl.getName(), rl.getMaxTrainLength(), maxLength);
                    log.info(s);
                    sb.append(s).append("\n");
                    ++count;
                    break;
                }
                if (count <= 20) continue;
                sb.append(Bundle.getMessage("More")).append("\n");
                break;
            }
            if (sb.length() > 0) {
                JmriJOptionPane.showMessageDialog(this, sb.toString(), Bundle.getMessage("YouNeedToAdjustRoutes"), 2);
                if (JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("ChangeMaximumTrainDepartureLength", maxLength), Bundle.getMessage("ModifyAllRoutes"), 0) == 0) {
                    routes.stream().forEach(route -> route.getLocationsBySequenceList().stream().filter(rl -> rl.getMaxTrainLength() > maxLength).map(rl -> {
                        log.debug("Setting route ({}) routeLocation ({}) max traim length to {}", new Object[]{route.getName(), rl.getName(), maxLength});
                        return rl;
                    }).forEach(rl -> rl.setMaxTrainLength(maxLength)));
                    InstanceManager.getDefault(RouteManagerXml.class).writeOperationsFile();
                }
            }
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.northCheckBox && !this.northCheckBox.isSelected()) {
            this.eastCheckBox.setSelected(true);
        }
        if (ae.getSource() == this.eastCheckBox && !this.eastCheckBox.isSelected()) {
            this.northCheckBox.setSelected(true);
        }
        int direction = 0;
        if (this.eastCheckBox.isSelected()) {
            ++direction;
        }
        if (this.northCheckBox.isSelected()) {
            direction += 4;
        }
        this.setDirectionCheckBox(direction);
    }

    private void setScale() {
        switch (Setup.getScale()) {
            case 1: {
                this.scaleZ.setSelected(true);
                break;
            }
            case 2: {
                this.scaleN.setSelected(true);
                break;
            }
            case 3: {
                this.scaleTT.setSelected(true);
                break;
            }
            case 4: {
                this.scaleHOn3.setSelected(true);
                break;
            }
            case 5: {
                this.scaleOO.setSelected(true);
                break;
            }
            case 6: {
                this.scaleHO.setSelected(true);
                break;
            }
            case 7: {
                this.scaleSn3.setSelected(true);
                break;
            }
            case 8: {
                this.scaleS.setSelected(true);
                break;
            }
            case 9: {
                this.scaleOn3.setSelected(true);
                break;
            }
            case 10: {
                this.scaleO.setSelected(true);
                break;
            }
            case 11: {
                this.scaleG.setSelected(true);
                break;
            }
            default: {
                log.error("Unknown scale");
            }
        }
    }

    private int getSelectedScale() {
        int scale = 0;
        if (this.scaleZ.isSelected()) {
            scale = 1;
        }
        if (this.scaleN.isSelected()) {
            scale = 2;
        }
        if (this.scaleTT.isSelected()) {
            scale = 3;
        }
        if (this.scaleOO.isSelected()) {
            scale = 5;
        }
        if (this.scaleHOn3.isSelected()) {
            scale = 4;
        }
        if (this.scaleHO.isSelected()) {
            scale = 6;
        }
        if (this.scaleSn3.isSelected()) {
            scale = 7;
        }
        if (this.scaleS.isSelected()) {
            scale = 8;
        }
        if (this.scaleOn3.isSelected()) {
            scale = 9;
        }
        if (this.scaleO.isSelected()) {
            scale = 10;
        }
        if (this.scaleG.isSelected()) {
            scale = 11;
        }
        return scale;
    }

    private void setCarTypes() {
        this.typeDesc.setSelected(Setup.getCarTypes().equals(Setup.DESCRIPTIVE));
        this.typeAAR.setSelected(Setup.getCarTypes().equals(Setup.AAR));
    }

    private void setDirectionCheckBox(int direction) {
        this.eastCheckBox.setSelected((direction & 1) == 1);
        this.textIconEast.setVisible((direction & 1) == 1);
        this.eastComboBox.setVisible((direction & 1) == 1);
        this.textIconWest.setVisible((direction & 1) == 1);
        this.westComboBox.setVisible((direction & 1) == 1);
        this.northCheckBox.setSelected((direction & 4) == 4);
        this.textIconNorth.setVisible((direction & 4) == 4);
        this.northComboBox.setVisible((direction & 4) == 4);
        this.textIconSouth.setVisible((direction & 4) == 4);
        this.southComboBox.setVisible((direction & 4) == 4);
    }

    private void setLengthUnit() {
        this.feetUnit.setSelected(Setup.getLengthUnit().equals(Setup.FEET));
        this.meterUnit.setSelected(Setup.getLengthUnit().equals(Setup.METER));
    }

    private void loadIconComboBox(JComboBox<String> comboBox) {
        for (String color : LocoIcon.getLocoColors()) {
            comboBox.addItem(color);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("propertyChange ({}), new: ({})", (Object)e.getPropertyName(), e.getNewValue());
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("TitleOperationsSetup");
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        this.save();
    }

    @Override
    public boolean isDirty() {
        if (this.typeDesc.isSelected() && !Setup.getCarTypes().equals(Setup.DESCRIPTIVE) || this.typeAAR.isSelected() && !Setup.getCarTypes().equals(Setup.AAR) || Setup.isMainMenuEnabled() != this.mainMenuCheckBox.isSelected() || Setup.isCloseWindowOnSaveEnabled() != this.closeOnSaveCheckBox.isSelected() || Setup.isAutoSaveEnabled() != this.autoSaveCheckBox.isSelected() || Setup.isAutoBackupEnabled() != this.autoBackupCheckBox.isSelected() || !Setup.getPanelName().equals(this.panelTextField.getText()) || Setup.isTrainIconCordEnabled() != this.iconCheckBox.isSelected() || Setup.isTrainIconAppendEnabled() != this.appendCheckBox.isSelected() || Setup.isTrainIconCordEnabled() != this.iconCheckBox.isSelected() || Setup.isTrainIconAppendEnabled() != this.appendCheckBox.isSelected() || !Setup.getTrainIconColorNorth().equals(this.northComboBox.getSelectedItem()) || !Setup.getTrainIconColorSouth().equals(this.southComboBox.getSelectedItem()) || !Setup.getTrainIconColorEast().equals(this.eastComboBox.getSelectedItem()) || !Setup.getTrainIconColorWest().equals(this.westComboBox.getSelectedItem()) || !Setup.getTrainIconColorLocal().equals(this.localComboBox.getSelectedItem()) || !Setup.getTrainIconColorTerminate().equals(this.terminateComboBox.getSelectedItem()) || Setup.getMaxNumberEngines() != Integer.parseInt(this.maxEngineSizeTextField.getText()) || Setup.getHorsePowerPerTon() != (double)Integer.parseInt(this.hptTextField.getText()) || Setup.getSwitchTime() != Integer.parseInt(this.switchTimeTextField.getText()) || Setup.getTravelTime() != Integer.parseInt(this.travelTimeTextField.getText()) || !Setup.getYearModeled().equals(this.yearTextField.getText().trim()) || Setup.getMaxTrainLength() != Integer.parseInt(this.maxLengthTextField.getText()) || !Setup.getComment().equals(this.commentTextArea.getText())) {
            return true;
        }
        int direction = 0;
        if (this.eastCheckBox.isSelected()) {
            direction = 3;
        }
        if (this.northCheckBox.isSelected()) {
            direction += 12;
        }
        int scale = this.getSelectedScale();
        String lengthUnit = "";
        if (this.feetUnit.isSelected()) {
            lengthUnit = Setup.FEET;
        }
        if (this.meterUnit.isSelected()) {
            lengthUnit = Setup.METER;
        }
        return Setup.getTrainDirection() != direction || Setup.getScale() != scale || !Setup.getRailroadName().equals(this.railroadNameTextField.getText()) || !Setup.getLengthUnit().equals(lengthUnit);
    }
}

