/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.setup.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.JobAttributes;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.setup.gui.Bundle;
import jmri.jmrit.operations.setup.gui.OperationsPreferencesPanel;
import jmri.jmrit.operations.setup.gui.PrintOptionFrame;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.FileUtil;
import jmri.util.swing.FontComboUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintOptionPanel
extends OperationsPreferencesPanel
implements PropertyChangeListener {
    private String ADD = "+";
    private String DELETE = "-";
    JLabel logoURL = new JLabel("");
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JButton addLogoButton = new JButton(Bundle.getMessage("AddLogo"));
    JButton removeLogoButton = new JButton(Bundle.getMessage("RemoveLogo"));
    JButton addEngPickupComboboxButton = new JButton(this.ADD);
    JButton deleteEngPickupComboboxButton = new JButton(this.DELETE);
    JButton addEngDropComboboxButton = new JButton(this.ADD);
    JButton deleteEngDropComboboxButton = new JButton(this.DELETE);
    JButton addCarPickupComboboxButton = new JButton(this.ADD);
    JButton deleteCarPickupComboboxButton = new JButton(this.DELETE);
    JButton addCarDropComboboxButton = new JButton(this.ADD);
    JButton deleteCarDropComboboxButton = new JButton(this.DELETE);
    JButton addLocalComboboxButton = new JButton(this.ADD);
    JButton deleteLocalComboboxButton = new JButton(this.DELETE);
    JButton addSwitchListPickupComboboxButton = new JButton(this.ADD);
    JButton deleteSwitchListPickupComboboxButton = new JButton(this.DELETE);
    JButton addSwitchListDropComboboxButton = new JButton(this.ADD);
    JButton deleteSwitchListDropComboboxButton = new JButton(this.DELETE);
    JButton addSwitchListLocalComboboxButton = new JButton(this.ADD);
    JButton deleteSwitchListLocalComboboxButton = new JButton(this.DELETE);
    JCheckBox tabFormatCheckBox = new JCheckBox(Bundle.getMessage("TabFormat"));
    JCheckBox formatSwitchListCheckBox = new JCheckBox(Bundle.getMessage("SameAsManifest"));
    JCheckBox editManifestCheckBox = new JCheckBox(Bundle.getMessage("UseTextEditor"));
    JCheckBox printLocCommentsCheckBox = new JCheckBox(Bundle.getMessage("PrintLocationComments"));
    JCheckBox printRouteCommentsCheckBox = new JCheckBox(Bundle.getMessage("PrintRouteComments"));
    JCheckBox printLoadsEmptiesCheckBox = new JCheckBox(Bundle.getMessage("PrintLoadsEmpties"));
    JCheckBox printCabooseLoadCheckBox = new JCheckBox(Bundle.getMessage("PrintCabooseLoad"));
    JCheckBox printPassengerLoadCheckBox = new JCheckBox(Bundle.getMessage("PrintPassengerLoad"));
    JCheckBox printTrainScheduleNameCheckBox = new JCheckBox(Bundle.getMessage("PrintTrainScheduleName"));
    JCheckBox use12hrFormatCheckBox = new JCheckBox(Bundle.getMessage("12hrFormat"));
    JCheckBox printValidCheckBox = new JCheckBox(Bundle.getMessage("PrintValid"));
    JCheckBox sortByTrackCheckBox = new JCheckBox(Bundle.getMessage("SortByTrack"));
    JCheckBox printHeadersCheckBox = new JCheckBox(Bundle.getMessage("PrintHeaders"));
    JCheckBox printPageHeaderCheckBox = new JCheckBox(Bundle.getMessage("PrintPageHeader"));
    JCheckBox truncateCheckBox = new JCheckBox(Bundle.getMessage("Truncate"));
    JCheckBox manifestDepartureTimeCheckBox = new JCheckBox(Bundle.getMessage("DepartureTime"));
    JCheckBox switchListDepartureTimeCheckBox = new JCheckBox(Bundle.getMessage("DepartureTime"));
    JCheckBox trackSummaryCheckBox = new JCheckBox(Bundle.getMessage("TrackSummary"));
    JCheckBox routeLocationCheckBox = new JCheckBox(Bundle.getMessage("RouteLocation"));
    JCheckBox groupCarMovesCheckBox = new JCheckBox(Bundle.getMessage("GroupCarMoves"));
    JCheckBox printLocoLastCheckBox = new JCheckBox(Bundle.getMessage("PrintLocoLast"));
    JTextField pickupEngPrefix = new JTextField(10);
    JTextField dropEngPrefix = new JTextField(10);
    JTextField pickupCarPrefix = new JTextField(10);
    JTextField dropCarPrefix = new JTextField(10);
    JTextField localPrefix = new JTextField(10);
    JTextField switchListPickupCarPrefix = new JTextField(10);
    JTextField switchListDropCarPrefix = new JTextField(10);
    JTextField switchListLocalPrefix = new JTextField(10);
    JTextField hazardousTextField = new JTextField(20);
    JTextArea commentTextArea = new JTextArea(2, 90);
    JScrollPane commentScroller = new JScrollPane(this.commentTextArea, 20, 30);
    JComboBox<String> fontComboBox = new JComboBox();
    JComboBox<String> manifestFormatComboBox = Setup.getManifestFormatComboBox();
    JComboBox<String> manifestOrientationComboBox = Setup.getOrientationComboBox();
    JComboBox<Integer> fontSizeComboBox = new JComboBox();
    JComboBox<String> switchListOrientationComboBox = Setup.getOrientationComboBox();
    JComboBox<JobAttributes.SidesType> printDuplexComboBox = new JComboBox();
    JColorChooser pickupEngineColorChooser = new JColorChooser();
    JColorChooser dropEngineColorChooser = new JColorChooser();
    JColorChooser pickupColorChooser = new JColorChooser();
    JColorChooser dropColorChooser = new JColorChooser();
    JColorChooser localColorChooser = new JColorChooser();
    JColorChooser missingCarColorChooser = new JColorChooser();
    List<JComboBox<String>> enginePickupMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> engineDropMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> carPickupMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> carDropMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> localMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> switchListCarPickupMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> switchListCarDropMessageList = new ArrayList<JComboBox<String>>();
    List<JComboBox<String>> switchListLocalMessageList = new ArrayList<JComboBox<String>>();
    JPanel pManifest = new JPanel();
    JPanel pEngPickup = new JPanel();
    JPanel pEngDrop = new JPanel();
    JPanel pPickup = new JPanel();
    JPanel pDrop = new JPanel();
    JPanel pLocal = new JPanel();
    JPanel pSwitchListOrientation = new JPanel();
    JPanel pSwPickup = new JPanel();
    JPanel pSwDrop = new JPanel();
    JPanel pSwLocal = new JPanel();
    JFileChooser fc = XmlFile.userFileChooser(Bundle.getMessage("Images"), new String[0]);
    private static final Logger log = LoggerFactory.getLogger(PrintOptionPanel.class);

    public PrintOptionPanel() {
        this.saveButton.setToolTipText(Bundle.getMessage("SaveToolTip"));
        this.addLogoButton.setToolTipText(Bundle.getMessage("AddLogoToolTip"));
        this.removeLogoButton.setToolTipText(Bundle.getMessage("RemoveLogoToolTip"));
        this.tabFormatCheckBox.setToolTipText(Bundle.getMessage("TabComment"));
        this.printLocCommentsCheckBox.setToolTipText(Bundle.getMessage("AddLocationComments"));
        this.printRouteCommentsCheckBox.setToolTipText(Bundle.getMessage("AddRouteComments"));
        this.printLoadsEmptiesCheckBox.setToolTipText(Bundle.getMessage("LoadsEmptiesComment"));
        this.printCabooseLoadCheckBox.setToolTipText(Bundle.getMessage("CabooseLoadTip"));
        this.printPassengerLoadCheckBox.setToolTipText(Bundle.getMessage("PassengerLoadTip"));
        this.printTrainScheduleNameCheckBox.setToolTipText(Bundle.getMessage("ShowTrainScheduleTip"));
        this.use12hrFormatCheckBox.setToolTipText(Bundle.getMessage("Use12hrFormatTip"));
        this.printValidCheckBox.setToolTipText(Bundle.getMessage("PrintValidTip"));
        this.sortByTrackCheckBox.setToolTipText(Bundle.getMessage("SortByTrackTip"));
        this.printHeadersCheckBox.setToolTipText(Bundle.getMessage("PrintHeadersTip"));
        this.printPageHeaderCheckBox.setToolTipText(Bundle.getMessage("PrintPageHeaderTip"));
        this.truncateCheckBox.setToolTipText(Bundle.getMessage("TruncateTip"));
        this.manifestDepartureTimeCheckBox.setToolTipText(Bundle.getMessage("DepartureTimeTip"));
        this.switchListDepartureTimeCheckBox.setToolTipText(Bundle.getMessage("SwitchListDepartureTimeTip"));
        this.routeLocationCheckBox.setToolTipText(Bundle.getMessage("RouteLocationTip"));
        this.editManifestCheckBox.setToolTipText(Bundle.getMessage("UseTextEditorTip"));
        this.trackSummaryCheckBox.setToolTipText(Bundle.getMessage("TrackSummaryTip"));
        this.groupCarMovesCheckBox.setToolTipText(Bundle.getMessage("GroupCarsTip"));
        this.printLocoLastCheckBox.setToolTipText(Bundle.getMessage("LocoLastTip"));
        this.addEngPickupComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteEngPickupComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addEngDropComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteEngDropComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addCarPickupComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteCarPickupComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addCarDropComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteCarDropComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addLocalComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteLocalComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addSwitchListPickupComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteSwitchListPickupComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addSwitchListDropComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteSwitchListDropComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.addSwitchListLocalComboboxButton.setToolTipText(Bundle.getMessage("AddMessageComboboxTip"));
        this.deleteSwitchListLocalComboboxButton.setToolTipText(Bundle.getMessage("DeleteMessageComboboxTip"));
        this.setLayout(new BoxLayout(this, 1));
        this.pManifest.setLayout(new BoxLayout(this.pManifest, 1));
        JScrollPane pManifestPane = new JScrollPane(this.pManifest);
        pManifestPane.setBorder(BorderFactory.createTitledBorder(""));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel pFont = new JPanel();
        pFont.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFont")));
        pFont.add(this.fontComboBox);
        JPanel pFontSize = new JPanel();
        pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
        pFontSize.add(this.fontSizeComboBox);
        JPanel pFormat = new JPanel();
        pFormat.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFormat")));
        pFormat.add(this.tabFormatCheckBox);
        pFormat.add(this.manifestFormatComboBox);
        JPanel pOrientation = new JPanel();
        pOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOrientation")));
        pOrientation.add(this.manifestOrientationComboBox);
        JPanel pDuplex = new JPanel();
        pDuplex.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutDuplex")));
        pDuplex.add(this.printDuplexComboBox);
        this.printDuplexComboBox.addItem(JobAttributes.SidesType.ONE_SIDED);
        this.printDuplexComboBox.addItem(JobAttributes.SidesType.TWO_SIDED_LONG_EDGE);
        this.printDuplexComboBox.addItem(JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE);
        p1.add(pFont);
        p1.add(pFontSize);
        p1.add(pFormat);
        p1.add(pOrientation);
        p1.add(pDuplex);
        JPanel pColor = new JPanel();
        pColor.setLayout(new BoxLayout(pColor, 0));
        pColor.add(PrintOptionPanel.getColorChooserPanel(Bundle.getMessage("BorderLayoutPickupEngineColor"), Setup.getPickupEngineColor(), this.pickupEngineColorChooser));
        pColor.add(PrintOptionPanel.getColorChooserPanel(Bundle.getMessage("BorderLayoutDropEngineColor"), Setup.getDropEngineColor(), this.dropEngineColorChooser));
        pColor.add(PrintOptionPanel.getColorChooserPanel(Bundle.getMessage("BorderLayoutPickupColor"), Setup.getPickupColor(), this.pickupColorChooser));
        pColor.add(PrintOptionPanel.getColorChooserPanel(Bundle.getMessage("BorderLayoutDropColor"), Setup.getDropColor(), this.dropColorChooser));
        pColor.add(PrintOptionPanel.getColorChooserPanel(Bundle.getMessage("BorderLayoutLocalColor"), Setup.getLocalColor(), this.localColorChooser));
        this.loadFormatComboBox();
        JPanel pSl = new JPanel();
        pSl.setLayout(new BoxLayout(pSl, 0));
        JPanel pSwitchFormat = new JPanel();
        pSwitchFormat.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListFormat")));
        pSwitchFormat.add(this.formatSwitchListCheckBox);
        this.pSwitchListOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListOrientation")));
        this.pSwitchListOrientation.add(this.switchListOrientationComboBox);
        pSl.add(pSwitchFormat);
        pSl.add(this.pSwitchListOrientation);
        JPanel pM = new JPanel();
        pM.setLayout(new BoxLayout(pM, 0));
        JPanel pSwitchOptions = new JPanel();
        pSwitchOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListOptions")));
        pSwitchOptions.add(this.trackSummaryCheckBox);
        pSwitchOptions.add(this.routeLocationCheckBox);
        pSwitchOptions.add(this.switchListDepartureTimeCheckBox);
        JPanel pManifestOptions = new JPanel();
        pManifestOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutManifestOptions")));
        pManifestOptions.add(this.printLocCommentsCheckBox);
        pManifestOptions.add(this.printRouteCommentsCheckBox);
        pManifestOptions.add(this.manifestDepartureTimeCheckBox);
        pManifestOptions.add(this.truncateCheckBox);
        pM.add(pSwitchOptions);
        pM.add(pManifestOptions);
        JPanel pManifestSwtichListOptions = new JPanel();
        pManifestSwtichListOptions.setLayout(new GridBagLayout());
        pManifestSwtichListOptions.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutManifestSwitchListOptions")));
        this.addItemLeft(pManifestSwtichListOptions, this.printValidCheckBox, 0, 0);
        this.addItemLeft(pManifestSwtichListOptions, this.printLoadsEmptiesCheckBox, 1, 0);
        this.addItemLeft(pManifestSwtichListOptions, this.groupCarMovesCheckBox, 2, 0);
        this.addItemLeft(pManifestSwtichListOptions, this.printLocoLastCheckBox, 3, 0);
        this.addItemLeft(pManifestSwtichListOptions, this.printCabooseLoadCheckBox, 4, 0);
        this.addItemLeft(pManifestSwtichListOptions, this.printPassengerLoadCheckBox, 5, 0);
        this.addItemLeft(pManifestSwtichListOptions, this.use12hrFormatCheckBox, 0, 1);
        this.addItemLeft(pManifestSwtichListOptions, this.printTrainScheduleNameCheckBox, 1, 1);
        this.addItemLeft(pManifestSwtichListOptions, this.sortByTrackCheckBox, 2, 1);
        this.addItemLeft(pManifestSwtichListOptions, this.printHeadersCheckBox, 3, 1);
        this.addItemLeft(pManifestSwtichListOptions, this.printPageHeaderCheckBox, 4, 1);
        JPanel p2 = new JPanel();
        p2.setLayout(new BoxLayout(p2, 0));
        JPanel pEdit = new JPanel();
        pEdit.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutManifestPreview")));
        pEdit.add(this.editManifestCheckBox);
        JPanel pLogo = new JPanel();
        pLogo.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLogo")));
        pLogo.add(this.removeLogoButton);
        pLogo.add(this.addLogoButton);
        pLogo.add(this.logoURL);
        JPanel pHazardous = new JPanel();
        pHazardous.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutHazardous")));
        pHazardous.add(this.hazardousTextField);
        p2.add(pEdit);
        p2.add(pLogo);
        p2.add(pHazardous);
        JPanel pCommentMia = new JPanel();
        pCommentMia.setLayout(new GridBagLayout());
        pCommentMia.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutCommentOptions")));
        this.addItem(pCommentMia, this.commentScroller, 0, 0);
        this.addItem(pCommentMia, PrintOptionPanel.getColorChooserPanel(Setup.getMiaComment(), this.missingCarColorChooser), 2, 0);
        this.pManifest.add(p1);
        this.pManifest.add(pColor);
        this.pManifest.add(this.pEngPickup);
        this.pManifest.add(this.pEngDrop);
        this.pManifest.add(this.pPickup);
        this.pManifest.add(this.pDrop);
        this.pManifest.add(this.pLocal);
        this.pManifest.add(pSl);
        this.pManifest.add(this.pSwPickup);
        this.pManifest.add(this.pSwDrop);
        this.pManifest.add(this.pSwLocal);
        this.pManifest.add(pM);
        this.pManifest.add(pManifestSwtichListOptions);
        this.pManifest.add(p2);
        this.pManifest.add(pCommentMia);
        JPanel pControl = new JPanel();
        pControl.setBorder(BorderFactory.createTitledBorder(""));
        pControl.setLayout(new GridBagLayout());
        this.addItem(pControl, this.saveButton, 0, 0);
        this.add(pManifestPane);
        this.add(pControl);
        this.manifestFormatComboBox.setSelectedItem(Setup.getManifestFormat());
        this.manifestOrientationComboBox.setSelectedItem(Setup.getManifestOrientation());
        this.switchListOrientationComboBox.setSelectedItem(Setup.getSwitchListOrientation());
        this.tabFormatCheckBox.setSelected(Setup.isTabEnabled());
        this.printDuplexComboBox.setSelectedItem(Setup.getPrintDuplexSides());
        this.formatSwitchListCheckBox.setSelected(Setup.isSwitchListFormatSameAsManifest());
        this.printLocCommentsCheckBox.setSelected(Setup.isPrintLocationCommentsEnabled());
        this.printRouteCommentsCheckBox.setSelected(Setup.isPrintRouteCommentsEnabled());
        this.printLoadsEmptiesCheckBox.setSelected(Setup.isPrintLoadsAndEmptiesEnabled());
        this.printCabooseLoadCheckBox.setSelected(Setup.isPrintCabooseLoadEnabled());
        this.printPassengerLoadCheckBox.setSelected(Setup.isPrintPassengerLoadEnabled());
        this.printTrainScheduleNameCheckBox.setSelected(Setup.isPrintTrainScheduleNameEnabled());
        this.use12hrFormatCheckBox.setSelected(Setup.is12hrFormatEnabled());
        this.printValidCheckBox.setSelected(Setup.isPrintValidEnabled());
        this.sortByTrackCheckBox.setSelected(Setup.isSortByTrackNameEnabled());
        this.printPageHeaderCheckBox.setSelected(Setup.isPrintPageHeaderEnabled());
        this.printHeadersCheckBox.setSelected(Setup.isPrintHeadersEnabled());
        this.truncateCheckBox.setSelected(Setup.isPrintTruncateManifestEnabled());
        this.manifestDepartureTimeCheckBox.setSelected(Setup.isUseDepartureTimeEnabled());
        this.trackSummaryCheckBox.setSelected(Setup.isPrintTrackSummaryEnabled());
        this.trackSummaryCheckBox.setEnabled(Setup.isSwitchListRealTime());
        this.routeLocationCheckBox.setSelected(Setup.isSwitchListRouteLocationCommentEnabled());
        this.switchListDepartureTimeCheckBox.setSelected(Setup.isUseSwitchListDepartureTimeEnabled());
        this.editManifestCheckBox.setSelected(Setup.isManifestEditorEnabled());
        this.groupCarMovesCheckBox.setSelected(Setup.isGroupCarMovesEnabled());
        this.printLocoLastCheckBox.setSelected(Setup.isPrintLocoLastEnabled());
        this.commentTextArea.setText(TrainCommon.getTextColorString(Setup.getMiaComment()));
        this.hazardousTextField.setText(Setup.getHazardousMsg());
        this.setSwitchListVisible(!this.formatSwitchListCheckBox.isSelected());
        this.updateLogoButtons();
        this.loadFontSizeComboBox();
        this.loadFontComboBox();
        this.addButtonAction(this.addLogoButton);
        this.addButtonAction(this.removeLogoButton);
        this.addButtonAction(this.saveButton);
        this.addButtonAction(this.addEngPickupComboboxButton);
        this.addButtonAction(this.deleteEngPickupComboboxButton);
        this.addButtonAction(this.addEngDropComboboxButton);
        this.addButtonAction(this.deleteEngDropComboboxButton);
        this.addButtonAction(this.addCarPickupComboboxButton);
        this.addButtonAction(this.deleteCarPickupComboboxButton);
        this.addButtonAction(this.addCarDropComboboxButton);
        this.addButtonAction(this.deleteCarDropComboboxButton);
        this.addButtonAction(this.addLocalComboboxButton);
        this.addButtonAction(this.deleteLocalComboboxButton);
        this.addButtonAction(this.addSwitchListPickupComboboxButton);
        this.addButtonAction(this.deleteSwitchListPickupComboboxButton);
        this.addButtonAction(this.addSwitchListDropComboboxButton);
        this.addButtonAction(this.deleteSwitchListDropComboboxButton);
        this.addButtonAction(this.addSwitchListLocalComboboxButton);
        this.addButtonAction(this.deleteSwitchListLocalComboboxButton);
        this.addCheckBoxAction(this.tabFormatCheckBox);
        this.addCheckBoxAction(this.formatSwitchListCheckBox);
        this.addCheckBoxAction(this.truncateCheckBox);
        this.addComboBoxAction(this.manifestFormatComboBox);
        Setup.getDefault().addPropertyChangeListener(this);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addLogoButton) {
            log.debug("add logo button pressed");
            File f = this.selectFile();
            if (f != null) {
                Setup.setManifestLogoURL(FileUtil.getPortableFilename(f));
            }
            this.updateLogoButtons();
        }
        if (ae.getSource() == this.removeLogoButton) {
            log.debug("remove logo button pressed");
            Setup.setManifestLogoURL("");
            this.updateLogoButtons();
        }
        if (ae.getSource() == this.addEngPickupComboboxButton) {
            this.addComboBox(this.pEngPickup, this.enginePickupMessageList, Setup.getEngineMessageComboBox());
        }
        if (ae.getSource() == this.deleteEngPickupComboboxButton) {
            this.removeComboBox(this.pEngPickup, this.enginePickupMessageList);
        }
        if (ae.getSource() == this.addEngDropComboboxButton) {
            this.addComboBox(this.pEngDrop, this.engineDropMessageList, Setup.getEngineMessageComboBox());
        }
        if (ae.getSource() == this.deleteEngDropComboboxButton) {
            this.removeComboBox(this.pEngDrop, this.engineDropMessageList);
        }
        if (ae.getSource() == this.addCarPickupComboboxButton) {
            this.addComboBox(this.pPickup, this.carPickupMessageList, Setup.getCarMessageComboBox());
        }
        if (ae.getSource() == this.deleteCarPickupComboboxButton) {
            this.removeComboBox(this.pPickup, this.carPickupMessageList);
        }
        if (ae.getSource() == this.addCarDropComboboxButton) {
            this.addComboBox(this.pDrop, this.carDropMessageList, Setup.getCarMessageComboBox());
        }
        if (ae.getSource() == this.deleteCarDropComboboxButton) {
            this.removeComboBox(this.pDrop, this.carDropMessageList);
        }
        if (ae.getSource() == this.addLocalComboboxButton) {
            this.addComboBox(this.pLocal, this.localMessageList, Setup.getCarMessageComboBox());
        }
        if (ae.getSource() == this.deleteLocalComboboxButton) {
            this.removeComboBox(this.pLocal, this.localMessageList);
        }
        if (ae.getSource() == this.addSwitchListPickupComboboxButton) {
            this.addComboBox(this.pSwPickup, this.switchListCarPickupMessageList, Setup.getCarMessageComboBox());
        }
        if (ae.getSource() == this.deleteSwitchListPickupComboboxButton) {
            this.removeComboBox(this.pSwPickup, this.switchListCarPickupMessageList);
        }
        if (ae.getSource() == this.addSwitchListDropComboboxButton) {
            this.addComboBox(this.pSwDrop, this.switchListCarDropMessageList, Setup.getCarMessageComboBox());
        }
        if (ae.getSource() == this.deleteSwitchListDropComboboxButton) {
            this.removeComboBox(this.pSwDrop, this.switchListCarDropMessageList);
        }
        if (ae.getSource() == this.addSwitchListLocalComboboxButton) {
            this.addComboBox(this.pSwLocal, this.switchListLocalMessageList, Setup.getCarMessageComboBox());
        }
        if (ae.getSource() == this.deleteSwitchListLocalComboboxButton) {
            this.removeComboBox(this.pSwLocal, this.switchListLocalMessageList);
        }
        if (ae.getSource() == this.saveButton) {
            this.savePreferences();
            Container topLevelAncestor = this.getTopLevelAncestor();
            if (Setup.isCloseWindowOnSaveEnabled() && topLevelAncestor instanceof PrintOptionFrame) {
                ((PrintOptionFrame)topLevelAncestor).dispose();
            }
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.tabFormatCheckBox) {
            this.loadFontComboBox();
        }
        if (ae.getSource() == this.formatSwitchListCheckBox) {
            log.debug("Switch list check box activated");
            this.setSwitchListVisible(!this.formatSwitchListCheckBox.isSelected());
            this.setPreferredSize(null);
            Container topLevelAncestor = this.getTopLevelAncestor();
            if (topLevelAncestor instanceof PrintOptionFrame) {
                ((PrintOptionFrame)topLevelAncestor).pack();
            }
        }
        if (ae.getSource() == this.truncateCheckBox && this.truncateCheckBox.isSelected() && JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("EnableTruncateWarning"), Bundle.getMessage("TruncateManifests?"), 0) == 1) {
            this.truncateCheckBox.setSelected(false);
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.manifestFormatComboBox) {
            this.loadFontComboBox();
        }
    }

    private void setSwitchListVisible(boolean b) {
        this.pSwitchListOrientation.setVisible(b);
        this.pSwPickup.setVisible(b);
        this.pSwDrop.setVisible(b);
        this.pSwLocal.setVisible(b);
    }

    private File selectFile() {
        if (this.fc == null) {
            log.error("Could not find user directory");
        } else {
            this.fc.setDialogTitle(Bundle.getMessage("FindDesiredImage"));
            this.fc.rescanCurrentDirectory();
            int retVal = this.fc.showOpenDialog(null);
            if (retVal == 0) {
                return this.fc.getSelectedFile();
            }
        }
        return null;
    }

    private void updateLogoButtons() {
        boolean flag = Setup.getManifestLogoURL().equals("");
        this.addLogoButton.setVisible(flag);
        this.removeLogoButton.setVisible(!flag);
        this.logoURL.setText(Setup.getManifestLogoURL());
        Container topLevelAncestor = this.getTopLevelAncestor();
        if (topLevelAncestor instanceof PrintOptionFrame) {
            ((PrintOptionFrame)topLevelAncestor).pack();
        }
    }

    private void addComboBox(JPanel panel, List<JComboBox<String>> list, JComboBox<String> box) {
        list.add(box);
        panel.add((Component)box, list.size());
        panel.revalidate();
        this.pManifest.revalidate();
    }

    private void removeComboBox(JPanel panel, List<JComboBox<String>> list) {
        for (int i = 0; i < list.size(); ++i) {
            JComboBox<String> cb = list.get(i);
            if (!cb.getSelectedItem().equals(" ")) continue;
            list.remove(i);
            panel.remove(cb);
            panel.revalidate();
            this.pManifest.revalidate();
            return;
        }
    }

    private void loadFormatComboBox() {
        JComboBox<String> cb;
        String[] localFormat;
        String[] dropFormat;
        String[] pickFormat;
        JComboBox<String> cb2;
        String[] format;
        this.pEngPickup.removeAll();
        this.enginePickupMessageList.clear();
        this.pEngPickup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutPickupEngine")));
        this.pEngPickup.add(this.pickupEngPrefix);
        this.pickupEngPrefix.setText(Setup.getPickupEnginePrefix());
        for (String f : format = Setup.getPickupEngineMessageFormat()) {
            cb2 = Setup.getEngineMessageComboBox();
            cb2.setSelectedItem(f);
            this.pEngPickup.add(cb2);
            this.enginePickupMessageList.add(cb2);
        }
        this.pEngPickup.add(this.addEngPickupComboboxButton);
        this.pEngPickup.add(this.deleteEngPickupComboboxButton);
        this.pEngPickup.revalidate();
        this.pEngDrop.removeAll();
        this.engineDropMessageList.clear();
        this.pEngDrop.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutDropEngine")));
        this.pEngDrop.add(this.dropEngPrefix);
        this.dropEngPrefix.setText(Setup.getDropEnginePrefix());
        for (String f : format = Setup.getDropEngineMessageFormat()) {
            cb2 = Setup.getEngineMessageComboBox();
            cb2.setSelectedItem(f);
            this.pEngDrop.add(cb2);
            this.engineDropMessageList.add(cb2);
        }
        this.pEngDrop.add(this.addEngDropComboboxButton);
        this.pEngDrop.add(this.deleteEngDropComboboxButton);
        this.pEngDrop.revalidate();
        this.pPickup.removeAll();
        this.carPickupMessageList.clear();
        this.pPickup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutPickupCar")));
        this.pPickup.add(this.pickupCarPrefix);
        this.pickupCarPrefix.setText(Setup.getPickupCarPrefix());
        for (String pf : pickFormat = Setup.getPickupManifestMessageFormat()) {
            JComboBox<String> cb3 = Setup.getCarMessageComboBox();
            cb3.setSelectedItem(pf);
            this.pPickup.add(cb3);
            this.carPickupMessageList.add(cb3);
        }
        this.pPickup.add(this.addCarPickupComboboxButton);
        this.pPickup.add(this.deleteCarPickupComboboxButton);
        this.pPickup.revalidate();
        this.pDrop.removeAll();
        this.carDropMessageList.clear();
        this.pDrop.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutDropCar")));
        this.pDrop.add(this.dropCarPrefix);
        this.dropCarPrefix.setText(Setup.getDropCarPrefix());
        for (String lf : dropFormat = Setup.getDropManifestMessageFormat()) {
            JComboBox<String> cb4 = Setup.getCarMessageComboBox();
            cb4.setSelectedItem(lf);
            this.pDrop.add(cb4);
            this.carDropMessageList.add(cb4);
        }
        this.pDrop.add(this.addCarDropComboboxButton);
        this.pDrop.add(this.deleteCarDropComboboxButton);
        this.pDrop.revalidate();
        this.pLocal.removeAll();
        this.localMessageList.clear();
        this.pLocal.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLocal")));
        this.pLocal.add(this.localPrefix);
        this.localPrefix.setText(Setup.getLocalPrefix());
        for (String lf : localFormat = Setup.getLocalManifestMessageFormat()) {
            cb = Setup.getCarMessageComboBox();
            cb.setSelectedItem(lf);
            this.pLocal.add(cb);
            this.localMessageList.add(cb);
        }
        this.pLocal.add(this.addLocalComboboxButton);
        this.pLocal.add(this.deleteLocalComboboxButton);
        this.pLocal.revalidate();
        this.pSwPickup.removeAll();
        this.switchListCarPickupMessageList.clear();
        this.pSwPickup.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListPickupCar")));
        this.pSwPickup.add(this.switchListPickupCarPrefix);
        this.switchListPickupCarPrefix.setText(Setup.getSwitchListPickupCarPrefix());
        pickFormat = Setup.getPickupSwitchListMessageFormat();
        for (String pf : pickFormat) {
            cb = Setup.getCarMessageComboBox();
            cb.setSelectedItem(pf);
            this.pSwPickup.add(cb);
            this.switchListCarPickupMessageList.add(cb);
        }
        this.pSwPickup.add(this.addSwitchListPickupComboboxButton);
        this.pSwPickup.add(this.deleteSwitchListPickupComboboxButton);
        this.pSwDrop.removeAll();
        this.switchListCarDropMessageList.clear();
        this.pSwDrop.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListDropCar")));
        this.pSwDrop.add(this.switchListDropCarPrefix);
        this.switchListDropCarPrefix.setText(Setup.getSwitchListDropCarPrefix());
        dropFormat = Setup.getDropSwitchListMessageFormat();
        for (String df : dropFormat) {
            cb = Setup.getCarMessageComboBox();
            cb.setSelectedItem(df);
            this.pSwDrop.add(cb);
            this.switchListCarDropMessageList.add(cb);
        }
        this.pSwDrop.add(this.addSwitchListDropComboboxButton);
        this.pSwDrop.add(this.deleteSwitchListDropComboboxButton);
        this.pSwLocal.removeAll();
        this.switchListLocalMessageList.clear();
        this.pSwLocal.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutSwitchListLocal")));
        this.pSwLocal.add(this.switchListLocalPrefix);
        this.switchListLocalPrefix.setText(Setup.getSwitchListLocalPrefix());
        for (String lf : localFormat = Setup.getLocalSwitchListMessageFormat()) {
            cb = Setup.getCarMessageComboBox();
            cb.setSelectedItem(lf);
            this.pSwLocal.add(cb);
            this.switchListLocalMessageList.add(cb);
        }
        this.pSwLocal.add(this.addSwitchListLocalComboboxButton);
        this.pSwLocal.add(this.deleteSwitchListLocalComboboxButton);
    }

    private void loadFontSizeComboBox() {
        PrintOptionPanel.loadFontSizeComboBox(this.fontSizeComboBox);
        this.fontSizeComboBox.setSelectedItem(Setup.getManifestFontSize());
    }

    private void loadFontComboBox() {
        this.fontComboBox.removeAllItems();
        List<String> fonts = FontComboUtil.getFonts(0);
        if (this.tabFormatCheckBox.isSelected() || !this.manifestFormatComboBox.getSelectedItem().equals(Setup.STANDARD_FORMAT)) {
            fonts = FontComboUtil.getFonts(1);
        }
        for (String font : fonts) {
            this.fontComboBox.addItem(font);
        }
        this.fontComboBox.setSelectedItem(Setup.getFontName());
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return Bundle.getMessage("TitlePrintOptions");
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        JComboBox<String> cb;
        int i;
        Setup.setFontName((String)this.fontComboBox.getSelectedItem());
        Setup.setManifestFontSize((Integer)this.fontSizeComboBox.getSelectedItem());
        Setup.setManifestOrientation((String)this.manifestOrientationComboBox.getSelectedItem());
        Setup.setSwitchListOrientation((String)this.switchListOrientationComboBox.getSelectedItem());
        Setup.setPrintDuplexSides((JobAttributes.SidesType)this.printDuplexComboBox.getSelectedItem());
        Setup.setManifestFormat((String)this.manifestFormatComboBox.getSelectedItem());
        Setup.setDropEngineColor(this.dropEngineColorChooser.getColor());
        Setup.setPickupEngineColor(this.pickupEngineColorChooser.getColor());
        Setup.setDropColor(this.dropColorChooser.getColor());
        Setup.setPickupColor(this.pickupColorChooser.getColor());
        Setup.setLocalColor(this.localColorChooser.getColor());
        Setup.setPickupEnginePrefix(this.pickupEngPrefix.getText());
        String[] format = new String[this.enginePickupMessageList.size()];
        for (i = 0; i < this.enginePickupMessageList.size(); ++i) {
            cb = this.enginePickupMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setPickupEngineMessageFormat(format);
        Setup.setDropEnginePrefix(this.dropEngPrefix.getText());
        format = new String[this.engineDropMessageList.size()];
        for (i = 0; i < this.engineDropMessageList.size(); ++i) {
            cb = this.engineDropMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setDropEngineMessageFormat(format);
        Setup.setPickupCarPrefix(this.pickupCarPrefix.getText());
        format = new String[this.carPickupMessageList.size()];
        for (i = 0; i < this.carPickupMessageList.size(); ++i) {
            cb = this.carPickupMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setPickupManifestMessageFormat(format);
        Setup.setDropCarPrefix(this.dropCarPrefix.getText());
        format = new String[this.carDropMessageList.size()];
        for (i = 0; i < this.carDropMessageList.size(); ++i) {
            cb = this.carDropMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setDropManifestMessageFormat(format);
        Setup.setLocalPrefix(this.localPrefix.getText());
        format = new String[this.localMessageList.size()];
        for (i = 0; i < this.localMessageList.size(); ++i) {
            cb = this.localMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setLocalManifestMessageFormat(format);
        Setup.setSwitchListPickupCarPrefix(this.switchListPickupCarPrefix.getText());
        format = new String[this.switchListCarPickupMessageList.size()];
        for (i = 0; i < this.switchListCarPickupMessageList.size(); ++i) {
            cb = this.switchListCarPickupMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setPickupSwitchListMessageFormat(format);
        Setup.setSwitchListDropCarPrefix(this.switchListDropCarPrefix.getText());
        format = new String[this.switchListCarDropMessageList.size()];
        for (i = 0; i < this.switchListCarDropMessageList.size(); ++i) {
            cb = this.switchListCarDropMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setDropSwitchListMessageFormat(format);
        Setup.setSwitchListLocalPrefix(this.switchListLocalPrefix.getText());
        format = new String[this.switchListLocalMessageList.size()];
        for (i = 0; i < this.switchListLocalMessageList.size(); ++i) {
            cb = this.switchListLocalMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        Setup.setLocalSwitchListMessageFormat(format);
        Setup.setHazardousMsg(this.hazardousTextField.getText());
        Setup.setMiaComment(TrainCommon.formatColorString(this.commentTextArea.getText(), this.missingCarColorChooser.getColor()));
        Setup.setSwitchListFormatSameAsManifest(this.formatSwitchListCheckBox.isSelected());
        Setup.setPrintLocationCommentsEnabled(this.printLocCommentsCheckBox.isSelected());
        Setup.setPrintRouteCommentsEnabled(this.printRouteCommentsCheckBox.isSelected());
        Setup.setPrintLoadsAndEmptiesEnabled(this.printLoadsEmptiesCheckBox.isSelected());
        Setup.setPrintCabooseLoadEnabled(this.printCabooseLoadCheckBox.isSelected());
        Setup.setPrintPassengerLoadEnabled(this.printPassengerLoadCheckBox.isSelected());
        Setup.set12hrFormatEnabled(this.use12hrFormatCheckBox.isSelected());
        Setup.setPrintValidEnabled(this.printValidCheckBox.isSelected());
        Setup.setSortByTrackNameEnabled(this.sortByTrackCheckBox.isSelected());
        Setup.setPrintPageHeaderEnabled(this.printPageHeaderCheckBox.isSelected());
        Setup.setPrintHeadersEnabled(this.printHeadersCheckBox.isSelected());
        Setup.setPrintTrainScheduleNameEnabled(this.printTrainScheduleNameCheckBox.isSelected());
        Setup.setPrintTruncateManifestEnabled(this.truncateCheckBox.isSelected());
        Setup.setUseDepartureTimeEnabled(this.manifestDepartureTimeCheckBox.isSelected());
        Setup.setManifestEditorEnabled(this.editManifestCheckBox.isSelected());
        Setup.setPrintTrackSummaryEnabled(this.trackSummaryCheckBox.isSelected());
        Setup.setUseSwitchListDepartureTimeEnabled(this.switchListDepartureTimeCheckBox.isSelected());
        Setup.setSwitchListRouteLocationCommentEnabled(this.routeLocationCheckBox.isSelected());
        Setup.setGroupCarMoves(this.groupCarMovesCheckBox.isSelected());
        Setup.setPrintLocoLast(this.printLocoLastCheckBox.isSelected());
        boolean oldTabEnabled = Setup.isTabEnabled();
        Setup.setTabEnabled(this.tabFormatCheckBox.isSelected());
        if (oldTabEnabled ^ Setup.isTabEnabled()) {
            this.loadFormatComboBox();
        }
        InstanceManager.getDefault(TrainManager.class).setTrainsModified();
        InstanceManager.getDefault(OperationsSetupXml.class).writeOperationsFile();
    }

    @Override
    public boolean isDirty() {
        JComboBox<String> cb;
        int i;
        if (!(Setup.getFontName().equals(this.fontComboBox.getSelectedItem()) && Setup.getManifestFontSize() == (Integer)this.fontSizeComboBox.getSelectedItem() && Setup.getPrintDuplexSides() == this.printDuplexComboBox.getSelectedItem() && Setup.getManifestOrientation().equals(this.manifestOrientationComboBox.getSelectedItem()) && Setup.getSwitchListOrientation().equals(this.switchListOrientationComboBox.getSelectedItem()) && Setup.getManifestFormat().equals(this.manifestFormatComboBox.getSelectedItem()) && Setup.getDropEngineColor().equals(this.dropEngineColorChooser.getColor()) && Setup.getPickupEngineColor().equals(this.pickupEngineColorChooser.getColor()) && Setup.getDropColor().equals(this.dropColorChooser.getColor()) && Setup.getPickupColor().equals(this.pickupColorChooser.getColor()) && Setup.getLocalColor().equals(this.localColorChooser.getColor()) && Setup.getHazardousMsg().equals(this.hazardousTextField.getText()) && Setup.getMiaComment().equals(TrainCommon.formatColorString(this.commentTextArea.getText(), this.missingCarColorChooser.getColor())) && Setup.isSwitchListFormatSameAsManifest() == this.formatSwitchListCheckBox.isSelected() && Setup.isPrintLocationCommentsEnabled() == this.printLocCommentsCheckBox.isSelected() && Setup.isPrintRouteCommentsEnabled() == this.printRouteCommentsCheckBox.isSelected() && Setup.isPrintLoadsAndEmptiesEnabled() == this.printLoadsEmptiesCheckBox.isSelected() && Setup.isPrintCabooseLoadEnabled() == this.printCabooseLoadCheckBox.isSelected() && Setup.isPrintPassengerLoadEnabled() == this.printPassengerLoadCheckBox.isSelected() && Setup.is12hrFormatEnabled() == this.use12hrFormatCheckBox.isSelected() && Setup.isPrintValidEnabled() == this.printValidCheckBox.isSelected() && Setup.isSortByTrackNameEnabled() == this.sortByTrackCheckBox.isSelected() && Setup.isPrintHeadersEnabled() == this.printHeadersCheckBox.isSelected() && Setup.isPrintPageHeaderEnabled() == this.printPageHeaderCheckBox.isSelected() && Setup.isPrintTrainScheduleNameEnabled() == this.printTrainScheduleNameCheckBox.isSelected() && Setup.isPrintTruncateManifestEnabled() == this.truncateCheckBox.isSelected() && Setup.isUseDepartureTimeEnabled() == this.manifestDepartureTimeCheckBox.isSelected() && Setup.isManifestEditorEnabled() == this.editManifestCheckBox.isSelected() && Setup.isSwitchListRouteLocationCommentEnabled() == this.routeLocationCheckBox.isSelected() && Setup.isPrintTrackSummaryEnabled() == this.trackSummaryCheckBox.isSelected() && Setup.isUseSwitchListDepartureTimeEnabled() == this.switchListDepartureTimeCheckBox.isSelected() && Setup.isGroupCarMovesEnabled() == this.groupCarMovesCheckBox.isSelected() && Setup.isPrintLocoLastEnabled() == this.printLocoLastCheckBox.isSelected() && Setup.isTabEnabled() == this.tabFormatCheckBox.isSelected())) {
            return true;
        }
        Object[] format = new String[this.enginePickupMessageList.size()];
        for (i = 0; i < this.enginePickupMessageList.size(); ++i) {
            cb = this.enginePickupMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getPickupEnginePrefix().equals(this.pickupEngPrefix.getText()) || !Arrays.equals(Setup.getPickupEngineMessageFormat(), format)) {
            return true;
        }
        format = new String[this.engineDropMessageList.size()];
        for (i = 0; i < this.engineDropMessageList.size(); ++i) {
            cb = this.engineDropMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getDropEnginePrefix().equals(this.dropEngPrefix.getText()) || !Arrays.equals(Setup.getDropEngineMessageFormat(), format)) {
            return true;
        }
        format = new String[this.carPickupMessageList.size()];
        for (i = 0; i < this.carPickupMessageList.size(); ++i) {
            cb = this.carPickupMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getPickupCarPrefix().equals(this.pickupCarPrefix.getText()) || !Arrays.equals(Setup.getPickupManifestMessageFormat(), format)) {
            return true;
        }
        format = new String[this.carDropMessageList.size()];
        for (i = 0; i < this.carDropMessageList.size(); ++i) {
            cb = this.carDropMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getDropCarPrefix().equals(this.dropCarPrefix.getText()) || !Arrays.equals(Setup.getDropManifestMessageFormat(), format)) {
            return true;
        }
        format = new String[this.localMessageList.size()];
        for (i = 0; i < this.localMessageList.size(); ++i) {
            cb = this.localMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getLocalPrefix().equals(this.localPrefix.getText()) || !Arrays.equals(Setup.getLocalManifestMessageFormat(), format)) {
            return true;
        }
        format = new String[this.switchListCarPickupMessageList.size()];
        for (i = 0; i < this.switchListCarPickupMessageList.size(); ++i) {
            cb = this.switchListCarPickupMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getSwitchListPickupCarPrefix().equals(this.switchListPickupCarPrefix.getText()) || !Arrays.equals(Setup.getPickupSwitchListMessageFormat(), format)) {
            return true;
        }
        format = new String[this.switchListCarDropMessageList.size()];
        for (i = 0; i < this.switchListCarDropMessageList.size(); ++i) {
            cb = this.switchListCarDropMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        if (!Setup.getSwitchListDropCarPrefix().equals(this.switchListDropCarPrefix.getText()) || !Arrays.equals(Setup.getDropSwitchListMessageFormat(), format)) {
            return true;
        }
        format = new String[this.switchListLocalMessageList.size()];
        for (i = 0; i < this.switchListLocalMessageList.size(); ++i) {
            cb = this.switchListLocalMessageList.get(i);
            format[i] = (String)cb.getSelectedItem();
        }
        return !Setup.getSwitchListLocalPrefix().equals(this.switchListLocalPrefix.getText()) || !Arrays.equals(Setup.getLocalSwitchListMessageFormat(), format);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("setupSwitchListRealTime")) {
            this.trackSummaryCheckBox.setEnabled(Setup.isSwitchListRealTime());
        }
    }
}

