/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import jmri.InstanceManager;
import jmri.ThrottleManager;
import jmri.beans.Identifiable;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.RollingStockManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.rollingstock.engines.EngineTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.JsonManifest;
import jmri.jmrit.operations.trains.TrainIcon;
import jmri.jmrit.operations.trains.TrainIconAnimation;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainManifest;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.jmrit.operations.trains.csv.TrainCsvManifest;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.trainbuilder.TrainBuilder;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.jmrit.roster.RosterEntry;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Train
extends PropertyChangeSupport
implements Identifiable,
PropertyChangeListener {
    public static final String NONE = "";
    protected String _id = "";
    protected String _name = "";
    protected String _description = "";
    protected RouteLocation _current = null;
    protected String _buildFailedMessage = "";
    protected boolean _built = false;
    protected boolean _modified = false;
    protected boolean _build = true;
    protected boolean _buildFailed = false;
    protected boolean _printed = false;
    protected boolean _sendToTerminal = false;
    protected boolean _allowLocalMoves = true;
    protected boolean _allowThroughCars = true;
    protected boolean _buildNormal = false;
    protected boolean _allowCarsReturnStaging = false;
    protected boolean _serviceAllCarsWithFinalDestinations = false;
    protected boolean _buildConsist = false;
    protected boolean _sendCarsWithCustomLoadsToStaging = false;
    protected Route _route = null;
    protected Track _departureTrack;
    protected Track _terminationTrack;
    protected String _carRoadOption = ALL_ROADS;
    protected List<String> _carRoadList = new ArrayList<String>();
    protected String _cabooseRoadOption = ALL_ROADS;
    protected List<String> _cabooseRoadList = new ArrayList<String>();
    protected String _locoRoadOption = ALL_ROADS;
    protected List<String> _locoRoadList = new ArrayList<String>();
    protected int _requires = 0;
    protected String _numberEngines = "0";
    protected String _engineRoad = "";
    protected String _engineModel = "";
    protected String _cabooseRoad = "";
    protected String _departureTime = "00:00";
    protected String _leadEngineId = "";
    protected String _builtStartYear = "";
    protected String _builtEndYear = "";
    protected String _loadOption = ALL_LOADS;
    protected String _ownerOption = ALL_OWNERS;
    protected List<String> _buildScripts = new ArrayList<String>();
    protected List<String> _afterBuildScripts = new ArrayList<String>();
    protected List<String> _moveScripts = new ArrayList<String>();
    protected List<String> _terminationScripts = new ArrayList<String>();
    protected String _railroadName = "";
    protected String _logoPathName = "";
    protected boolean _showTimes = true;
    protected Engine _leadEngine = null;
    protected String _switchListStatus = "";
    protected String _comment = "";
    protected String _serviceStatus = "";
    protected int _statusCode = 65535;
    protected int _oldStatusCode = 65535;
    protected Date _date;
    protected int _statusCarsRequested = 0;
    protected String _tableRowColorName = "";
    protected String _tableRowColorResetName = "";
    protected int _leg2Options = 0;
    protected RouteLocation _leg2Start = null;
    protected RouteLocation _end2Leg = null;
    protected String _leg2Engines = "0";
    protected String _leg2Road = "";
    protected String _leg2Model = "";
    protected String _leg2CabooseRoad = "";
    protected int _leg3Options = 0;
    protected RouteLocation _leg3Start = null;
    protected RouteLocation _leg3End = null;
    protected String _leg3Engines = "0";
    protected String _leg3Road = "";
    protected String _leg3Model = "";
    protected String _leg3CabooseRoad = "";
    public static final int CHANGE_ENGINES = 1;
    public static final int HELPER_ENGINES = 2;
    public static final int ADD_CABOOSE = 4;
    public static final int REMOVE_CABOOSE = 8;
    public static final int ADD_ENGINES = 16;
    public static final int REMOVE_ENGINES = 32;
    public static final String DISPOSE_CHANGED_PROPERTY = "TrainDispose";
    public static final String STOPS_CHANGED_PROPERTY = "TrainStops";
    public static final String TYPES_CHANGED_PROPERTY = "TrainTypes";
    public static final String BUILT_CHANGED_PROPERTY = "TrainBuilt";
    public static final String BUILT_YEAR_CHANGED_PROPERTY = "TrainBuiltYear";
    public static final String BUILD_CHANGED_PROPERTY = "TrainBuild";
    public static final String ROADS_CHANGED_PROPERTY = "TrainRoads";
    public static final String LOADS_CHANGED_PROPERTY = "TrainLoads";
    public static final String OWNERS_CHANGED_PROPERTY = "TrainOwners";
    public static final String NAME_CHANGED_PROPERTY = "TrainName";
    public static final String DESCRIPTION_CHANGED_PROPERTY = "TrainDescription";
    public static final String STATUS_CHANGED_PROPERTY = "TrainStatus";
    public static final String DEPARTURETIME_CHANGED_PROPERTY = "TrainDepartureTime";
    public static final String TRAIN_LOCATION_CHANGED_PROPERTY = "TrainLocation";
    public static final String TRAIN_ROUTE_CHANGED_PROPERTY = "TrainRoute";
    public static final String TRAIN_REQUIREMENTS_CHANGED_PROPERTY = "TrainRequirements";
    public static final String TRAIN_MOVE_COMPLETE_CHANGED_PROPERTY = "TrainMoveComplete";
    public static final String TRAIN_ROW_COLOR_CHANGED_PROPERTY = "TrianRowColor";
    public static final String TRAIN_ROW_COLOR_RESET_CHANGED_PROPERTY = "TrianRowColorReset";
    public static final String TRAIN_MODIFIED_CHANGED_PROPERTY = "TrainModified";
    public static final String TRAIN_CURRENT_CHANGED_PROPERTY = "TrainCurrentLocation";
    public static final String TRAIN_RESET = Bundle.getMessage("TrainReset");
    public static final String RUN_SCRIPTS = Bundle.getMessage("RunScripts");
    public static final String BUILDING = Bundle.getMessage("Building");
    public static final String BUILD_FAILED = Bundle.getMessage("BuildFailed");
    public static final String BUILT = Bundle.getMessage("Built");
    public static final String PARTIAL_BUILT = Bundle.getMessage("Partial");
    public static final String TRAIN_EN_ROUTE = Bundle.getMessage("TrainEnRoute");
    public static final String TERMINATED = Bundle.getMessage("Terminated");
    public static final String MANIFEST_MODIFIED = Bundle.getMessage("Modified");
    public static final int CODE_TRAIN_RESET = 0;
    public static final int CODE_RUN_SCRIPTS = 256;
    public static final int CODE_BUILDING = 1;
    public static final int CODE_BUILD_FAILED = 2;
    public static final int CODE_BUILT = 16;
    public static final int CODE_PARTIAL_BUILT = 20;
    public static final int CODE_TRAIN_EN_ROUTE = 24;
    public static final int CODE_TERMINATED = 128;
    public static final int CODE_MANIFEST_MODIFIED = 512;
    public static final int CODE_UNKNOWN = 65535;
    public static final int NO_CABOOSE_OR_FRED = 0;
    public static final int CABOOSE = 1;
    public static final int FRED = 2;
    public static final String ALL_ROADS = Bundle.getMessage("All");
    public static final String INCLUDE_ROADS = Bundle.getMessage("Include");
    public static final String EXCLUDE_ROADS = Bundle.getMessage("Exclude");
    public static final String ALL_OWNERS = Bundle.getMessage("All");
    public static final String INCLUDE_OWNERS = Bundle.getMessage("Include");
    public static final String EXCLUDE_OWNERS = Bundle.getMessage("Exclude");
    public static final String ALL_LOADS = Bundle.getMessage("All");
    public static final String INCLUDE_LOADS = Bundle.getMessage("Include");
    public static final String EXCLUDE_LOADS = Bundle.getMessage("Exclude");
    public static final String UNKNOWN = "";
    public static final String PRINTED = Bundle.getMessage("Printed");
    public static final String AUTO = Bundle.getMessage("Auto");
    public static final String AUTO_HPT = Bundle.getMessage("AutoHPT");
    public static final String ALREADY_SERVICED = "-1";
    List<String> _skipLocationsList = new ArrayList<String>();
    List<String> _typeList = new ArrayList<String>();
    List<String> _loadList = new ArrayList<String>();
    List<String> _ownerList = new ArrayList<String>();
    private final boolean debugFlag = false;
    protected static final String SEVEN = "7";
    private final boolean animation = true;
    TrainIconAnimation _ta;
    protected TrainIcon _trainIcon = null;
    private static final Logger log = LoggerFactory.getLogger(Train.class);

    public Train(String id, String name) {
        this._name = name;
        this._id = id;
        this.setTypeNames(InstanceManager.getDefault(CarTypes.class).getNames());
        this.setTypeNames(InstanceManager.getDefault(EngineTypes.class).getNames());
        this.addPropertyChangeListerners();
    }

    @Override
    public String getId() {
        return this._id;
    }

    public void setName(String name) {
        String old = this._name;
        this._name = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange(NAME_CHANGED_PROPERTY, old, name);
        }
    }

    public String toString() {
        return this._name;
    }

    public String getName() {
        return this._name;
    }

    public String getTableRowColorName() {
        return this._tableRowColorName;
    }

    public void setTableRowColorName(String colorName) {
        String old = this._tableRowColorName;
        this._tableRowColorName = colorName;
        if (!old.equals(colorName)) {
            this.setDirtyAndFirePropertyChange(TRAIN_ROW_COLOR_CHANGED_PROPERTY, old, colorName);
        }
    }

    public String getTableRowColorNameReset() {
        return this._tableRowColorResetName;
    }

    public void setTableRowColorNameReset(String colorName) {
        String old = this._tableRowColorResetName;
        this._tableRowColorResetName = colorName;
        if (!old.equals(colorName)) {
            this.setDirtyAndFirePropertyChange(TRAIN_ROW_COLOR_RESET_CHANGED_PROPERTY, old, colorName);
        }
    }

    public Color getTableRowColor() {
        String colorName = this.getTableRowColorName();
        if (colorName.equals("")) {
            return null;
        }
        return Setup.getColor(colorName);
    }

    public String getDepartureTime() {
        RouteLocation rl = this.getTrainDepartsRouteLocation();
        if (rl != null) {
            rl.removePropertyChangeListener(this);
            rl.addPropertyChangeListener(this);
            if (!rl.getDepartureTime().equals("")) {
                return rl.getDepartureTime();
            }
        }
        return this._departureTime;
    }

    public String getFormatedDepartureTime() {
        RouteLocation rl = this.getTrainDepartsRouteLocation();
        if (rl != null && !rl.getDepartureTime().equals("")) {
            rl.removePropertyChangeListener(this);
            rl.addPropertyChangeListener(this);
            return rl.getFormatedDepartureTime();
        }
        return this.parseTime(this.getDepartTimeMinutes());
    }

    public int getDepartTimeMinutes() {
        int hour = Integer.parseInt(this.getDepartureTimeHour());
        int minute = Integer.parseInt(this.getDepartureTimeMinute());
        return hour * 60 + minute;
    }

    public void setDepartureTime(String hour, String minute) {
        int m;
        String old = this._departureTime;
        int h = Integer.parseInt((String)hour);
        if (h < 10) {
            hour = "0" + h;
        }
        if ((m = Integer.parseInt((String)minute)) < 10) {
            minute = "0" + m;
        }
        String time = (String)hour + ":" + (String)minute;
        this._departureTime = time;
        if (!old.equals(time)) {
            this.setDirtyAndFirePropertyChange(DEPARTURETIME_CHANGED_PROPERTY, old, this._departureTime);
            this.setModified(true);
        }
    }

    public String getDepartureTimeHour() {
        String[] time = this.getDepartureTime().split(":");
        return time[0];
    }

    public String getDepartureTimeMinute() {
        String[] time = this.getDepartureTime().split(":");
        return time[1];
    }

    public String getExpectedArrivalTime(RouteLocation routeLocation) {
        return this.getExpectedArrivalTime(routeLocation, false);
    }

    public String getExpectedArrivalTime(RouteLocation routeLocation, boolean isSortFormat) {
        int minutes = this.getExpectedTravelTimeInMinutes(routeLocation);
        if (minutes == -1) {
            return ALREADY_SERVICED;
        }
        log.debug("Expected arrival time for train ({}) at ({}), {} minutes", new Object[]{this.getName(), routeLocation.getName(), minutes});
        return this.parseTime(minutes, isSortFormat);
    }

    public String getExpectedDepartureTime(RouteLocation routeLocation) {
        return this.getExpectedDepartureTime(routeLocation, false);
    }

    public String getExpectedDepartureTime(RouteLocation routeLocation, boolean isSortFormat) {
        int minutes = this.getExpectedTravelTimeInMinutes(routeLocation);
        if (minutes == -1) {
            return ALREADY_SERVICED;
        }
        if (!routeLocation.getDepartureTime().equals("")) {
            return this.parseTime(this.checkForDepartureTime(minutes, routeLocation), isSortFormat);
        }
        if (this.getRoute() != null) {
            boolean foundRouteLocation = false;
            for (RouteLocation rl : this.getRoute().getLocationsBySequenceList()) {
                if (rl == routeLocation) {
                    foundRouteLocation = true;
                }
                if (!foundRouteLocation) continue;
                if (!rl.getSplitName().equals(routeLocation.getSplitName())) break;
                minutes += this.getWorkTimeAtLocation(rl);
            }
        }
        log.debug("Expected departure time {} for train ({}) at ({})", new Object[]{minutes, this.getName(), routeLocation.getName()});
        return this.parseTime(minutes, isSortFormat);
    }

    public int getWorkTimeAtLocation(RouteLocation routeLocation) {
        int minutes = 0;
        if (routeLocation == this.getTrainDepartsRouteLocation()) {
            return minutes;
        }
        for (Car rs : InstanceManager.getDefault(CarManager.class).getList(this)) {
            if (rs.getRouteLocation() == routeLocation && !rs.getTrackName().equals("")) {
                minutes += Setup.getSwitchTime();
            }
            if (rs.getRouteDestination() != routeLocation) continue;
            minutes += Setup.getSwitchTime();
        }
        return minutes;
    }

    public int getExpectedTravelTimeInMinutes(RouteLocation routeLocation) {
        int minutes = 0;
        if (!this.isTrainEnRoute()) {
            minutes += Integer.parseInt(this.getDepartureTimeMinute());
            minutes += 60 * Integer.parseInt(this.getDepartureTimeHour());
        } else {
            minutes = -1;
        }
        boolean trainLocFound = false;
        if (this.getRoute() != null) {
            RouteLocation rl;
            List<RouteLocation> routeList = this.getRoute().getLocationsBySequenceList();
            for (int i = 0; i < routeList.size() && (rl = routeList.get(i)) != routeLocation; ++i) {
                if (!trainLocFound && this.isTrainEnRoute()) {
                    if (rl != this.getCurrentRouteLocation()) continue;
                    trainLocFound = true;
                    minutes = Setup.getTravelTime();
                    continue;
                }
                minutes = this.checkForDepartureTime(minutes, rl);
                minutes += rl.getWait();
                RouteLocation next = routeList.get(i + 1);
                if (next != null && !rl.getSplitName().equals(next.getSplitName())) {
                    minutes += Setup.getTravelTime();
                }
                if (i == 0 || !rl.getDepartureTime().equals("") && !this.isTrainEnRoute()) continue;
                minutes += this.getWorkTimeAtLocation(rl);
            }
        }
        return minutes;
    }

    private int checkForDepartureTime(int minutes, RouteLocation rl) {
        if (!rl.getDepartureTime().equals("") && !this.isTrainEnRoute()) {
            String dt = rl.getDepartureTime();
            log.debug("Location {} departure time {}", (Object)rl.getName(), (Object)dt);
            String[] time = dt.split(":");
            int departMinute = 60 * Integer.parseInt(time[0]) + Integer.parseInt(time[1]);
            if (minutes > departMinute) {
                int days = 1 + minutes / 1440;
                departMinute += days * 60 * 24;
            }
            minutes = departMinute;
        }
        return minutes;
    }

    private String parseTime(int minutes) {
        return this.parseTime(minutes, false);
    }

    private String parseTime(int minutes, boolean isSortFormat) {
        int hours = 0;
        int days = 0;
        if (minutes >= 60) {
            int h = minutes / 60;
            minutes -= h * 60;
            hours += h;
        }
        Object d = "";
        if (isSortFormat) {
            d = "0:";
        }
        if (hours >= 24) {
            int nd = hours / 24;
            hours -= nd * 24;
            d = Integer.toString(days += nd) + ":";
        }
        Object am_pm = "";
        if (Setup.is12hrFormatEnabled() && !isSortFormat) {
            am_pm = " " + Bundle.getMessage("AM");
            if (hours >= 12) {
                hours -= 12;
                am_pm = " " + Bundle.getMessage("PM");
            }
            if (hours == 0) {
                hours = 12;
            }
        }
        Object h = Integer.toString(hours);
        if (hours < 10) {
            h = "0" + (String)h;
        }
        if (minutes < 10) {
            return (String)d + (String)h + ":0" + minutes + (String)am_pm;
        }
        return (String)d + (String)h + ":" + minutes + (String)am_pm;
    }

    public void setRequirements(int requires) {
        int old = this._requires;
        this._requires = requires;
        if (old != requires) {
            this.setDirtyAndFirePropertyChange(TRAIN_REQUIREMENTS_CHANGED_PROPERTY, Integer.toString(old), Integer.toString(requires));
        }
    }

    public int getRequirements() {
        return this._requires;
    }

    public boolean isCabooseNeeded() {
        return (this.getRequirements() & 1) == 1;
    }

    public boolean isFredNeeded() {
        return (this.getRequirements() & 2) == 2;
    }

    public void setRoute(Route route) {
        Route old = this._route;
        String oldRoute = "";
        String newRoute = "";
        if (old != null) {
            old.removePropertyChangeListener(this);
            oldRoute = old.toString();
        }
        if (route != null) {
            route.addPropertyChangeListener(this);
            newRoute = route.toString();
        }
        this._route = route;
        this._skipLocationsList.clear();
        if (old == null || !old.equals(route)) {
            this.setDirtyAndFirePropertyChange(TRAIN_ROUTE_CHANGED_PROPERTY, oldRoute, newRoute);
        }
    }

    public Route getRoute() {
        return this._route;
    }

    public String getTrainRouteName() {
        if (this.getRoute() == null) {
            return "";
        }
        return this.getRoute().getName();
    }

    public String getTrainDepartsName() {
        if (this.getTrainDepartsRouteLocation() != null) {
            return this.getTrainDepartsRouteLocation().getName();
        }
        return "";
    }

    public RouteLocation getTrainDepartsRouteLocation() {
        if (this.getRoute() == null) {
            return null;
        }
        return this.getRoute().getDepartsRouteLocation();
    }

    public String getTrainDepartsDirection() {
        String direction = "";
        if (this.getTrainDepartsRouteLocation() != null) {
            direction = this.getTrainDepartsRouteLocation().getTrainDirectionString();
        }
        return direction;
    }

    public String getTrainTerminatesName() {
        if (this.getTrainTerminatesRouteLocation() != null) {
            return this.getTrainTerminatesRouteLocation().getName();
        }
        return "";
    }

    public RouteLocation getTrainTerminatesRouteLocation() {
        if (this.getRoute() == null) {
            return null;
        }
        return this.getRoute().getTerminatesRouteLocation();
    }

    public List<RouteLocation> getTrainBlockingOrder() {
        if (this.getRoute() == null) {
            return null;
        }
        return this.getRoute().getBlockingOrder();
    }

    public void setCurrentLocation(RouteLocation location) {
        RouteLocation old = this._current;
        this._current = location;
        if (old != null && !old.equals(location) || old == null && location != null) {
            this.setDirtyAndFirePropertyChange(TRAIN_CURRENT_CHANGED_PROPERTY, old, location);
        }
    }

    public String getCurrentLocationName() {
        if (this.getCurrentRouteLocation() == null) {
            return "";
        }
        return this.getCurrentRouteLocation().getName();
    }

    public RouteLocation getCurrentRouteLocation() {
        if (this.getRoute() == null) {
            return null;
        }
        if (this._current == null) {
            return null;
        }
        return this.getRoute().getRouteLocationById(this._current.getId());
    }

    public String getNextLocationName() {
        return this.getNextLocationName(1);
    }

    public String getNextLocationName(int number) {
        RouteLocation rl = this.getCurrentRouteLocation();
        while (number-- > 0) {
            if ((rl = this.getNextRouteLocation(rl)) != null) continue;
            return "";
        }
        return rl.getName();
    }

    public RouteLocation getNextRouteLocation(RouteLocation currentRouteLocation) {
        if (this.getRoute() == null) {
            return null;
        }
        List<RouteLocation> routeList = this.getRoute().getLocationsBySequenceList();
        for (int i = 0; i < routeList.size(); ++i) {
            RouteLocation rl = routeList.get(i);
            if (rl != currentRouteLocation) continue;
            if (++i >= routeList.size()) break;
            return routeList.get(i);
        }
        return null;
    }

    public void setDepartureTrack(Track track) {
        Track old = this._departureTrack;
        this._departureTrack = track;
        if (old != track) {
            this.setDirtyAndFirePropertyChange("DepartureTrackChanged", old, track);
        }
    }

    public Track getDepartureTrack() {
        return this._departureTrack;
    }

    public boolean isDepartingStaging() {
        return this.getDepartureTrack() != null;
    }

    public void setTerminationTrack(Track track) {
        Track old = this._terminationTrack;
        this._terminationTrack = track;
        if (old != track) {
            this.setDirtyAndFirePropertyChange("TerminationTrackChanged", old, track);
        }
    }

    public Track getTerminationTrack() {
        return this._terminationTrack;
    }

    public void setStatusCode(int code) {
        String oldStatus = this.getStatus();
        int oldCode = this.getStatusCode();
        this._statusCode = code;
        this.setDate(Calendar.getInstance().getTime());
        if (oldCode != this.getStatusCode()) {
            this.setDirtyAndFirePropertyChange(STATUS_CHANGED_PROPERTY, oldStatus, this.getStatus());
        }
        this.updateTrainTableRowColor();
    }

    public void updateTrainTableRowColor() {
        if (!InstanceManager.getDefault(TrainManager.class).isRowColorManual()) {
            switch (this.getStatusCode()) {
                case 0: {
                    String color = this.getTableRowColorNameReset();
                    if (color.equals("")) {
                        color = InstanceManager.getDefault(TrainManager.class).getRowColorNameForReset();
                    }
                    this.setTableRowColorName(color);
                    break;
                }
                case 16: 
                case 20: {
                    this.setTableRowColorName(InstanceManager.getDefault(TrainManager.class).getRowColorNameForBuilt());
                    break;
                }
                case 2: {
                    this.setTableRowColorName(InstanceManager.getDefault(TrainManager.class).getRowColorNameForBuildFailed());
                    break;
                }
                case 24: {
                    this.setTableRowColorName(InstanceManager.getDefault(TrainManager.class).getRowColorNameForTrainEnRoute());
                    break;
                }
                case 128: {
                    this.setTableRowColorName(InstanceManager.getDefault(TrainManager.class).getRowColorNameForTerminated());
                    break;
                }
            }
        }
    }

    public String getStatus() {
        return this.getStatus(Locale.getDefault());
    }

    public String getStatus(Locale locale) {
        return this.getStatus(locale, this.getStatusCode());
    }

    public String getStatus(Locale locale, int code) {
        switch (code) {
            case 256: {
                return RUN_SCRIPTS;
            }
            case 1: {
                return BUILDING;
            }
            case 2: {
                return BUILD_FAILED;
            }
            case 16: {
                return Bundle.getMessage(locale, "StatusBuilt", this.getNumberCarsWorked());
            }
            case 20: {
                return Bundle.getMessage(locale, "StatusPartialBuilt", this.getNumberCarsWorked(), this.getNumberCarsRequested());
            }
            case 128: {
                return Bundle.getMessage(locale, "StatusTerminated", this.getSortDate());
            }
            case 24: {
                return Bundle.getMessage(locale, "StatusEnRoute", this.getNumberCarsInTrain(), this.getTrainLength(), Setup.getLengthUnit().toLowerCase(), this.getTrainWeight());
            }
            case 0: {
                return TRAIN_RESET;
            }
            case 512: {
                return MANIFEST_MODIFIED;
            }
        }
        return "";
    }

    public String getMRStatus() {
        switch (this.getStatusCode()) {
            case 20: {
                return this.getStatusCode() + "||" + this.getNumberCarsRequested();
            }
            case 128: {
                return this.getStatusCode() + "||" + this.getSortDate();
            }
        }
        return Integer.toString(this.getStatusCode());
    }

    public int getStatusCode() {
        return this._statusCode;
    }

    protected void setOldStatusCode(int code) {
        this._oldStatusCode = code;
    }

    protected int getOldStatusCode() {
        return this._oldStatusCode;
    }

    public boolean isTrainEnRoute() {
        return !this.getCurrentLocationName().equals("") && this.getTrainDepartsRouteLocation() != this.getCurrentRouteLocation();
    }

    public boolean isLocalSwitcher() {
        String departureName = TrainCommon.splitString(this.getTrainDepartsName());
        Route route = this.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (departureName.equals(rl.getSplitName())) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isTurn() {
        return !this.isLocalSwitcher() && TrainCommon.splitString(this.getTrainDepartsName()).equals(TrainCommon.splitString(this.getTrainTerminatesName()));
    }

    public boolean isOnlyPassengerCars() {
        for (Car car : InstanceManager.getDefault(CarManager.class).getList(this)) {
            if (car.isPassenger()) continue;
            return false;
        }
        return true;
    }

    protected String[] getTrainSkipsLocations() {
        String[] locationIds = new String[this._skipLocationsList.size()];
        for (int i = 0; i < this._skipLocationsList.size(); ++i) {
            locationIds[i] = this._skipLocationsList.get(i);
        }
        return locationIds;
    }

    protected void setTrainSkipsLocations(String[] locationIds) {
        if (locationIds.length > 0) {
            Arrays.sort(locationIds);
            for (String id : locationIds) {
                this._skipLocationsList.add(id);
            }
        }
    }

    public void addTrainSkipsLocation(RouteLocation rl) {
        if (!this._skipLocationsList.contains(rl.getId())) {
            this._skipLocationsList.add(0, rl.getId());
            this.setDirtyAndFirePropertyChange(STOPS_CHANGED_PROPERTY, this._skipLocationsList.size() - 1, this._skipLocationsList.size());
        }
    }

    public void deleteTrainSkipsLocation(RouteLocation rl) {
        this._skipLocationsList.remove(rl.getId());
        this.setDirtyAndFirePropertyChange(STOPS_CHANGED_PROPERTY, this._skipLocationsList.size() + 1, this._skipLocationsList.size());
    }

    public boolean isLocationSkipped(RouteLocation rl) {
        return this._skipLocationsList.contains(rl.getId());
    }

    public String[] getTypeNames() {
        return this._typeList.toArray(new String[0]);
    }

    public String[] getCarTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (String type : this._typeList) {
            if (!InstanceManager.getDefault(CarTypes.class).containsName(type)) continue;
            list.add(type);
        }
        return list.toArray(new String[0]);
    }

    public String[] getLocoTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (String type : this._typeList) {
            if (!InstanceManager.getDefault(EngineTypes.class).containsName(type)) continue;
            list.add(type);
        }
        return list.toArray(new String[0]);
    }

    protected void setTypeNames(String[] types) {
        if (types.length > 0) {
            Arrays.sort(types);
            for (String type : types) {
                this._typeList.add(type);
            }
        }
    }

    public void addTypeName(String type) {
        if (type == null || this._typeList.contains(type)) {
            return;
        }
        this._typeList.add(0, type);
        log.debug("Train ({}) add car type ({})", (Object)this.getName(), (Object)type);
        this.setDirtyAndFirePropertyChange(TYPES_CHANGED_PROPERTY, this._typeList.size() - 1, this._typeList.size());
    }

    public void deleteTypeName(String type) {
        if (this._typeList.remove(type)) {
            log.debug("Train ({}) delete car type ({})", (Object)this.getName(), (Object)type);
            this.setDirtyAndFirePropertyChange(TYPES_CHANGED_PROPERTY, this._typeList.size() + 1, this._typeList.size());
        }
    }

    public boolean isTypeNameAccepted(String type) {
        return this._typeList.contains(type);
    }

    protected void replaceType(String oldType, String newType) {
        if (this.isTypeNameAccepted(oldType)) {
            this.deleteTypeName(oldType);
            this.addTypeName(newType);
            for (String string : this.getLoadNames()) {
                String[] splitLoad = string.split(" & ");
                if (splitLoad.length <= 1 || !splitLoad[0].equals(oldType)) continue;
                this.deleteLoadName(string);
                if (newType == null) continue;
                String string2 = newType + " & " + splitLoad[1];
                this.addLoadName(string2);
            }
        }
    }

    public String getCarRoadOption() {
        return this._carRoadOption;
    }

    public void setCarRoadOption(String option) {
        String old = this._carRoadOption;
        this._carRoadOption = option;
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, old, option);
    }

    public void setCarRoadNames(String[] roads) {
        this.setRoadNames(roads, this._carRoadList);
    }

    public String[] getCarRoadNames() {
        Object[] roads = this._carRoadList.toArray(new String[0]);
        if (this._carRoadList.size() > 0) {
            Arrays.sort(roads);
        }
        return roads;
    }

    public boolean addCarRoadName(String road) {
        if (this._carRoadList.contains(road)) {
            return false;
        }
        this._carRoadList.add(road);
        log.debug("train ({}) add car road {}", (Object)this.getName(), (Object)road);
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._carRoadList.size() - 1, this._carRoadList.size());
        return true;
    }

    public boolean deleteCarRoadName(String road) {
        if (this._carRoadList.remove(road)) {
            log.debug("train ({}) delete car road {}", (Object)this.getName(), (Object)road);
            this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._carRoadList.size() + 1, this._carRoadList.size());
            return true;
        }
        return false;
    }

    public boolean isCarRoadNameAccepted(String road) {
        if (this._carRoadOption.equals(ALL_ROADS)) {
            return true;
        }
        if (this._carRoadOption.equals(INCLUDE_ROADS)) {
            return this._carRoadList.contains(road);
        }
        return !this._carRoadList.contains(road);
    }

    public String getCabooseRoadOption() {
        return this._cabooseRoadOption;
    }

    public void setCabooseRoadOption(String option) {
        String old = this._cabooseRoadOption;
        this._cabooseRoadOption = option;
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, old, option);
    }

    protected void setCabooseRoadNames(String[] roads) {
        this.setRoadNames(roads, this._cabooseRoadList);
    }

    public String[] getCabooseRoadNames() {
        Object[] roads = this._cabooseRoadList.toArray(new String[0]);
        if (this._cabooseRoadList.size() > 0) {
            Arrays.sort(roads);
        }
        return roads;
    }

    public boolean addCabooseRoadName(String road) {
        if (this._cabooseRoadList.contains(road)) {
            return false;
        }
        this._cabooseRoadList.add(road);
        log.debug("train ({}) add caboose road {}", (Object)this.getName(), (Object)road);
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._cabooseRoadList.size() - 1, this._cabooseRoadList.size());
        return true;
    }

    public boolean deleteCabooseRoadName(String road) {
        if (this._cabooseRoadList.remove(road)) {
            log.debug("train ({}) delete caboose road {}", (Object)this.getName(), (Object)road);
            this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._cabooseRoadList.size() + 1, this._cabooseRoadList.size());
            return true;
        }
        return false;
    }

    public boolean isCabooseRoadNameAccepted(String road) {
        if (this._cabooseRoadOption.equals(ALL_ROADS)) {
            return true;
        }
        if (this._cabooseRoadOption.equals(INCLUDE_ROADS)) {
            return this._cabooseRoadList.contains(road);
        }
        return !this._cabooseRoadList.contains(road);
    }

    public String getLocoRoadOption() {
        return this._locoRoadOption;
    }

    public void setLocoRoadOption(String option) {
        String old = this._locoRoadOption;
        this._locoRoadOption = option;
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, old, option);
    }

    public void setLocoRoadNames(String[] roads) {
        this.setRoadNames(roads, this._locoRoadList);
    }

    private void setRoadNames(String[] roads, List<String> list) {
        if (roads.length > 0) {
            Arrays.sort(roads);
            for (String road : roads) {
                if (road.isEmpty()) continue;
                list.add(road);
            }
        }
    }

    public String[] getLocoRoadNames() {
        Object[] roads = this._locoRoadList.toArray(new String[0]);
        if (this._locoRoadList.size() > 0) {
            Arrays.sort(roads);
        }
        return roads;
    }

    public boolean addLocoRoadName(String road) {
        if (road.isBlank() || this._locoRoadList.contains(road)) {
            return false;
        }
        this._locoRoadList.add(road);
        log.debug("train ({}) add engine road {}", (Object)this.getName(), (Object)road);
        this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._locoRoadList.size() - 1, this._locoRoadList.size());
        return true;
    }

    public boolean deleteLocoRoadName(String road) {
        if (this._locoRoadList.remove(road)) {
            log.debug("train ({}) delete engine road {}", (Object)this.getName(), (Object)road);
            this.setDirtyAndFirePropertyChange(ROADS_CHANGED_PROPERTY, this._locoRoadList.size() + 1, this._locoRoadList.size());
            return true;
        }
        return false;
    }

    public boolean isLocoRoadNameAccepted(String road) {
        if (this._locoRoadOption.equals(ALL_ROADS)) {
            return true;
        }
        if (this._locoRoadOption.equals(INCLUDE_ROADS)) {
            return this._locoRoadList.contains(road);
        }
        return !this._locoRoadList.contains(road);
    }

    protected void replaceRoad(String oldRoad, String newRoad) {
        if (newRoad != null) {
            if (this.deleteCarRoadName(oldRoad)) {
                this.addCarRoadName(newRoad);
            }
            if (this.deleteCabooseRoadName(oldRoad)) {
                this.addCabooseRoadName(newRoad);
            }
            if (this.deleteLocoRoadName(oldRoad)) {
                this.addLocoRoadName(newRoad);
            }
            if (this.getEngineRoad().equals(oldRoad)) {
                this.setEngineRoad(newRoad);
            }
            if (this.getCabooseRoad().equals(oldRoad)) {
                this.setCabooseRoad(newRoad);
            }
            if (this.getSecondLegEngineRoad().equals(oldRoad)) {
                this.setSecondLegEngineRoad(newRoad);
            }
            if (this.getSecondLegCabooseRoad().equals(oldRoad)) {
                this.setSecondLegCabooseRoad(newRoad);
            }
            if (this.getThirdLegEngineRoad().equals(oldRoad)) {
                this.setThirdLegEngineRoad(newRoad);
            }
            if (this.getThirdLegCabooseRoad().equals(oldRoad)) {
                this.setThirdLegCabooseRoad(newRoad);
            }
        }
    }

    public String getLoadOption() {
        return this._loadOption;
    }

    public void setLoadOption(String option) {
        String old = this._loadOption;
        this._loadOption = option;
        this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, old, option);
    }

    public void setLoadNames(String[] loads) {
        if (loads.length > 0) {
            Arrays.sort(loads);
            for (String load : loads) {
                if (load.isEmpty()) continue;
                this._loadList.add(load);
            }
        }
    }

    public String[] getLoadNames() {
        Object[] loads = this._loadList.toArray(new String[0]);
        if (this._loadList.size() > 0) {
            Arrays.sort(loads);
        }
        return loads;
    }

    public boolean addLoadName(String load) {
        if (this._loadList.contains(load)) {
            return false;
        }
        this._loadList.add(load);
        log.debug("train ({}) add car load {}", (Object)this.getName(), (Object)load);
        this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, this._loadList.size() - 1, this._loadList.size());
        return true;
    }

    public boolean deleteLoadName(String load) {
        if (this._loadList.remove(load)) {
            log.debug("train ({}) delete car load {}", (Object)this.getName(), (Object)load);
            this.setDirtyAndFirePropertyChange(LOADS_CHANGED_PROPERTY, this._loadList.size() + 1, this._loadList.size());
            return true;
        }
        return false;
    }

    public boolean isLoadNameAccepted(String load) {
        if (this._loadOption.equals(ALL_LOADS)) {
            return true;
        }
        if (this._loadOption.equals(INCLUDE_LOADS)) {
            return this._loadList.contains(load);
        }
        return !this._loadList.contains(load);
    }

    public boolean isLoadNameAccepted(String load, String type) {
        if (this._loadOption.equals(ALL_LOADS)) {
            return true;
        }
        if (this._loadOption.equals(INCLUDE_LOADS)) {
            return this._loadList.contains(load) || this._loadList.contains(type + " & " + load);
        }
        return !this._loadList.contains(load) && !this._loadList.contains(type + " & " + load);
    }

    public String getOwnerOption() {
        return this._ownerOption;
    }

    public void setOwnerOption(String option) {
        String old = this._ownerOption;
        this._ownerOption = option;
        this.setDirtyAndFirePropertyChange(OWNERS_CHANGED_PROPERTY, old, option);
    }

    public void setOwnerNames(String[] owners) {
        if (owners.length > 0) {
            Arrays.sort(owners);
            for (String owner : owners) {
                if (owner.isEmpty()) continue;
                this._ownerList.add(owner);
            }
        }
    }

    public String[] getOwnerNames() {
        Object[] owners = this._ownerList.toArray(new String[0]);
        if (this._ownerList.size() > 0) {
            Arrays.sort(owners);
        }
        return owners;
    }

    public boolean addOwnerName(String owner) {
        if (this._ownerList.contains(owner)) {
            return false;
        }
        this._ownerList.add(owner);
        log.debug("train ({}) add car owner {}", (Object)this.getName(), (Object)owner);
        this.setDirtyAndFirePropertyChange(OWNERS_CHANGED_PROPERTY, this._ownerList.size() - 1, this._ownerList.size());
        return true;
    }

    public boolean deleteOwnerName(String owner) {
        if (this._ownerList.remove(owner)) {
            log.debug("train ({}) delete car owner {}", (Object)this.getName(), (Object)owner);
            this.setDirtyAndFirePropertyChange(OWNERS_CHANGED_PROPERTY, this._ownerList.size() + 1, this._ownerList.size());
            return true;
        }
        return false;
    }

    public boolean isOwnerNameAccepted(String owner) {
        if (this._ownerOption.equals(ALL_OWNERS)) {
            return true;
        }
        if (this._ownerOption.equals(INCLUDE_OWNERS)) {
            return this._ownerList.contains(owner);
        }
        return !this._ownerList.contains(owner);
    }

    protected void replaceOwner(String oldName, String newName) {
        if (this.deleteOwnerName(oldName)) {
            this.addOwnerName(newName);
        }
    }

    public void setBuiltStartYear(String year) {
        String old = this._builtStartYear;
        this._builtStartYear = year;
        if (!old.equals(year)) {
            this.setDirtyAndFirePropertyChange(BUILT_YEAR_CHANGED_PROPERTY, old, year);
        }
    }

    public String getBuiltStartYear() {
        return this._builtStartYear;
    }

    public void setBuiltEndYear(String year) {
        String old = this._builtEndYear;
        this._builtEndYear = year;
        if (!old.equals(year)) {
            this.setDirtyAndFirePropertyChange(BUILT_YEAR_CHANGED_PROPERTY, old, year);
        }
    }

    public String getBuiltEndYear() {
        return this._builtEndYear;
    }

    public boolean isBuiltDateAccepted(String date) {
        if (this.getBuiltStartYear().equals("") && this.getBuiltEndYear().equals("")) {
            return true;
        }
        int startYear = 0;
        int endYear = 99999;
        int builtYear = -1900;
        if (!this.getBuiltStartYear().equals("")) {
            try {
                startYear = Integer.parseInt(this.getBuiltStartYear());
            }
            catch (NumberFormatException e) {
                log.debug("Train ({}) built start date not initialized, start: {}", (Object)this.getName(), (Object)this.getBuiltStartYear());
            }
        }
        if (!this.getBuiltEndYear().equals("")) {
            try {
                endYear = Integer.parseInt(this.getBuiltEndYear());
            }
            catch (NumberFormatException e) {
                log.debug("Train ({}) built end date not initialized, end: {}", (Object)this.getName(), (Object)this.getBuiltEndYear());
            }
        }
        try {
            builtYear = Integer.parseInt(RollingStockManager.convertBuildDate(date));
        }
        catch (NumberFormatException e) {
            log.debug("Unable to parse car built date {}", (Object)date);
        }
        return startYear < builtYear && builtYear < endYear;
    }

    public boolean isServiceable(Car car) {
        return this.isServiceable(null, car);
    }

    public boolean isServiceable(PrintWriter buildReport, Car car) {
        this.setServiceStatus("");
        if (!this.isTypeNameAccepted(car.getTypeName())) {
            this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarType", this.getName(), car.toString(), car.getTypeName()));
            return false;
        }
        if (!this.isLoadNameAccepted(car.getLoadName(), car.getTypeName())) {
            this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarLoad", this.getName(), car.toString(), car.getTypeName(), car.getLoadName()));
            return false;
        }
        if (!this.isBuiltDateAccepted(car.getBuilt()) || !this.isOwnerNameAccepted(car.getOwnerName()) || !car.isCaboose() && !this.isCarRoadNameAccepted(car.getRoadName()) || car.isCaboose() && !this.isCabooseRoadNameAccepted(car.getRoadName())) {
            this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCar", this.getName(), car.toString()));
            return false;
        }
        Route route = this.getRoute();
        if (route == null) {
            return false;
        }
        if (car.getLocation() == null || car.getTrack() == null) {
            return false;
        }
        if (route.getLastLocationByName(car.getLocationName()) == null) {
            this.addLine(buildReport, Bundle.getMessage("trainNotThisLocation", this.getName(), car.getLocationName()));
            return false;
        }
        if (car.getDestination() != null && (route.getLastLocationByName(car.getDestinationName()) == null || car.getDestination().isStaging() && this.getTrainTerminatesRouteLocation().getLocation() != car.getDestination())) {
            this.addLine(buildReport, Bundle.getMessage("trainNotThisLocation", this.getName(), car.getDestinationName()));
            return false;
        }
        List<RouteLocation> rLocations = route.getLocationsBySequenceList();
        for (RouteLocation rLoc : rLocations) {
            if (!rLoc.getName().equals(car.getLocationName())) continue;
            if (rLoc.getMaxCarMoves() <= 0 || this.isLocationSkipped(rLoc) || !rLoc.isPickUpAllowed() && !car.isLocalMove() || !rLoc.isLocalMovesAllowed() && car.isLocalMove()) {
                this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarFrom", this.getName(), car.toString(), car.getLocationName(), car.getTrackName(), rLoc.getId()));
                continue;
            }
            if ((car.getLocation().getTrainDirections() & rLoc.getTrainDirection()) == 0 && !this.isLocalSwitcher()) {
                this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarLocation", this.getName(), car.toString(), car.getLocationName(), car.getTrackName(), rLoc.getId(), car.getLocationName(), rLoc.getTrainDirectionString()));
                continue;
            }
            if ((car.getTrack().getTrainDirections() & rLoc.getTrainDirection()) == 0 && !this.isLocalSwitcher()) {
                this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarTrack", this.getName(), car.toString(), car.getLocationName(), car.getTrackName(), rLoc.getId(), car.getTrackName(), rLoc.getTrainDirectionString()));
                continue;
            }
            if (!car.getTrack().isPickupTrainAccepted(this)) {
                this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarPickup", this.getName(), car.toString(), car.getLocationName(), car.getTrackName(), rLoc.getId(), car.getTrackName(), this.getName()));
                continue;
            }
            this.addLine(buildReport, Bundle.getMessage("trainCanPickUpCar", this.getName(), car.toString(), car.getLocationName(), car.getTrackName(), rLoc.getId()));
            if (car.getDestination() == null) {
                return true;
            }
            return this.isServiceableDestination(buildReport, car, rLoc, rLocations);
        }
        return false;
    }

    private boolean isServiceableDestination(PrintWriter buildReport, Car car, RouteLocation rLoc, List<RouteLocation> rLocations) {
        int length = car.getTotalKernelLength();
        for (int k = rLocations.indexOf(rLoc); k < rLocations.size(); ++k) {
            RouteLocation rldest = rLocations.get(k);
            if (rldest.getName().equals(car.getDestinationName()) && (rldest.isDropAllowed() && !car.isLocalMove() || rldest.isLocalMovesAllowed() && car.isLocalMove()) && rldest.getMaxCarMoves() > 0 && !this.isLocationSkipped(rldest) && (!Setup.isCheckCarDestinationEnabled() || car.getTrack().isDestinationAccepted(car.getDestination()))) {
                if ((car.getDestination().getTrainDirections() & rldest.getTrainDirection()) == 0 && !this.isLocalSwitcher()) {
                    this.addLine(buildReport, Bundle.getMessage("trainCanNotServiceCarDestination", this.getName(), car.toString(), car.getDestinationName(), rldest.getId(), rldest.getTrainDirectionString()));
                    continue;
                }
                if (car.getDestinationTrack() != null) {
                    if (!this.isServicableTrack(buildReport, car, rldest, car.getDestinationTrack())) {
                        continue;
                    }
                } else {
                    if (!this.isCarToStaging(buildReport, rldest, car)) continue;
                    String status = "";
                    List<Track> tracks = rldest.getLocation().getTracksList();
                    for (Track track : tracks) {
                        if (this.isServicableTrack(buildReport, car, rldest, track) && ((status = track.isRollingStockAccepted(car)).equals(Track.OKAY) || status.startsWith(Track.LENGTH))) break;
                    }
                    if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                        this.addLine(buildReport, Bundle.getMessage("trainCanNotDeliverNoTracks", this.getName(), car.toString(), car.getDestinationName(), rldest.getId()));
                        continue;
                    }
                }
                if (!this.isOnlyToTerminal(buildReport, car)) continue;
                if (!this.isTurn() && car.getTrack().isStaging() && rldest.getLocation() == car.getLocation()) {
                    log.debug("Car ({}) at ({}, {}) not allowed to perform local move in staging ({})", new Object[]{car.toString(), car.getLocationName(), car.getTrackName(), rldest.getName()});
                    continue;
                }
                if (this.isAllowReturnToStagingEnabled() && car.getTrack().isStaging() && rldest.getLocation() == car.getLocation()) {
                    this.addLine(buildReport, Bundle.getMessage("trainCanReturnCarToStaging", this.getName(), car.toString(), car.getDestinationName(), car.getDestinationTrackName()));
                    return true;
                }
                if (!this.isLocalMoveAllowed(buildReport, car, rLoc, rldest) || !this.isTravelOriginToTerminalAllowed(buildReport, rLoc, rldest, car) || !this.isRouteMovesAvailable(buildReport, rldest)) continue;
                return true;
            }
            if (this.isTrainLengthOkay(buildReport, car, rldest, length)) continue;
            return false;
        }
        this.addLine(buildReport, Bundle.getMessage("trainCanNotDeliverToDestination", this.getName(), car.toString(), car.getDestinationName(), car.getDestinationTrackName()));
        return false;
    }

    private boolean isServicableTrack(PrintWriter buildReport, Car car, RouteLocation rldest, Track track) {
        if ((track.getTrainDirections() & rldest.getTrainDirection()) == 0 && !this.isLocalSwitcher()) {
            this.addLine(buildReport, Bundle.getMessage("buildCanNotDropRsUsingTrain", car.toString(), rldest.getTrainDirectionString(), track.getName()));
            return false;
        }
        if (!track.isDropTrainAccepted(this)) {
            this.addLine(buildReport, Bundle.getMessage("buildCanNotDropTrain", car.toString(), this.getName(), track.getTrackTypeName(), track.getLocation().getName(), track.getName()));
            return false;
        }
        return true;
    }

    private boolean isCarToStaging(PrintWriter buildReport, RouteLocation rldest, Car car) {
        String status;
        if (rldest.getLocation().isStaging() && this.getStatusCode() == 1 && this.getTerminationTrack() != null && this.getTerminationTrack().getLocation() == rldest.getLocation() && !(status = car.checkDestination(this.getTerminationTrack().getLocation(), this.getTerminationTrack())).equals(Track.OKAY)) {
            this.addLine(buildReport, Bundle.getMessage("trainCanNotDeliverToStaging", this.getName(), car.toString(), this.getTerminationTrack().getLocation().getName(), this.getTerminationTrack().getName(), status));
            this.setServiceStatus(status);
            return false;
        }
        return true;
    }

    private boolean isOnlyToTerminal(PrintWriter buildReport, Car car) {
        if (this.isSendCarsToTerminalEnabled() && !car.isLocalMove() && !car.getSplitLocationName().equals(TrainCommon.splitString(this.getTrainDepartsName())) && !car.getSplitDestinationName().equals(TrainCommon.splitString(this.getTrainTerminatesName()))) {
            this.addLine(buildReport, Bundle.getMessage("trainCanNotCarryCarOption", this.getName(), car.toString(), car.getLocationName(), car.getTrackName(), car.getDestinationName(), car.getDestinationTrackName()));
            return false;
        }
        return true;
    }

    private boolean isLocalMoveAllowed(PrintWriter buildReport, Car car, RouteLocation rLoc, RouteLocation rldest) {
        if (!(this.isAllowLocalMovesEnabled() && rLoc.isLocalMovesAllowed() && rldest.isLocalMovesAllowed() || this.isLocalSwitcher() || car.isCaboose() || car.hasFred() || car.isPassenger() || !car.isLocalMove())) {
            this.addLine(buildReport, Bundle.getMessage("trainCanNotPerformLocalMove", this.getName(), car.toString(), car.getLocationName()));
            return false;
        }
        return true;
    }

    private boolean isTravelOriginToTerminalAllowed(PrintWriter buildReport, RouteLocation rLoc, RouteLocation rldest, Car car) {
        if (!(this.isAllowThroughCarsEnabled() || !TrainCommon.splitString(this.getTrainDepartsName()).equals(rLoc.getSplitName()) || !TrainCommon.splitString(this.getTrainTerminatesName()).equals(rldest.getSplitName()) || TrainCommon.splitString(this.getTrainDepartsName()).equals(TrainCommon.splitString(this.getTrainTerminatesName())) || this.isLocalSwitcher() || car.isCaboose() || car.hasFred() || car.isPassenger())) {
            this.addLine(buildReport, Bundle.getMessage("trainDoesNotCarryOriginTerminal", this.getName(), car.getLocationName(), car.getDestinationName()));
            return false;
        }
        return true;
    }

    private boolean isRouteMovesAvailable(PrintWriter buildReport, RouteLocation rldest) {
        if (this.getStatusCode() == 1 && rldest.getMaxCarMoves() - rldest.getCarMoves() <= 0) {
            this.setServiceStatus(Bundle.getMessage("trainNoMoves", this.getName(), this.getRoute().getName(), rldest.getId(), rldest.getName()));
            this.addLine(buildReport, this.getServiceStatus());
            return false;
        }
        return true;
    }

    private boolean isTrainLengthOkay(PrintWriter buildReport, Car car, RouteLocation rldest, int length) {
        if (this.getStatusCode() == 1 && rldest.getTrainLength() + length > rldest.getMaxTrainLength()) {
            this.setServiceStatus(Bundle.getMessage("trainExceedsMaximumLength", this.getName(), this.getRoute().getName(), rldest.getId(), rldest.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase(), rldest.getName(), car.toString(), rldest.getTrainLength() + length - rldest.getMaxTrainLength()));
            this.addLine(buildReport, this.getServiceStatus());
            return false;
        }
        return true;
    }

    private void addLine(PrintWriter buildReport, String string) {
        if (Setup.getRouterBuildReportLevel().equals(SEVEN)) {
            TrainCommon.addLine(buildReport, SEVEN, string);
        }
    }

    protected void setServiceStatus(String status) {
        this._serviceStatus = status;
    }

    public String getServiceStatus() {
        return this._serviceStatus;
    }

    public int getNumberCarsWorked() {
        int count = 0;
        for (Car rs : InstanceManager.getDefault(CarManager.class).getList(this)) {
            if (rs.getRouteLocation() == null) continue;
            ++count;
        }
        return count;
    }

    public void setNumberCarsRequested(int number) {
        this._statusCarsRequested = number;
    }

    public int getNumberCarsRequested() {
        return this._statusCarsRequested;
    }

    public void setDate(Date date) {
        this._date = date;
    }

    public String getSortDate() {
        if (this._date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return format.format(this._date);
    }

    public String getDate() {
        if (this._date == null) {
            return "";
        }
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        return format.format(this._date);
    }

    public int getNumberCarsInTrain() {
        return this.getNumberCarsInTrain(this.getCurrentRouteLocation());
    }

    public int getNumberCarsInTrain(RouteLocation routeLocation) {
        int number = 0;
        Route route = this.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                for (Car rs : InstanceManager.getDefault(CarManager.class).getList(this)) {
                    if (rs.getRouteLocation() == rl) {
                        ++number;
                    }
                    if (rs.getRouteDestination() != rl) continue;
                    --number;
                }
                if (rl != routeLocation) continue;
                break;
            }
        }
        return number;
    }

    public int getNumberEmptyCarsInTrain(RouteLocation routeLocation) {
        int number = 0;
        Route route = this.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                for (Car car : InstanceManager.getDefault(CarManager.class).getList(this)) {
                    if (!car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY)) continue;
                    if (car.getRouteLocation() == rl) {
                        ++number;
                    }
                    if (car.getRouteDestination() != rl) continue;
                    --number;
                }
                if (rl != routeLocation) continue;
                break;
            }
        }
        return number;
    }

    public int getNumberLoadedCarsInTrain(RouteLocation routeLocation) {
        return this.getNumberCarsInTrain(routeLocation) - this.getNumberEmptyCarsInTrain(routeLocation);
    }

    public int getNumberCarsPickedUp() {
        return this.getNumberCarsPickedUp(this.getCurrentRouteLocation());
    }

    public int getNumberCarsPickedUp(RouteLocation routeLocation) {
        int number = 0;
        for (Car rs : InstanceManager.getDefault(CarManager.class).getList(this)) {
            if (rs.getRouteLocation() != routeLocation || rs.getTrack() == null) continue;
            ++number;
        }
        return number;
    }

    public int getNumberCarsSetout() {
        return this.getNumberCarsSetout(this.getCurrentRouteLocation());
    }

    public int getNumberCarsSetout(RouteLocation routeLocation) {
        int number = 0;
        for (Car rs : InstanceManager.getDefault(CarManager.class).getList(this)) {
            if (rs.getRouteDestination() != routeLocation) continue;
            ++number;
        }
        return number;
    }

    public int getTrainLength() {
        return this.getTrainLength(this.getCurrentRouteLocation());
    }

    public int getTrainLength(RouteLocation routeLocation) {
        int length = 0;
        Route route = this.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                for (RollingStock rs : InstanceManager.getDefault(EngineManager.class).getList(this)) {
                    if (rs.getRouteLocation() == rl) {
                        length += rs.getTotalLength();
                    }
                    if (rs.getRouteDestination() != rl) continue;
                    length += -rs.getTotalLength();
                }
                for (RollingStock rs : InstanceManager.getDefault(CarManager.class).getList(this)) {
                    if (rs.getRouteLocation() == rl) {
                        length += rs.getTotalLength();
                    }
                    if (rs.getRouteDestination() != rl) continue;
                    length += -rs.getTotalLength();
                }
                if (rl != routeLocation) continue;
                break;
            }
        }
        return length;
    }

    public int getTrainWeight() {
        return this.getTrainWeight(this.getCurrentRouteLocation());
    }

    public int getTrainWeight(RouteLocation routeLocation) {
        int weight = 0;
        Route route = this.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                for (RollingStock rs : InstanceManager.getDefault(EngineManager.class).getList(this)) {
                    if (rs.getRouteLocation() == rl) {
                        weight += rs.getAdjustedWeightTons();
                    }
                    if (rs.getRouteDestination() != rl) continue;
                    weight += -rs.getAdjustedWeightTons();
                }
                for (Car car : InstanceManager.getDefault(CarManager.class).getList(this)) {
                    if (car.getRouteLocation() == rl) {
                        weight += car.getAdjustedWeightTons();
                    }
                    if (car.getRouteDestination() != rl) continue;
                    weight += -car.getAdjustedWeightTons();
                }
                if (rl != routeLocation) continue;
                break;
            }
        }
        return weight;
    }

    public int getTrainHorsePower(RouteLocation routeLocation) {
        int hp = 0;
        Route route = this.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                for (Engine eng : InstanceManager.getDefault(EngineManager.class).getList(this)) {
                    if (eng.getRouteLocation() == rl) {
                        hp += eng.getHpInteger();
                    }
                    if (eng.getRouteDestination() != rl) continue;
                    hp += -eng.getHpInteger();
                }
                if (rl != routeLocation) continue;
                break;
            }
        }
        return hp;
    }

    public String getCabooseRoadAndNumber() {
        Object cabooseRoadNumber = "";
        RouteLocation rl = this.getCurrentRouteLocation();
        List cars = InstanceManager.getDefault(CarManager.class).getByTrainList(this);
        for (Car car : cars) {
            if (car.getRouteLocation() != rl || !car.isCaboose()) continue;
            cabooseRoadNumber = car.getRoadName().split("-")[0] + " " + TrainCommon.splitString(car.getNumber());
        }
        return cabooseRoadNumber;
    }

    public void setDescription(String description) {
        String old = this._description;
        this._description = description;
        if (!old.equals(description)) {
            this.setDirtyAndFirePropertyChange(DESCRIPTION_CHANGED_PROPERTY, old, description);
        }
    }

    public String getRawDescription() {
        return this._description;
    }

    public String getDescription() {
        try {
            String description = MessageFormat.format(this.getRawDescription(), this.getLeadEngineNumber(), this.getTrainDepartsDirection(), this.getLeadEngineRoadName(), this.getLeadEngineDccAddress());
            return description;
        }
        catch (IllegalArgumentException e) {
            return "ERROR IN FORMATTING: " + this.getRawDescription();
        }
    }

    public void setNumberEngines(String number) {
        String old = this._numberEngines;
        this._numberEngines = number;
        if (!old.equals(number)) {
            this.setDirtyAndFirePropertyChange("trainNmberEngines", old, number);
        }
    }

    public String getNumberEngines() {
        return this._numberEngines;
    }

    public String getSecondLegNumberEngines() {
        return this._leg2Engines;
    }

    public void setSecondLegNumberEngines(String number) {
        String old = this._leg2Engines;
        this._leg2Engines = number;
        if (!old.equals(number)) {
            this.setDirtyAndFirePropertyChange("trainNmberEngines", old, number);
        }
    }

    public String getThirdLegNumberEngines() {
        return this._leg3Engines;
    }

    public void setThirdLegNumberEngines(String number) {
        String old = this._leg3Engines;
        this._leg3Engines = number;
        if (!old.equals(number)) {
            this.setDirtyAndFirePropertyChange("trainNmberEngines", old, number);
        }
    }

    public void setEngineRoad(String road) {
        String old = this._engineRoad;
        this._engineRoad = road;
        if (!old.equals(road)) {
            this.setDirtyAndFirePropertyChange("trainEngineRoad", old, road);
        }
    }

    public String getEngineRoad() {
        return this._engineRoad;
    }

    public void setSecondLegEngineRoad(String road) {
        String old = this._leg2Road;
        this._leg2Road = road;
        if (!old.equals(road)) {
            this.setDirtyAndFirePropertyChange("trainEngineRoad", old, road);
        }
    }

    public String getSecondLegEngineRoad() {
        return this._leg2Road;
    }

    public void setThirdLegEngineRoad(String road) {
        String old = this._leg3Road;
        this._leg3Road = road;
        if (!old.equals(road)) {
            this.setDirtyAndFirePropertyChange("trainEngineRoad", old, road);
        }
    }

    public String getThirdLegEngineRoad() {
        return this._leg3Road;
    }

    public void setEngineModel(String model) {
        String old = this._engineModel;
        this._engineModel = model;
        if (!old.equals(model)) {
            this.setDirtyAndFirePropertyChange("trainEngineModel", old, model);
        }
    }

    public String getEngineModel() {
        return this._engineModel;
    }

    public void setSecondLegEngineModel(String model) {
        String old = this._leg2Model;
        this._leg2Model = model;
        if (!old.equals(model)) {
            this.setDirtyAndFirePropertyChange("trainEngineModel", old, model);
        }
    }

    public String getSecondLegEngineModel() {
        return this._leg2Model;
    }

    public void setThirdLegEngineModel(String model) {
        String old = this._leg3Model;
        this._leg3Model = model;
        if (!old.equals(model)) {
            this.setDirtyAndFirePropertyChange("trainEngineModel", old, model);
        }
    }

    public String getThirdLegEngineModel() {
        return this._leg3Model;
    }

    protected void replaceModel(String oldModel, String newModel) {
        if (this.getEngineModel().equals(oldModel)) {
            this.setEngineModel(newModel);
        }
        if (this.getSecondLegEngineModel().equals(oldModel)) {
            this.setSecondLegEngineModel(newModel);
        }
        if (this.getThirdLegEngineModel().equals(oldModel)) {
            this.setThirdLegEngineModel(newModel);
        }
    }

    public void setCabooseRoad(String road) {
        String old = this._cabooseRoad;
        this._cabooseRoad = road;
        if (!old.equals(road)) {
            this.setDirtyAndFirePropertyChange("trainCabooseRoad", old, road);
        }
    }

    public String getCabooseRoad() {
        return this._cabooseRoad;
    }

    public void setSecondLegCabooseRoad(String road) {
        String old = this._leg2CabooseRoad;
        this._leg2CabooseRoad = road;
        if (!old.equals(road)) {
            this.setDirtyAndFirePropertyChange("trainCabooseRoad", old, road);
        }
    }

    public String getSecondLegCabooseRoad() {
        return this._leg2CabooseRoad;
    }

    public void setThirdLegCabooseRoad(String road) {
        String old = this._leg3CabooseRoad;
        this._leg3CabooseRoad = road;
        if (!old.equals(road)) {
            this.setDirtyAndFirePropertyChange("trainCabooseRoad", old, road);
        }
    }

    public String getThirdLegCabooseRoad() {
        return this._leg3CabooseRoad;
    }

    public void setSecondLegStartRouteLocation(RouteLocation rl) {
        this._leg2Start = rl;
    }

    public RouteLocation getSecondLegStartRouteLocation() {
        return this._leg2Start;
    }

    public String getSecondLegStartLocationName() {
        if (this.getSecondLegStartRouteLocation() == null) {
            return "";
        }
        return this.getSecondLegStartRouteLocation().getName();
    }

    public void setThirdLegStartRouteLocation(RouteLocation rl) {
        this._leg3Start = rl;
    }

    public RouteLocation getThirdLegStartRouteLocation() {
        return this._leg3Start;
    }

    public String getThirdLegStartLocationName() {
        if (this.getThirdLegStartRouteLocation() == null) {
            return "";
        }
        return this.getThirdLegStartRouteLocation().getName();
    }

    public void setSecondLegEndRouteLocation(RouteLocation rl) {
        this._end2Leg = rl;
    }

    public String getSecondLegEndLocationName() {
        if (this.getSecondLegEndRouteLocation() == null) {
            return "";
        }
        return this.getSecondLegEndRouteLocation().getName();
    }

    public RouteLocation getSecondLegEndRouteLocation() {
        return this._end2Leg;
    }

    public void setThirdLegEndRouteLocation(RouteLocation rl) {
        this._leg3End = rl;
    }

    public RouteLocation getThirdLegEndRouteLocation() {
        return this._leg3End;
    }

    public String getThirdLegEndLocationName() {
        if (this.getThirdLegEndRouteLocation() == null) {
            return "";
        }
        return this.getThirdLegEndRouteLocation().getName();
    }

    public void setSecondLegOptions(int options) {
        int old = this._leg2Options;
        this._leg2Options = options;
        if (old != options) {
            this.setDirtyAndFirePropertyChange("trainLegOptions", old, options);
        }
    }

    public int getSecondLegOptions() {
        return this._leg2Options;
    }

    public void setThirdLegOptions(int options) {
        int old = this._leg3Options;
        this._leg3Options = options;
        if (old != options) {
            this.setDirtyAndFirePropertyChange("trainLegOptions", old, options);
        }
    }

    public int getThirdLegOptions() {
        return this._leg3Options;
    }

    public void setComment(String comment) {
        String old = this._comment;
        this._comment = comment;
        if (!old.equals(comment)) {
            this.setDirtyAndFirePropertyChange("trainComment", old, comment);
        }
    }

    public String getComment() {
        return TrainCommon.getTextColorString(this.getCommentWithColor());
    }

    public String getCommentWithColor() {
        return this._comment;
    }

    public void addBuildScript(String pathname) {
        this._buildScripts.add(pathname);
        this.setDirtyAndFirePropertyChange("addBuildScript", pathname, null);
    }

    public void deleteBuildScript(String pathname) {
        this._buildScripts.remove(pathname);
        this.setDirtyAndFirePropertyChange("deleteBuildScript", null, pathname);
    }

    public List<String> getBuildScripts() {
        return this._buildScripts;
    }

    public void addAfterBuildScript(String pathname) {
        this._afterBuildScripts.add(pathname);
        this.setDirtyAndFirePropertyChange("addAfterBuildScript", pathname, null);
    }

    public void deleteAfterBuildScript(String pathname) {
        this._afterBuildScripts.remove(pathname);
        this.setDirtyAndFirePropertyChange("deleteAfterBuildScript", null, pathname);
    }

    public List<String> getAfterBuildScripts() {
        return this._afterBuildScripts;
    }

    public void addMoveScript(String pathname) {
        this._moveScripts.add(pathname);
        this.setDirtyAndFirePropertyChange("addMoveScript", pathname, null);
    }

    public void deleteMoveScript(String pathname) {
        this._moveScripts.remove(pathname);
        this.setDirtyAndFirePropertyChange("deleteMoveScript", null, pathname);
    }

    public List<String> getMoveScripts() {
        return this._moveScripts;
    }

    public void addTerminationScript(String pathname) {
        this._terminationScripts.add(pathname);
        this.setDirtyAndFirePropertyChange("addTerminationScript", pathname, null);
    }

    public void deleteTerminationScript(String pathname) {
        this._terminationScripts.remove(pathname);
        this.setDirtyAndFirePropertyChange("deleteTerminationScript", null, pathname);
    }

    public List<String> getTerminationScripts() {
        return this._terminationScripts;
    }

    public String getRailroadName() {
        return this._railroadName;
    }

    public void setRailroadName(String name) {
        String old = this._railroadName;
        this._railroadName = name;
        if (!old.equals(name)) {
            this.setDirtyAndFirePropertyChange("trainRailroadName", old, name);
        }
    }

    public String getManifestLogoPathName() {
        return this._logoPathName;
    }

    public void setManifestLogoPathName(String pathName) {
        this._logoPathName = pathName;
    }

    public boolean isShowArrivalAndDepartureTimesEnabled() {
        return this._showTimes;
    }

    public void setShowArrivalAndDepartureTimes(boolean enable) {
        boolean old = this._showTimes;
        this._showTimes = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("showArrivalAndDepartureTimes", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isSendCarsToTerminalEnabled() {
        return this._sendToTerminal;
    }

    public void setSendCarsToTerminalEnabled(boolean enable) {
        boolean old = this._sendToTerminal;
        this._sendToTerminal = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("send cars to terminal", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isAllowLocalMovesEnabled() {
        return this._allowLocalMoves;
    }

    public void setAllowLocalMovesEnabled(boolean enable) {
        boolean old = this._allowLocalMoves;
        this._allowLocalMoves = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("allow local moves", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isAllowThroughCarsEnabled() {
        return this._allowThroughCars;
    }

    public void setAllowThroughCarsEnabled(boolean enable) {
        boolean old = this._allowThroughCars;
        this._allowThroughCars = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("allow through cars", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isBuildTrainNormalEnabled() {
        return this._buildNormal;
    }

    public void setBuildTrainNormalEnabled(boolean enable) {
        boolean old = this._buildNormal;
        this._buildNormal = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("build train normal", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isAllowReturnToStagingEnabled() {
        return this._allowCarsReturnStaging;
    }

    public void setAllowReturnToStagingEnabled(boolean enable) {
        boolean old = this._allowCarsReturnStaging;
        this._allowCarsReturnStaging = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("allow cars to return to staging", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isServiceAllCarsWithFinalDestinationsEnabled() {
        return this._serviceAllCarsWithFinalDestinations;
    }

    public void setServiceAllCarsWithFinalDestinationsEnabled(boolean enable) {
        boolean old = this._serviceAllCarsWithFinalDestinations;
        this._serviceAllCarsWithFinalDestinations = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("TrainServiceAllCarsWithFinalDestinations", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isBuildConsistEnabled() {
        return this._buildConsist;
    }

    public void setBuildConsistEnabled(boolean enable) {
        boolean old = this._buildConsist;
        this._buildConsist = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("TrainBuildConsist", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public boolean isSendCarsWithCustomLoadsToStagingEnabled() {
        return this._sendCarsWithCustomLoadsToStaging;
    }

    public void setSendCarsWithCustomLoadsToStagingEnabled(boolean enable) {
        boolean old = this._sendCarsWithCustomLoadsToStaging;
        this._sendCarsWithCustomLoadsToStaging = enable;
        if (old != enable) {
            this.setDirtyAndFirePropertyChange("SendCarsWithCustomLoadsToStaging", old ? "true" : "false", enable ? "true" : "false");
        }
    }

    public void setBuilt(boolean built) {
        boolean old = this._built;
        this._built = built;
        if (old != built) {
            this.setDirtyAndFirePropertyChange(BUILT_CHANGED_PROPERTY, old, built);
        }
    }

    public boolean isBuilt() {
        return this._built;
    }

    public void setModified(boolean modified) {
        log.debug("Set modified {}", (Object)modified);
        if (!this.isBuilt()) {
            this._modified = false;
            return;
        }
        boolean old = this._modified;
        this._modified = modified;
        if (modified) {
            this.setPrinted(false);
        }
        if (old != modified) {
            if (modified) {
                if (this.getStatusCode() != 256) {
                    this.setOldStatusCode(this.getStatusCode());
                }
                this.setStatusCode(512);
            } else {
                this.setStatusCode(this.getOldStatusCode());
            }
        }
        this.setDirtyAndFirePropertyChange(TRAIN_MODIFIED_CHANGED_PROPERTY, null, modified);
    }

    public boolean isModified() {
        return this._modified;
    }

    public void setBuildEnabled(boolean build) {
        boolean old = this._build;
        this._build = build;
        if (old != build) {
            this.setDirtyAndFirePropertyChange(BUILD_CHANGED_PROPERTY, old, build);
        }
    }

    public boolean isBuildEnabled() {
        return this._build;
    }

    public boolean buildIfSelected() {
        if (this.isBuildEnabled() && !this.isBuilt()) {
            return this.build();
        }
        log.debug("Train ({}) not selected or already built, skipping build", (Object)this.getName());
        return false;
    }

    public synchronized boolean build() {
        this.reset();
        int count = 1200;
        while (InstanceManager.getDefault(TrainManager.class).isAnyTrainBuilding() && count > 0) {
            --count;
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                log.error("Thread unexpectedly interrupted", (Throwable)e);
            }
        }
        if (count <= 0) {
            log.warn("Build timeout for train ({})", (Object)this.getName());
            this.setBuildFailed(true);
            this.setStatusCode(2);
            return false;
        }
        this.runScripts(this.getBuildScripts());
        TrainBuilder tb = new TrainBuilder();
        boolean results = tb.build(this);
        this.runScripts(this.getAfterBuildScripts());
        return results;
    }

    private synchronized void runScripts(List<String> scripts) {
        if (scripts.size() > 0) {
            this.setOldStatusCode(this.getStatusCode());
            this.setStatusCode(256);
            JmriScriptEngineManager.getDefault().initializeAllEngines();
            ThreadGroup root = Thread.currentThread().getThreadGroup();
            int numberOfThreads = root.activeCount();
            for (String scriptPathname : scripts) {
                try {
                    JmriScriptEngineManager.getDefault().runScript(new File(FileUtil.getExternalFilename(scriptPathname)));
                }
                catch (Exception e) {
                    log.error("Problem with script: {}", (Object)scriptPathname);
                }
            }
            int count = 0;
            while (root.activeCount() > numberOfThreads) {
                log.debug("Number of active threads: {}, at start: {}", (Object)root.activeCount(), (Object)numberOfThreads);
                try {
                    this.wait(40L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (count++ <= 100) continue;
            }
            this.setStatusCode(this.getOldStatusCode());
        }
    }

    public boolean printBuildReport() {
        boolean isPreview = InstanceManager.getDefault(TrainManager.class).isPrintPreviewEnabled() || Setup.isBuildReportAlwaysPreviewEnabled();
        return this.printBuildReport(isPreview);
    }

    public boolean printBuildReport(boolean isPreview) {
        File buildFile = InstanceManager.getDefault(TrainManagerXml.class).getTrainBuildReportFile(this.getName());
        if (!buildFile.exists()) {
            log.warn("Build file missing for train {}", (Object)this.getName());
            return false;
        }
        if (isPreview && Setup.isBuildReportEditorEnabled()) {
            TrainPrintUtilities.editReport(buildFile, this.getName());
        } else {
            TrainPrintUtilities.printReport(buildFile, Bundle.getMessage("buildReport", this.getDescription()), isPreview, "", true, "", "", Setup.PORTRAIT, Setup.getBuildReportFontSize(), true, null);
        }
        return true;
    }

    public void setBuildFailed(boolean status) {
        boolean old = this._buildFailed;
        this._buildFailed = status;
        if (old != status) {
            this.setDirtyAndFirePropertyChange("buildFailed", old ? "true" : "false", status ? "true" : "false");
        }
    }

    public boolean isBuildFailed() {
        return this._buildFailed;
    }

    public void setBuildFailedMessage(String message) {
        String old = this._buildFailedMessage;
        this._buildFailedMessage = message;
        if (!old.equals(message)) {
            this.setDirtyAndFirePropertyChange("buildFailedMessage", old, message);
        }
    }

    protected String getBuildFailedMessage() {
        return this._buildFailedMessage;
    }

    public boolean printManifestIfBuilt() {
        if (this.isBuilt()) {
            boolean isPreview = InstanceManager.getDefault(TrainManager.class).isPrintPreviewEnabled();
            try {
                return this.printManifest(isPreview);
            }
            catch (BuildFailedException e) {
                log.error("Print Manifest failed: {}", (Object)e.getMessage());
            }
        } else {
            log.debug("Need to build train ({}) before printing manifest", (Object)this.getName());
        }
        return false;
    }

    public boolean printManifest(boolean isPreview) throws BuildFailedException {
        String name;
        File file;
        if (this.isModified()) {
            new TrainManifest(this);
            try {
                new JsonManifest(this).build();
            }
            catch (IOException ex) {
                log.error("Unable to create JSON manifest {}", (Object)ex.getLocalizedMessage());
            }
            new TrainCsvManifest(this);
        }
        if (!(file = InstanceManager.getDefault(TrainManagerXml.class).getTrainManifestFile(this.getName())).exists()) {
            log.warn("Manifest file missing for train ({})", (Object)this.getName());
            return false;
        }
        if (isPreview && Setup.isManifestEditorEnabled()) {
            TrainUtilities.openDesktop(file);
            return true;
        }
        String logoURL = "";
        if (!this.getManifestLogoPathName().equals("")) {
            logoURL = FileUtil.getExternalFilename(this.getManifestLogoPathName());
        } else if (!Setup.getManifestLogoURL().equals("")) {
            logoURL = FileUtil.getExternalFilename(Setup.getManifestLogoURL());
        }
        Location departs = InstanceManager.getDefault(LocationManager.class).getLocationByName(this.getTrainDepartsName());
        String printerName = "";
        if (departs != null) {
            printerName = departs.getDefaultPrinterName();
        }
        if ((name = this.getDescription()).length() > TrainCommon.getManifestHeaderLineLength() / 2) {
            name = name.substring(0, TrainCommon.getManifestHeaderLineLength() / 2);
        }
        TrainPrintUtilities.printReport(file, name, isPreview, Setup.getFontName(), false, logoURL, printerName, Setup.getManifestOrientation(), Setup.getManifestFontSize(), Setup.isPrintPageHeaderEnabled(), Setup.getPrintDuplexSides());
        if (!isPreview) {
            this.setPrinted(true);
        }
        return true;
    }

    public boolean openFile() {
        File file = this.createCsvManifestFile();
        if (file == null || !file.exists()) {
            log.warn("CSV manifest file missing for train {}", (Object)this.getName());
            return false;
        }
        TrainUtilities.openDesktop(file);
        return true;
    }

    public boolean runFile() {
        File file = this.createCsvManifestFile();
        if (file == null || !file.exists()) {
            log.warn("CSV manifest file missing for train {}", (Object)this.getName());
            return false;
        }
        InstanceManager.getDefault(TrainCustomManifest.class).addCsvFile(file);
        if (!InstanceManager.getDefault(TrainCustomManifest.class).process()) {
            if (!InstanceManager.getDefault(TrainCustomManifest.class).excelFileExists()) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LoadDirectoryNameFileName", InstanceManager.getDefault(TrainCustomManifest.class).getDirectoryPathName(), InstanceManager.getDefault(TrainCustomManifest.class).getFileName()), Bundle.getMessage("ManifestCreatorNotFound"), 0);
            }
            return false;
        }
        return true;
    }

    public File createCsvManifestFile() {
        File file;
        if (this.isModified()) {
            try {
                new TrainManifest(this);
                try {
                    new JsonManifest(this).build();
                }
                catch (IOException ex) {
                    log.error("Unable to create JSON manifest {}", (Object)ex.getLocalizedMessage());
                }
                new TrainCsvManifest(this);
            }
            catch (BuildFailedException e) {
                log.error("Could not create CVS Manifest files");
            }
        }
        if (!(file = InstanceManager.getDefault(TrainManagerXml.class).getTrainCsvManifestFile(this.getName())).exists()) {
            log.warn("CSV manifest file was not created for train ({})", (Object)this.getName());
            return null;
        }
        return file;
    }

    public void setPrinted(boolean printed) {
        boolean old = this._printed;
        this._printed = printed;
        if (old != printed) {
            this.setDirtyAndFirePropertyChange("trainPrinted", old ? "true" : "false", printed ? "true" : "false");
        }
    }

    public boolean isPrinted() {
        return this._printed;
    }

    public boolean setTrainIconCoordinates() {
        if (Setup.isTrainIconCordEnabled() && this.getCurrentRouteLocation() != null && this._trainIcon != null) {
            this.getCurrentRouteLocation().setTrainIconX(this._trainIcon.getX());
            this.getCurrentRouteLocation().setTrainIconY(this._trainIcon.getY());
            return true;
        }
        return false;
    }

    public void terminate() {
        while (this.isBuilt()) {
            this.move();
        }
    }

    public void move() {
        log.debug("Move train ({})", (Object)this.getName());
        if (this.getRoute() == null || this.getCurrentRouteLocation() == null) {
            this.setBuilt(false);
            return;
        }
        if (!this.isBuilt()) {
            log.error("ERROR attempt to move train ({}) that hasn't been built", (Object)this.getName());
            return;
        }
        RouteLocation rl = this.getCurrentRouteLocation();
        RouteLocation rlNext = this.getNextRouteLocation(rl);
        this.setCurrentLocation(rlNext);
        this.setDirtyAndFirePropertyChange(TRAIN_LOCATION_CHANGED_PROPERTY, rl, rlNext);
        this.moveTrainIcon(rlNext);
        this.updateStatus(rl, rlNext);
        this.setDirtyAndFirePropertyChange(TRAIN_MOVE_COMPLETE_CHANGED_PROPERTY, rl, rlNext);
    }

    public boolean move(String locationName) {
        log.info("Move train ({}) to location ({})", (Object)this.getName(), (Object)locationName);
        if (this.getRoute() == null || this.getCurrentRouteLocation() == null) {
            return false;
        }
        List<RouteLocation> routeList = this.getRoute().getLocationsBySequenceList();
        for (int i = 0; i < routeList.size(); ++i) {
            RouteLocation rl = routeList.get(i);
            if (this.getCurrentRouteLocation() != rl) continue;
            for (int j = i + 1; j < routeList.size(); ++j) {
                rl = routeList.get(j);
                if (!rl.getName().equals(locationName)) continue;
                log.debug("Found location ({}) moving train to this location", (Object)locationName);
                for (j = i + 1; j < routeList.size(); ++j) {
                    rl = routeList.get(j);
                    this.move();
                    if (!rl.getName().equals(locationName)) continue;
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public boolean move(RouteLocation rl) {
        if (rl == null) {
            return false;
        }
        log.debug("Move train ({}) to location ({})", (Object)this.getName(), (Object)rl.getName());
        if (this.getRoute() == null || this.getCurrentRouteLocation() == null) {
            return false;
        }
        boolean foundCurrent = false;
        for (RouteLocation xrl : this.getRoute().getLocationsBySequenceList()) {
            if (this.getCurrentRouteLocation() == xrl) {
                foundCurrent = true;
            }
            if (xrl == rl) {
                if (!foundCurrent) break;
                return true;
            }
            if (!foundCurrent) continue;
            this.move();
        }
        return false;
    }

    public boolean moveToNextLocation(String locationName) {
        if (this.getNextLocationName().equals(locationName)) {
            this.move();
            return true;
        }
        return false;
    }

    public void loadTrainIcon() {
        if (this.getCurrentRouteLocation() != null) {
            this.moveTrainIcon(this.getCurrentRouteLocation());
        }
    }

    public void moveTrainIcon(RouteLocation rl) {
        if (rl == this.getTrainDepartsRouteLocation() || this._trainIcon == null || !this._trainIcon.isActive()) {
            this.createTrainIcon(rl);
        }
        if (this.getLeadEngine() != null && this.getLeadEngine().getRouteDestination() == rl && rl != null) {
            log.debug("Engine ({}) arriving at destination {}", (Object)this.getLeadEngine().toString(), (Object)rl.getName());
        }
        if (this._trainIcon != null && this._trainIcon.isActive()) {
            this.setTrainIconColor();
            this._trainIcon.setShowToolTip(true);
            Object txt = null;
            txt = this.getCurrentLocationName().equals("") ? this.getDescription() + " " + Bundle.getMessage("Terminated") + " (" + this.getTrainTerminatesName() + ")" : Bundle.getMessage("TrainAtNext", this.getDescription(), this.getCurrentLocationName(), this.getNextLocationName(), this.getTrainLength(), Setup.getLengthUnit().toLowerCase());
            this._trainIcon.getToolTip().setText((String)txt);
            this._trainIcon.getToolTip().setBackgroundColor(Color.white);
            if (rl != null && (rl.getTrainIconX() != 0 || rl.getTrainIconY() != 0)) {
                TrainIconAnimation ta = new TrainIconAnimation(this._trainIcon, rl, this._ta);
                ta.start();
                this._ta = ta;
            }
        }
    }

    public String getIconName() {
        Object name = this.getName();
        if (this.isBuilt() && this.getLeadEngine() != null && Setup.isTrainIconAppendEnabled()) {
            name = (String)name + " " + this.getLeadEngine().getNumber();
        }
        return name;
    }

    public String getLeadEngineNumber() {
        if (this.getLeadEngine() == null) {
            return "";
        }
        return this.getLeadEngine().getNumber();
    }

    public String getLeadEngineRoadName() {
        if (this.getLeadEngine() == null) {
            return "";
        }
        return this.getLeadEngine().getRoadName();
    }

    public String getLeadEngineRoadAndNumber() {
        if (this.getLeadEngine() == null) {
            return "";
        }
        return this.getLeadEngine().toString();
    }

    public String getLeadEngineDccAddress() {
        if (this.getLeadEngine() == null) {
            return "";
        }
        return this.getLeadEngine().getDccAddress();
    }

    public Engine getLeadEngine() {
        if (this._leadEngine == null && !this._leadEngineId.equals("")) {
            this._leadEngine = (Engine)InstanceManager.getDefault(EngineManager.class).getById(this._leadEngineId);
        }
        return this._leadEngine;
    }

    public void setLeadEngine(Engine engine) {
        if (engine == null) {
            this._leadEngineId = "";
        }
        this._leadEngine = engine;
    }

    public Engine getLeadEngine(RouteLocation routeLocation) {
        Engine lead = null;
        for (RouteLocation rl : this.getRoute().getLocationsBySequenceList()) {
            for (Engine engine : InstanceManager.getDefault(EngineManager.class).getByTrainList(this)) {
                if (engine.getRouteLocation() != rl || engine.getConsist() != null && !engine.isLead()) continue;
                lead = engine;
                break;
            }
            if (rl != routeLocation) continue;
            break;
        }
        return lead;
    }

    public TrainIcon getTrainIcon() {
        return this._trainIcon;
    }

    public void createTrainIcon(RouteLocation rl) {
        Editor editor;
        if (this._trainIcon != null && this._trainIcon.isActive()) {
            this._trainIcon.remove();
        }
        if (!Setup.getPanelName().isEmpty() && (editor = InstanceManager.getDefault(EditorManager.class).getTargetFrame(Setup.getPanelName())) != null) {
            try {
                this._trainIcon = editor.addTrainIcon(this.getIconName());
            }
            catch (Exception e) {
                log.error("Error placing train ({}) icon on panel ({})", new Object[]{this.getName(), Setup.getPanelName(), e});
                return;
            }
            this._trainIcon.setTrain(this);
            if (this.getIconName().length() > 9) {
                this._trainIcon.setFont(this._trainIcon.getFont().deriveFont(8.0f));
            }
            if (rl != null) {
                this._trainIcon.setLocation(rl.getTrainIconX(), rl.getTrainIconY());
            }
            if (InstanceManager.getNullableDefault(ThrottleManager.class) != null) {
                RosterEntry entry = null;
                if (this.getLeadEngine() != null) {
                    entry = this.getLeadEngine().getRosterEntry();
                }
                if (entry != null) {
                    this._trainIcon.setRosterEntry(entry);
                    if (this.getLeadEngine().getConsist() != null) {
                        this._trainIcon.setConsistNumber(this.getLeadEngine().getConsist().getConsistNumber());
                    }
                } else {
                    log.debug("Loco roster entry not found for train ({})", (Object)this.getName());
                }
            }
        }
    }

    private void setTrainIconColor() {
        if (this.getCurrentLocationName().equals("")) {
            this._trainIcon.setLocoColor(Setup.getTrainIconColorTerminate());
            return;
        }
        if (this.isLocalSwitcher()) {
            this._trainIcon.setLocoColor(Setup.getTrainIconColorLocal());
            return;
        }
        if (this.getCurrentRouteLocation().getTrainDirection() == 4) {
            this._trainIcon.setLocoColor(Setup.getTrainIconColorNorth());
        }
        if (this.getCurrentRouteLocation().getTrainDirection() == 8) {
            this._trainIcon.setLocoColor(Setup.getTrainIconColorSouth());
        }
        if (this.getCurrentRouteLocation().getTrainDirection() == 1) {
            this._trainIcon.setLocoColor(Setup.getTrainIconColorEast());
        }
        if (this.getCurrentRouteLocation().getTrainDirection() == 2) {
            this._trainIcon.setLocoColor(Setup.getTrainIconColorWest());
        }
    }

    private void updateStatus(RouteLocation old, RouteLocation next) {
        if (next != null) {
            this.setStatusCode(24);
            this.runScripts(this.getMoveScripts());
        } else {
            log.debug("Train ({}) terminated", (Object)this.getName());
            this.setStatusCode(128);
            this.setBuilt(false);
            this.runScripts(this.getTerminationScripts());
        }
    }

    public void setSwitchListStatus(String status) {
        String old = this._switchListStatus;
        this._switchListStatus = status;
        if (!old.equals(status)) {
            this.setDirtyAndFirePropertyChange("switch list train status", old, status);
        }
    }

    public String getSwitchListStatus() {
        return this._switchListStatus;
    }

    public boolean reset() {
        if (this.isTrainEnRoute()) {
            log.info("Train ({}) has started its route, can not be reset", (Object)this.getName());
            return false;
        }
        this.setCurrentLocation(null);
        this.setDepartureTrack(null);
        this.setTerminationTrack(null);
        this.setBuilt(false);
        this.setBuildFailed(false);
        this.setBuildFailedMessage("");
        this.setPrinted(false);
        this.setModified(false);
        this.setStatusCode(0);
        if (this._trainIcon != null && this._trainIcon.isActive()) {
            this._trainIcon.remove();
        }
        return true;
    }

    public void dispose() {
        if (this.getRoute() != null) {
            this.getRoute().removePropertyChangeListener(this);
        }
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineModels.class).removePropertyChangeListener(this);
        this.setDirtyAndFirePropertyChange(DISPOSE_CHANGED_PROPERTY, null, "Dispose");
    }

    public Train(Element e) {
        Object owners;
        String[] loads;
        String[] roads;
        List carRoads;
        String names;
        String[] types;
        int i;
        String[] locs;
        Element eRoute;
        Element eRowColor;
        Attribute a = e.getAttribute("id");
        if (a != null) {
            this._id = a.getValue();
        } else {
            log.warn("no id attribute in train element when reading operations");
        }
        a = e.getAttribute("name");
        if (a != null) {
            this._name = a.getValue();
        }
        if ((a = e.getAttribute("description")) != null) {
            this._description = a.getValue();
        }
        if ((a = e.getAttribute("departHour")) != null) {
            String hour = a.getValue();
            a = e.getAttribute("departMinute");
            if (a != null) {
                String minute = a.getValue();
                this._departureTime = hour + ":" + minute;
            }
        }
        if ((eRowColor = e.getChild("rowColor")) != null && (a = eRowColor.getAttribute("name")) != null) {
            this._tableRowColorName = a.getValue().toLowerCase();
        }
        if (eRowColor != null && (a = eRowColor.getAttribute("resetRowColor")) != null) {
            this._tableRowColorResetName = a.getValue().toLowerCase();
        }
        if ((eRoute = e.getChild("route")) != null) {
            a = eRoute.getAttribute("id");
            if (a != null) {
                this.setRoute(InstanceManager.getDefault(RouteManager.class).getRouteById(a.getValue()));
            }
            if (eRoute.getChild("skips") != null) {
                List skips = eRoute.getChild("skips").getChildren("location");
                locs = new String[skips.size()];
                for (i = 0; i < skips.size(); ++i) {
                    Element loc = (Element)skips.get(i);
                    a = loc.getAttribute("id");
                    if (a == null) continue;
                    locs[i] = a.getValue();
                }
                this.setTrainSkipsLocations(locs);
            }
        } else {
            a = e.getAttribute("routeId");
            if (a != null) {
                this.setRoute(InstanceManager.getDefault(RouteManager.class).getRouteById(a.getValue()));
            } else {
                a = e.getAttribute("route");
                if (a != null) {
                    this.setRoute(InstanceManager.getDefault(RouteManager.class).getRouteByName(a.getValue()));
                }
            }
            a = e.getAttribute("skip");
            if (a != null) {
                String locationIds = a.getValue();
                locs = locationIds.split("%%");
                this.setTrainSkipsLocations(locs);
            }
        }
        if (e.getChild("types") != null) {
            List carTypes = e.getChild("types").getChildren("carType");
            types = new String[carTypes.size()];
            for (i = 0; i < carTypes.size(); ++i) {
                Element type = (Element)carTypes.get(i);
                a = type.getAttribute("name");
                if (a == null) continue;
                types[i] = a.getValue();
            }
            this.setTypeNames(types);
            List locoTypes = e.getChild("types").getChildren("locoType");
            types = new String[locoTypes.size()];
            for (int i2 = 0; i2 < locoTypes.size(); ++i2) {
                Element type = (Element)locoTypes.get(i2);
                a = type.getAttribute("name");
                if (a == null) continue;
                types[i2] = a.getValue();
            }
            this.setTypeNames(types);
        } else {
            a = e.getAttribute("carTypes");
            if (a != null) {
                names = a.getValue();
                types = names.split("%%");
                this.setTypeNames(types);
            }
        }
        a = e.getAttribute("carRoadOperation");
        if (a != null) {
            this._carRoadOption = a.getValue();
        }
        if ((a = e.getAttribute("carRoadOption")) != null) {
            this._carRoadOption = a.getValue();
        }
        if (e.getChild("carRoads") != null) {
            carRoads = e.getChild("carRoads").getChildren("carRoad");
            roads = new String[carRoads.size()];
            for (int i3 = 0; i3 < carRoads.size(); ++i3) {
                Element road = (Element)carRoads.get(i3);
                a = road.getAttribute("name");
                if (a == null) continue;
                roads[i3] = a.getValue();
            }
            this.setCarRoadNames(roads);
        } else {
            a = e.getAttribute("carRoads");
            if (a != null) {
                names = a.getValue();
                roads = names.split("%%");
                log.debug("Train ({}) {} car roads: {}", new Object[]{this.getName(), this.getCarRoadOption(), names});
                this.setCarRoadNames(roads);
            }
        }
        a = e.getAttribute("cabooseRoadOption");
        if (a != null) {
            this._cabooseRoadOption = a.getValue();
        }
        if (e.getChild("cabooseRoads") != null) {
            carRoads = e.getChild("cabooseRoads").getChildren("carRoad");
            roads = new String[carRoads.size()];
            for (int i4 = 0; i4 < carRoads.size(); ++i4) {
                Element road = (Element)carRoads.get(i4);
                a = road.getAttribute("name");
                if (a == null) continue;
                roads[i4] = a.getValue();
            }
            this.setCabooseRoadNames(roads);
        }
        if ((a = e.getAttribute("locoRoadOption")) != null) {
            this._locoRoadOption = a.getValue();
        }
        if (e.getChild("locoRoads") != null) {
            List locoRoads = e.getChild("locoRoads").getChildren("locoRoad");
            roads = new String[locoRoads.size()];
            for (int i5 = 0; i5 < locoRoads.size(); ++i5) {
                Element road = (Element)locoRoads.get(i5);
                a = road.getAttribute("name");
                if (a == null) continue;
                roads[i5] = a.getValue();
            }
            this.setLocoRoadNames(roads);
        }
        if ((a = e.getAttribute("carLoadOption")) != null) {
            this._loadOption = a.getValue();
        }
        if ((a = e.getAttribute("carOwnerOption")) != null) {
            this._ownerOption = a.getValue();
        }
        if ((a = e.getAttribute("builtStartYear")) != null) {
            this._builtStartYear = a.getValue();
        }
        if ((a = e.getAttribute("builtEndYear")) != null) {
            this._builtEndYear = a.getValue();
        }
        if (e.getChild("carLoads") != null) {
            List carLoads = e.getChild("carLoads").getChildren("carLoad");
            loads = new String[carLoads.size()];
            for (int i6 = 0; i6 < carLoads.size(); ++i6) {
                Element load = (Element)carLoads.get(i6);
                a = load.getAttribute("name");
                if (a == null) continue;
                loads[i6] = a.getValue();
            }
            this.setLoadNames(loads);
        } else {
            a = e.getAttribute("carLoads");
            if (a != null) {
                names = a.getValue();
                loads = names.split("%%");
                log.debug("Train ({}) {} car loads: {}", new Object[]{this.getName(), this.getLoadOption(), names});
                this.setLoadNames(loads);
            }
        }
        if (e.getChild("carOwners") != null) {
            List carOwners = e.getChild("carOwners").getChildren("carOwner");
            owners = new String[carOwners.size()];
            for (int i7 = 0; i7 < carOwners.size(); ++i7) {
                Element owner = (Element)carOwners.get(i7);
                a = owner.getAttribute("name");
                if (a == null) continue;
                owners[i7] = a.getValue();
            }
            this.setOwnerNames((String[])owners);
        } else {
            a = e.getAttribute("carOwners");
            if (a != null) {
                names = a.getValue();
                owners = names.split("%%");
                log.debug("Train ({}) {} car owners: {}", new Object[]{this.getName(), this.getOwnerOption(), names});
                this.setOwnerNames((String[])owners);
            }
        }
        a = e.getAttribute("numberEngines");
        if (a != null) {
            this._numberEngines = a.getValue();
        }
        if ((a = e.getAttribute("leg2Engines")) != null) {
            this._leg2Engines = a.getValue();
        }
        if ((a = e.getAttribute("leg3Engines")) != null) {
            this._leg3Engines = a.getValue();
        }
        if ((a = e.getAttribute("engineRoad")) != null) {
            this._engineRoad = a.getValue();
        }
        if ((a = e.getAttribute("leg2Road")) != null) {
            this._leg2Road = a.getValue();
        }
        if ((a = e.getAttribute("leg3Road")) != null) {
            this._leg3Road = a.getValue();
        }
        if ((a = e.getAttribute("engineModel")) != null) {
            this._engineModel = a.getValue();
        }
        if ((a = e.getAttribute("leg2Model")) != null) {
            this._leg2Model = a.getValue();
        }
        if ((a = e.getAttribute("leg3Model")) != null) {
            this._leg3Model = a.getValue();
        }
        if ((a = e.getAttribute("requires")) != null) {
            try {
                this._requires = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Requires ({}) isn't a valid number for train ({})", (Object)a.getValue(), (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("cabooseRoad")) != null) {
            this._cabooseRoad = a.getValue();
        }
        if ((a = e.getAttribute("leg2CabooseRoad")) != null) {
            this._leg2CabooseRoad = a.getValue();
        }
        if ((a = e.getAttribute("leg3CabooseRoad")) != null) {
            this._leg3CabooseRoad = a.getValue();
        }
        if ((a = e.getAttribute("leg2Options")) != null) {
            try {
                this._leg2Options = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Leg 2 options ({}) isn't a valid number for train ({})", (Object)a.getValue(), (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("leg3Options")) != null) {
            try {
                this._leg3Options = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Leg 3 options ({}) isn't a valid number for train ({})", (Object)a.getValue(), (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("buildNormal")) != null) {
            this._buildNormal = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("toTerminal")) != null) {
            this._sendToTerminal = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("allowLocalMoves")) != null) {
            this._allowLocalMoves = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("allowThroughCars")) != null) {
            this._allowThroughCars = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("allowReturn")) != null) {
            this._allowCarsReturnStaging = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("serviceAll")) != null) {
            this._serviceAllCarsWithFinalDestinations = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("buildConsist")) != null) {
            this._buildConsist = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("sendCustomStaging")) != null) {
            this._sendCarsWithCustomLoadsToStaging = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("built")) != null) {
            this._built = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("build")) != null) {
            this._build = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("buildFailed")) != null) {
            this._buildFailed = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("buildFailedMessage")) != null) {
            this._buildFailedMessage = a.getValue();
        }
        if ((a = e.getAttribute("printed")) != null) {
            this._printed = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("modified")) != null) {
            this._modified = a.getValue().equals("true");
        }
        if ((a = e.getAttribute("switchListStatus")) != null) {
            this._switchListStatus = a.getValue();
        }
        if ((a = e.getAttribute("leadEngine")) != null) {
            this._leadEngineId = a.getValue();
        }
        if ((a = e.getAttribute("TerminationDate")) != null) {
            this._date = TrainCommon.convertStringToDate(a.getValue());
        }
        if ((a = e.getAttribute("RequestedCars")) != null) {
            try {
                this._statusCarsRequested = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Status cars requested ({}) isn't a valid number for train ({})", (Object)a.getValue(), (Object)this.getName());
            }
        }
        if ((a = e.getAttribute("statusCode")) != null) {
            try {
                this._statusCode = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Status code ({}) isn't a valid number for train ({})", (Object)a.getValue(), (Object)this.getName());
            }
        } else {
            a = e.getAttribute("status");
            if (a != null) {
                String status = a.getValue();
                this._statusCode = status.startsWith(BUILD_FAILED) ? 2 : (status.startsWith(BUILT) ? 16 : (status.startsWith(PARTIAL_BUILT) ? 20 : (status.startsWith(TERMINATED) ? 128 : (status.startsWith(TRAIN_EN_ROUTE) ? 24 : (status.startsWith(TRAIN_RESET) ? 0 : 65535)))));
            }
        }
        if ((a = e.getAttribute("oldStatusCode")) != null) {
            try {
                this._oldStatusCode = Integer.parseInt(a.getValue());
            }
            catch (NumberFormatException ee) {
                log.error("Old status code ({}) isn't a valid number for train ({})", (Object)a.getValue(), (Object)this.getName());
            }
        } else {
            this._oldStatusCode = this.getStatusCode();
        }
        if ((a = e.getAttribute("comment")) != null) {
            this._comment = a.getValue();
        }
        if (this.getRoute() != null) {
            Location location;
            a = e.getAttribute("current");
            if (a != null) {
                this._current = this.getRoute().getRouteLocationById(a.getValue());
            }
            if ((a = e.getAttribute("leg2Start")) != null) {
                this._leg2Start = this.getRoute().getRouteLocationById(a.getValue());
            }
            if ((a = e.getAttribute("leg3Start")) != null) {
                this._leg3Start = this.getRoute().getRouteLocationById(a.getValue());
            }
            if ((a = e.getAttribute("leg2End")) != null) {
                this._end2Leg = this.getRoute().getRouteLocationById(a.getValue());
            }
            if ((a = e.getAttribute("leg3End")) != null) {
                this._leg3End = this.getRoute().getRouteLocationById(a.getValue());
            }
            if ((a = e.getAttribute("departureTrack")) != null) {
                location = InstanceManager.getDefault(LocationManager.class).getLocationByName(this.getTrainDepartsName());
                if (location != null) {
                    this._departureTrack = location.getTrackById(a.getValue());
                } else {
                    log.error("Departure location not found for track {}", (Object)a.getValue());
                }
            }
            if ((a = e.getAttribute("terminationTrack")) != null) {
                location = InstanceManager.getDefault(LocationManager.class).getLocationByName(this.getTrainTerminatesName());
                if (location != null) {
                    this._terminationTrack = location.getTrackById(a.getValue());
                } else {
                    log.error("Termiation location not found for track {}", (Object)a.getValue());
                }
            }
        }
        if (e.getChild("scripts") != null) {
            List lb = e.getChild("scripts").getChildren("build");
            for (Element es : lb) {
                a = es.getAttribute("name");
                if (a == null) continue;
                this.addBuildScript(a.getValue());
            }
            List lab = e.getChild("scripts").getChildren("afterBuild");
            for (Element es : lab) {
                a = es.getAttribute("name");
                if (a == null) continue;
                this.addAfterBuildScript(a.getValue());
            }
            List lm = e.getChild("scripts").getChildren("move");
            for (Element es : lm) {
                a = es.getAttribute("name");
                if (a == null) continue;
                this.addMoveScript(a.getValue());
            }
            List lt = e.getChild("scripts").getChildren("terminate");
            for (Element es : lt) {
                a = es.getAttribute("name");
                if (a == null) continue;
                this.addTerminationScript(a.getValue());
            }
        }
        if (e.getChild("railRoad") != null && (a = e.getChild("railRoad").getAttribute("name")) != null) {
            String name = a.getValue();
            this.setRailroadName(name);
        }
        if (e.getChild("manifestLogo") != null && (a = e.getChild("manifestLogo").getAttribute("name")) != null) {
            this.setManifestLogoPathName(a.getValue());
        }
        if ((a = e.getAttribute("showTimes")) != null) {
            this._showTimes = a.getValue().equals("true");
        }
        this.addPropertyChangeListerners();
    }

    private void addPropertyChangeListerners() {
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarOwners.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineModels.class).addPropertyChangeListener(this);
    }

    public Element store() {
        Element eRoad;
        String[] roads;
        Element e = new Element("train");
        e.setAttribute("id", this.getId());
        e.setAttribute("name", this.getName());
        e.setAttribute("description", this.getRawDescription());
        e.setAttribute("departHour", this.getDepartureTimeHour());
        e.setAttribute("departMinute", this.getDepartureTimeMinute());
        Element eRowColor = new Element("rowColor");
        eRowColor.setAttribute("name", this.getTableRowColorName());
        eRowColor.setAttribute("resetRowColor", this.getTableRowColorNameReset());
        e.addContent((Content)eRowColor);
        Element eRoute = new Element("route");
        if (this.getRoute() != null) {
            eRoute.setAttribute("name", this.getRoute().getName());
            eRoute.setAttribute("id", this.getRoute().getId());
            e.addContent((Content)eRoute);
            String[] locationIds = this.getTrainSkipsLocations();
            if (locationIds.length > 0) {
                Element eSkips = new Element("skips");
                for (String id : locationIds) {
                    Element eLoc = new Element("location");
                    RouteLocation rl = this.getRoute().getRouteLocationById(id);
                    if (rl == null) continue;
                    eLoc.setAttribute("name", rl.getName());
                    eLoc.setAttribute("id", id);
                    eSkips.addContent((Content)eLoc);
                }
                eRoute.addContent((Content)eSkips);
            }
        }
        if (this.getCurrentRouteLocation() != null) {
            e.setAttribute("current", this.getCurrentRouteLocation().getId());
        }
        if (this.getDepartureTrack() != null) {
            e.setAttribute("departureTrack", this.getDepartureTrack().getId());
        }
        if (this.getTerminationTrack() != null) {
            e.setAttribute("terminationTrack", this.getTerminationTrack().getId());
        }
        e.setAttribute("builtStartYear", this.getBuiltStartYear());
        e.setAttribute("builtEndYear", this.getBuiltEndYear());
        e.setAttribute("numberEngines", this.getNumberEngines());
        e.setAttribute("engineRoad", this.getEngineRoad());
        e.setAttribute("engineModel", this.getEngineModel());
        e.setAttribute("requires", Integer.toString(this.getRequirements()));
        e.setAttribute("cabooseRoad", this.getCabooseRoad());
        e.setAttribute("buildNormal", this.isBuildTrainNormalEnabled() ? "true" : "false");
        e.setAttribute("toTerminal", this.isSendCarsToTerminalEnabled() ? "true" : "false");
        e.setAttribute("allowLocalMoves", this.isAllowLocalMovesEnabled() ? "true" : "false");
        e.setAttribute("allowReturn", this.isAllowReturnToStagingEnabled() ? "true" : "false");
        e.setAttribute("allowThroughCars", this.isAllowThroughCarsEnabled() ? "true" : "false");
        e.setAttribute("serviceAll", this.isServiceAllCarsWithFinalDestinationsEnabled() ? "true" : "false");
        e.setAttribute("sendCustomStaging", this.isSendCarsWithCustomLoadsToStagingEnabled() ? "true" : "false");
        e.setAttribute("buildConsist", this.isBuildConsistEnabled() ? "true" : "false");
        e.setAttribute("built", this.isBuilt() ? "true" : "false");
        e.setAttribute("build", this.isBuildEnabled() ? "true" : "false");
        e.setAttribute("buildFailed", this.isBuildFailed() ? "true" : "false");
        e.setAttribute("buildFailedMessage", this.getBuildFailedMessage());
        e.setAttribute("printed", this.isPrinted() ? "true" : "false");
        e.setAttribute("modified", this.isModified() ? "true" : "false");
        e.setAttribute("switchListStatus", this.getSwitchListStatus());
        if (this.getLeadEngine() != null) {
            e.setAttribute("leadEngine", this.getLeadEngine().getId());
        }
        e.setAttribute("status", this.getStatus());
        e.setAttribute("TerminationDate", this.getDate());
        e.setAttribute("RequestedCars", Integer.toString(this.getNumberCarsRequested()));
        e.setAttribute("statusCode", Integer.toString(this.getStatusCode()));
        e.setAttribute("oldStatusCode", Integer.toString(this.getOldStatusCode()));
        e.setAttribute("comment", this.getCommentWithColor());
        e.setAttribute("showTimes", this.isShowArrivalAndDepartureTimesEnabled() ? "true" : "false");
        String[] types = this.getTypeNames();
        Element eTypes = new Element("types");
        for (String type : types) {
            Element eType;
            if (InstanceManager.getDefault(EngineTypes.class).containsName(type)) {
                eType = new Element("locoType");
                eType.setAttribute("name", type);
                eTypes.addContent((Content)eType);
                continue;
            }
            if (!InstanceManager.getDefault(CarTypes.class).containsName(type)) continue;
            eType = new Element("carType");
            eType.setAttribute("name", type);
            eTypes.addContent((Content)eType);
        }
        e.addContent((Content)eTypes);
        if (!this.getCarRoadOption().equals(ALL_ROADS)) {
            e.setAttribute("carRoadOption", this.getCarRoadOption());
            roads = this.getCarRoadNames();
            Element eRoads = new Element("carRoads");
            for (String road : roads) {
                eRoad = new Element("carRoad");
                eRoad.setAttribute("name", road);
                eRoads.addContent((Content)eRoad);
            }
            e.addContent((Content)eRoads);
        }
        if (!this.getCabooseRoadOption().equals(ALL_ROADS)) {
            e.setAttribute("cabooseRoadOption", this.getCabooseRoadOption());
            roads = this.getCabooseRoadNames();
            Element eRoads = new Element("cabooseRoads");
            for (String road : roads) {
                eRoad = new Element("carRoad");
                eRoad.setAttribute("name", road);
                eRoads.addContent((Content)eRoad);
            }
            e.addContent((Content)eRoads);
        }
        if (!this.getLocoRoadOption().equals(ALL_ROADS)) {
            e.setAttribute("locoRoadOption", this.getLocoRoadOption());
            roads = this.getLocoRoadNames();
            Element eRoads = new Element("locoRoads");
            for (String road : roads) {
                eRoad = new Element("locoRoad");
                eRoad.setAttribute("name", road);
                eRoads.addContent((Content)eRoad);
            }
            e.addContent((Content)eRoads);
        }
        if (!this.getLoadOption().equals(ALL_LOADS)) {
            e.setAttribute("carLoadOption", this.getLoadOption());
            String[] loads = this.getLoadNames();
            Element eLoads = new Element("carLoads");
            for (String load : loads) {
                Element eLoad = new Element("carLoad");
                eLoad.setAttribute("name", load);
                eLoads.addContent((Content)eLoad);
            }
            e.addContent((Content)eLoads);
        }
        if (!this.getOwnerOption().equals(ALL_OWNERS)) {
            e.setAttribute("carOwnerOption", this.getOwnerOption());
            String[] owners = this.getOwnerNames();
            Element eOwners = new Element("carOwners");
            for (String owner : owners) {
                Element eOwner = new Element("carOwner");
                eOwner.setAttribute("name", owner);
                eOwners.addContent((Content)eOwner);
            }
            e.addContent((Content)eOwners);
        }
        if (this.getBuildScripts().size() > 0 || this.getAfterBuildScripts().size() > 0 || this.getMoveScripts().size() > 0 || this.getTerminationScripts().size() > 0) {
            Element es = new Element("scripts");
            if (this.getBuildScripts().size() > 0) {
                for (String scriptPathname : this.getBuildScripts()) {
                    Element em = new Element("build");
                    em.setAttribute("name", scriptPathname);
                    es.addContent((Content)em);
                }
            }
            if (this.getAfterBuildScripts().size() > 0) {
                for (String scriptPathname : this.getAfterBuildScripts()) {
                    Element em = new Element("afterBuild");
                    em.setAttribute("name", scriptPathname);
                    es.addContent((Content)em);
                }
            }
            if (this.getMoveScripts().size() > 0) {
                for (String scriptPathname : this.getMoveScripts()) {
                    Element em = new Element("move");
                    em.setAttribute("name", scriptPathname);
                    es.addContent((Content)em);
                }
            }
            if (this.getTerminationScripts().size() > 0) {
                for (String scriptPathname : this.getTerminationScripts()) {
                    Element et = new Element("terminate");
                    et.setAttribute("name", scriptPathname);
                    es.addContent((Content)et);
                }
            }
            e.addContent((Content)es);
        }
        if (!this.getRailroadName().equals("")) {
            Element r = new Element("railRoad");
            r.setAttribute("name", this.getRailroadName());
            e.addContent((Content)r);
        }
        if (!this.getManifestLogoPathName().equals("")) {
            Element l = new Element("manifestLogo");
            l.setAttribute("name", this.getManifestLogoPathName());
            e.addContent((Content)l);
        }
        if (this.getSecondLegOptions() != 0) {
            e.setAttribute("leg2Options", Integer.toString(this.getSecondLegOptions()));
            e.setAttribute("leg2Engines", this.getSecondLegNumberEngines());
            e.setAttribute("leg2Road", this.getSecondLegEngineRoad());
            e.setAttribute("leg2Model", this.getSecondLegEngineModel());
            e.setAttribute("leg2CabooseRoad", this.getSecondLegCabooseRoad());
            if (this.getSecondLegStartRouteLocation() != null) {
                e.setAttribute("leg2Start", this.getSecondLegStartRouteLocation().getId());
            }
            if (this.getSecondLegEndRouteLocation() != null) {
                e.setAttribute("leg2End", this.getSecondLegEndRouteLocation().getId());
            }
        }
        if (this.getThirdLegOptions() != 0) {
            e.setAttribute("leg3Options", Integer.toString(this.getThirdLegOptions()));
            e.setAttribute("leg3Engines", this.getThirdLegNumberEngines());
            e.setAttribute("leg3Road", this.getThirdLegEngineRoad());
            e.setAttribute("leg3Model", this.getThirdLegEngineModel());
            e.setAttribute("leg3CabooseRoad", this.getThirdLegCabooseRoad());
            if (this.getThirdLegStartRouteLocation() != null) {
                e.setAttribute("leg3Start", this.getThirdLegStartRouteLocation().getId());
            }
            if (this.getThirdLegEndRouteLocation() != null) {
                e.setAttribute("leg3End", this.getThirdLegEndRouteLocation().getId());
            }
        }
        return e;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("routeDispose")) {
            this.setRoute(null);
        }
        if (e.getPropertyName().equals("CarTypes Name") || e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("EngineTypesName")) {
            this.replaceType((String)e.getOldValue(), (String)e.getNewValue());
        }
        if (e.getPropertyName().equals("CarRoads Name")) {
            this.replaceRoad((String)e.getOldValue(), (String)e.getNewValue());
        }
        if (e.getPropertyName().equals("CarOwners Name")) {
            this.replaceOwner((String)e.getOldValue(), (String)e.getNewValue());
        }
        if (e.getPropertyName().equals("EngineModelsName")) {
            this.replaceModel((String)e.getOldValue(), (String)e.getNewValue());
        }
        if (e.getPropertyName().equals("routeDepartureTimeChange")) {
            this.setDirtyAndFirePropertyChange(DEPARTURETIME_CHANGED_PROPERTY, e.getOldValue(), e.getNewValue());
        }
        if (e.getSource().getClass().equals(Route.class)) {
            this.setDirtyAndFirePropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
        }
    }

    protected void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }
}

