/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import jmri.InstanceManager;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.gui.TrainConductorAction;
import jmri.jmrit.operations.trains.tools.ShowCarsInTrainAction;
import jmri.jmrit.throttle.ThrottleFrame;
import jmri.jmrit.throttle.ThrottleFrameManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainIcon
extends LocoIcon {
    Train _train = null;
    int _consistNumber = 0;
    ThrottleFrame _tf = null;
    private static final Logger log = LoggerFactory.getLogger(TrainIcon.class);

    public TrainIcon(Editor editor) {
        super(editor);
    }

    @Override
    public void setShowToolTip(boolean set) {
        this._showTooltip = true;
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this._train != null) {
            String actionText = this._train.getCurrentRouteLocation() == this._train.getTrainTerminatesRouteLocation() ? Bundle.getMessage("Terminate") : Bundle.getMessage("Move");
            popup.add(new AbstractAction(actionText){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrainIcon.this._train.move();
                }
            });
            popup.add(this.makeTrainRouteMenu());
            popup.add(new TrainConductorAction(this._train));
            popup.add(new ShowCarsInTrainAction(this._train));
            if (!this.isEditable()) {
                popup.add(new AbstractAction(Bundle.getMessage("SetX&Y")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (!TrainIcon.this._train.setTrainIconCoordinates()) {
                            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("SeeOperationsSettings"), Bundle.getMessage("SetX&YisDisabled"), 0);
                        }
                    }
                });
            }
        }
        popup.add(new ThrottleAction(Bundle.getMessage("Throttle")));
        popup.add(this.makeLocoIconMenu());
        if (!this.isEditable()) {
            this.getEditor().setRemoveMenu(this, popup);
        }
        return true;
    }

    public void setTrain(Train train) {
        this._train = train;
    }

    public Train getTrain() {
        return this._train;
    }

    public void setConsistNumber(int cN) {
        this._consistNumber = cN;
    }

    private int getConsistNumber() {
        return this._consistNumber;
    }

    private void createThrottle() {
        this._tf = InstanceManager.getDefault(ThrottleFrameManager.class).createThrottleFrame();
        if (this.getConsistNumber() > 0) {
            this._tf.getAddressPanel().setAddress(this.getConsistNumber(), false);
            if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("SendFunctionCommands"), Bundle.getMessage("ConsistThrottle"), 0) == 0) {
                this._tf.getAddressPanel().setRosterEntry(this._entry);
            }
        } else {
            this._tf.getAddressPanel().setRosterEntry(this._entry);
        }
        this._tf.toFront();
    }

    private JMenu makeTrainRouteMenu() {
        JMenu routeMenu = new JMenu(Bundle.getMessage("Route"));
        Route route = this._train.getRoute();
        if (route == null) {
            return routeMenu;
        }
        List carList = InstanceManager.getDefault(CarManager.class).getByTrainList(this._train);
        for (RouteLocation rl : route.getLocationsBySequenceList()) {
            int pickupCars = 0;
            int dropCars = 0;
            int localCars = 0;
            String current = "     ";
            if (this._train.getCurrentRouteLocation() == rl) {
                current = "-> ";
            }
            for (Car car : carList) {
                if (car.getRouteLocation() == rl && !car.getTrackName().equals("") && car.getRouteDestination() == rl) {
                    ++localCars;
                    continue;
                }
                if (car.getRouteLocation() == rl && !car.getTrackName().equals("")) {
                    ++pickupCars;
                    continue;
                }
                if (car.getRouteDestination() != rl) continue;
                ++dropCars;
            }
            String rText = current + rl.getName();
            Object pickups = "";
            Object drops = "";
            Object local = "";
            if (pickupCars > 0) {
                pickups = " " + Bundle.getMessage("Pickup") + " " + pickupCars + ",";
            }
            if (dropCars > 0) {
                drops = " " + Bundle.getMessage("SetOut") + " " + dropCars + ",";
            }
            if (localCars > 0) {
                local = " " + Bundle.getMessage("LocalMoves") + " " + localCars + ",";
            }
            if (pickupCars > 0 || dropCars > 0 || localCars > 0) {
                Object actonText = (String)pickups + (String)drops + (String)local;
                actonText = ((String)actonText).substring(0, ((String)actonText).length() - 1);
                rText = rText + "  (" + (String)actonText + " )";
            }
            routeMenu.add(new RouteAction(rText, rl));
        }
        return routeMenu;
    }

    @Override
    public void doMouseDragged(JmriMouseEvent event) {
        RouteLocation next;
        log.debug("Mouse dragged, X={} Y={}", (Object)this.getX(), (Object)this.getY());
        if (this._train != null && (next = this._train.getNextRouteLocation(this._train.getCurrentRouteLocation())) != null) {
            Point nextPoint = next.getTrainIconCoordinates();
            log.debug("Next location ({}), X={} Y={}", new Object[]{next.getName(), nextPoint.x, nextPoint.y});
            if (Math.abs(this.getX() - nextPoint.x) < next.getTrainIconRangeX() && Math.abs(this.getY() - nextPoint.y) < next.getTrainIconRangeY()) {
                log.debug("Train icon ({}) within range of ({})", (Object)this._train.getName(), (Object)next.getName());
                if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("MoveTrainTo", next.getName()), Bundle.getMessage("MoveTrain", this._train.getIconName()), 0) == 0) {
                    this._train.move();
                }
            }
        }
    }

    public class RouteAction
    extends AbstractAction {
        RouteLocation _rl;

        public RouteAction(String actionName, RouteLocation rl) {
            super(actionName);
            this._rl = rl;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            log.debug("Route location selected {}", (Object)this._rl.getName());
            Route route = TrainIcon.this._train.getRoute();
            List<RouteLocation> routeList = route.getLocationsBySequenceList();
            for (int r = 0; r < routeList.size(); ++r) {
                RouteLocation rl = routeList.get(r);
                if (TrainIcon.this._train.getCurrentRouteLocation() != rl) continue;
                log.debug("Train is at location {}", (Object)rl.getName());
                if (rl == this._rl) break;
                for (int i = r + 1; i < routeList.size(); ++i) {
                    RouteLocation nextRl = routeList.get(i);
                    if (nextRl == this._rl && i == r + 1) {
                        TrainIcon.this._train.move();
                        continue;
                    }
                    if (nextRl != this._rl || JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("MoveTrainTo", this._rl.getName()), Bundle.getMessage("MoveTrain", TrainIcon.this._train.getIconName()), 0) != 0) continue;
                    while (TrainIcon.this._train.getCurrentRouteLocation() != this._rl) {
                        TrainIcon.this._train.move();
                    }
                }
            }
        }
    }

    public class ThrottleAction
    extends AbstractAction {
        public ThrottleAction(String actionName) {
            super(actionName);
            if (TrainIcon.this._entry == null) {
                this.setEnabled(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TrainIcon.this.createThrottle();
        }
    }
}

