/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainLogger
extends XmlFile
implements InstanceManagerAutoDefault,
PropertyChangeListener {
    File _fileLogger;
    private boolean _trainLog = false;
    ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.setup.JmritOperationsSetupBundle");
    private String operationsDirectory = OperationsSetupXml.getFileLocation() + OperationsSetupXml.getOperationsDirectoryName();
    private String loggingDirectory = this.operationsDirectory + File.separator + "logger" + File.separator + "trains";
    private String fileName;
    private static final Logger log = LoggerFactory.getLogger(TrainLogger.class);

    public void enableTrainLogging(boolean enable) {
        if (enable) {
            this.addTrainListeners();
        } else {
            this.removeTrainListeners();
        }
    }

    private void createFile() {
        if (!Setup.isTrainLoggerEnabled()) {
            return;
        }
        if (this._fileLogger != null) {
            return;
        }
        try {
            if (!this.checkFile(this.getFullLoggerFileName())) {
                this._fileLogger = new File(this.getFullLoggerFileName());
                File parentDir = this._fileLogger.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdirs()) {
                    log.error("logger directory not created");
                }
                if (this._fileLogger.createNewFile()) {
                    log.debug("new file created");
                    this.fileOut(this.getHeader());
                }
            } else {
                this._fileLogger = new File(this.getFullLoggerFileName());
            }
        }
        catch (Exception e) {
            log.error("Exception while making logging directory", (Throwable)e);
        }
    }

    private void store(Train train) {
        this.createFile();
        List<Object> line = Arrays.asList(train.getName(), train.getDescription(), train.getCurrentLocationName(), train.getNextLocationName(), train.getNumberCarsInTrain(), train.getNumberCarsPickedUp(), train.getNumberCarsSetout(), train.getTrainLength(), train.getTrainWeight(), train.getStatus(), train.getBuildFailedMessage(), this.getTime());
        this.fileOut(line);
    }

    private void storeFileSaved() {
        if (this._fileLogger == null) {
            return;
        }
        List<Object> line = Arrays.asList(Bundle.getMessage("TrainLogger"), "", "", "", "", "", "", "", "", Setup.isAutoSaveEnabled() ? this.rb.getString("AutoSave") : Bundle.getMessage("Manual"), Bundle.getMessage("TrainsSaved"), this.getTime());
        this.fileOut(line);
    }

    private List<Object> getHeader() {
        return Arrays.asList(Bundle.getMessage("Name"), Bundle.getMessage("Description"), Bundle.getMessage("Current"), Bundle.getMessage("NextLocation"), Bundle.getMessage("Cars"), Bundle.getMessage("Pulls"), Bundle.getMessage("Drops"), Bundle.getMessage("Length"), Bundle.getMessage("Weight"), Bundle.getMessage("Status"), Bundle.getMessage("BuildMessages"), Bundle.getMessage("DateAndTime"));
    }

    private void fileOut(List<Object> line) {
        if (this._fileLogger == null) {
            log.error("Log file doesn't exist");
            return;
        }
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this._fileLogger, true), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            log.debug("Log: {}", line);
            fileOut.printRecord(line);
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException e) {
            log.error("Exception while opening log file: {}", (Object)e.getLocalizedMessage());
        }
    }

    private void addTrainListeners() {
        if (Setup.isTrainLoggerEnabled() && !this._trainLog) {
            log.debug("Train Logger adding train listerners");
            this._trainLog = true;
            List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByIdList();
            trains.forEach(train -> train.addPropertyChangeListener(this));
            InstanceManager.getDefault(TrainManager.class).addPropertyChangeListener(this);
        }
    }

    private void removeTrainListeners() {
        log.debug("Train Logger removing train listerners");
        if (this._trainLog) {
            List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByIdList();
            trains.forEach(train -> train.removePropertyChangeListener(this));
            InstanceManager.getDefault(TrainManager.class).removePropertyChangeListener(this);
        }
        this._trainLog = false;
    }

    public void dispose() {
        this.removeTrainListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("TrainCurrentLocation") && e.getNewValue() != null || e.getPropertyName().equals("TrainStatus") && (e.getNewValue().equals(Train.TRAIN_RESET) || e.getNewValue().equals(Train.BUILDING) || e.getNewValue().equals(Train.BUILD_FAILED) || e.getNewValue().toString().startsWith(Train.TERMINATED))) {
            this.store((Train)e.getSource());
        }
        if (e.getPropertyName().equals("TrainsListLength") && (Integer)e.getNewValue() > (Integer)e.getOldValue()) {
            this.removeTrainListeners();
            this.addTrainListeners();
        }
        if (e.getPropertyName().equals("TrainsSaved")) {
            this.storeFileSaved();
        }
    }

    public String getFullLoggerFileName() {
        return this.loggingDirectory + File.separator + this.getFileName();
    }

    public String getDirectoryName() {
        return this.loggingDirectory;
    }

    public void setDirectoryName(String name) {
        this.loggingDirectory = name;
    }

    public String getFileName() {
        if (this.fileName == null) {
            this.fileName = Bundle.getMessage("Trains") + "_" + this.getDate() + ".csv";
        }
        return this.fileName;
    }

    private String getDate() {
        Date date = Calendar.getInstance().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd");
        return simpleDateFormat.format(date);
    }

    private String getTime() {
        String time = Calendar.getInstance().getTime().toString();
        SimpleDateFormat dt = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
        SimpleDateFormat dtout = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        try {
            return dtout.format(dt.parse(time));
        }
        catch (ParseException e) {
            return time;
        }
    }
}

