/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.InstanceManagerAutoInitialize;
import jmri.beans.PropertyChangeSupport;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.jmrit.operations.trains.excel.TrainCustomSwitchList;
import jmri.jmrit.operations.trains.gui.TrainsTableFrame;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.script.JmriScriptEngineManager;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainManager
extends PropertyChangeSupport
implements InstanceManagerAutoDefault,
InstanceManagerAutoInitialize,
PropertyChangeListener {
    static final String NONE = "";
    private String _trainAction = TrainsTableFrame.MOVE;
    private boolean _buildMessages = true;
    private boolean _buildReport = false;
    private boolean _printPreview = false;
    private boolean _openFile = false;
    private boolean _runFile = false;
    private boolean _showLocationHyphenName = false;
    private boolean _rowColorManual = true;
    private String _rowColorBuilt = "";
    private String _rowColorBuildFailed = "";
    private String _rowColorTrainEnRoute = "";
    private String _rowColorTerminated = "";
    private String _rowColorReset = "";
    protected List<String> _startUpScripts = new ArrayList<String>();
    protected List<String> _shutDownScripts = new ArrayList<String>();
    public static final String LISTLENGTH_CHANGED_PROPERTY = "TrainsListLength";
    public static final String PRINTPREVIEW_CHANGED_PROPERTY = "TrainsPrintPreview";
    public static final String OPEN_FILE_CHANGED_PROPERTY = "TrainsOpenFile";
    public static final String RUN_FILE_CHANGED_PROPERTY = "TrainsRunFile";
    public static final String TRAIN_ACTION_CHANGED_PROPERTY = "TrainsAction";
    public static final String ROW_COLOR_NAME_CHANGED_PROPERTY = "TrainsRowColorChange";
    public static final String TRAINS_BUILT_CHANGED_PROPERTY = "TrainsBuiltChange";
    public static final String TRAINS_SHOW_FULL_NAME_PROPERTY = "TrainsShowFullName";
    public static final String TRAINS_SAVED_PROPERTY = "TrainsSaved";
    private int _id = 0;
    private final Hashtable<String, Train> _trainHashTable = new Hashtable();
    protected static final String SEVEN = "7";
    private static final int GET_TRAIN_DEPARTES_NAME = 0;
    private static final int GET_TRAIN_NAME = 1;
    private static final int GET_TRAIN_ROUTE_NAME = 2;
    private static final int GET_TRAIN_TERMINATES_NAME = 3;
    private static final int GET_TRAIN_TIME = 4;
    private static final int GET_TRAIN_STATUS = 5;
    private static final int GET_TRAIN_ID = 6;
    private static final int GET_TRAIN_DESCRIPTION = 7;
    int _maxTrainNameLength = 0;
    private static final Logger log = LoggerFactory.getLogger(TrainManager.class);

    public int getNumEntries() {
        return this._trainHashTable.size();
    }

    public boolean isBuildMessagesEnabled() {
        return this._buildMessages;
    }

    public void setBuildMessagesEnabled(boolean enable) {
        boolean old = this._buildMessages;
        this._buildMessages = enable;
        this.setDirtyAndFirePropertyChange("BuildMessagesEnabled", enable, old);
    }

    public boolean isBuildReportEnabled() {
        return this._buildReport;
    }

    public void setBuildReportEnabled(boolean enable) {
        boolean old = this._buildReport;
        this._buildReport = enable;
        this.setDirtyAndFirePropertyChange("BuildReportEnabled", enable, old);
    }

    public boolean isOpenFileEnabled() {
        return this._openFile;
    }

    public void setOpenFileEnabled(boolean enable) {
        boolean old = this._openFile;
        this._openFile = enable;
        this.setDirtyAndFirePropertyChange(OPEN_FILE_CHANGED_PROPERTY, old ? "true" : "false", enable ? "true" : "false");
    }

    public boolean isRunFileEnabled() {
        return this._runFile;
    }

    public void setRunFileEnabled(boolean enable) {
        boolean old = this._runFile;
        this._runFile = enable;
        this.setDirtyAndFirePropertyChange(RUN_FILE_CHANGED_PROPERTY, old ? "true" : "false", enable ? "true" : "false");
    }

    public boolean isPrintPreviewEnabled() {
        return this._printPreview;
    }

    public void setPrintPreviewEnabled(boolean enable) {
        boolean old = this._printPreview;
        this._printPreview = enable;
        this.setDirtyAndFirePropertyChange(PRINTPREVIEW_CHANGED_PROPERTY, old ? "Preview" : "Print", enable ? "Preview" : "Print");
    }

    public boolean isShowLocationHyphenNameEnabled() {
        return this._showLocationHyphenName;
    }

    public void setShowLocationHyphenNameEnabled(boolean enable) {
        boolean old = this._showLocationHyphenName;
        this._showLocationHyphenName = enable;
        this.setDirtyAndFirePropertyChange(TRAINS_SHOW_FULL_NAME_PROPERTY, old, enable);
    }

    public String getTrainsFrameTrainAction() {
        return this._trainAction;
    }

    public void setTrainsFrameTrainAction(String action) {
        String old = this._trainAction;
        this._trainAction = action;
        if (!old.equals(action)) {
            this.setDirtyAndFirePropertyChange(TRAIN_ACTION_CHANGED_PROPERTY, old, action);
        }
    }

    public void addStartUpScript(String pathname) {
        this._startUpScripts.add(pathname);
        this.setDirtyAndFirePropertyChange("addStartUpScript", pathname, null);
    }

    public void deleteStartUpScript(String pathname) {
        this._startUpScripts.remove(pathname);
        this.setDirtyAndFirePropertyChange("deleteStartUpScript", null, pathname);
    }

    public List<String> getStartUpScripts() {
        return this._startUpScripts;
    }

    public void runStartUpScripts() {
        Thread scripts = ThreadingUtil.newThread(new Runnable(){

            @Override
            public void run() {
                for (String scriptPathName : TrainManager.this.getStartUpScripts()) {
                    try {
                        JmriScriptEngineManager.getDefault().runScript(new File(FileUtil.getExternalFilename(scriptPathName)));
                    }
                    catch (Exception e) {
                        log.error("Problem with script: {}", (Object)scriptPathName);
                    }
                }
            }
        });
        scripts.setName("Startup Scripts");
        scripts.start();
    }

    public void addShutDownScript(String pathname) {
        this._shutDownScripts.add(pathname);
        this.setDirtyAndFirePropertyChange("addShutDownScript", pathname, null);
    }

    public void deleteShutDownScript(String pathname) {
        this._shutDownScripts.remove(pathname);
        this.setDirtyAndFirePropertyChange("deleteShutDownScript", null, pathname);
    }

    public List<String> getShutDownScripts() {
        return this._shutDownScripts;
    }

    public void runShutDownScripts() {
        for (String scriptPathName : this.getShutDownScripts()) {
            try {
                JmriScriptEngineManager.getDefault().runScript(new File(FileUtil.getExternalFilename(scriptPathName)));
            }
            catch (Exception e) {
                log.error("Problem with script: {}", (Object)scriptPathName);
            }
        }
    }

    public boolean isBuiltRestricted() {
        for (Train train : this.getList()) {
            if (train.getBuiltStartYear().equals(NONE) && train.getBuiltEndYear().equals(NONE)) continue;
            return true;
        }
        return false;
    }

    public boolean isLoadRestricted() {
        for (Train train : this.getList()) {
            if (train.getLoadOption().equals(Train.ALL_LOADS)) continue;
            return true;
        }
        return false;
    }

    public boolean isCarRoadRestricted() {
        for (Train train : this.getList()) {
            if (train.getCarRoadOption().equals(Train.ALL_ROADS)) continue;
            return true;
        }
        return false;
    }

    public boolean isCabooseRoadRestricted() {
        for (Train train : this.getList()) {
            if (train.getCabooseRoadOption().equals(Train.ALL_ROADS)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocoRoadRestricted() {
        for (Train train : this.getList()) {
            if (train.getLocoRoadOption().equals(Train.ALL_ROADS)) continue;
            return true;
        }
        return false;
    }

    public boolean isOwnerRestricted() {
        for (Train train : this.getList()) {
            if (train.getOwnerOption().equals(Train.ALL_OWNERS)) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this._trainHashTable.clear();
        this._id = 0;
    }

    public Train getTrainByName(String name) {
        if (!InstanceManager.getDefault(TrainManagerXml.class).isTrainFileLoaded()) {
            log.error("TrainManager getTrainByName called before trains completely loaded!");
        }
        Enumeration<Train> en = this._trainHashTable.elements();
        while (en.hasMoreElements()) {
            Train train = en.nextElement();
            if (!train.getName().toLowerCase().equals(name.toLowerCase())) continue;
            return train;
        }
        log.debug("Train ({}) doesn't exist", (Object)name);
        return null;
    }

    public Train getTrainById(String id) {
        if (!InstanceManager.getDefault(TrainManagerXml.class).isTrainFileLoaded()) {
            log.error("TrainManager getTrainById called before trains completely loaded!");
        }
        return this._trainHashTable.get(id);
    }

    public Train newTrain(String name) {
        Train train = this.getTrainByName(name);
        if (train == null) {
            ++this._id;
            train = new Train(Integer.toString(this._id), name);
            int oldSize = this.getNumEntries();
            this._trainHashTable.put(train.getId(), train);
            this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this.getNumEntries());
        }
        return train;
    }

    public void register(Train train) {
        int oldSize = this.getNumEntries();
        this._trainHashTable.put(train.getId(), train);
        int id = Integer.parseInt(train.getId());
        if (id > this._id) {
            this._id = id;
        }
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this.getNumEntries());
    }

    public void deregister(Train train) {
        if (train == null) {
            return;
        }
        train.dispose();
        int oldSize = this.getNumEntries();
        this._trainHashTable.remove(train.getId());
        this.setDirtyAndFirePropertyChange(LISTLENGTH_CHANGED_PROPERTY, oldSize, this.getNumEntries());
    }

    public void replaceLoad(String type, String oldLoadName, String newLoadName) {
        for (Train train : this.getTrainsByIdList()) {
            for (String loadName : train.getLoadNames()) {
                String[] splitLoad;
                if (loadName.equals(oldLoadName)) {
                    train.deleteLoadName(oldLoadName);
                    if (newLoadName != null) {
                        train.addLoadName(newLoadName);
                    }
                }
                if ((splitLoad = loadName.split(" & ")).length <= 1 || !splitLoad[0].equals(type) || !splitLoad[1].equals(oldLoadName)) continue;
                train.deleteLoadName(loadName);
                if (newLoadName == null) continue;
                train.addLoadName(type + " & " + newLoadName);
            }
        }
    }

    public boolean isAnyTrainBuilt() {
        for (Train train : this.getTrainsByIdList()) {
            if (!train.isBuilt()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyTrainBuilding() {
        for (Train train : this.getTrainsByIdList()) {
            if (train.getStatusCode() != 1) continue;
            log.debug("Train {} is currently building", (Object)train.getName());
            return true;
        }
        return false;
    }

    public Train getTrainForCar(Car car, PrintWriter buildReport) {
        return this.getTrainForCar(car, new ArrayList<Train>(), buildReport);
    }

    public Train getTrainForCar(Car car, List<Train> excludeTrains, PrintWriter buildReport) {
        this.addLine(buildReport, " ");
        this.addLine(buildReport, Bundle.getMessage("trainFindForCar", car.toString(), car.getLocationName(), car.getTrackName(), car.getDestinationName(), car.getDestinationTrackName()));
        block0: for (Train train : this.getTrainsByNameList()) {
            if (excludeTrains.contains(train) || Setup.isOnlyActiveTrainsEnabled() && !train.isBuildEnabled()) continue;
            for (Train t : excludeTrains) {
                if (t == null || train.getRoute() != t.getRoute()) continue;
                this.addLine(buildReport, Bundle.getMessage("trainHasSameRoute", train, t));
                continue block0;
            }
            if (!train.isServiceable(buildReport, car)) continue;
            log.debug("Found train ({}) for car ({}) location ({}, {}) destination ({}, {})", new Object[]{train.getName(), car.toString(), car.getLocationName(), car.getTrackName(), car.getDestinationName(), car.getDestinationTrackName()});
            return train;
        }
        return null;
    }

    private void addLine(PrintWriter buildReport, String string) {
        if (Setup.getRouterBuildReportLevel().equals(SEVEN)) {
            TrainCommon.addLine(buildReport, SEVEN, string);
        }
    }

    public List<Train> getTrainsByNameList() {
        return this.getTrainsByList(this.getList(), 1);
    }

    public List<Train> getTrainsByTimeList() {
        return this.getTrainsByIntList(this.getTrainsByNameList(), 4);
    }

    public List<Train> getTrainsByDepartureList() {
        return this.getTrainsByList(this.getTrainsByTimeList(), 0);
    }

    public List<Train> getTrainsByTerminatesList() {
        return this.getTrainsByList(this.getTrainsByTimeList(), 3);
    }

    public List<Train> getTrainsByRouteList() {
        return this.getTrainsByList(this.getTrainsByTimeList(), 2);
    }

    public List<Train> getTrainsByStatusList() {
        return this.getTrainsByList(this.getTrainsByTimeList(), 5);
    }

    public List<Train> getTrainsByDescriptionList() {
        return this.getTrainsByList(this.getTrainsByTimeList(), 7);
    }

    public List<Train> getTrainsByIdList() {
        return this.getTrainsByIntList(this.getList(), 6);
    }

    private List<Train> getTrainsByList(List<Train> sortList, int attribute) {
        ArrayList<Train> out = new ArrayList<Train>();
        for (Train train : sortList) {
            String trainAttribute = (String)this.getTrainAttribute(train, attribute);
            for (int j = 0; j < out.size(); ++j) {
                if (trainAttribute.compareToIgnoreCase((String)this.getTrainAttribute((Train)out.get(j), attribute)) >= 0) continue;
                out.add(j, train);
                break;
            }
            if (out.contains(train)) continue;
            out.add(train);
        }
        return out;
    }

    private List<Train> getTrainsByIntList(List<Train> sortList, int attribute) {
        ArrayList<Train> out = new ArrayList<Train>();
        for (Train train : sortList) {
            int trainAttribute = (Integer)this.getTrainAttribute(train, attribute);
            for (int j = 0; j < out.size(); ++j) {
                if (trainAttribute >= (Integer)this.getTrainAttribute((Train)out.get(j), attribute)) continue;
                out.add(j, train);
                break;
            }
            if (out.contains(train)) continue;
            out.add(train);
        }
        return out;
    }

    private Object getTrainAttribute(Train train, int attribute) {
        switch (attribute) {
            case 0: {
                return train.getTrainDepartsName();
            }
            case 1: {
                return train.getName();
            }
            case 2: {
                return train.getTrainRouteName();
            }
            case 3: {
                return train.getTrainTerminatesName();
            }
            case 4: {
                return train.getDepartTimeMinutes();
            }
            case 5: {
                return train.getStatus();
            }
            case 6: {
                return Integer.parseInt(train.getId());
            }
            case 7: {
                return train.getDescription();
            }
        }
        return "unknown";
    }

    private List<Train> getList() {
        if (!InstanceManager.getDefault(TrainManagerXml.class).isTrainFileLoaded()) {
            log.error("TrainManager getList called before trains completely loaded!");
        }
        ArrayList<Train> out = new ArrayList<Train>();
        Enumeration<Train> en = this._trainHashTable.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextElement());
        }
        return out;
    }

    public JComboBox<Train> getTrainComboBox() {
        JComboBox<Train> box = new JComboBox<Train>();
        this.updateTrainComboBox(box);
        OperationsPanel.padComboBox(box);
        return box;
    }

    public void updateTrainComboBox(JComboBox<Train> box) {
        box.removeAllItems();
        box.addItem(null);
        for (Train train : this.getTrainsByNameList()) {
            box.addItem(train);
        }
    }

    public void updateTrainComboBox(JComboBox<Train> box, Car car) {
        box.removeAllItems();
        box.addItem(null);
        for (Train train : this.getTrainsByNameList()) {
            if (!train.isServiceable(car)) continue;
            box.addItem(train);
        }
    }

    public boolean isRowColorManual() {
        return this._rowColorManual;
    }

    public void setRowColorsManual(boolean manual) {
        boolean old = this._rowColorManual;
        this._rowColorManual = manual;
        this.setDirtyAndFirePropertyChange(ROW_COLOR_NAME_CHANGED_PROPERTY, old, manual);
    }

    public String getRowColorNameForBuilt() {
        return this._rowColorBuilt;
    }

    public void setRowColorNameForBuilt(String colorName) {
        String old = this._rowColorBuilt;
        this._rowColorBuilt = colorName;
        this.setDirtyAndFirePropertyChange(ROW_COLOR_NAME_CHANGED_PROPERTY, old, colorName);
    }

    public String getRowColorNameForBuildFailed() {
        return this._rowColorBuildFailed;
    }

    public void setRowColorNameForBuildFailed(String colorName) {
        String old = this._rowColorBuildFailed;
        this._rowColorBuildFailed = colorName;
        this.setDirtyAndFirePropertyChange(ROW_COLOR_NAME_CHANGED_PROPERTY, old, colorName);
    }

    public String getRowColorNameForTrainEnRoute() {
        return this._rowColorTrainEnRoute;
    }

    public void setRowColorNameForTrainEnRoute(String colorName) {
        String old = this._rowColorTrainEnRoute;
        this._rowColorTrainEnRoute = colorName;
        this.setDirtyAndFirePropertyChange(ROW_COLOR_NAME_CHANGED_PROPERTY, old, colorName);
    }

    public String getRowColorNameForTerminated() {
        return this._rowColorTerminated;
    }

    public void setRowColorNameForTerminated(String colorName) {
        String old = this._rowColorTerminated;
        this._rowColorTerminated = colorName;
        this.setDirtyAndFirePropertyChange(ROW_COLOR_NAME_CHANGED_PROPERTY, old, colorName);
    }

    public String getRowColorNameForReset() {
        return this._rowColorReset;
    }

    public void setRowColorNameForReset(String colorName) {
        String old = this._rowColorReset;
        this._rowColorReset = colorName;
        this.setDirtyAndFirePropertyChange(ROW_COLOR_NAME_CHANGED_PROPERTY, old, colorName);
    }

    public JComboBox<String> getRowColorComboBox() {
        JComboBox<String> box = new JComboBox<String>();
        box.addItem(NONE);
        box.addItem("black");
        box.addItem("red");
        box.addItem("pink");
        box.addItem("orange");
        box.addItem("yellow");
        box.addItem("green");
        box.addItem("magenta");
        box.addItem("cyan");
        box.addItem("blue");
        box.addItem("gray");
        return box;
    }

    public Train copyTrain(Train train, String trainName) {
        Train newTrain = this.newTrain(trainName);
        newTrain.setRoute(train.getRoute());
        newTrain.setTrainSkipsLocations(train.getTrainSkipsLocations());
        newTrain.setDepartureTime(train.getDepartureTimeHour(), train.getDepartureTimeMinute());
        newTrain._typeList.clear();
        newTrain.setTypeNames(train.getTypeNames());
        newTrain.setCarRoadOption(train.getCarRoadOption());
        newTrain.setCarRoadNames(train.getCarRoadNames());
        newTrain.setCabooseRoadNames(train.getCabooseRoadNames());
        newTrain.setLocoRoadOption(train.getLocoRoadOption());
        newTrain.setLocoRoadNames(train.getLocoRoadNames());
        newTrain.setLoadOption(train.getLoadOption());
        newTrain.setLoadNames(train.getLoadNames());
        newTrain.setOwnerOption(train.getOwnerOption());
        newTrain.setOwnerNames(train.getOwnerNames());
        newTrain.setBuiltStartYear(train.getBuiltStartYear());
        newTrain.setBuiltEndYear(train.getBuiltEndYear());
        newTrain.setNumberEngines(train.getNumberEngines());
        newTrain.setEngineModel(train.getEngineModel());
        newTrain.setEngineRoad(train.getEngineRoad());
        newTrain.setRequirements(train.getRequirements());
        newTrain.setCabooseRoad(train.getCabooseRoad());
        newTrain.setSecondLegNumberEngines(train.getSecondLegNumberEngines());
        newTrain.setSecondLegEngineModel(train.getSecondLegEngineModel());
        newTrain.setSecondLegEngineRoad(train.getSecondLegEngineRoad());
        newTrain.setSecondLegOptions(train.getSecondLegOptions());
        newTrain.setSecondLegCabooseRoad(train.getSecondLegCabooseRoad());
        newTrain.setSecondLegStartRouteLocation(train.getSecondLegStartRouteLocation());
        newTrain.setSecondLegEndRouteLocation(train.getSecondLegEndRouteLocation());
        newTrain.setThirdLegNumberEngines(train.getThirdLegNumberEngines());
        newTrain.setThirdLegEngineModel(train.getThirdLegEngineModel());
        newTrain.setThirdLegEngineRoad(train.getThirdLegEngineRoad());
        newTrain.setThirdLegOptions(train.getThirdLegOptions());
        newTrain.setThirdLegCabooseRoad(train.getThirdLegCabooseRoad());
        newTrain.setThirdLegStartRouteLocation(train.getThirdLegStartRouteLocation());
        newTrain.setThirdLegEndRouteLocation(train.getThirdLegEndRouteLocation());
        for (String scriptName : train.getBuildScripts()) {
            newTrain.addBuildScript(scriptName);
        }
        for (String scriptName : train.getMoveScripts()) {
            newTrain.addMoveScript(scriptName);
        }
        for (String scriptName : train.getTerminationScripts()) {
            newTrain.addTerminationScript(scriptName);
        }
        newTrain.setRailroadName(train.getRailroadName());
        newTrain.setManifestLogoPathName(train.getManifestLogoPathName());
        newTrain.setShowArrivalAndDepartureTimes(train.isShowArrivalAndDepartureTimesEnabled());
        newTrain.setAllowLocalMovesEnabled(train.isAllowLocalMovesEnabled());
        newTrain.setAllowReturnToStagingEnabled(train.isAllowReturnToStagingEnabled());
        newTrain.setAllowThroughCarsEnabled(train.isAllowThroughCarsEnabled());
        newTrain.setBuildConsistEnabled(train.isBuildConsistEnabled());
        newTrain.setSendCarsWithCustomLoadsToStagingEnabled(train.isSendCarsWithCustomLoadsToStagingEnabled());
        newTrain.setBuildTrainNormalEnabled(train.isBuildTrainNormalEnabled());
        newTrain.setSendCarsToTerminalEnabled(train.isSendCarsToTerminalEnabled());
        newTrain.setServiceAllCarsWithFinalDestinationsEnabled(train.isServiceAllCarsWithFinalDestinationsEnabled());
        newTrain.setComment(train.getCommentWithColor());
        newTrain.setDescription(train.getRawDescription());
        return newTrain;
    }

    public List<Train> getTrainsArrivingThisLocationList(Location location) {
        ArrayList<Train> out = new ArrayList<Train>();
        ArrayList<Integer> arrivalTimes = new ArrayList<Integer>();
        block0: for (Train train : this.getTrainsByTimeList()) {
            Route route;
            if (!train.isBuilt() || (route = train.getRoute()) == null) continue;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                int time;
                Train t;
                int j;
                if (!rl.getSplitName().equals(location.getSplitName())) continue;
                int expectedArrivalTime = train.getExpectedTravelTimeInMinutes(rl);
                if (expectedArrivalTime == -1) {
                    out.add(0, train);
                    arrivalTimes.add(0, expectedArrivalTime);
                } else if (train.isTrainEnRoute()) {
                    for (j = 0; j < out.size(); ++j) {
                        t = (Train)out.get(j);
                        time = (Integer)arrivalTimes.get(j);
                        if (t.isTrainEnRoute() && expectedArrivalTime < time) {
                            out.add(j, train);
                            arrivalTimes.add(j, expectedArrivalTime);
                        } else {
                            if (t.isTrainEnRoute()) continue;
                            out.add(j, train);
                            arrivalTimes.add(j, expectedArrivalTime);
                        }
                        break;
                    }
                } else {
                    for (j = 0; j < out.size(); ++j) {
                        t = (Train)out.get(j);
                        time = (Integer)arrivalTimes.get(j);
                        if (t.isTrainEnRoute() || expectedArrivalTime >= time) continue;
                        out.add(j, train);
                        arrivalTimes.add(j, expectedArrivalTime);
                        break;
                    }
                }
                if (out.contains(train)) continue block0;
                out.add(train);
                arrivalTimes.add(expectedArrivalTime);
                continue block0;
            }
        }
        return out;
    }

    public void loadTrainIcons() {
        for (Train train : this.getTrainsByIdList()) {
            train.loadTrainIcon();
        }
    }

    public void setTrainsSwitchListStatus(String status) {
        for (Train train : this.getTrainsByTimeList()) {
            if (!train.isBuilt()) continue;
            train.setSwitchListStatus(status);
        }
    }

    public void setTrainsModified() {
        for (Train train : this.getTrainsByTimeList()) {
            if (!train.isBuilt() || train.isTrainEnRoute()) continue;
            train.setModified(true);
        }
    }

    public void buildSelectedTrains(final List<Train> trains) {
        Thread build = ThreadingUtil.newThread(new Runnable(){

            @Override
            public void run() {
                Train train;
                Iterator iterator = trains.iterator();
                while (iterator.hasNext() && ((train = (Train)iterator.next()).buildIfSelected() || !TrainManager.this.isBuildMessagesEnabled() || !train.isBuildEnabled() || train.isBuilt() || JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("ContinueBuilding"), Bundle.getMessage("buildFailedMsg", train.getName()), 0) != 1)) {
                }
                TrainManager.this.setDirtyAndFirePropertyChange(TrainManager.TRAINS_BUILT_CHANGED_PROPERTY, false, true);
            }
        });
        build.setName("Build Trains");
        build.start();
    }

    public boolean printSelectedTrains(List<Train> trains) {
        boolean status = true;
        for (Train train : trains) {
            if (!train.isBuildEnabled() || train.printManifestIfBuilt()) continue;
            status = false;
            if (!this.isBuildMessagesEnabled()) continue;
            Object[] objectArray = new Object[1];
            Object object = objectArray[0] = this.isPrintPreviewEnabled() ? Bundle.getMessage("preview") : Bundle.getMessage("print");
            int response = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("NeedToBuildBeforePrinting", train.getName(), this.isPrintPreviewEnabled() ? Bundle.getMessage("preview") : Bundle.getMessage("print")), Bundle.getMessage("CanNotPrintManifest", objectArray), 2);
            if (response == 0) continue;
            break;
        }
        return status;
    }

    public boolean terminateSelectedTrains(List<Train> trains) {
        boolean status = true;
        for (Train train : trains) {
            if (!train.isBuildEnabled() || !train.isBuilt()) continue;
            if (train.isPrinted()) {
                train.terminate();
                continue;
            }
            status = false;
            int response = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("WarningTrainManifestNotPrinted"), Bundle.getMessage("TerminateTrain", train.getName(), train.getDescription()), 1);
            if (response == 0) {
                train.terminate();
            }
            if (response != -1 && response != 2) continue;
            break;
        }
        return status;
    }

    public void resetBuildFailedTrains() {
        for (Train train : this.getList()) {
            if (!train.isBuildFailed()) continue;
            train.reset();
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N of Info Message")
    public int getMaxTrainNameLength() {
        String trainName = NONE;
        if (this._maxTrainNameLength == 0) {
            for (Train train : this.getList()) {
                if (train.getName().length() <= this._maxTrainNameLength) continue;
                trainName = train.getName();
                this._maxTrainNameLength = train.getName().length();
            }
            log.info(Bundle.getMessage("InfoMaxName", trainName, this._maxTrainNameLength));
        }
        return this._maxTrainNameLength;
    }

    public void load(Element root) {
        if (root.getChild("options") != null) {
            Element eRowColorOptions;
            Element eConductorOptions;
            Attribute a;
            Element options = root.getChild("options");
            InstanceManager.getDefault(TrainCustomManifest.class).load(options);
            InstanceManager.getDefault(TrainCustomSwitchList.class).load(options);
            Element e = options.getChild("trainOptions");
            if (e != null) {
                a = e.getAttribute("buildMessages");
                if (a != null) {
                    this._buildMessages = a.getValue().equals("true");
                }
                if ((a = e.getAttribute("buildReport")) != null) {
                    this._buildReport = a.getValue().equals("true");
                }
                if ((a = e.getAttribute("printPreview")) != null) {
                    this._printPreview = a.getValue().equals("true");
                }
                if ((a = e.getAttribute("openFile")) != null) {
                    this._openFile = a.getValue().equals("true");
                }
                if ((a = e.getAttribute("runFile")) != null) {
                    this._runFile = a.getValue().equals("true");
                }
                if ((a = e.getAttribute("trainAction")) != null && (a.getValue().equals(TrainsTableFrame.MOVE) || a.getValue().equals(TrainsTableFrame.RESET) || a.getValue().equals(TrainsTableFrame.TERMINATE) || a.getValue().equals(TrainsTableFrame.CONDUCTOR))) {
                    this._trainAction = a.getValue();
                }
            }
            if ((eConductorOptions = options.getChild("conductorOptions")) != null && (a = eConductorOptions.getAttribute("showHyphenName")) != null) {
                this._showLocationHyphenName = a.getValue().equals("true");
            }
            if ((eRowColorOptions = options.getChild("rowColorOptions")) != null) {
                a = eRowColorOptions.getAttribute("rowColorManual");
                if (a != null) {
                    this._rowColorManual = a.getValue().equals("true");
                }
                if ((a = eRowColorOptions.getAttribute("rowColorBuidFailed")) != null) {
                    this._rowColorBuildFailed = a.getValue().toLowerCase();
                }
                if ((a = eRowColorOptions.getAttribute("rowColorBuilt")) != null) {
                    this._rowColorBuilt = a.getValue().toLowerCase();
                }
                if ((a = eRowColorOptions.getAttribute("rowColorTrainEnRoute")) != null) {
                    this._rowColorTrainEnRoute = a.getValue().toLowerCase();
                }
                if ((a = eRowColorOptions.getAttribute("rowColorTerminated")) != null) {
                    this._rowColorTerminated = a.getValue().toLowerCase();
                }
                if ((a = eRowColorOptions.getAttribute("rowColorReset")) != null) {
                    this._rowColorReset = a.getValue().toLowerCase();
                }
            }
            if ((e = options.getChild("trainScheduleOptions")) != null && (a = e.getAttribute("activeId")) != null) {
                InstanceManager.getDefault(TrainScheduleManager.class).setTrainScheduleActiveId(a.getValue());
            }
            if (options.getChild("scripts") != null) {
                List lm = options.getChild("scripts").getChildren("startUp");
                for (Element es : lm) {
                    a = es.getAttribute("name");
                    if (a == null) continue;
                    this.addStartUpScript(a.getValue());
                }
                List lt = options.getChild("scripts").getChildren("shutDown");
                for (Element es : lt) {
                    a = es.getAttribute("name");
                    if (a == null) continue;
                    this.addShutDownScript(a.getValue());
                }
            }
        }
        if (root.getChild("trains") != null) {
            List eTrains = root.getChild("trains").getChildren("train");
            log.debug("readFile sees {} trains", (Object)eTrains.size());
            for (Element eTrain : eTrains) {
                this.register(new Train(eTrain));
            }
        }
    }

    public void store(Element root) {
        Element options = new Element("options");
        Element e = new Element("trainOptions");
        e.setAttribute("buildMessages", this.isBuildMessagesEnabled() ? "true" : "false");
        e.setAttribute("buildReport", this.isBuildReportEnabled() ? "true" : "false");
        e.setAttribute("printPreview", this.isPrintPreviewEnabled() ? "true" : "false");
        e.setAttribute("openFile", this.isOpenFileEnabled() ? "true" : "false");
        e.setAttribute("runFile", this.isRunFileEnabled() ? "true" : "false");
        e.setAttribute("trainAction", this.getTrainsFrameTrainAction());
        options.addContent((Content)e);
        e = new Element("conductorOptions");
        e.setAttribute("showHyphenName", this.isShowLocationHyphenNameEnabled() ? "true" : "false");
        options.addContent((Content)e);
        e = new Element("rowColorOptions");
        e.setAttribute("rowColorManual", this.isRowColorManual() ? "true" : "false");
        e.setAttribute("rowColorBuidFailed", this.getRowColorNameForBuildFailed());
        e.setAttribute("rowColorBuilt", this.getRowColorNameForBuilt());
        e.setAttribute("rowColorTrainEnRoute", this.getRowColorNameForTrainEnRoute());
        e.setAttribute("rowColorTerminated", this.getRowColorNameForTerminated());
        e.setAttribute("rowColorReset", this.getRowColorNameForReset());
        options.addContent((Content)e);
        if (this.getStartUpScripts().size() > 0 || this.getShutDownScripts().size() > 0) {
            Element es = new Element("scripts");
            for (String scriptName : this.getStartUpScripts()) {
                Element em = new Element("startUp");
                em.setAttribute("name", scriptName);
                es.addContent((Content)em);
            }
            for (String scriptName : this.getShutDownScripts()) {
                Element et = new Element("shutDown");
                et.setAttribute("name", scriptName);
                es.addContent((Content)et);
            }
            options.addContent((Content)es);
        }
        InstanceManager.getDefault(TrainCustomManifest.class).store(options);
        InstanceManager.getDefault(TrainCustomSwitchList.class).store(options);
        root.addContent((Content)options);
        Element trains = new Element("trains");
        root.addContent((Content)trains);
        for (Train train : this.getTrainsByIdList()) {
            trains.addContent((Content)train.store());
        }
        this.firePropertyChange(TRAINS_SAVED_PROPERTY, true, false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("TrainManager sees property change: {} old: {} new: {}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
    }

    private void setDirtyAndFirePropertyChange(String p, Object old, Object n) {
        InstanceManager.getDefault(TrainManagerXml.class).setDirty(true);
        this.firePropertyChange(p, old, n);
    }

    @Override
    public void initialize() {
        InstanceManager.getDefault(OperationsSetupXml.class);
        InstanceManager.getDefault(TrainManagerXml.class);
    }
}

