/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainManifest
extends TrainCommon {
    private static final Logger log = LoggerFactory.getLogger(TrainManifest.class);
    String messageFormatText = "";

    public TrainManifest(Train train) throws BuildFailedException {
        PrintWriter fileOut;
        File file = InstanceManager.getDefault(TrainManagerXml.class).createTrainManifestFile(train.getName());
        try {
            fileOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), true);
        }
        catch (IOException e) {
            log.error("Can not open train manifest file: {}", (Object)e.getLocalizedMessage());
            throw new BuildFailedException(e);
        }
        try {
            TrainSchedule sch;
            if (!train.getRailroadName().equals("")) {
                this.newLine(fileOut, train.getRailroadName());
            } else {
                this.newLine(fileOut, Setup.getRailroadName());
            }
            this.newLine(fileOut);
            this.messageFormatText = TrainManifestText.getStringManifestForTrain();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription()));
            this.messageFormatText = TrainManifestText.getStringValid();
            String valid = MessageFormat.format(this.messageFormatText, TrainManifest.getDate(true));
            Object schName = "";
            if (Setup.isPrintTrainScheduleNameEnabled() && (sch = InstanceManager.getDefault(TrainScheduleManager.class).getActiveSchedule()) != null) {
                schName = "(" + sch.getName() + ")";
            }
            if (Setup.isPrintValidEnabled()) {
                this.newLine(fileOut, valid + " " + (String)schName);
            } else {
                this.newLine(fileOut, (String)schName);
            }
            if (!train.getCommentWithColor().equals("")) {
                this.newLine(fileOut, train.getCommentWithColor());
            }
            if (Setup.isPrintRouteCommentsEnabled() && !train.getRoute().getComment().equals("")) {
                this.newLine(fileOut, train.getRoute().getComment());
            }
            List<Engine> engineList = this.engineManager.getByTrainBlockingList(train);
            List<Car> carList = this.carManager.getByTrainDestinationList(train);
            log.debug("Train has {} cars assigned to it", (Object)carList.size());
            boolean hadWork = false;
            String previousRouteLocationName = null;
            List<RouteLocation> routeList = train.getRoute().getLocationsBySequenceList();
            for (RouteLocation rl : routeList) {
                boolean printHeader = false;
                boolean hasWork = this.isThereWorkAtLocation(carList, engineList, rl);
                String routeLocationName = rl.getSplitName();
                if ((!routeLocationName.equals(previousRouteLocationName) || hasWork && !hadWork) && hasWork) {
                    this.newLine(fileOut);
                    hadWork = true;
                    printHeader = true;
                    this.arrivalMessage(fileOut, train, rl);
                    if (!rl.getComment().trim().equals("")) {
                        this.newLine(fileOut, rl.getCommentWithColor());
                    }
                    if (Setup.isPrintLocationCommentsEnabled() && !rl.getLocation().getCommentWithColor().equals("")) {
                        this.newLine(fileOut, rl.getLocation().getCommentWithColor());
                    }
                }
                previousRouteLocationName = routeLocationName;
                this.printTrackComments(fileOut, rl, carList, true);
                if (train.getSecondLegOptions() != 0) {
                    if (rl == train.getSecondLegStartRouteLocation()) {
                        this.printChange(fileOut, rl, train, train.getSecondLegOptions());
                    }
                    if (rl == train.getSecondLegEndRouteLocation() && train.getSecondLegOptions() == 2) {
                        this.messageFormatText = TrainManifestText.getStringRemoveHelpers();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, rl.getSplitName(), train.getName(), train.getDescription(), train.getSecondLegNumberEngines(), train.getSecondLegEngineModel(), train.getSecondLegEngineRoad()));
                    }
                }
                if (train.getThirdLegOptions() != 0) {
                    if (rl == train.getThirdLegStartRouteLocation()) {
                        this.printChange(fileOut, rl, train, train.getThirdLegOptions());
                    }
                    if (rl == train.getThirdLegEndRouteLocation() && train.getThirdLegOptions() == 2) {
                        this.messageFormatText = TrainManifestText.getStringRemoveHelpers();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, rl.getSplitName(), train.getName(), train.getDescription(), train.getThirdLegNumberEngines(), train.getThirdLegEngineModel(), train.getThirdLegEngineRoad()));
                    }
                }
                this.setCarPickupAndSetoutTimes(train, rl, carList);
                if (Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                    this.pickupEngines(fileOut, engineList, rl, true);
                    if (train.isLocalSwitcher() || Setup.isPrintLocoLastEnabled()) {
                        this.blockCarsByTrack(fileOut, train, carList, rl, printHeader, true);
                        this.dropEngines(fileOut, engineList, rl, true);
                    } else {
                        this.dropEngines(fileOut, engineList, rl, true);
                        this.blockCarsByTrack(fileOut, train, carList, rl, printHeader, true);
                    }
                } else if (Setup.getManifestFormat().equals(Setup.TWO_COLUMN_FORMAT)) {
                    this.blockLocosTwoColumn(fileOut, engineList, rl, true);
                    this.blockCarsTwoColumn(fileOut, train, carList, rl, printHeader, true);
                } else {
                    this.blockLocosTwoColumn(fileOut, engineList, rl, true);
                    this.blockCarsByTrackNameTwoColumn(fileOut, train, carList, rl, printHeader, true);
                }
                if (rl != train.getTrainTerminatesRouteLocation()) {
                    RouteLocation rlNext = train.getRoute().getNextRouteLocation(rl);
                    if (routeLocationName.equals(rlNext.getSplitName())) continue;
                    this.departureMessage(fileOut, train, rl, hadWork);
                    hadWork = false;
                    continue;
                }
                if (!hadWork) {
                    this.newLine(fileOut);
                } else {
                    this.printHorizontalLine3(fileOut, true);
                }
                this.messageFormatText = TrainManifestText.getStringTrainTerminates();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, train.getName(), train.getDescription(), rl.getLocation().getDivisionName()));
            }
            this.addCarsLocationUnknown(fileOut, true);
        }
        catch (IllegalArgumentException e) {
            this.newLine(fileOut, Bundle.getMessage("ErrorIllegalArgument", Bundle.getMessage("TitleManifestText"), e.getLocalizedMessage()));
            this.newLine(fileOut, this.messageFormatText);
            log.error("Illegal argument", (Throwable)e);
        }
        fileOut.flush();
        fileOut.close();
        train.setModified(false);
    }

    private void arrivalMessage(PrintWriter fileOut, Train train, RouteLocation rl) {
        this.newLine(fileOut, TrainManifest.getTrainMessage(train, rl));
    }

    private void departureMessage(PrintWriter fileOut, Train train, RouteLocation rl, boolean hadWork) {
        String routeLocationName = rl.getSplitName();
        if (!hadWork) {
            this.newLine(fileOut);
            this.messageFormatText = TrainManifestText.getStringNoScheduledWork();
            Object s = MessageFormat.format(this.messageFormatText, routeLocationName, train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
            if (!rl.getComment().equals("")) {
                s = routeLocationName;
                if (!rl.getComment().isBlank()) {
                    this.messageFormatText = TrainManifestText.getStringNoScheduledWorkWithRouteComment();
                    s = MessageFormat.format(this.messageFormatText, routeLocationName, rl.getCommentWithColor(), train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
                }
            }
            if (train.isShowArrivalAndDepartureTimesEnabled()) {
                if (rl == train.getTrainDepartsRouteLocation()) {
                    this.messageFormatText = TrainManifestText.getStringDepartTime();
                    s = (String)s + MessageFormat.format(this.messageFormatText, train.getFormatedDepartureTime());
                } else if (!rl.getDepartureTime().equals("")) {
                    this.messageFormatText = TrainManifestText.getStringDepartTime();
                    s = (String)s + MessageFormat.format(this.messageFormatText, train.getExpectedDepartureTime(rl));
                } else if (Setup.isUseDepartureTimeEnabled() && !rl.getComment().equals("")) {
                    this.messageFormatText = TrainManifestText.getStringDepartTime();
                    s = (String)s + MessageFormat.format(this.messageFormatText, train.getExpectedDepartureTime(rl));
                }
            }
            this.newLine(fileOut, (String)s);
            if (Setup.isPrintLocationCommentsEnabled() && !rl.getLocation().getCommentWithColor().equals("")) {
                this.newLine(fileOut, rl.getLocation().getCommentWithColor());
            }
        } else {
            this.printHorizontalLine3(fileOut, true);
        }
        if (Setup.isPrintLoadsAndEmptiesEnabled()) {
            int emptyCars = train.getNumberEmptyCarsInTrain(rl);
            this.messageFormatText = TrainManifestText.getStringTrainDepartsLoads();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl) - emptyCars, emptyCars, train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName()));
        } else {
            this.messageFormatText = TrainManifestText.getStringTrainDepartsCars();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, routeLocationName, rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl), train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName()));
        }
    }

    private void printChange(PrintWriter fileOut, RouteLocation rl, Train train, int legOptions) throws IllegalArgumentException {
        if ((legOptions & 2) == 2) {
            String numberEngines = train.getSecondLegNumberEngines();
            String endLocationName = train.getSecondLegEndLocationName();
            String engineModel = train.getSecondLegEngineModel();
            String engineRoad = train.getSecondLegEngineRoad();
            if (rl == train.getThirdLegStartRouteLocation()) {
                numberEngines = train.getThirdLegNumberEngines();
                endLocationName = train.getThirdLegEndLocationName();
                engineModel = train.getThirdLegEngineModel();
                engineRoad = train.getThirdLegEngineRoad();
            }
            this.messageFormatText = TrainManifestText.getStringAddHelpers();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, rl.getSplitName(), train.getName(), train.getDescription(), numberEngines, endLocationName, engineModel, engineRoad));
        } else if ((legOptions & 1) == 1 && ((legOptions & 8) == 8 || (legOptions & 4) == 4)) {
            this.messageFormatText = TrainManifestText.getStringLocoAndCabooseChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, rl.getSplitName(), train.getName(), train.getDescription(), rl.getLocation().getDivisionName()));
        } else if ((legOptions & 1) == 1) {
            this.messageFormatText = TrainManifestText.getStringLocoChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, rl.getSplitName(), train.getName(), train.getDescription(), rl.getLocation().getDivisionName()));
        } else if ((legOptions & 8) == 8 || (legOptions & 4) == 4) {
            this.messageFormatText = TrainManifestText.getStringCabooseChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, rl.getSplitName(), train.getName(), train.getDescription(), rl.getLocation().getDivisionName()));
        }
    }

    private void newLine(PrintWriter file, String string) {
        if (!string.isEmpty()) {
            this.newLine(file, string, true);
        }
    }
}

