/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.JobAttributes;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainPrintUtilities
extends TrainCommon {
    static final char SPACE = ' ';
    private static final Logger log = LoggerFactory.getLogger(TrainPrintUtilities.class);

    public static void printReport(File file, String name, boolean isPreview, String fontName, boolean isBuildReport, String logoURL, String printerName, String orientation, int fontSize, boolean isPrintHeader, JobAttributes.SidesType sidesType) {
        boolean isLandScape = false;
        double margin = 0.5;
        Dimension pagesize = null;
        if (orientation.equals(Setup.LANDSCAPE)) {
            margin = 0.65;
            isLandScape = true;
        }
        if (orientation.equals(Setup.HANDHELD) || orientation.equals(Setup.HALFPAGE)) {
            isPrintHeader = false;
            pagesize = new Dimension(TrainPrintUtilities.getPageSize((String)orientation).width + TrainPrintUtilities.PAPER_MARGINS.width, TrainPrintUtilities.getPageSize((String)orientation).height + TrainPrintUtilities.PAPER_MARGINS.height);
        }
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), name, fontSize, margin, margin, 0.5, 0.5, isPreview, printerName, isLandScape, isPrintHeader, sidesType, pagesize);
             BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            if (!fontName.isEmpty()) {
                writer.setFontName(fontName);
            }
            if (!isBuildReport && logoURL != null && !logoURL.equals("")) {
                ImageIcon icon = new ImageIcon(logoURL);
                if (icon.getIconWidth() == -1) {
                    log.error("Logo not found: {}", (Object)logoURL);
                } else {
                    writer.write(icon.getImage(), new JLabel(icon));
                }
            }
            Color color = null;
            boolean printingColor = false;
            while (true) {
                String line;
                try {
                    line = in.readLine();
                }
                catch (IOException e) {
                    log.debug("Print read failed");
                    break;
                }
                if (line == null) {
                    if (!isPreview) break;
                    writer.write(" ");
                    break;
                }
                if (isBuildReport) {
                    if ((line = TrainPrintUtilities.filterBuildReport(line, false)).isEmpty()) {
                        continue;
                    }
                } else {
                    if (TrainPrintUtilities.printHorizontialLineSeparator(writer, line)) {
                        color = null;
                        continue;
                    }
                    if (line.contains("<FONT color=\"")) {
                        color = TrainPrintUtilities.getTextColor(line);
                        printingColor = !line.contains("</FONT>");
                        if (line.contains(Character.toString('|'))) {
                            String s = line.substring(0, line.indexOf(124));
                            s = TrainPrintUtilities.getTextColorString(s);
                            writer.write(color, s);
                            line = line.substring(line.indexOf(124));
                            color = TrainPrintUtilities.getTextColor(line);
                            line = TrainPrintUtilities.tabString(TrainPrintUtilities.getTextColorString(line), s.length());
                        } else {
                            line = TrainPrintUtilities.getTextColorString(line);
                        }
                    } else if (line.contains("</FONT>")) {
                        printingColor = false;
                        line = TrainPrintUtilities.getTextColorString(line);
                    } else if (!printingColor) {
                        color = null;
                    }
                    TrainPrintUtilities.printVerticalLineSeparator(writer, line);
                    line = line.replace('|', ' ');
                    if (color != null) {
                        writer.write(color, line + "\n");
                        continue;
                    }
                }
                writer.write(line + "\n");
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            log.error("Build file doesn't exist", (Throwable)e);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException e) {
            log.warn("Exception printing: {}", (Object)e.getLocalizedMessage());
        }
    }

    private static boolean printHorizontialLineSeparator(HardcopyWriter writer, String line) {
        boolean horizontialLineSeparatorFound = true;
        if (line.length() > 0) {
            for (int i = 0; i < line.length(); ++i) {
                if (line.charAt(i) == '-') continue;
                horizontialLineSeparatorFound = false;
                break;
            }
            if (horizontialLineSeparatorFound) {
                writer.write(writer.getCurrentLineNumber(), 0, writer.getCurrentLineNumber(), line.length() + 1);
            }
        }
        return horizontialLineSeparatorFound;
    }

    private static void printVerticalLineSeparator(HardcopyWriter writer, String line) {
        for (int i = 0; i < line.length(); ++i) {
            if (line.charAt(i) != '|') continue;
            if (Setup.isTabEnabled()) {
                writer.write(writer.getCurrentLineNumber(), 0, writer.getCurrentLineNumber() + 1, 0);
                writer.write(writer.getCurrentLineNumber(), line.length() + 1, writer.getCurrentLineNumber() + 1, line.length() + 1);
            }
            writer.write(writer.getCurrentLineNumber(), i + 1, writer.getCurrentLineNumber() + 1, i + 1);
        }
    }

    public static void editReport(File file, String name) {
        File buildReport = InstanceManager.getDefault(TrainManagerXml.class).createTrainBuildReportFile(Bundle.getMessage("Report") + " " + name);
        TrainPrintUtilities.editReport(file, buildReport);
        TrainUtilities.openDesktop(buildReport);
    }

    public static void editReport(File file, File fileOut) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));
             PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileOut), StandardCharsets.UTF_8)), true);){
            try {
                String line;
                while ((line = in.readLine()) != null) {
                    if ((line = TrainPrintUtilities.filterBuildReport(line, Setup.isBuildReportIndentEnabled())).isEmpty()) continue;
                    out.println(line);
                }
            }
            catch (IOException e) {
                log.debug("Print read failed");
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            log.error("Build file doesn't exist: {}", (Object)e.getLocalizedMessage());
        }
        catch (IOException e) {
            log.error("Can not create build report file: {}", (Object)e.getLocalizedMessage());
        }
    }

    private static String filterBuildReport(String line, boolean indent) {
        String[] inputLine = line.split("\\s+");
        if (inputLine.length == 0) {
            return "";
        }
        if (inputLine[0].equals("7-") || inputLine[0].equals("5-") || inputLine[0].equals("3-") || inputLine[0].equals("1-")) {
            if (Setup.getBuildReportLevel().equals("1") && (inputLine[0].equals("3-") || inputLine[0].equals("5-") || inputLine[0].equals("7-"))) {
                return "";
            }
            if (Setup.getBuildReportLevel().equals("3") && (inputLine[0].equals("5-") || inputLine[0].equals("7-"))) {
                return "";
            }
            if (Setup.getBuildReportLevel().equals("5") && inputLine[0].equals("7-")) {
                return "";
            }
            int start = 0;
            if (indent) {
                if (inputLine[0].equals("7-")) {
                    inputLine[0] = "   ";
                } else if (inputLine[0].equals("5-")) {
                    inputLine[0] = "  ";
                } else if (inputLine[0].equals("3-")) {
                    inputLine[0] = " ";
                } else if (inputLine[0].equals("1-")) {
                    inputLine[0] = "";
                }
            } else {
                start = 1;
            }
            StringBuffer buf = new StringBuffer();
            for (int i = start; i < inputLine.length; ++i) {
                buf.append(inputLine[i] + " ");
            }
            if (buf.length() == 0) {
                return " ";
            }
            return buf.toString();
        }
        log.debug("ERROR first characters of build report not valid ({})", (Object)line);
        return "ERROR " + line;
    }

    public static JComboBox<String> getPrinterJComboBox() {
        PrintService[] services;
        JComboBox<String> box = new JComboBox<String>();
        for (PrintService printService : services = PrintServiceLookup.lookupPrintServices(null, null)) {
            box.addItem(printService.getName());
        }
        box.setSelectedItem(TrainPrintUtilities.getDefaultPrinterName());
        return box;
    }

    public static String getDefaultPrinterName() {
        if (PrintServiceLookup.lookupDefaultPrintService() != null) {
            return PrintServiceLookup.lookupDefaultPrintService().getName();
        }
        return "";
    }
}

