/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Bundle;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.TrainSwitchListText;
import jmri.jmrit.operations.trains.TrainUtilities;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainSwitchLists
extends TrainCommon {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    private static final char FORM_FEED = '\f';
    private static final boolean IS_PRINT_HEADER = true;
    String messageFormatText = "";
    private static final Logger log = LoggerFactory.getLogger(TrainSwitchLists.class);

    public void buildSwitchList(Location location) {
        boolean append = false;
        boolean checkFormFeed = true;
        if (!Setup.isSwitchListRealTime()) {
            if (!location.getStatus().equals(Location.MODIFIED) && !Setup.isSwitchListAllTrainsEnabled()) {
                return;
            }
            append = location.getSwitchListState() == 1;
            location.setSwitchListState(1);
        }
        log.debug("Append: {} for location ({})", (Object)append, (Object)location.getName());
        File file = InstanceManager.getDefault(TrainManagerXml.class).createSwitchListFile(location.getName());
        PrintWriter fileOut = null;
        try {
            fileOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), StandardCharsets.UTF_8)), true);
        }
        catch (IOException e) {
            log.error("Can not open switchlist file: {}", (Object)e.getLocalizedMessage());
            return;
        }
        try {
            if (!append) {
                this.newLine(fileOut, Setup.getRailroadName());
                this.newLine(fileOut);
                this.messageFormatText = TrainSwitchListText.getStringSwitchListFor();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, location.getSplitName()));
                if (!location.getSwitchListCommentWithColor().isEmpty()) {
                    this.newLine(fileOut, location.getSwitchListCommentWithColor());
                }
            } else {
                this.newLine(fileOut);
            }
            List<Train> trains = this.trainManager.getTrainsArrivingThisLocationList(location);
            for (Train train : trains) {
                Route route;
                if (!Setup.isSwitchListRealTime() && train.getSwitchListStatus().equals(Train.PRINTED) || (route = train.getRoute()) == null) continue;
                boolean works = TrainSwitchLists.isThereWorkAtLocation(train, location);
                if (!works && !Setup.isSwitchListAllTrainsEnabled()) {
                    log.debug("No work for train ({}) at location ({})", (Object)train.getName(), (Object)location.getName());
                    continue;
                }
                if (checkFormFeed) {
                    if (append && !Setup.getSwitchListPageFormat().equals(Setup.PAGE_NORMAL)) {
                        fileOut.write(12);
                    }
                    if (Setup.isPrintValidEnabled()) {
                        this.newLine(fileOut, this.getValid());
                    }
                } else if (!Setup.getSwitchListPageFormat().equals(Setup.PAGE_NORMAL)) {
                    fileOut.write(12);
                }
                checkFormFeed = false;
                this._pickupCars = false;
                this._dropCars = false;
                int stops = 1;
                boolean trainDone = false;
                List<Engine> engineList = this.engineManager.getByTrainBlockingList(train);
                List<Car> carList = this.carManager.getByTrainDestinationList(train);
                List<RouteLocation> routeList = route.getLocationsBySequenceList();
                RouteLocation rlPrevious = null;
                for (RouteLocation rl : routeList) {
                    if (!rl.getSplitName().equals(location.getSplitName())) {
                        rlPrevious = rl;
                        continue;
                    }
                    if (train.getExpectedArrivalTime(rl).equals("-1") && train.getCurrentRouteLocation() != rl) {
                        trainDone = true;
                    }
                    if (stops == 1) {
                        this.firstTimeMessages(fileOut, train, rl);
                        ++stops;
                    } else if (rlPrevious == null || !rl.getSplitName().equals(rlPrevious.getSplitName())) {
                        this.multipleVisitMessages(fileOut, train, rl, rlPrevious, stops);
                        ++stops;
                    } else {
                        this.reverseDirectionMessage(fileOut, train, rl, rlPrevious);
                    }
                    rlPrevious = rl;
                    if (Setup.isSwitchListRouteLocationCommentEnabled() && !rl.getComment().trim().isEmpty()) {
                        this.newLine(fileOut, rl.getCommentWithColor());
                    }
                    this.printTrackComments(fileOut, rl, carList, false);
                    if (this.isThereWorkAtLocation(carList, engineList, rl)) {
                        if (Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
                            this.pickupEngines(fileOut, engineList, rl, false);
                            if (train.isLocalSwitcher() || Setup.isPrintLocoLastEnabled()) {
                                this.blockCarsByTrack(fileOut, train, carList, rl, true, false);
                                this.dropEngines(fileOut, engineList, rl, false);
                            } else {
                                this.dropEngines(fileOut, engineList, rl, false);
                                this.blockCarsByTrack(fileOut, train, carList, rl, true, false);
                            }
                        } else if (Setup.getManifestFormat().equals(Setup.TWO_COLUMN_FORMAT)) {
                            this.blockLocosTwoColumn(fileOut, engineList, rl, false);
                            this.blockCarsTwoColumn(fileOut, train, carList, rl, true, false);
                        } else {
                            this.blockLocosTwoColumn(fileOut, engineList, rl, false);
                            this.blockCarsByTrackNameTwoColumn(fileOut, train, carList, rl, true, false);
                        }
                        this.printHorizontalLine3(fileOut, false);
                    }
                    if (rl == train.getTrainTerminatesRouteLocation()) continue;
                    RouteLocation nextRl = train.getRoute().getNextRouteLocation(rl);
                    if (rl.getSplitName().equals(nextRl.getSplitName()) || train.isLocalSwitcher() || trainDone) continue;
                    this.departureMessages(fileOut, train, rl);
                }
                this.trainSummaryMessages(fileOut, train, location, trainDone, stops);
            }
            this.reportByTrack(fileOut, location);
        }
        catch (IllegalArgumentException e) {
            this.newLine(fileOut, Bundle.getMessage("ErrorIllegalArgument", Bundle.getMessage("TitleSwitchListText"), e.getLocalizedMessage()));
            this.newLine(fileOut, this.messageFormatText);
            log.error("Illegal argument", (Throwable)e);
        }
        this.addCarsLocationUnknown(fileOut, false);
        fileOut.flush();
        fileOut.close();
        location.setStatus(Location.UPDATED);
    }

    private String getValid() {
        TrainSchedule sch;
        this.messageFormatText = TrainManifestText.getStringValid();
        Object valid = MessageFormat.format(this.messageFormatText, TrainSwitchLists.getDate(true));
        if (Setup.isPrintTrainScheduleNameEnabled() && (sch = InstanceManager.getDefault(TrainScheduleManager.class).getActiveSchedule()) != null) {
            valid = (String)valid + " (" + sch.getName() + ")";
        }
        return valid;
    }

    private void firstTimeMessages(PrintWriter fileOut, Train train, RouteLocation rl) {
        this.newLine(fileOut);
        this.messageFormatText = TrainSwitchListText.getStringScheduledWork();
        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription()));
        this.newLine(fileOut, TrainSwitchLists.getSwitchListTrainStatus(train, rl));
    }

    private void multipleVisitMessages(PrintWriter fileOut, Train train, RouteLocation rl, RouteLocation rlPrevious, int stops) {
        String expectedArrivalTime = train.getExpectedArrivalTime(rl);
        if (rlPrevious == null || !rl.getSplitName().equals(rlPrevious.getSplitName())) {
            if (Setup.getSwitchListPageFormat().equals(Setup.PAGE_PER_VISIT)) {
                fileOut.write(12);
            }
            this.newLine(fileOut);
            if (train.isTrainEnRoute()) {
                if (expectedArrivalTime.equals("-1")) {
                    this.messageFormatText = TrainSwitchListText.getStringVisitNumberDone();
                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), train.getDescription()));
                } else if (rl != train.getTrainTerminatesRouteLocation()) {
                    this.messageFormatText = TrainSwitchListText.getStringVisitNumberDeparted();
                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, rl.getTrainDirectionString(), train.getDescription()));
                } else {
                    this.messageFormatText = TrainSwitchListText.getStringVisitNumberTerminatesDeparted();
                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, rl.getSplitName(), train.getDescription()));
                }
            } else if (rl != train.getTrainTerminatesRouteLocation()) {
                this.messageFormatText = TrainSwitchListText.getStringVisitNumber();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, rl.getTrainDirectionString(), train.getDescription()));
                if (Setup.isUseSwitchListDepartureTimeEnabled()) {
                    this.messageFormatText = TrainSwitchListText.getStringDepartsAt();
                    this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.splitString(rl.getName()), rl.getTrainDirectionString(), train.getExpectedDepartureTime(rl)));
                }
            } else {
                this.messageFormatText = TrainSwitchListText.getStringVisitNumberTerminates();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, stops, train.getName(), expectedArrivalTime, rl.getSplitName(), train.getDescription()));
            }
        }
    }

    private void reverseDirectionMessage(PrintWriter fileOut, Train train, RouteLocation rl, RouteLocation rlPrevious) {
        if (rl.getTrainDirection() != rlPrevious.getTrainDirection() && !TrainSwitchListText.getStringTrainDirectionChange().isEmpty()) {
            this.messageFormatText = TrainSwitchListText.getStringTrainDirectionChange();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), rl.getTrainDirectionString(), train.getDescription(), train.getTrainTerminatesName()));
        }
    }

    private void departureMessages(PrintWriter fileOut, Train train, RouteLocation rl) {
        String trainDeparts = "";
        if (Setup.isPrintLoadsAndEmptiesEnabled()) {
            int emptyCars = train.getNumberEmptyCarsInTrain(rl);
            trainDeparts = MessageFormat.format(TrainSwitchListText.getStringTrainDepartsLoads(), rl.getSplitName(), rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl) - emptyCars, emptyCars, train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName());
        } else {
            trainDeparts = MessageFormat.format(TrainSwitchListText.getStringTrainDepartsCars(), rl.getSplitName(), rl.getTrainDirectionString(), train.getNumberCarsInTrain(rl), train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), train.getTrainWeight(rl), train.getTrainTerminatesName(), train.getName());
        }
        this.newLine(fileOut, trainDeparts);
    }

    private void trainSummaryMessages(PrintWriter fileOut, Train train, Location location, boolean trainDone, int stops) {
        if (trainDone && !this._pickupCars && !this._dropCars) {
            this.messageFormatText = TrainSwitchListText.getStringTrainDone();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription(), location.getSplitName()));
        } else {
            if (stops > 1 && !this._pickupCars) {
                this.messageFormatText = TrainSwitchListText.getStringNoCarPickUps();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription(), location.getSplitName()));
            }
            if (stops > 1 && !this._dropCars) {
                this.messageFormatText = TrainSwitchListText.getStringNoCarDrops();
                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, train.getName(), train.getDescription(), location.getSplitName()));
            }
        }
    }

    private void reportByTrack(PrintWriter fileOut, Location location) {
        if (Setup.isPrintTrackSummaryEnabled() && Setup.isSwitchListRealTime()) {
            this.clearUtilityCarTypes();
            if (Setup.getSwitchListPageFormat().equals(Setup.PAGE_NORMAL)) {
                this.newLine(fileOut);
                this.newLine(fileOut);
            } else {
                fileOut.write(12);
            }
            this.messageFormatText = TrainSwitchListText.getStringSwitchListByTrack();
            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, location.getSplitName()));
            List rsList = this.carManager.getByTrainList();
            ArrayList<Car> carList = new ArrayList<Car>();
            for (Car rs : rsList) {
                if ((rs.getLocation() == null || !rs.getLocation().getSplitName().equals(location.getSplitName())) && (rs.getDestination() == null || !rs.getSplitDestinationName().equals(location.getSplitName()))) continue;
                carList.add(rs);
            }
            ArrayList<String> trackNames = new ArrayList<String>();
            for (Location loc : this.locationManager.getLocationsByNameList()) {
                if (!loc.getSplitName().equals(location.getSplitName())) continue;
                for (Track track : loc.getTracksByBlockingOrderList(null)) {
                    String trackName = track.getSplitName();
                    if (trackNames.contains(trackName)) continue;
                    trackNames.add(trackName);
                    String trainName = "";
                    this.newLine(fileOut);
                    this.newLine(fileOut, trackName);
                    for (Car car : carList) {
                        if (!car.getSplitTrackName().equals(trackName)) continue;
                        if (car.getRouteLocation() != null) {
                            if (!car.getRouteLocation().getLocation().getSplitName().equals(location.getSplitName())) continue;
                            if (!trainName.equals(car.getTrainName())) {
                                trainName = car.getTrainName();
                                this.messageFormatText = TrainSwitchListText.getStringScheduledWork();
                                this.newLine(fileOut, MessageFormat.format(this.messageFormatText, car.getTrainName(), car.getTrain().getDescription()));
                                this.printPickupCarHeader(fileOut, false, false);
                            }
                            if (car.isUtility()) {
                                this.pickupUtilityCars(fileOut, carList, car, false, false);
                                continue;
                            }
                            this.pickUpCar(fileOut, car, false);
                            continue;
                        }
                        if (car.isUtility()) {
                            String s = this.pickupUtilityCars(carList, car, false, false);
                            if (s == null) continue;
                            this.newLine(fileOut, TrainSwitchListText.getStringHoldCar().split("\\{")[0] + s.trim());
                            continue;
                        }
                        this.messageFormatText = TrainSwitchListText.getStringHoldCar();
                        this.newLine(fileOut, MessageFormat.format(this.messageFormatText, TrainSwitchLists.padAndTruncateIfNeeded(car.getRoadName(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(TrainCommon.splitString(car.getNumber()), Control.max_len_string_print_road_number), TrainSwitchLists.padAndTruncateIfNeeded(car.getTypeName().split("-")[0], InstanceManager.getDefault(CarTypes.class).getMaxNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(car.getLength() + Setup.getLengthUnitAbv(), Control.max_len_string_length_name), TrainSwitchLists.padAndTruncateIfNeeded(car.getLoadName(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(trackName, this.locationManager.getMaxTrackNameLength()), TrainSwitchLists.padAndTruncateIfNeeded(car.getColor(), InstanceManager.getDefault(CarColors.class).getMaxNameLength())));
                    }
                    for (Car car : carList) {
                        if (!car.getSplitDestinationTrackName().equals(trackName) || car.getRouteDestination() == null || !car.getRouteDestination().getLocation().getSplitName().equals(location.getSplitName())) continue;
                        if (!trainName.equals(car.getTrainName())) {
                            trainName = car.getTrainName();
                            this.messageFormatText = TrainSwitchListText.getStringScheduledWork();
                            this.newLine(fileOut, MessageFormat.format(this.messageFormatText, car.getTrainName(), car.getTrain().getDescription()));
                            this.printDropCarHeader(fileOut, false, false);
                        }
                        if (car.isUtility()) {
                            this.setoutUtilityCars(fileOut, carList, car, false, false);
                            continue;
                        }
                        this.dropCar(fileOut, car, false);
                    }
                }
            }
        }
    }

    public void printSwitchList(Location location, boolean isPreview) {
        File switchListFile = InstanceManager.getDefault(TrainManagerXml.class).getSwitchListFile(location.getName());
        if (!switchListFile.exists()) {
            log.warn("Switch list file missing for location ({})", (Object)location.getName());
            return;
        }
        if (isPreview && Setup.isManifestEditorEnabled()) {
            TrainUtilities.openDesktop(switchListFile);
        } else {
            TrainPrintUtilities.printReport(switchListFile, location.getName(), isPreview, Setup.getFontName(), false, FileUtil.getExternalFilename(Setup.getManifestLogoURL()), location.getDefaultPrinterName(), Setup.getSwitchListOrientation(), Setup.getManifestFontSize(), Setup.isPrintPageHeaderEnabled(), Setup.getPrintDuplexSides());
        }
        if (!isPreview) {
            location.setStatus(Location.PRINTED);
            location.setSwitchListState(2);
        }
    }

    protected void newLine(PrintWriter file, String string) {
        if (!string.isEmpty()) {
            this.newLine(file, string, false);
        }
    }
}

