/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.csv;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.csv.Bundle;
import jmri.jmrit.operations.trains.csv.TrainCsvCommon;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCsvManifest
extends TrainCsvCommon {
    private static final Logger log = LoggerFactory.getLogger(TrainCsvManifest.class);

    public TrainCsvManifest(Train train) throws BuildFailedException {
        if (!Setup.isGenerateCsvManifestEnabled()) {
            return;
        }
        File file = InstanceManager.getDefault(TrainManagerXml.class).createTrainCsvManifestFile(train.getName());
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            this.printHeader(fileOut);
            this.printRailroadName(fileOut, train.getRailroadName().isEmpty() ? Setup.getRailroadName() : train.getRailroadName());
            this.printTrainName(fileOut, train.getName());
            this.printTrainDescription(fileOut, train.getDescription());
            this.printPrinterName(fileOut, this.locationManager.getLocationByName(train.getTrainDepartsName()).getDefaultPrinterName());
            this.printLogoURL(fileOut, train);
            this.printValidity(fileOut, TrainCsvManifest.getDate(true));
            this.printTrainComment(fileOut, train);
            this.printRouteComment(fileOut, train);
            List<Engine> engineList = this.engineManager.getByTrainBlockingList(train);
            List<Car> carList = this.carManager.getByTrainDestinationList(train);
            boolean newWork = false;
            String previousRouteLocationName = null;
            List<RouteLocation> routeList = train.getRoute().getLocationsBySequenceList();
            for (RouteLocation rl : routeList) {
                int count;
                if (!rl.getSplitName().equals(previousRouteLocationName)) {
                    this.printLocationName(fileOut, rl.getSplitName());
                    if (rl != train.getTrainDepartsRouteLocation()) {
                        fileOut.printRecord(new Object[]{"AT", Bundle.getMessage("csvArrivalTime"), train.getExpectedArrivalTime(rl)});
                    }
                    if (rl == train.getTrainDepartsRouteLocation()) {
                        fileOut.printRecord(new Object[]{"DT", Bundle.getMessage("csvDepartureTime"), train.getFormatedDepartureTime()});
                    } else if (!rl.getDepartureTime().equals("")) {
                        fileOut.printRecord(new Object[]{"DTR", Bundle.getMessage("csvDepartureTimeRoute"), rl.getFormatedDepartureTime()});
                    } else {
                        fileOut.printRecord(new Object[]{"EDT", Bundle.getMessage("csvEstimatedDepartureTime"), train.getExpectedDepartureTime(rl)});
                    }
                    this.printLocationComment(fileOut, rl.getLocation());
                    if (Setup.isPrintTruncateManifestEnabled() && rl.getLocation().isSwitchListEnabled()) {
                        fileOut.printRecord(new Object[]{"TRUN", Bundle.getMessage("csvTruncate")});
                    }
                }
                this.printRouteLocationComment(fileOut, rl);
                this.printTrackComments(fileOut, rl, carList);
                this.checkForEngineOrCabooseChange(fileOut, train, rl);
                for (Engine engine : engineList) {
                    if (engine.getRouteLocation() != rl) continue;
                    this.printEngine(fileOut, engine, "PL", Bundle.getMessage("csvPickUpLoco"));
                }
                for (Engine engine : engineList) {
                    if (engine.getRouteDestination() != rl) continue;
                    this.printEngine(fileOut, engine, "SL", Bundle.getMessage("csvSetOutLoco"));
                }
                for (RouteLocation rld : train.getTrainBlockingOrder()) {
                    for (Car car : carList) {
                        if (!TrainCsvManifest.isNextCar(car, rl, rld)) continue;
                        newWork = true;
                        count = 0;
                        if (car.isUtility() && (count = this.countPickupUtilityCars(carList, car, true)) == 0) continue;
                        this.printCar(fileOut, car, "PC", Bundle.getMessage("csvPickUpCar"), count);
                    }
                }
                for (Car car : carList) {
                    if (car.getRouteDestination() != rl) continue;
                    newWork = true;
                    int count2 = 0;
                    if (car.isUtility() && (count2 = this.countSetoutUtilityCars(carList, car, false, true)) == 0) continue;
                    this.printCar(fileOut, car, "SC", Bundle.getMessage("csvSetOutCar"), count2);
                }
                List<Car> carsByLocation = this.carManager.getByLocationList();
                ArrayList<Car> cList = new ArrayList<Car>();
                for (Car car : carsByLocation) {
                    if (car.getLocation() != rl.getLocation() || car.getRouteLocation() != null || car.getTrack() == null) continue;
                    cList.add(car);
                }
                this.clearUtilityCarTypes();
                for (Car car : cList) {
                    if (car.getTrack().getLocation().isStaging() || !car.getTrack().isPickupTrainAccepted(train) || car.getTrack().getPickupIds().length != 1 || !car.getTrack().getPickupOption().equals("trains")) continue;
                    count = 0;
                    if (car.isUtility() && (count = this.countPickupUtilityCars(cList, car, false)) == 0) continue;
                    this.printCar(fileOut, car, "HOLD", Bundle.getMessage("csvHoldCar"), count);
                }
                if (rl != train.getTrainTerminatesRouteLocation()) {
                    RouteLocation rlNext = train.getRoute().getNextRouteLocation(rl);
                    if (!rl.getSplitName().equals(rlNext.getSplitName())) {
                        if (newWork) {
                            this.printTrainDeparts(fileOut, rl.getSplitName(), rl.getTrainDirectionString());
                            this.printTrainLength(fileOut, train.getTrainLength(rl), train.getNumberEmptyCarsInTrain(rl), train.getNumberCarsInTrain(rl));
                            this.printTrainWeight(fileOut, train.getTrainWeight(rl));
                            newWork = false;
                        } else {
                            fileOut.printRecord(new Object[]{"NW", Bundle.getMessage("csvNoWork")});
                        }
                    }
                } else {
                    this.printTrainTerminates(fileOut, rl.getSplitName());
                }
                previousRouteLocationName = rl.getSplitName();
            }
            this.listCarsLocationUnknown(fileOut);
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException e) {
            log.error("Can not open CSV manifest file: {}", (Object)e.getLocalizedMessage());
            throw new BuildFailedException(e);
        }
    }
}

