/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.csv;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.csv.Bundle;
import jmri.jmrit.operations.trains.csv.TrainCsvCommon;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCsvSwitchLists
extends TrainCsvCommon {
    private static final Logger log = LoggerFactory.getLogger(TrainCsvSwitchLists.class);

    public File buildSwitchList(Location location) {
        if (!Setup.isGenerateCsvSwitchListEnabled()) {
            return null;
        }
        boolean append = false;
        if (!Setup.isSwitchListRealTime()) {
            if (location.getStatus().equals(Location.UPDATED)) {
                return null;
            }
            append = location.getSwitchListState() == 1;
        }
        File file = InstanceManager.getDefault(TrainManagerXml.class).createCsvSwitchListFile(location.getName());
        log.debug("Append CSV file: {} for location ({})", (Object)append, (Object)location.getName());
        if (append) {
            this.trimCvsFile(file, location);
        }
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), StandardCharsets.UTF_8), CSVFormat.DEFAULT);){
            if (!append) {
                this.printHeader(fileOut);
                fileOut.printRecord(new Object[]{"SWL", Bundle.getMessage("csvSwitchList")});
                this.printRailroadName(fileOut, Setup.getRailroadName());
                this.printLocationName(fileOut, location.getSplitName());
                this.printPrinterName(fileOut, location.getDefaultPrinterName());
                this.printLocationSwitchListComment(fileOut, location);
                this.printLocationComment(fileOut, location);
            }
            this.printValidity(fileOut, TrainCsvSwitchLists.getDate(true));
            List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsArrivingThisLocationList(location);
            for (Train train : trains) {
                if (!train.isBuilt() || !Setup.isSwitchListRealTime() && train.getSwitchListStatus().equals(Train.PRINTED)) continue;
                int pickupCars = 0;
                int dropCars = 0;
                int stops = 1;
                boolean trainDone = false;
                List<Car> carList = InstanceManager.getDefault(CarManager.class).getByTrainDestinationList(train);
                List<Engine> enginesList = InstanceManager.getDefault(EngineManager.class).getByTrainBlockingList(train);
                Route route = train.getRoute();
                if (route == null) continue;
                List<RouteLocation> routeList = route.getLocationsBySequenceList();
                RouteLocation rlPrevious = null;
                for (RouteLocation rl : routeList) {
                    if (!rl.getSplitName().equals(location.getSplitName())) {
                        rlPrevious = rl;
                        continue;
                    }
                    String expectedArrivalTime = train.getExpectedArrivalTime(rl);
                    if (expectedArrivalTime.equals("-1")) {
                        trainDone = true;
                    }
                    if (stops == 1) {
                        this.printTrainName(fileOut, train.getName());
                        this.printTrainDescription(fileOut, train.getDescription());
                        this.printTrainComment(fileOut, train);
                        this.printRouteComment(fileOut, train);
                        if (train.isTrainEnRoute()) {
                            fileOut.printRecord(new Object[]{"TIR", Bundle.getMessage("csvTrainEnRoute")});
                            this.printEstimatedTimeEnRoute(fileOut, expectedArrivalTime);
                        } else {
                            fileOut.printRecord(new Object[]{"DL", Bundle.getMessage("csvDepartureLocationName"), TrainCsvSwitchLists.splitString(train.getTrainDepartsName())});
                            this.printDepartureTime(fileOut, train.getFormatedDepartureTime());
                            if (rl == train.getTrainDepartsRouteLocation() && !train.isLocalSwitcher()) {
                                this.printTrainDeparts(fileOut, rl.getSplitName(), rl.getTrainDirectionString());
                            }
                            if (rl != train.getTrainDepartsRouteLocation()) {
                                this.printExpectedTimeArrival(fileOut, expectedArrivalTime);
                                this.printTrainArrives(fileOut, rl.getSplitName(), rl.getTrainDirectionString());
                            }
                        }
                        if (rl == train.getTrainTerminatesRouteLocation()) {
                            this.printTrainTerminates(fileOut, rl.getSplitName());
                        }
                    }
                    if (stops > 1) {
                        if (rlPrevious == null || !rl.getSplitName().equals(rlPrevious.getSplitName())) {
                            fileOut.printRecord(new Object[]{"VN", Bundle.getMessage("csvVisitNumber"), stops});
                            if (train.isTrainEnRoute()) {
                                this.printEstimatedTimeEnRoute(fileOut, expectedArrivalTime);
                            } else {
                                this.printExpectedTimeArrival(fileOut, expectedArrivalTime);
                            }
                            this.printTrainArrives(fileOut, rl.getSplitName(), rl.getTrainDirectionString());
                            if (rl == train.getTrainTerminatesRouteLocation()) {
                                this.printTrainTerminates(fileOut, rl.getSplitName());
                            }
                        } else {
                            --stops;
                            if (rl.getTrainDirection() != rlPrevious.getTrainDirection()) {
                                fileOut.printRecord(new Object[]{"TDC", Bundle.getMessage("csvTrainChangesDirection"), rl.getTrainDirectionString()});
                            }
                        }
                    }
                    rlPrevious = rl;
                    this.printRouteLocationComment(fileOut, rl);
                    this.printTrackComments(fileOut, rl, carList);
                    this.checkForEngineOrCabooseChange(fileOut, train, rl);
                    for (Engine engine : enginesList) {
                        if (engine.getRouteLocation() != rl || engine.getTrack() == null) continue;
                        this.printEngine(fileOut, engine, "PL", Bundle.getMessage("csvPickUpLoco"));
                    }
                    for (RouteLocation rld : train.getTrainBlockingOrder()) {
                        for (Car car : carList) {
                            if (!TrainCsvSwitchLists.isNextCar(car, rl, rld)) continue;
                            ++pickupCars;
                            int count = 0;
                            if (car.isUtility() && (count = this.countPickupUtilityCars(carList, car, false)) == 0) continue;
                            this.printCar(fileOut, car, "PC", Bundle.getMessage("csvPickUpCar"), count);
                        }
                    }
                    for (Engine engine : enginesList) {
                        if (engine.getRouteDestination() != rl) continue;
                        this.printEngine(fileOut, engine, "SL", Bundle.getMessage("csvSetOutLoco"));
                    }
                    for (Car car : carList) {
                        if (car.getRouteDestination() != rl) continue;
                        ++dropCars;
                        int count = 0;
                        if (car.isUtility() && (count = this.countSetoutUtilityCars(carList, car, false, false)) == 0) continue;
                        this.printCar(fileOut, car, "SC", Bundle.getMessage("csvSetOutCar"), count);
                    }
                    ++stops;
                    if (rl == train.getTrainTerminatesRouteLocation()) continue;
                    this.printTrainLength(fileOut, train.getTrainLength(rl), train.getNumberEmptyCarsInTrain(rl), train.getNumberCarsInTrain(rl));
                    this.printTrainWeight(fileOut, train.getTrainWeight(rl));
                }
                if (trainDone && pickupCars == 0 && dropCars == 0) {
                    fileOut.printRecord(new Object[]{"TDONE", Bundle.getMessage("csvTrainHasAlreadyServiced")});
                    continue;
                }
                if (stops <= true) continue;
                if (pickupCars == 0) {
                    fileOut.printRecord(new Object[]{"NCPU", Bundle.getMessage("csvNoCarPickUp")});
                }
                if (dropCars == 0) {
                    fileOut.printRecord(new Object[]{"NCSO", Bundle.getMessage("csvNoCarSetOut")});
                }
                fileOut.printRecord(new Object[]{"TEND", Bundle.getMessage("csvTrainEnd"), train.getName()});
            }
            this.printEnd(fileOut);
            if (Setup.isSwitchListRealTime() && Setup.isPrintTrackSummaryEnabled()) {
                List<Car> rsByLocation = InstanceManager.getDefault(CarManager.class).getByLocationList();
                ArrayList<Car> carList = new ArrayList<Car>();
                for (Car rs : rsByLocation) {
                    if (rs.getLocation() == null || !rs.getLocation().getSplitName().equals(location.getSplitName()) || rs.getRouteLocation() != null) continue;
                    carList.add(rs);
                }
                this.clearUtilityCarTypes();
                for (Car car : carList) {
                    int count = 0;
                    if (car.isUtility() && (count = this.countPickupUtilityCars(carList, car, false)) == 0) continue;
                    this.printCar(fileOut, car, "HOLD", Bundle.getMessage("csvHoldCar"), count);
                }
            }
            this.printEnd(fileOut);
            this.listCarsLocationUnknown(fileOut);
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException e) {
            log.error("Can not open CSV switch list file: {}", (Object)e.getLocalizedMessage());
            return null;
        }
        return file;
    }

    protected final void printEnd(CSVPrinter printer) throws IOException {
        printer.printRecord(new Object[]{"END", Bundle.getMessage("csvEnd")});
    }

    protected final void printExpectedTimeArrival(CSVPrinter printer, String time) throws IOException {
        printer.printRecord(new Object[]{"ETA", Bundle.getMessage("csvExpectedTimeArrival"), time});
    }

    protected final void printEstimatedTimeEnRoute(CSVPrinter printer, String time) throws IOException {
        printer.printRecord(new Object[]{"ETE", Bundle.getMessage("csvEstimatedTimeEnRoute"), time});
    }

    protected final void printTrainArrives(CSVPrinter printer, String name, String direction) throws IOException {
        printer.printRecord(new Object[]{"TA", Bundle.getMessage("csvTrainArrives"), name, direction});
    }

    private void trimCvsFile(File file, Location location) {
        try (PrintWriter fileOut = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), true);){
            File backupFile = new File(InstanceManager.getDefault(TrainManagerXml.class).backupFileName(file.getAbsolutePath()));
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(backupFile), StandardCharsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null && !line.startsWith("END")) {
                    fileOut.println(line);
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                log.error("Can not open CSV switch list file: {}", (Object)file.getName());
            }
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException e) {
            log.error("Can not open CSV switch list file: {}", (Object)e.getLocalizedMessage());
        }
    }
}

