/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.excel;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.excel.Bundle;
import jmri.jmrit.operations.trains.excel.SetupExcelProgramFrame;
import jmri.jmrit.operations.trains.excel.TrainCustomManifest;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupExcelProgramManifestFrame
extends SetupExcelProgramFrame {
    TrainCustomManifest tcm = InstanceManager.getDefault(TrainCustomManifest.class);
    private static final Logger log = LoggerFactory.getLogger(SetupExcelProgramManifestFrame.class);

    @Override
    public void initComponents() {
        super.initComponents();
        this.generateCheckBox.setText(rb.getString("GenerateCsvManifest"));
        this.generateCheckBox.setSelected(Setup.isGenerateCsvManifestEnabled());
        this.fileNameTextField.setText(this.tcm.getFileName());
        this.pDirectoryName.add(new JLabel(this.tcm.getDirectoryPathName()));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        File f;
        if (ae.getSource() == this.addButton && (f = this.selectFile(this.tcm.getDirectoryName())) != null) {
            log.debug("User selected file: {}", (Object)f.getName());
            this.fileNameTextField.setText(f.getName());
        }
        this.tcm.setFileName(this.fileNameTextField.getText());
        if (ae.getSource() == this.testButton) {
            if (this.tcm.excelFileExists()) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DirectoryNameFileName", this.tcm.getDirectoryName(), this.tcm.getFileName()), Bundle.getMessage("ManifestCreatorFound"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LoadDirectoryNameFileName", this.tcm.getDirectoryPathName(), this.tcm.getFileName()), Bundle.getMessage("ManifestCreatorNotFound"), 0);
            }
        }
        if (ae.getSource() == this.saveButton) {
            log.debug("Save button activated");
            Setup.setGenerateCsvManifestEnabled(this.generateCheckBox.isSelected());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }
}

