/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.excel;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.excel.Bundle;
import jmri.jmrit.operations.trains.excel.SetupExcelProgramFrame;
import jmri.jmrit.operations.trains.excel.TrainCustomSwitchList;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetupExcelProgramSwitchListFrame
extends SetupExcelProgramFrame {
    TrainCustomSwitchList tcs = InstanceManager.getDefault(TrainCustomSwitchList.class);
    private static final Logger log = LoggerFactory.getLogger(SetupExcelProgramSwitchListFrame.class);

    @Override
    public void initComponents() {
        super.initComponents();
        this.generateCheckBox.setText(rb.getString("GenerateCsvSwitchList"));
        this.generateCheckBox.setSelected(Setup.isGenerateCsvSwitchListEnabled());
        this.fileNameTextField.setText(this.tcs.getFileName());
        this.pDirectoryName.add(new JLabel(this.tcs.getDirectoryPathName()));
        this.setTitle(Bundle.getMessage("MenuItemSetupExcelProgramSwitchList"));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        File f;
        if (ae.getSource() == this.addButton && (f = this.selectFile(this.tcs.getDirectoryName())) != null) {
            log.debug("User selected file: {}", (Object)f.getName());
            this.fileNameTextField.setText(f.getName());
        }
        this.tcs.setFileName(this.fileNameTextField.getText());
        if (ae.getSource() == this.testButton) {
            if (this.tcs.excelFileExists()) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DirectoryNameFileName", this.tcs.getDirectoryName(), this.tcs.getFileName()), Bundle.getMessage("ManifestCreatorFound"), 1);
            } else {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("LoadDirectoryNameFileName", this.tcs.getDirectoryPathName(), this.tcs.getFileName()), Bundle.getMessage("ManifestCreatorNotFound"), 0);
            }
        }
        if (ae.getSource() == this.saveButton) {
            log.debug("Save button activated");
            Setup.setGenerateCsvSwitchListEnabled(this.generateCheckBox.isSelected());
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }
}

