/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jmri.jmrit.operations.CommonConductorYardmasterPanel;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.gui.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainConductorPanel
extends CommonConductorYardmasterPanel {
    JLabel textTrainName = new JLabel();
    JLabel textTrainDepartureTime = new JLabel();
    JLabel textNextLocationName = new JLabel();
    JPanel pTrainDepartureTime = new JPanel();
    private boolean queued = false;
    private static final Logger log = LoggerFactory.getLogger(TrainConductorPanel.class);

    public TrainConductorPanel() {
        this((Train)null);
    }

    public TrainConductorPanel(Train train) {
        this._train = train;
        JPanel pRow2 = new JPanel();
        pRow2.setLayout(new BoxLayout(pRow2, 0));
        JPanel pTrainName = new JPanel();
        pTrainName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        pTrainName.add(this.textTrainName);
        pRow2.add(pTrainName);
        pRow2.add(this.pTrainDescription);
        pRow2.add(this.pRailRoadName);
        JPanel pLocation = new JPanel();
        pLocation.setLayout(new BoxLayout(pLocation, 0));
        this.pTrainDepartureTime.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("DepartTime")));
        this.pTrainDepartureTime.add(this.textTrainDepartureTime);
        JPanel pNextLocationName = new JPanel();
        pNextLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("NextLocation")));
        pNextLocationName.add(this.textNextLocationName);
        pLocation.add(this.pLocationName);
        pLocation.add(this.pTrainDepartureTime);
        pLocation.add(pNextLocationName);
        JPanel pRow14 = new JPanel();
        pRow14.setLayout(new BoxLayout(pRow14, 0));
        pRow14.setMaximumSize(new Dimension(2000, 200));
        JPanel pMoveButton = new JPanel();
        pMoveButton.setLayout(new GridBagLayout());
        pMoveButton.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        this.addItem(pMoveButton, this.moveButton, 1, 0);
        pRow14.add(this.pButtons);
        pRow14.add(pMoveButton);
        this.add(pRow2);
        this.add(pLocation);
        this.add(this.textTrainCommentPane);
        this.add(this.textTrainRouteCommentPane);
        this.add(this.textTrainRouteLocationCommentPane);
        this.add(this.textLocationCommentPane);
        this.add(this.pTrackComments);
        this.add(this.textTrainStatusPane);
        this.add(this.locoPane);
        this.add(this.pWorkPanes);
        this.add(this.movePane);
        this.add(this.pStatus);
        this.add(pRow14);
        this.addButtonAction(this.moveButton);
        if (this._train != null) {
            this.loadTrainDescription();
            this.loadTrainComment();
            this.loadRouteComment();
            this.loadRailroadName();
            this._train.addPropertyChangeListener(this);
        }
        this.trainManager.addPropertyChangeListener(this);
        this.update();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.moveButton) {
            this._train.move();
            return;
        }
        super.buttonActionPerformed(ae);
    }

    @Override
    protected void update() {
        log.debug("queue update");
        if (this.queued) {
            return;
        }
        this.queued = true;
        SwingUtilities.invokeLater(() -> {
            log.debug("run update, setMode: {}", (Object)this.isSetMode);
            this.queued = false;
            this.initialize();
            if (this._train != null && this._train.getRoute() != null) {
                this.textTrainName.setText(this._train.getIconName());
                RouteLocation rl = this._train.getCurrentRouteLocation();
                if (rl != null) {
                    this.loadRouteLocationComment(rl);
                    this.textLocationName.setText(this.trainManager.isShowLocationHyphenNameEnabled() ? rl.getLocation().getName() : rl.getLocation().getSplitName());
                    this.pTrainDepartureTime.setVisible(this._train.isShowArrivalAndDepartureTimesEnabled() && !rl.getDepartureTime().equals(""));
                    this.textTrainDepartureTime.setText(rl.getFormatedDepartureTime());
                    this.loadLocationComment(rl.getLocation());
                    this.textNextLocationName.setText(this.trainManager.isShowLocationHyphenNameEnabled() ? this._train.getNextLocationName() : TrainCommon.splitString(this._train.getNextLocationName()));
                    this.updateTrackComments(rl, true);
                    this.textTrainStatusPane.setText(TrainCommon.getTrainMessage(this._train, rl));
                    this.updateLocoPanes(rl);
                    this.blockCars(rl, true);
                }
                this.textStatus.setText(this.getStatus(rl, true));
                if (rl == this._train.getTrainTerminatesRouteLocation()) {
                    this.moveButton.setText(Bundle.getMessage("Terminate"));
                } else {
                    this.moveButton.setText(Bundle.getMessage("Move"));
                }
            }
            this.updateComplete();
        });
    }

    @Override
    public void dispose() {
        this.trainManager.removePropertyChangeListener(this);
        this.removePropertyChangeListerners();
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("TrainMoveComplete") || e.getPropertyName().equals("TrainBuilt")) {
            this.clearAndUpdate();
        }
        if (e.getPropertyName().equals("rolling stock route location") && e.getNewValue() == null || e.getPropertyName().equals("rolling stock route destination") && e.getNewValue() == null || e.getPropertyName().equals("rolling stock train") || e.getPropertyName().equals("TrainModified") || e.getPropertyName().equals("TrainsShowFullName")) {
            if (e.getSource().getClass().equals(Car.class)) {
                Car car = (Car)e.getSource();
                this.removeCarFromList(car);
            }
            this.update();
        }
    }
}

