/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.gui.Bundle;
import jmri.jmrit.operations.trains.gui.TrainEditFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainEditBuildOptionsFrame
extends OperationsFrame
implements PropertyChangeListener {
    Train _train = null;
    JPanel panelOwnerNames = new JPanel();
    JPanel panelBuilt = new JPanel();
    JPanel panelTrainReq1 = new JPanel();
    JPanel panelTrainReq2 = new JPanel();
    JScrollPane ownerPane;
    JScrollPane builtPane;
    JScrollPane trainReq1Pane;
    JScrollPane trainReq2Pane;
    JPanel engine1Option = new JPanel();
    JPanel engine1DropOption = new JPanel();
    JPanel engine1caboose = new JPanel();
    JPanel engine2Option = new JPanel();
    JPanel engine2DropOption = new JPanel();
    JPanel engine2caboose = new JPanel();
    JLabel trainName = new JLabel();
    JLabel trainDescription = new JLabel();
    JLabel before = new JLabel(Bundle.getMessage("Before"));
    JLabel after = new JLabel(Bundle.getMessage("After"));
    JButton addOwnerButton = new JButton(Bundle.getMessage("AddOwner"));
    JButton deleteOwnerButton = new JButton(Bundle.getMessage("DeleteOwner"));
    JButton saveTrainButton = new JButton(Bundle.getMessage("SaveTrain"));
    JRadioButton ownerNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton ownerNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton ownerNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JRadioButton builtDateAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton builtDateAfter = new JRadioButton(Bundle.getMessage("After"));
    JRadioButton builtDateBefore = new JRadioButton(Bundle.getMessage("Before"));
    JRadioButton builtDateRange = new JRadioButton(Bundle.getMessage("Range"));
    ButtonGroup ownerGroup = new ButtonGroup();
    ButtonGroup builtGroup = new ButtonGroup();
    JRadioButton none1 = new JRadioButton(Bundle.getMessage("None"));
    JRadioButton change1Engine = new JRadioButton(Bundle.getMessage("EngineChange"));
    JRadioButton add1Engine = new JRadioButton(Bundle.getMessage("AddEngines"));
    JRadioButton remove1Engine = new JRadioButton(Bundle.getMessage("RemoveEngines"));
    JRadioButton modify1Caboose = new JRadioButton(Bundle.getMessage("ChangeCaboose"));
    JRadioButton helper1Service = new JRadioButton(Bundle.getMessage("HelperService"));
    JRadioButton remove1Caboose = new JRadioButton(Bundle.getMessage("RemoveCaboose"));
    JRadioButton keep1Caboose = new JRadioButton(Bundle.getMessage("KeepCaboose"));
    JRadioButton change1Caboose = new JRadioButton(Bundle.getMessage("ChangeCaboose"));
    ButtonGroup trainReq1Group = new ButtonGroup();
    ButtonGroup cabooseOption1Group = new ButtonGroup();
    JRadioButton none2 = new JRadioButton(Bundle.getMessage("None"));
    JRadioButton change2Engine = new JRadioButton(Bundle.getMessage("EngineChange"));
    JRadioButton add2Engine = new JRadioButton(Bundle.getMessage("AddEngines"));
    JRadioButton remove2Engine = new JRadioButton(Bundle.getMessage("RemoveEngines"));
    JRadioButton modify2Caboose = new JRadioButton(Bundle.getMessage("ChangeCaboose"));
    JRadioButton helper2Service = new JRadioButton(Bundle.getMessage("HelperService"));
    JRadioButton remove2Caboose = new JRadioButton(Bundle.getMessage("RemoveCaboose"));
    JRadioButton keep2Caboose = new JRadioButton(Bundle.getMessage("KeepCaboose"));
    JRadioButton change2Caboose = new JRadioButton(Bundle.getMessage("ChangeCaboose"));
    ButtonGroup trainReq2Group = new ButtonGroup();
    ButtonGroup cabooseOption2Group = new ButtonGroup();
    JCheckBox buildNormalCheckBox = new JCheckBox(Bundle.getMessage("NormalModeWhenBuilding"));
    JCheckBox sendToTerminalCheckBox = new JCheckBox();
    JCheckBox returnStagingCheckBox = new JCheckBox(Bundle.getMessage("AllowCarsToReturn"));
    JCheckBox allowLocalMovesCheckBox = new JCheckBox(Bundle.getMessage("AllowLocalMoves"));
    JCheckBox allowThroughCarsCheckBox = new JCheckBox(Bundle.getMessage("AllowThroughCars"));
    JCheckBox serviceAllCarsCheckBox = new JCheckBox(Bundle.getMessage("ServiceAllCars"));
    JCheckBox sendCustomStagngCheckBox = new JCheckBox(Bundle.getMessage("SendCustomToStaging"));
    JCheckBox buildConsistCheckBox = new JCheckBox(Bundle.getMessage("BuildConsist"));
    JTextField builtAfterTextField = new JTextField(10);
    JTextField builtBeforeTextField = new JTextField(10);
    JComboBox<String> ownerBox = InstanceManager.getDefault(CarOwners.class).getComboBox();
    JComboBox<RouteLocation> routePickup1Box = new JComboBox();
    JComboBox<RouteLocation> routeDrop1Box = new JComboBox();
    JComboBox<String> roadCaboose1Box = new JComboBox();
    JComboBox<String> roadEngine1Box = InstanceManager.getDefault(CarRoads.class).getComboBox();
    JComboBox<String> modelEngine1Box = InstanceManager.getDefault(EngineModels.class).getComboBox();
    JComboBox<String> numEngines1Box = new JComboBox();
    JComboBox<RouteLocation> routePickup2Box = new JComboBox();
    JComboBox<RouteLocation> routeDrop2Box = new JComboBox();
    JComboBox<String> roadCaboose2Box = new JComboBox();
    JComboBox<String> roadEngine2Box = InstanceManager.getDefault(CarRoads.class).getComboBox();
    JComboBox<String> modelEngine2Box = InstanceManager.getDefault(EngineModels.class).getComboBox();
    JComboBox<String> numEngines2Box = new JComboBox();
    public static final String DISPOSE = "dispose";
    private static final Logger log = LoggerFactory.getLogger(TrainEditBuildOptionsFrame.class);

    public TrainEditBuildOptionsFrame() {
        super(Bundle.getMessage("MenuItemBuildOptions"));
    }

    public void initComponents(TrainEditFrame parent) {
        this.ownerPane = new JScrollPane(this.panelOwnerNames);
        this.ownerPane.setVerticalScrollBarPolicy(20);
        this.ownerPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("OwnersTrain")));
        this.builtPane = new JScrollPane(this.panelBuilt);
        this.builtPane.setVerticalScrollBarPolicy(20);
        this.builtPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BuiltDatesTrain")));
        this.trainReq1Pane = new JScrollPane(this.panelTrainReq1);
        this.trainReq1Pane.setVerticalScrollBarPolicy(20);
        this.trainReq1Pane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainRequires")));
        this.trainReq2Pane = new JScrollPane(this.panelTrainReq2);
        this.trainReq2Pane.setVerticalScrollBarPolicy(20);
        this.trainReq2Pane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainRequires")));
        parent.setChildFrame(this);
        this._train = parent._train;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainName, 0, 0);
        JPanel pDesc = new JPanel();
        pDesc.setLayout(new GridBagLayout());
        pDesc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.addItem(pDesc, this.trainDescription, 0, 0);
        p1.add(pName);
        p1.add(pDesc);
        JPanel pOption = new JPanel();
        pOption.setLayout(new GridBagLayout());
        pOption.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Options")));
        this.addItemLeft(pOption, this.buildNormalCheckBox, 0, 0);
        this.addItemLeft(pOption, this.sendToTerminalCheckBox, 1, 0);
        this.addItemLeft(pOption, this.returnStagingCheckBox, 0, 1);
        this.addItemLeft(pOption, this.allowLocalMovesCheckBox, 1, 1);
        this.addItemLeft(pOption, this.allowThroughCarsCheckBox, 0, 2);
        this.addItemLeft(pOption, this.serviceAllCarsCheckBox, 1, 2);
        this.addItemLeft(pOption, this.sendCustomStagngCheckBox, 0, 3);
        this.addItemLeft(pOption, this.buildConsistCheckBox, 1, 3);
        pOption.setMaximumSize(new Dimension(2000, 250));
        this.buildNormalCheckBox.setEnabled(Setup.isBuildAggressive());
        this.returnStagingCheckBox.setEnabled(false);
        this.panelOwnerNames.setLayout(new GridBagLayout());
        this.ownerGroup.add(this.ownerNameAll);
        this.ownerGroup.add(this.ownerNameInclude);
        this.ownerGroup.add(this.ownerNameExclude);
        this.panelBuilt.setLayout(new GridBagLayout());
        this.builtAfterTextField.setToolTipText(Bundle.getMessage("EnterYearTip"));
        this.builtBeforeTextField.setToolTipText(Bundle.getMessage("EnterYearTip"));
        this.addItem(this.panelBuilt, this.builtDateAll, 0, 0);
        this.addItem(this.panelBuilt, this.builtDateAfter, 1, 0);
        this.addItem(this.panelBuilt, this.builtDateBefore, 2, 0);
        this.addItem(this.panelBuilt, this.builtDateRange, 3, 0);
        this.addItem(this.panelBuilt, this.after, 1, 1);
        this.addItem(this.panelBuilt, this.builtAfterTextField, 2, 1);
        this.addItem(this.panelBuilt, this.before, 1, 2);
        this.addItem(this.panelBuilt, this.builtBeforeTextField, 2, 2);
        this.builtGroup.add(this.builtDateAll);
        this.builtGroup.add(this.builtDateAfter);
        this.builtGroup.add(this.builtDateBefore);
        this.builtGroup.add(this.builtDateRange);
        this.panelTrainReq1.setLayout(new BoxLayout(this.panelTrainReq1, 1));
        JPanel trainOption1 = new JPanel();
        trainOption1.setLayout(new GridBagLayout());
        this.addItem(trainOption1, this.none1, 0, 0);
        this.addItem(trainOption1, this.change1Engine, 1, 0);
        this.addItem(trainOption1, this.add1Engine, 2, 0);
        this.addItem(trainOption1, this.remove1Engine, 3, 0);
        this.addItem(trainOption1, this.modify1Caboose, 1, 1);
        this.addItem(trainOption1, this.helper1Service, 2, 1);
        this.panelTrainReq1.add(trainOption1);
        this.trainReq1Group.add(this.none1);
        this.trainReq1Group.add(this.change1Engine);
        this.trainReq1Group.add(this.add1Engine);
        this.trainReq1Group.add(this.remove1Engine);
        this.trainReq1Group.add(this.modify1Caboose);
        this.trainReq1Group.add(this.helper1Service);
        this.engine1Option.setLayout(new GridBagLayout());
        for (int i = 0; i < Setup.getMaxNumberEngines() + 1; ++i) {
            this.numEngines1Box.addItem(Integer.toString(i));
        }
        this.numEngines1Box.addItem(Train.AUTO_HPT);
        this.numEngines1Box.setMinimumSize(new Dimension(50, 20));
        this.modelEngine1Box.insertItemAt("", 0);
        this.modelEngine1Box.setSelectedIndex(0);
        this.modelEngine1Box.setMinimumSize(new Dimension(120, 20));
        this.modelEngine1Box.setToolTipText(Bundle.getMessage("ModelEngineTip"));
        this.roadEngine1Box.insertItemAt("", 0);
        this.roadEngine1Box.setSelectedIndex(0);
        this.roadEngine1Box.setMinimumSize(new Dimension(120, 20));
        this.roadEngine1Box.setToolTipText(Bundle.getMessage("RoadEngineTip"));
        this.panelTrainReq1.add(this.engine1Option);
        this.engine1caboose.setLayout(new GridBagLayout());
        this.engine1caboose.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ChangeCaboose")));
        this.roadCaboose1Box.setMinimumSize(new Dimension(120, 20));
        this.roadCaboose1Box.setToolTipText(Bundle.getMessage("RoadCabooseTip"));
        this.panelTrainReq1.add(this.engine1caboose);
        this.cabooseOption1Group.add(this.remove1Caboose);
        this.cabooseOption1Group.add(this.keep1Caboose);
        this.cabooseOption1Group.add(this.change1Caboose);
        this.addItem(this.engine1DropOption, new JLabel(Bundle.getMessage("DropEnginesAt")), 0, 0);
        this.addItem(this.engine1DropOption, this.routeDrop1Box, 1, 0);
        this.panelTrainReq1.add(this.engine1DropOption);
        this.panelTrainReq2.setLayout(new BoxLayout(this.panelTrainReq2, 1));
        JPanel trainOption2 = new JPanel();
        trainOption2.setLayout(new GridBagLayout());
        this.addItem(trainOption2, this.none2, 0, 0);
        this.addItem(trainOption2, this.change2Engine, 1, 0);
        this.addItem(trainOption2, this.add2Engine, 2, 0);
        this.addItem(trainOption2, this.remove2Engine, 3, 0);
        this.addItem(trainOption2, this.modify2Caboose, 1, 1);
        this.addItem(trainOption2, this.helper2Service, 2, 1);
        this.panelTrainReq2.add(trainOption2);
        this.trainReq2Group.add(this.none2);
        this.trainReq2Group.add(this.change2Engine);
        this.trainReq2Group.add(this.add2Engine);
        this.trainReq2Group.add(this.remove2Engine);
        this.trainReq2Group.add(this.modify2Caboose);
        this.trainReq2Group.add(this.helper2Service);
        this.engine2Option.setLayout(new GridBagLayout());
        for (int i = 0; i < Setup.getMaxNumberEngines() + 1; ++i) {
            this.numEngines2Box.addItem(Integer.toString(i));
        }
        this.numEngines2Box.addItem(Train.AUTO_HPT);
        this.numEngines2Box.setMinimumSize(new Dimension(50, 20));
        this.modelEngine2Box.insertItemAt("", 0);
        this.modelEngine2Box.setSelectedIndex(0);
        this.modelEngine2Box.setMinimumSize(new Dimension(120, 20));
        this.modelEngine2Box.setToolTipText(Bundle.getMessage("ModelEngineTip"));
        this.roadEngine2Box.insertItemAt("", 0);
        this.roadEngine2Box.setSelectedIndex(0);
        this.roadEngine2Box.setMinimumSize(new Dimension(120, 20));
        this.roadEngine2Box.setToolTipText(Bundle.getMessage("RoadEngineTip"));
        this.panelTrainReq2.add(this.engine2Option);
        this.engine2caboose.setLayout(new GridBagLayout());
        this.engine2caboose.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ChangeCaboose")));
        this.roadCaboose2Box.setMinimumSize(new Dimension(120, 20));
        this.roadCaboose2Box.setToolTipText(Bundle.getMessage("RoadCabooseTip"));
        this.panelTrainReq2.add(this.engine2caboose);
        this.cabooseOption2Group.add(this.remove2Caboose);
        this.cabooseOption2Group.add(this.keep2Caboose);
        this.cabooseOption2Group.add(this.change2Caboose);
        this.addItem(this.engine2DropOption, new JLabel(Bundle.getMessage("DropEnginesAt")), 0, 0);
        this.addItem(this.engine2DropOption, this.routeDrop2Box, 1, 0);
        this.panelTrainReq2.add(this.engine2DropOption);
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.saveTrainButton, 3, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(pOption);
        this.getContentPane().add(this.ownerPane);
        this.getContentPane().add(this.builtPane);
        this.getContentPane().add(this.trainReq1Pane);
        this.getContentPane().add(this.trainReq2Pane);
        this.getContentPane().add(pB);
        this.addButtonAction(this.deleteOwnerButton);
        this.addButtonAction(this.addOwnerButton);
        this.addButtonAction(this.saveTrainButton);
        this.addRadioButtonAction(this.ownerNameAll);
        this.addRadioButtonAction(this.ownerNameInclude);
        this.addRadioButtonAction(this.ownerNameExclude);
        this.addRadioButtonAction(this.builtDateAll);
        this.addRadioButtonAction(this.builtDateAfter);
        this.addRadioButtonAction(this.builtDateBefore);
        this.addRadioButtonAction(this.builtDateRange);
        this.addRadioButtonAction(this.none1);
        this.addRadioButtonAction(this.change1Engine);
        this.addRadioButtonAction(this.add1Engine);
        this.addRadioButtonAction(this.remove1Engine);
        this.addRadioButtonAction(this.modify1Caboose);
        this.addRadioButtonAction(this.helper1Service);
        this.addRadioButtonAction(this.remove1Caboose);
        this.addRadioButtonAction(this.keep1Caboose);
        this.addRadioButtonAction(this.change1Caboose);
        this.addRadioButtonAction(this.none2);
        this.addRadioButtonAction(this.change2Engine);
        this.addRadioButtonAction(this.add2Engine);
        this.addRadioButtonAction(this.remove2Engine);
        this.addRadioButtonAction(this.modify2Caboose);
        this.addRadioButtonAction(this.helper2Service);
        this.addRadioButtonAction(this.remove2Caboose);
        this.addRadioButtonAction(this.keep2Caboose);
        this.addRadioButtonAction(this.change2Caboose);
        this.addComboBoxAction(this.numEngines1Box);
        this.addComboBoxAction(this.modelEngine1Box);
        this.addComboBoxAction(this.numEngines2Box);
        this.addComboBoxAction(this.modelEngine2Box);
        if (this._train != null) {
            this.trainName.setText(this._train.getName());
            this.trainDescription.setText(this._train.getDescription());
            this.buildNormalCheckBox.setSelected(this._train.isBuildTrainNormalEnabled());
            this.sendToTerminalCheckBox.setSelected(this._train.isSendCarsToTerminalEnabled());
            this.allowLocalMovesCheckBox.setSelected(this._train.isAllowLocalMovesEnabled());
            this.allowThroughCarsCheckBox.setSelected(this._train.isAllowThroughCarsEnabled());
            this.serviceAllCarsCheckBox.setSelected(this._train.isServiceAllCarsWithFinalDestinationsEnabled());
            this.sendCustomStagngCheckBox.setSelected(this._train.isSendCarsWithCustomLoadsToStagingEnabled());
            this.buildConsistCheckBox.setSelected(this._train.isBuildConsistEnabled());
            this.sendToTerminalCheckBox.setText(Bundle.getMessage("SendToTerminal", this._train.getTrainTerminatesName()));
            this.builtAfterTextField.setText(this._train.getBuiltStartYear());
            this.builtBeforeTextField.setText(this._train.getBuiltEndYear());
            this.setBuiltRadioButton();
            this.enableButtons(true);
            this.updateReturnToStagingCheckbox();
            this.updateRemoveEnginesRadioButtons();
            this._train.addPropertyChangeListener(this);
        } else {
            this.enableButtons(false);
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainBuildOptions", true);
        this.updateOwnerNames();
        this.updateBuilt();
        this.updateTrainRequires1Option();
        this.updateTrainRequires2Option();
        InstanceManager.getDefault(CarOwners.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineModels.class).addPropertyChangeListener(this);
        Setup.getDefault().addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(700, 600));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._train != null) {
            if (ae.getSource() == this.saveTrainButton) {
                log.debug("train save button activated");
                this.saveTrain();
            }
            if (ae.getSource() == this.addOwnerButton) {
                if (this._train.addOwnerName((String)this.ownerBox.getSelectedItem())) {
                    this.updateOwnerNames();
                }
                this.selectNextItemComboBox(this.ownerBox);
            }
            if (ae.getSource() == this.deleteOwnerButton) {
                if (this._train.deleteOwnerName((String)this.ownerBox.getSelectedItem())) {
                    this.updateOwnerNames();
                }
                this.selectNextItemComboBox(this.ownerBox);
            }
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (this._train != null) {
            if (ae.getSource() == this.ownerNameAll) {
                this._train.setOwnerOption(Train.ALL_OWNERS);
                this.updateOwnerNames();
            }
            if (ae.getSource() == this.ownerNameInclude) {
                this._train.setOwnerOption(Train.INCLUDE_OWNERS);
                this.updateOwnerNames();
            }
            if (ae.getSource() == this.ownerNameExclude) {
                this._train.setOwnerOption(Train.EXCLUDE_OWNERS);
                this.updateOwnerNames();
            }
            if (ae.getSource() == this.builtDateAll || ae.getSource() == this.builtDateAfter || ae.getSource() == this.builtDateBefore || ae.getSource() == this.builtDateRange) {
                this.updateBuilt();
            }
            if (ae.getSource() == this.none1) {
                this._train.setSecondLegOptions(0);
                this.updateTrainRequires1Option();
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.change1Engine) {
                this._train.setSecondLegOptions(1);
                this.updateTrainRequires1Option();
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.add1Engine) {
                this._train.setSecondLegOptions(16);
                this.updateTrainRequires1Option();
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.remove1Engine) {
                this._train.setSecondLegOptions(32);
                this.updateTrainRequires1Option();
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.modify1Caboose) {
                this._train.setSecondLegOptions(4);
                this.updateTrainRequires1Option();
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.helper1Service) {
                this._train.setSecondLegOptions(2);
                this.updateTrainRequires1Option();
            }
            if (ae.getSource() == this.keep1Caboose || ae.getSource() == this.change1Caboose || ae.getSource() == this.remove1Caboose) {
                this.roadCaboose1Box.setEnabled(this.change1Caboose.isSelected());
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.none2) {
                this._train.setThirdLegOptions(0);
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.change2Engine) {
                this._train.setThirdLegOptions(1);
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.add2Engine) {
                this._train.setThirdLegOptions(16);
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.remove2Engine) {
                this._train.setThirdLegOptions(32);
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.modify2Caboose) {
                this._train.setThirdLegOptions(4);
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.helper2Service) {
                this._train.setThirdLegOptions(2);
                this.updateTrainRequires2Option();
            }
            if (ae.getSource() == this.keep2Caboose || ae.getSource() == this.change2Caboose || ae.getSource() == this.remove2Caboose) {
                this.roadCaboose2Box.setEnabled(this.change2Caboose.isSelected());
            }
        }
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.numEngines1Box) {
            this.modelEngine1Box.setEnabled(!this.numEngines1Box.getSelectedItem().equals("0"));
            this.roadEngine1Box.setEnabled(!this.numEngines1Box.getSelectedItem().equals("0"));
        }
        if (ae.getSource() == this.modelEngine1Box) {
            this.updateEngineRoadComboBox(this.roadEngine1Box, (String)this.modelEngine1Box.getSelectedItem());
            if (this._train != null) {
                this.roadEngine1Box.setSelectedItem(this._train.getSecondLegEngineRoad());
            }
        }
        if (ae.getSource() == this.numEngines2Box) {
            this.modelEngine2Box.setEnabled(!this.numEngines2Box.getSelectedItem().equals("0"));
            this.roadEngine2Box.setEnabled(!this.numEngines2Box.getSelectedItem().equals("0"));
        }
        if (ae.getSource() == this.modelEngine2Box) {
            this.updateEngineRoadComboBox(this.roadEngine2Box, (String)this.modelEngine2Box.getSelectedItem());
            if (this._train != null) {
                this.roadEngine2Box.setSelectedItem(this._train.getThirdLegEngineRoad());
            }
        }
    }

    private void updateOwnerNames() {
        this.panelOwnerNames.removeAll();
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.add((Component)this.ownerNameAll, 0);
        p.add((Component)this.ownerNameInclude, 1);
        p.add((Component)this.ownerNameExclude, 2);
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridwidth = 6;
        this.panelOwnerNames.add((Component)p, gc);
        int y = 1;
        if (this._train != null) {
            this.ownerNameAll.setSelected(this._train.getOwnerOption().equals(Train.ALL_OWNERS));
            this.ownerNameInclude.setSelected(this._train.getOwnerOption().equals(Train.INCLUDE_OWNERS));
            this.ownerNameExclude.setSelected(this._train.getOwnerOption().equals(Train.EXCLUDE_OWNERS));
            if (!this.ownerNameAll.isSelected()) {
                p = new JPanel();
                p.setLayout(new FlowLayout());
                p.add(this.ownerBox);
                p.add(this.addOwnerButton);
                p.add(this.deleteOwnerButton);
                gc.gridy = y++;
                this.panelOwnerNames.add((Component)p, gc);
                int x = 0;
                for (String ownerName : this._train.getOwnerNames()) {
                    JLabel owner = new JLabel();
                    owner.setText(ownerName);
                    this.addItem(this.panelOwnerNames, owner, x++, y);
                    if (x <= 6) continue;
                    ++y;
                    x = 0;
                }
            }
        } else {
            this.ownerNameAll.setSelected(true);
        }
        this.panelOwnerNames.revalidate();
        this.panelOwnerNames.repaint();
        this.revalidate();
    }

    private void setBuiltRadioButton() {
        if (this._train.getBuiltStartYear().equals("") && this._train.getBuiltEndYear().equals("")) {
            this.builtDateAll.setSelected(true);
        } else if (!this._train.getBuiltStartYear().equals("") && !this._train.getBuiltEndYear().equals("")) {
            this.builtDateRange.setSelected(true);
        } else if (!this._train.getBuiltStartYear().equals("")) {
            this.builtDateAfter.setSelected(true);
        } else if (!this._train.getBuiltEndYear().equals("")) {
            this.builtDateBefore.setSelected(true);
        }
    }

    private void updateBuilt() {
        this.builtAfterTextField.setVisible(false);
        this.builtBeforeTextField.setVisible(false);
        this.after.setVisible(false);
        this.before.setVisible(false);
        if (this.builtDateAll.isSelected()) {
            this.builtAfterTextField.setText("");
            this.builtBeforeTextField.setText("");
        } else if (this.builtDateAfter.isSelected()) {
            this.builtBeforeTextField.setText("");
            this.builtAfterTextField.setVisible(true);
            this.after.setVisible(true);
        } else if (this.builtDateBefore.isSelected()) {
            this.builtAfterTextField.setText("");
            this.builtBeforeTextField.setVisible(true);
            this.before.setVisible(true);
        } else if (this.builtDateRange.isSelected()) {
            this.after.setVisible(true);
            this.before.setVisible(true);
            this.builtAfterTextField.setVisible(true);
            this.builtBeforeTextField.setVisible(true);
        }
        this.revalidate();
    }

    private void updateTrainRequires1Option() {
        this.none1.setSelected(true);
        if (this._train != null) {
            this.updateCabooseRoadComboBox(this.roadCaboose1Box);
            this.updateEngineRoadComboBox(this.roadEngine1Box, (String)this.modelEngine1Box.getSelectedItem());
            if (this._train.getRoute() != null) {
                this._train.getRoute().updateComboBox(this.routePickup1Box);
                this._train.getRoute().updateComboBox(this.routeDrop1Box);
            }
            this.change1Engine.setSelected((this._train.getSecondLegOptions() & 1) == 1);
            this.add1Engine.setSelected((this._train.getSecondLegOptions() & 0x10) == 16);
            this.remove1Engine.setSelected((this._train.getSecondLegOptions() & 0x20) == 32);
            this.helper1Service.setSelected((this._train.getSecondLegOptions() & 2) == 2);
            if (!(this.change1Engine.isSelected() || this.add1Engine.isSelected() || this.remove1Engine.isSelected() || this.helper1Service.isSelected())) {
                this.modify1Caboose.setSelected((this._train.getSecondLegOptions() & 4) == 4 || (this._train.getSecondLegOptions() & 8) == 8);
            }
            this.numEngines1Box.setSelectedItem(this._train.getSecondLegNumberEngines());
            this.modelEngine1Box.setSelectedItem(this._train.getSecondLegEngineModel());
            this.routePickup1Box.setSelectedItem(this._train.getSecondLegStartRouteLocation());
            this.routeDrop1Box.setSelectedItem(this._train.getSecondLegEndRouteLocation());
            this.roadEngine1Box.setSelectedItem(this._train.getSecondLegEngineRoad());
            this.keep1Caboose.setSelected(true);
            this.remove1Caboose.setSelected((this._train.getSecondLegOptions() & 8) == 8);
            this.change1Caboose.setSelected((this._train.getSecondLegOptions() & 4) == 4);
            this.roadCaboose1Box.setEnabled(this.change1Caboose.isSelected());
            this.roadCaboose1Box.setSelectedItem(this._train.getSecondLegCabooseRoad());
            if (this._train.isCabooseNeeded()) {
                this.change1Caboose.setText(Bundle.getMessage("ChangeCaboose"));
                this.remove1Caboose.setEnabled(true);
            } else {
                this.change1Caboose.setText(Bundle.getMessage("AddCaboose"));
                this.remove1Caboose.setEnabled(false);
            }
        }
        this.engine1Option.setVisible(this.change1Engine.isSelected() || this.add1Engine.isSelected() || this.remove1Engine.isSelected() || this.helper1Service.isSelected());
        this.engine1caboose.setVisible(this.change1Engine.isSelected() || this.add1Engine.isSelected() || this.remove1Engine.isSelected() || this.modify1Caboose.isSelected());
        this.engine1DropOption.setVisible(this.helper1Service.isSelected());
        if (this.change1Engine.isSelected()) {
            this.engine1Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("EngineChange")));
        } else if (this.add1Engine.isSelected()) {
            this.engine1Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AddEngines")));
        } else {
            this.engine1Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RemoveEngines")));
        }
        if (this.helper1Service.isSelected()) {
            this.engine1Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AddHelpers")));
        }
        if (this.change1Engine.isSelected() || this.add1Engine.isSelected() || this.remove1Engine.isSelected() || this.helper1Service.isSelected()) {
            this.createEngine1Panel();
        }
        if (this.change1Engine.isSelected() || this.add1Engine.isSelected() || this.remove1Engine.isSelected() || this.modify1Caboose.isSelected()) {
            this.createCaboose1Panel(this.modify1Caboose.isSelected());
        }
        this.revalidate();
    }

    private void updateTrainRequires2Option() {
        this.none2.setSelected(true);
        if (this._train != null) {
            this.updateCabooseRoadComboBox(this.roadCaboose2Box);
            this.updateEngineRoadComboBox(this.roadEngine2Box, (String)this.modelEngine2Box.getSelectedItem());
            if (this._train.getRoute() != null) {
                this._train.getRoute().updateComboBox(this.routePickup2Box);
                this._train.getRoute().updateComboBox(this.routeDrop2Box);
            }
            this.change2Engine.setSelected((this._train.getThirdLegOptions() & 1) == 1);
            this.add2Engine.setSelected((this._train.getThirdLegOptions() & 0x10) == 16);
            this.remove2Engine.setSelected((this._train.getThirdLegOptions() & 0x20) == 32);
            this.helper2Service.setSelected((this._train.getThirdLegOptions() & 2) == 2);
            if (!(this.change2Engine.isSelected() || this.add2Engine.isSelected() || this.remove2Engine.isSelected() || this.helper2Service.isSelected())) {
                this.modify2Caboose.setSelected((this._train.getThirdLegOptions() & 4) == 4 || (this._train.getThirdLegOptions() & 8) == 8);
            }
            this.numEngines2Box.setSelectedItem(this._train.getThirdLegNumberEngines());
            this.modelEngine2Box.setSelectedItem(this._train.getThirdLegEngineModel());
            this.routePickup2Box.setSelectedItem(this._train.getThirdLegStartRouteLocation());
            this.routeDrop2Box.setSelectedItem(this._train.getThirdLegEndRouteLocation());
            this.roadEngine2Box.setSelectedItem(this._train.getThirdLegEngineRoad());
            this.keep2Caboose.setSelected(true);
            this.remove2Caboose.setSelected((this._train.getThirdLegOptions() & 8) == 8);
            this.change2Caboose.setSelected((this._train.getThirdLegOptions() & 4) == 4);
            this.roadCaboose2Box.setEnabled(this.change2Caboose.isSelected());
            this.roadCaboose2Box.setSelectedItem(this._train.getThirdLegCabooseRoad());
            if ((this._train.isCabooseNeeded() || this.change1Caboose.isSelected()) && !this.remove1Caboose.isSelected()) {
                this.change2Caboose.setText(Bundle.getMessage("ChangeCaboose"));
                this.remove2Caboose.setEnabled(true);
            } else {
                this.change2Caboose.setText(Bundle.getMessage("AddCaboose"));
                this.remove2Caboose.setEnabled(false);
            }
        }
        this.engine2Option.setVisible(this.change2Engine.isSelected() || this.add2Engine.isSelected() || this.remove2Engine.isSelected() || this.helper2Service.isSelected());
        this.engine2caboose.setVisible(this.change2Engine.isSelected() || this.add2Engine.isSelected() || this.remove2Engine.isSelected() || this.modify2Caboose.isSelected());
        this.engine2DropOption.setVisible(this.helper2Service.isSelected());
        if (this.change2Engine.isSelected()) {
            this.engine2Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("EngineChange")));
        } else if (this.add2Engine.isSelected()) {
            this.engine2Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AddEngines")));
        } else {
            this.engine2Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RemoveEngines")));
        }
        if (this.helper2Service.isSelected()) {
            this.engine2Option.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AddHelpers")));
        }
        if (this.change2Engine.isSelected() || this.add2Engine.isSelected() || this.remove2Engine.isSelected() || this.helper2Service.isSelected()) {
            this.createEngine2Panel();
        }
        if (this.change2Engine.isSelected() || this.add2Engine.isSelected() || this.remove2Engine.isSelected() || this.modify2Caboose.isSelected()) {
            this.createCaboose2Panel(this.modify2Caboose.isSelected());
        }
        this.revalidate();
    }

    private void saveTrain() {
        if (!this.checkInput()) {
            return;
        }
        this._train.setBuildTrainNormalEnabled(this.buildNormalCheckBox.isSelected());
        this._train.setSendCarsToTerminalEnabled(this.sendToTerminalCheckBox.isSelected());
        if (this.returnStagingCheckBox.isEnabled()) {
            this._train.setAllowReturnToStagingEnabled(this.returnStagingCheckBox.isSelected());
        }
        this._train.setAllowLocalMovesEnabled(this.allowLocalMovesCheckBox.isSelected());
        this._train.setAllowThroughCarsEnabled(this.allowThroughCarsCheckBox.isSelected());
        this._train.setServiceAllCarsWithFinalDestinationsEnabled(this.serviceAllCarsCheckBox.isSelected());
        this._train.setSendCarsWithCustomLoadsToStagingEnabled(this.sendCustomStagngCheckBox.isSelected());
        this._train.setBuildConsistEnabled(this.buildConsistCheckBox.isSelected());
        this._train.setBuiltStartYear(this.builtAfterTextField.getText().trim());
        this._train.setBuiltEndYear(this.builtBeforeTextField.getText().trim());
        int options1 = 0;
        if (this.change1Engine.isSelected()) {
            options1 |= 1;
        }
        if (this.add1Engine.isSelected()) {
            options1 |= 0x10;
        }
        if (this.remove1Engine.isSelected()) {
            options1 |= 0x20;
        }
        if (this.remove1Caboose.isSelected()) {
            options1 |= 8;
        } else if (this.change1Caboose.isSelected()) {
            options1 = options1 | 4 | 8;
        }
        if (this.helper1Service.isSelected()) {
            options1 |= 2;
        }
        this._train.setSecondLegOptions(options1);
        if (this.routePickup1Box.getSelectedItem() != null) {
            this._train.setSecondLegStartRouteLocation((RouteLocation)this.routePickup1Box.getSelectedItem());
        } else {
            this._train.setSecondLegStartRouteLocation(null);
        }
        if (this.routeDrop1Box.getSelectedItem() != null) {
            this._train.setSecondLegEndRouteLocation((RouteLocation)this.routeDrop1Box.getSelectedItem());
        } else {
            this._train.setSecondLegEndRouteLocation(null);
        }
        this._train.setSecondLegNumberEngines((String)this.numEngines1Box.getSelectedItem());
        this._train.setSecondLegEngineModel((String)this.modelEngine1Box.getSelectedItem());
        this._train.setSecondLegEngineRoad((String)this.roadEngine1Box.getSelectedItem());
        this._train.setSecondLegCabooseRoad((String)this.roadCaboose1Box.getSelectedItem());
        int options2 = 0;
        if (this.change2Engine.isSelected()) {
            options2 |= 1;
        }
        if (this.add2Engine.isSelected()) {
            options2 |= 0x10;
        }
        if (this.remove2Engine.isSelected()) {
            options2 |= 0x20;
        }
        if (this.remove2Caboose.isSelected()) {
            options2 |= 8;
        } else if (this.change2Caboose.isSelected()) {
            options2 = options2 | 4 | 8;
        }
        if (this.helper2Service.isSelected()) {
            options2 |= 2;
        }
        this._train.setThirdLegOptions(options2);
        if (this.routePickup2Box.getSelectedItem() != null) {
            this._train.setThirdLegStartRouteLocation((RouteLocation)this.routePickup2Box.getSelectedItem());
        } else {
            this._train.setThirdLegStartRouteLocation(null);
        }
        if (this.routeDrop2Box.getSelectedItem() != null) {
            this._train.setThirdLegEndRouteLocation((RouteLocation)this.routeDrop2Box.getSelectedItem());
        } else {
            this._train.setThirdLegEndRouteLocation(null);
        }
        this._train.setThirdLegNumberEngines((String)this.numEngines2Box.getSelectedItem());
        this._train.setThirdLegEngineModel((String)this.modelEngine2Box.getSelectedItem());
        this._train.setThirdLegEngineRoad((String)this.roadEngine2Box.getSelectedItem());
        this._train.setThirdLegCabooseRoad((String)this.roadCaboose2Box.getSelectedItem());
        OperationsXml.save();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private boolean checkInput() {
        if (!this.none1.isSelected() && this.routePickup1Box.getSelectedItem() == null || !this.none2.isSelected() && this.routePickup2Box.getSelectedItem() == null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocationEngChange"), Bundle.getMessage("CanNotSave"), 0);
            return false;
        }
        if (this.helper1Service.isSelected() && this.routeDrop1Box.getSelectedItem() == null || this.helper2Service.isSelected() && this.routeDrop2Box.getSelectedItem() == null) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectLocationEndHelper"), Bundle.getMessage("CanNotSave"), 0);
            return false;
        }
        try {
            if (!this.builtAfterTextField.getText().trim().isEmpty()) {
                Integer.parseInt(this.builtAfterTextField.getText().trim());
            }
            if (!this.builtBeforeTextField.getText().trim().isEmpty()) {
                Integer.parseInt(this.builtBeforeTextField.getText().trim());
            }
        }
        catch (NumberFormatException e) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("EnterFourDigitYear"), Bundle.getMessage("CanNotSave"), 0);
            return false;
        }
        if (this.change1Engine.isSelected() && !this.checkModel(this.modelEngine1Box, this.numEngines1Box, this.roadEngine1Box) || this.change2Engine.isSelected() && !this.checkModel(this.modelEngine2Box, this.numEngines2Box, this.roadEngine2Box)) {
            return false;
        }
        if (this.add1Engine.isSelected() && !this.checkModel(this.modelEngine1Box, this.numEngines1Box, this.roadEngine1Box) || this.add2Engine.isSelected() && !this.checkModel(this.modelEngine2Box, this.numEngines2Box, this.roadEngine2Box)) {
            return false;
        }
        if (this.remove1Engine.isSelected() && !this.checkModel(this.modelEngine1Box, this.numEngines1Box, this.roadEngine1Box) || this.remove2Engine.isSelected() && !this.checkModel(this.modelEngine2Box, this.numEngines2Box, this.roadEngine2Box)) {
            return false;
        }
        if (!this.checkCabooseRoad(this.roadCaboose1Box, this.change1Caboose)) {
            return false;
        }
        return this.checkCabooseRoad(this.roadCaboose2Box, this.change2Caboose);
    }

    private boolean checkModel(JComboBox<String> modelEngineBox, JComboBox<String> numEnginesBox, JComboBox<String> roadEngineBox) {
        String model = (String)modelEngineBox.getSelectedItem();
        if (numEnginesBox.getSelectedItem().equals("0") || model.equals("")) {
            return true;
        }
        String type = InstanceManager.getDefault(EngineModels.class).getModelType(model);
        if (!this._train.isTypeNameAccepted(type)) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrainModelService", model, type), Bundle.getMessage("CanNot", Bundle.getMessage("save")), 0);
            return false;
        }
        if (roadEngineBox.getItemCount() == 1) {
            log.debug("No locos available that match the model selected!");
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("NoLocosModel", model), Bundle.getMessage("TrainWillNotBuild", this._train.getName()), 2);
        }
        return true;
    }

    private boolean checkCabooseRoad(JComboBox<String> roadCabooseBox, JRadioButton cabooseRadioButton) {
        String road = (String)roadCabooseBox.getSelectedItem();
        if (!road.equals("") && cabooseRadioButton.isSelected() && !this._train.isCabooseRoadNameAccepted(road)) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrainNotCabooseRoad", this._train.getName(), road), Bundle.getMessage("TrainWillNotBuild", this._train.getName()), 2);
            return false;
        }
        return true;
    }

    private void enableButtons(boolean enabled) {
        this.ownerNameAll.setEnabled(enabled);
        this.ownerNameInclude.setEnabled(enabled);
        this.ownerNameExclude.setEnabled(enabled);
        this.builtDateAll.setEnabled(enabled);
        this.builtDateAfter.setEnabled(enabled);
        this.builtDateBefore.setEnabled(enabled);
        this.builtDateRange.setEnabled(enabled);
        this.none1.setEnabled(enabled);
        this.change1Engine.setEnabled(enabled);
        this.add1Engine.setEnabled(enabled);
        this.remove1Engine.setEnabled(enabled);
        this.modify1Caboose.setEnabled(enabled);
        this.helper1Service.setEnabled(enabled);
        this.none2.setEnabled(enabled);
        this.change2Engine.setEnabled(enabled);
        this.add2Engine.setEnabled(enabled);
        this.remove2Engine.setEnabled(enabled);
        this.modify2Caboose.setEnabled(enabled);
        this.helper2Service.setEnabled(enabled);
        this.saveTrainButton.setEnabled(enabled);
    }

    private void updateModelComboBoxes() {
        InstanceManager.getDefault(EngineModels.class).updateComboBox(this.modelEngine1Box);
        InstanceManager.getDefault(EngineModels.class).updateComboBox(this.modelEngine2Box);
        this.modelEngine1Box.insertItemAt("", 0);
        this.modelEngine2Box.insertItemAt("", 0);
        if (this._train != null) {
            this.modelEngine1Box.setSelectedItem(this._train.getSecondLegEngineModel());
            this.modelEngine2Box.setSelectedItem(this._train.getThirdLegEngineModel());
        }
    }

    private void updateOwnerComboBoxes() {
        InstanceManager.getDefault(CarOwners.class).updateComboBox(this.ownerBox);
    }

    private void updateCabooseRoadComboBox(JComboBox<String> box) {
        box.removeAllItems();
        box.addItem("");
        List<String> roads = InstanceManager.getDefault(CarManager.class).getCabooseRoadNames();
        for (String road : roads) {
            box.addItem(road);
        }
    }

    private void updateEngineRoadComboBox(JComboBox<String> box, String engineModel) {
        if (engineModel == null) {
            return;
        }
        InstanceManager.getDefault(EngineManager.class).updateEngineRoadComboBox(engineModel, box);
    }

    private void updateReturnToStagingCheckbox() {
        if (this._train != null && this._train.getTrainDepartsRouteLocation() != null && this._train.getTrainTerminatesRouteLocation() != null && this._train.getTrainTerminatesRouteLocation().getLocation() != null && this._train.getTrainTerminatesRouteLocation().getLocation().isStaging() && this._train.getTrainDepartsRouteLocation().getName().equals(this._train.getTrainTerminatesRouteLocation().getName())) {
            this.allowThroughCarsCheckBox.setEnabled(false);
            if (Setup.isStagingAllowReturnEnabled()) {
                this.returnStagingCheckBox.setEnabled(false);
                this.returnStagingCheckBox.setSelected(true);
                this.returnStagingCheckBox.setToolTipText(Bundle.getMessage("TipReturnToStaging"));
            } else {
                this.returnStagingCheckBox.setEnabled(true);
                this.returnStagingCheckBox.setSelected(this._train.isAllowReturnToStagingEnabled());
                this.returnStagingCheckBox.setToolTipText("");
            }
        }
    }

    private void updateRemoveEnginesRadioButtons() {
        if (this._train != null && this._train.getTrainDepartsRouteLocation() != null && this._train.getTrainDepartsRouteLocation().getLocation() != null && this._train.getTrainDepartsRouteLocation().getLocation().isStaging()) {
            this.remove1Engine.setEnabled(false);
            this.remove2Engine.setEnabled(false);
        }
    }

    private void createEngine1Panel() {
        this.engine1Option.removeAll();
        this.addItem(this.engine1Option, new JLabel(Bundle.getMessage("ChangeEnginesAt")), 0, 0);
        this.addItem(this.engine1Option, this.routePickup1Box, 1, 0);
        this.addItem(this.engine1Option, new JLabel(Bundle.getMessage("Engines")), 2, 0);
        this.addItem(this.engine1Option, this.numEngines1Box, 3, 0);
        this.addItem(this.engine1Option, new JLabel(Bundle.getMessage("Model")), 4, 0);
        this.addItem(this.engine1Option, this.modelEngine1Box, 5, 0);
        this.addItem(this.engine1Option, new JLabel(Bundle.getMessage("Road")), 6, 0);
        this.addItem(this.engine1Option, this.roadEngine1Box, 7, 0);
    }

    private void createEngine2Panel() {
        this.engine2Option.removeAll();
        this.addItem(this.engine2Option, new JLabel(Bundle.getMessage("ChangeEnginesAt")), 0, 0);
        this.addItem(this.engine2Option, this.routePickup2Box, 1, 0);
        this.addItem(this.engine2Option, new JLabel(Bundle.getMessage("Engines")), 2, 0);
        this.addItem(this.engine2Option, this.numEngines2Box, 3, 0);
        this.addItem(this.engine2Option, new JLabel(Bundle.getMessage("Model")), 4, 0);
        this.addItem(this.engine2Option, this.modelEngine2Box, 5, 0);
        this.addItem(this.engine2Option, new JLabel(Bundle.getMessage("Road")), 6, 0);
        this.addItem(this.engine2Option, this.roadEngine2Box, 7, 0);
    }

    private void createCaboose1Panel(boolean withCombox) {
        this.engine1caboose.removeAll();
        this.addItem(this.engine1caboose, this.remove1Caboose, 2, 6);
        this.addItem(this.engine1caboose, this.change1Caboose, 4, 6);
        this.addItem(this.engine1caboose, new JLabel(Bundle.getMessage("Road")), 5, 6);
        this.addItem(this.engine1caboose, this.roadCaboose1Box, 6, 6);
        if (withCombox) {
            this.addItem(this.engine1caboose, new JLabel(Bundle.getMessage("ChangeEnginesAt")), 0, 6);
            this.addItem(this.engine1caboose, this.routePickup1Box, 1, 6);
        } else {
            this.addItem(this.engine1caboose, this.keep1Caboose, 3, 6);
        }
    }

    private void createCaboose2Panel(boolean withCombox) {
        this.engine2caboose.removeAll();
        this.addItem(this.engine2caboose, this.remove2Caboose, 2, 6);
        this.addItem(this.engine2caboose, this.change2Caboose, 4, 6);
        this.addItem(this.engine2caboose, new JLabel(Bundle.getMessage("Road")), 5, 6);
        this.addItem(this.engine2caboose, this.roadCaboose2Box, 6, 6);
        if (withCombox) {
            this.addItem(this.engine2caboose, new JLabel(Bundle.getMessage("ChangeEnginesAt")), 0, 6);
            this.addItem(this.engine2caboose, this.routePickup2Box, 1, 6);
        } else {
            this.addItem(this.engine2caboose, this.keep2Caboose, 3, 6);
        }
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarOwners.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(EngineModels.class).removePropertyChangeListener(this);
        Setup.getDefault().removePropertyChangeListener(this);
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarOwners Length")) {
            this.updateOwnerComboBoxes();
            this.updateOwnerNames();
        }
        if (e.getPropertyName().equals("EngineModels") || e.getPropertyName().equals("TrainTypes")) {
            this.updateModelComboBoxes();
        }
        if (e.getPropertyName().equals("TrainRequirements")) {
            this.updateTrainRequires1Option();
            this.updateTrainRequires2Option();
        }
        if (e.getPropertyName().equals("allowCarsToReturnChange")) {
            this.updateReturnToStagingCheckbox();
        }
    }
}

