/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.gui;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.gui.Bundle;
import jmri.jmrit.operations.trains.gui.TrainEditFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainRoadOptionsFrame
extends OperationsFrame
implements PropertyChangeListener {
    Train _train = null;
    JPanel pCarRoadControls = new JPanel();
    JPanel panelCarRoads = new JPanel();
    JScrollPane paneCarRoads = new JScrollPane(this.panelCarRoads);
    JPanel pCabooseRoadControls = new JPanel();
    JPanel panelCabooseRoads = new JPanel();
    JScrollPane paneCabooseRoads = new JScrollPane(this.panelCabooseRoads);
    JPanel pLocoRoadControls = new JPanel();
    JPanel panelLocoRoads = new JPanel();
    JScrollPane paneLocoRoads = new JScrollPane(this.panelLocoRoads);
    JLabel trainName = new JLabel();
    JLabel trainDescription = new JLabel();
    JButton addCarRoadButton = new JButton(Bundle.getMessage("AddRoad"));
    JButton deleteCarRoadButton = new JButton(Bundle.getMessage("DeleteRoad"));
    JButton deleteCarAllRoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JButton addCabooseRoadButton = new JButton(Bundle.getMessage("AddRoad"));
    JButton deleteCabooseRoadButton = new JButton(Bundle.getMessage("DeleteRoad"));
    JButton deleteCabooseAllRoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JButton addLocoRoadButton = new JButton(Bundle.getMessage("AddRoad"));
    JButton deleteLocoRoadButton = new JButton(Bundle.getMessage("DeleteRoad"));
    JButton deleteLocoAllRoadsButton = new JButton(Bundle.getMessage("DeleteAll"));
    JButton saveTrainButton = new JButton(Bundle.getMessage("SaveTrain"));
    JRadioButton carRoadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton carRoadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton carRoadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JRadioButton cabooseRoadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton cabooseRoadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton cabooseRoadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JRadioButton locoRoadNameAll = new JRadioButton(Bundle.getMessage("AcceptAll"));
    JRadioButton locoRoadNameInclude = new JRadioButton(Bundle.getMessage("AcceptOnly"));
    JRadioButton locoRoadNameExclude = new JRadioButton(Bundle.getMessage("Exclude"));
    JComboBox<String> comboBoxCarRoads = InstanceManager.getDefault(CarRoads.class).getComboBox();
    JComboBox<String> comboBoxCabooseRoads = new JComboBox();
    JComboBox<String> comboBoxLocoRoads = new JComboBox();
    public static final String DISPOSE = "dispose";
    private static final int NUMBER_ROADS_PER_LINE = 6;
    private static final Logger log = LoggerFactory.getLogger(TrainRoadOptionsFrame.class);

    public TrainRoadOptionsFrame() {
        super(Bundle.getMessage("MenuItemRoadOptions"));
    }

    public void initComponents(TrainEditFrame parent) {
        parent.setChildFrame(this);
        this._train = parent._train;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        p1.setMaximumSize(new Dimension(2000, 250));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainName, 0, 0);
        JPanel pDesc = new JPanel();
        pDesc.setLayout(new GridBagLayout());
        pDesc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.addItem(pDesc, this.trainDescription, 0, 0);
        p1.add(pName);
        p1.add(pDesc);
        JPanel pCarRoad = new JPanel();
        pCarRoad.setLayout(new BoxLayout(pCarRoad, 1));
        JScrollPane paneCar = new JScrollPane(pCarRoad);
        paneCar.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CarRoadsTrain")));
        paneCar.setMaximumSize(new Dimension(2000, 400));
        JPanel pCarRoadRadioButtons = new JPanel();
        pCarRoadRadioButtons.setLayout(new FlowLayout());
        pCarRoadRadioButtons.add(this.carRoadNameAll);
        pCarRoadRadioButtons.add(this.carRoadNameInclude);
        pCarRoadRadioButtons.add(this.carRoadNameExclude);
        this.pCarRoadControls.setLayout(new FlowLayout());
        this.pCarRoadControls.add(this.comboBoxCarRoads);
        this.pCarRoadControls.add(this.addCarRoadButton);
        this.pCarRoadControls.add(this.deleteCarRoadButton);
        this.pCarRoadControls.add(this.deleteCarAllRoadsButton);
        this.pCarRoadControls.setVisible(false);
        pCarRoad.add(pCarRoadRadioButtons);
        pCarRoad.add(this.pCarRoadControls);
        this.panelCarRoads.setLayout(new GridBagLayout());
        this.paneCarRoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadsCar")));
        ButtonGroup carRoadGroup = new ButtonGroup();
        carRoadGroup.add(this.carRoadNameAll);
        carRoadGroup.add(this.carRoadNameInclude);
        carRoadGroup.add(this.carRoadNameExclude);
        JPanel pCabooseRoad = new JPanel();
        pCabooseRoad.setLayout(new BoxLayout(pCabooseRoad, 1));
        JScrollPane paneCaboose = new JScrollPane(pCabooseRoad);
        paneCaboose.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CabooseRoadsTrain")));
        paneCaboose.setMaximumSize(new Dimension(2000, 400));
        JPanel pCabooseRoadRadioButtons = new JPanel();
        pCabooseRoadRadioButtons.setLayout(new FlowLayout());
        pCabooseRoadRadioButtons.add(this.cabooseRoadNameAll);
        pCabooseRoadRadioButtons.add(this.cabooseRoadNameInclude);
        pCabooseRoadRadioButtons.add(this.cabooseRoadNameExclude);
        this.pCabooseRoadControls.setLayout(new FlowLayout());
        this.pCabooseRoadControls.add(this.comboBoxCabooseRoads);
        this.pCabooseRoadControls.add(this.addCabooseRoadButton);
        this.pCabooseRoadControls.add(this.deleteCabooseRoadButton);
        this.pCabooseRoadControls.add(this.deleteCabooseAllRoadsButton);
        this.pCabooseRoadControls.setVisible(false);
        pCabooseRoad.add(pCabooseRoadRadioButtons);
        pCabooseRoad.add(this.pCabooseRoadControls);
        this.panelCabooseRoads.setLayout(new GridBagLayout());
        this.paneCabooseRoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadsCaboose")));
        ButtonGroup cabooseRoadGroup = new ButtonGroup();
        cabooseRoadGroup.add(this.cabooseRoadNameAll);
        cabooseRoadGroup.add(this.cabooseRoadNameInclude);
        cabooseRoadGroup.add(this.cabooseRoadNameExclude);
        JPanel pLocoRoad = new JPanel();
        pLocoRoad.setLayout(new BoxLayout(pLocoRoad, 1));
        JScrollPane paneLoco = new JScrollPane(pLocoRoad);
        paneLoco.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("LocoRoadsTrain")));
        paneLoco.setMaximumSize(new Dimension(2000, 400));
        JPanel pLocoRoadRadioButtons = new JPanel();
        pLocoRoadRadioButtons.setLayout(new FlowLayout());
        pLocoRoadRadioButtons.add(this.locoRoadNameAll);
        pLocoRoadRadioButtons.add(this.locoRoadNameInclude);
        pLocoRoadRadioButtons.add(this.locoRoadNameExclude);
        this.pLocoRoadControls.setLayout(new FlowLayout());
        this.pLocoRoadControls.add(this.comboBoxLocoRoads);
        this.pLocoRoadControls.add(this.addLocoRoadButton);
        this.pLocoRoadControls.add(this.deleteLocoRoadButton);
        this.pLocoRoadControls.add(this.deleteLocoAllRoadsButton);
        this.pLocoRoadControls.setVisible(false);
        pLocoRoad.add(pLocoRoadRadioButtons);
        pLocoRoad.add(this.pLocoRoadControls);
        this.panelLocoRoads.setLayout(new GridBagLayout());
        this.paneLocoRoads.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("RoadsLoco")));
        ButtonGroup locoRoadGroup = new ButtonGroup();
        locoRoadGroup.add(this.locoRoadNameAll);
        locoRoadGroup.add(this.locoRoadNameInclude);
        locoRoadGroup.add(this.locoRoadNameExclude);
        JPanel panelButtons = new JPanel();
        panelButtons.setLayout(new GridBagLayout());
        panelButtons.setBorder(BorderFactory.createTitledBorder(""));
        panelButtons.setMaximumSize(new Dimension(2000, 200));
        this.addItem(panelButtons, this.saveTrainButton, 0, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(paneCar);
        this.getContentPane().add(this.paneCarRoads);
        this.getContentPane().add(paneCaboose);
        this.getContentPane().add(this.paneCabooseRoads);
        this.getContentPane().add(paneLoco);
        this.getContentPane().add(this.paneLocoRoads);
        this.getContentPane().add(panelButtons);
        this.addButtonAction(this.saveTrainButton);
        this.addButtonAction(this.deleteCarRoadButton);
        this.addButtonAction(this.deleteCarAllRoadsButton);
        this.addButtonAction(this.addCarRoadButton);
        this.addRadioButtonAction(this.carRoadNameAll);
        this.addRadioButtonAction(this.carRoadNameInclude);
        this.addRadioButtonAction(this.carRoadNameExclude);
        this.addButtonAction(this.deleteCabooseRoadButton);
        this.addButtonAction(this.deleteCabooseAllRoadsButton);
        this.addButtonAction(this.addCabooseRoadButton);
        this.addRadioButtonAction(this.cabooseRoadNameAll);
        this.addRadioButtonAction(this.cabooseRoadNameInclude);
        this.addRadioButtonAction(this.cabooseRoadNameExclude);
        this.addButtonAction(this.deleteLocoRoadButton);
        this.addButtonAction(this.deleteLocoAllRoadsButton);
        this.addButtonAction(this.addLocoRoadButton);
        this.addRadioButtonAction(this.locoRoadNameAll);
        this.addRadioButtonAction(this.locoRoadNameInclude);
        this.addRadioButtonAction(this.locoRoadNameExclude);
        if (this._train != null) {
            this.trainName.setText(this._train.getName());
            this.trainDescription.setText(this._train.getDescription());
            this.updateButtons(true);
            this._train.addPropertyChangeListener(this);
        } else {
            this.updateButtons(false);
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainRoadOptions", true);
        this.updateRoadComboBoxes();
        this.updateCarRoadNames();
        this.updateCabooseRoadNames();
        this.updateLocoRoadNames();
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(EngineManager.class).addPropertyChangeListener(this);
        InstanceManager.getDefault(CarManager.class).addPropertyChangeListener(this);
        this.initMinimumSize(new Dimension(500, 500));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._train != null) {
            String roadName;
            if (ae.getSource() == this.saveTrainButton) {
                log.debug("train save button activated");
                this.saveTrain();
            }
            if (ae.getSource() == this.addCarRoadButton) {
                roadName = (String)this.comboBoxCarRoads.getSelectedItem();
                if (this._train.addCarRoadName(roadName)) {
                    this.updateCarRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxCarRoads);
            }
            if (ae.getSource() == this.deleteCarRoadButton) {
                roadName = (String)this.comboBoxCarRoads.getSelectedItem();
                if (this._train.deleteCarRoadName(roadName)) {
                    this.updateCarRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxCarRoads);
            }
            if (ae.getSource() == this.deleteCarAllRoadsButton) {
                this.deleteAllCarRoads();
            }
            if (ae.getSource() == this.addCabooseRoadButton) {
                roadName = (String)this.comboBoxCabooseRoads.getSelectedItem();
                if (this._train.addCabooseRoadName(roadName)) {
                    this.updateCabooseRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxCabooseRoads);
            }
            if (ae.getSource() == this.deleteCabooseRoadButton) {
                roadName = (String)this.comboBoxCabooseRoads.getSelectedItem();
                if (this._train.deleteCabooseRoadName(roadName)) {
                    this.updateCabooseRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxCabooseRoads);
            }
            if (ae.getSource() == this.deleteCabooseAllRoadsButton) {
                this.deleteAllCabooseRoads();
            }
            if (ae.getSource() == this.addLocoRoadButton) {
                roadName = (String)this.comboBoxLocoRoads.getSelectedItem();
                if (this._train.addLocoRoadName(roadName)) {
                    this.updateLocoRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxLocoRoads);
            }
            if (ae.getSource() == this.deleteLocoRoadButton) {
                roadName = (String)this.comboBoxLocoRoads.getSelectedItem();
                if (this._train.deleteLocoRoadName(roadName)) {
                    this.updateLocoRoadNames();
                }
                this.selectNextItemComboBox(this.comboBoxLocoRoads);
            }
            if (ae.getSource() == this.deleteLocoAllRoadsButton) {
                this.deleteAllLocoRoads();
            }
        }
    }

    @Override
    public void radioButtonActionPerformed(ActionEvent ae) {
        log.debug("radio button activated");
        if (this._train != null) {
            if (ae.getSource() == this.carRoadNameAll) {
                this._train.setCarRoadOption(Train.ALL_LOADS);
                this.updateCarRoadNames();
            }
            if (ae.getSource() == this.carRoadNameInclude) {
                this._train.setCarRoadOption(Train.INCLUDE_LOADS);
                this.updateCarRoadNames();
            }
            if (ae.getSource() == this.carRoadNameExclude) {
                this._train.setCarRoadOption(Train.EXCLUDE_LOADS);
                this.updateCarRoadNames();
            }
            if (ae.getSource() == this.cabooseRoadNameAll) {
                this._train.setCabooseRoadOption(Train.ALL_LOADS);
                this.updateCabooseRoadNames();
            }
            if (ae.getSource() == this.cabooseRoadNameInclude) {
                this._train.setCabooseRoadOption(Train.INCLUDE_LOADS);
                this.updateCabooseRoadNames();
            }
            if (ae.getSource() == this.cabooseRoadNameExclude) {
                this._train.setCabooseRoadOption(Train.EXCLUDE_LOADS);
                this.updateCabooseRoadNames();
            }
            if (ae.getSource() == this.locoRoadNameAll) {
                this._train.setLocoRoadOption(Train.ALL_LOADS);
                this.updateLocoRoadNames();
            }
            if (ae.getSource() == this.locoRoadNameInclude) {
                this._train.setLocoRoadOption(Train.INCLUDE_LOADS);
                this.updateLocoRoadNames();
            }
            if (ae.getSource() == this.locoRoadNameExclude) {
                this._train.setLocoRoadOption(Train.EXCLUDE_LOADS);
                this.updateLocoRoadNames();
            }
        }
    }

    protected void updateButtons(boolean enabled) {
        this.saveTrainButton.setEnabled(enabled);
        this.carRoadNameAll.setEnabled(enabled);
        this.carRoadNameInclude.setEnabled(enabled);
        this.carRoadNameExclude.setEnabled(enabled);
        this.locoRoadNameAll.setEnabled(enabled);
        this.locoRoadNameInclude.setEnabled(enabled);
        this.locoRoadNameExclude.setEnabled(enabled);
    }

    private void updateCarRoadNames() {
        log.debug("Update car road names");
        this.panelCarRoads.removeAll();
        if (this._train != null) {
            this.carRoadNameAll.setSelected(this._train.getCarRoadOption().equals(Train.ALL_LOADS));
            this.carRoadNameInclude.setSelected(this._train.getCarRoadOption().equals(Train.INCLUDE_ROADS));
            this.carRoadNameExclude.setSelected(this._train.getCarRoadOption().equals(Train.EXCLUDE_ROADS));
            this.pCarRoadControls.setVisible(!this.carRoadNameAll.isSelected());
            if (!this.carRoadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                for (String roadName : this._train.getCarRoadNames()) {
                    JLabel road = new JLabel();
                    road.setText(roadName);
                    this.addItemTop(this.panelCarRoads, road, x++, y);
                    if (x <= 6) continue;
                    ++y;
                    x = 0;
                }
                this.revalidate();
            }
        } else {
            this.carRoadNameAll.setSelected(true);
        }
        this.panelCarRoads.repaint();
        this.panelCarRoads.revalidate();
    }

    private void updateCabooseRoadNames() {
        log.debug("Update caboose road names");
        this.panelCabooseRoads.removeAll();
        if (this._train != null) {
            this.cabooseRoadNameAll.setSelected(this._train.getCabooseRoadOption().equals(Train.ALL_LOADS));
            this.cabooseRoadNameInclude.setSelected(this._train.getCabooseRoadOption().equals(Train.INCLUDE_ROADS));
            this.cabooseRoadNameExclude.setSelected(this._train.getCabooseRoadOption().equals(Train.EXCLUDE_ROADS));
            this.pCabooseRoadControls.setVisible(!this.cabooseRoadNameAll.isSelected());
            if (!this.cabooseRoadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                for (String roadName : this._train.getCabooseRoadNames()) {
                    JLabel road = new JLabel();
                    road.setText(roadName);
                    this.addItemTop(this.panelCabooseRoads, road, x++, y);
                    if (x <= 6) continue;
                    ++y;
                    x = 0;
                }
                this.revalidate();
            }
        } else {
            this.cabooseRoadNameAll.setSelected(true);
        }
        this.panelCabooseRoads.repaint();
        this.panelCabooseRoads.revalidate();
    }

    private void updateLocoRoadNames() {
        log.debug("Update loco road names");
        this.panelLocoRoads.removeAll();
        if (this._train != null) {
            this.locoRoadNameAll.setSelected(this._train.getLocoRoadOption().equals(Train.ALL_LOADS));
            this.locoRoadNameInclude.setSelected(this._train.getLocoRoadOption().equals(Train.INCLUDE_ROADS));
            this.locoRoadNameExclude.setSelected(this._train.getLocoRoadOption().equals(Train.EXCLUDE_ROADS));
            this.pLocoRoadControls.setVisible(!this.locoRoadNameAll.isSelected());
            if (!this.locoRoadNameAll.isSelected()) {
                int x = 0;
                int y = 0;
                for (String roadName : this._train.getLocoRoadNames()) {
                    JLabel road = new JLabel();
                    road.setText(roadName);
                    this.addItemTop(this.panelLocoRoads, road, x++, y);
                    if (x <= 6) continue;
                    ++y;
                    x = 0;
                }
                this.revalidate();
            }
        } else {
            this.locoRoadNameAll.setSelected(true);
        }
        this.panelLocoRoads.repaint();
        this.panelLocoRoads.revalidate();
    }

    private void deleteAllCarRoads() {
        if (this._train != null) {
            for (String road : this._train.getCarRoadNames()) {
                this._train.deleteCarRoadName(road);
            }
        }
        this.updateCarRoadNames();
    }

    private void deleteAllCabooseRoads() {
        if (this._train != null) {
            for (String road : this._train.getCabooseRoadNames()) {
                this._train.deleteCabooseRoadName(road);
            }
        }
        this.updateCabooseRoadNames();
    }

    private void deleteAllLocoRoads() {
        if (this._train != null) {
            for (String road : this._train.getLocoRoadNames()) {
                this._train.deleteLocoRoadName(road);
            }
        }
        this.updateLocoRoadNames();
    }

    private void saveTrain() {
        OperationsXml.save();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateRoadComboBoxes() {
        InstanceManager.getDefault(CarRoads.class).updateComboBox(this.comboBoxCarRoads);
        this.updateCabooseRoadComboBox();
        InstanceManager.getDefault(EngineManager.class).updateEngineRoadComboBox("", this.comboBoxLocoRoads);
    }

    private void updateCabooseRoadComboBox() {
        this.comboBoxCabooseRoads.removeAllItems();
        List<String> roads = InstanceManager.getDefault(CarManager.class).getCabooseRoadNames();
        for (String road : roads) {
            this.comboBoxCabooseRoads.addItem(road);
        }
        OperationsPanel.padComboBox(this.comboBoxCabooseRoads);
    }

    @Override
    public void dispose() {
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        InstanceManager.getDefault(CarRoads.class).removePropertyChangeListener(this);
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("CarRoads Length") || e.getPropertyName().equals("RollingStockListLength")) {
            this.updateRoadComboBoxes();
            this.updateCarRoadNames();
            this.updateCabooseRoadNames();
            this.updateLocoRoadNames();
        }
    }
}

