/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.gui;

import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import jmri.InstanceManager;
import jmri.jmrit.beantable.EnablingCheckboxRenderer;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.gui.Bundle;
import jmri.jmrit.operations.trains.gui.TrainConductorFrame;
import jmri.jmrit.operations.trains.gui.TrainEditFrame;
import jmri.jmrit.operations.trains.gui.TrainsTableFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    volatile List<Train> sysList = this.trainManager.getTrainsByTimeList();
    JTable _table = null;
    TrainsTableFrame _frame = null;
    private static final int ID_COLUMN = 0;
    private static final int TIME_COLUMN = 1;
    private static final int BUILDBOX_COLUMN = 2;
    private static final int BUILD_COLUMN = 3;
    private static final int NAME_COLUMN = 4;
    private static final int DESCRIPTION_COLUMN = 5;
    private static final int BUILT_COLUMN = 6;
    private static final int CAR_ROAD_COLUMN = 7;
    private static final int CABOOSE_ROAD_COLUMN = 8;
    private static final int LOCO_ROAD_COLUMN = 9;
    private static final int LOAD_COLUMN = 10;
    private static final int OWNER_COLUMN = 11;
    private static final int ROUTE_COLUMN = 12;
    private static final int DEPARTS_COLUMN = 13;
    private static final int TERMINATES_COLUMN = 14;
    private static final int CURRENT_COLUMN = 15;
    private static final int CARS_COLUMN = 16;
    private static final int STATUS_COLUMN = 17;
    private static final int ACTION_COLUMN = 18;
    private static final int EDIT_COLUMN = 19;
    private static final int HIGHESTCOLUMN = 20;
    public final int SORTBYTIME = 2;
    public final int SORTBYID = 7;
    private int _sort = 2;
    private boolean _showAll = true;
    private final int[] _tableColumnWidths = new int[]{50, 50, 50, 72, 100, 140, 50, 50, 50, 50, 50, 50, 120, 120, 120, 120, 50, 120, 90, 70};
    public static final String IDCOLUMNNAME = Bundle.getMessage("Id");
    public static final String TIMECOLUMNNAME = Bundle.getMessage("Time");
    public static final String BUILDBOXCOLUMNNAME = Bundle.getMessage("Build");
    public static final String BUILDCOLUMNNAME = Bundle.getMessage("Function");
    public static final String NAMECOLUMNNAME = Bundle.getMessage("Name");
    public static final String DESCRIPTIONCOLUMNNAME = Bundle.getMessage("Description");
    public static final String ROUTECOLUMNNAME = Bundle.getMessage("Route");
    public static final String DEPARTSCOLUMNNAME = Bundle.getMessage("Departs");
    public static final String CURRENTCOLUMNNAME = Bundle.getMessage("Current");
    public static final String TERMINATESCOLUMNNAME = Bundle.getMessage("Terminates");
    public static final String STATUSCOLUMNNAME = Bundle.getMessage("Status");
    public static final String ACTIONCOLUMNNAME = Bundle.getMessage("Action");
    public static final String EDITCOLUMNNAME = Bundle.getMessage("ButtonEdit");
    TrainEditFrame tef = null;
    Thread build;
    private static Hashtable<String, TrainConductorFrame> _trainConductorHashTable = new Hashtable();
    private static final Logger log = LoggerFactory.getLogger(TrainsTableModel.class);

    public TrainsTableModel() {
        this.trainManager.addPropertyChangeListener(this);
        Setup.getDefault().addPropertyChangeListener(this);
        this.updateList();
    }

    public void setSort(int sort) {
        this._sort = sort;
        this.updateList();
        this.updateColumnVisible();
    }

    public void setShowAll(boolean showAll) {
        this._showAll = showAll;
        this.updateList();
        this.fireTableDataChanged();
    }

    public boolean isShowAll() {
        return this._showAll;
    }

    private void updateList() {
        this.removePropertyChangeTrains();
        List<Train> tempList = this._sort == 7 ? this.trainManager.getTrainsByIdList() : this.trainManager.getTrainsByTimeList();
        if (!this.isShowAll()) {
            for (int i = tempList.size() - 1; i >= 0; --i) {
                if (tempList.get(i).isBuildEnabled()) continue;
                tempList.remove(i);
            }
        }
        this.sysList = tempList;
        this.addPropertyChangeTrains();
    }

    private Train getTrainByRow(int row) {
        return this.sysList.get(row);
    }

    void initTable(JTable table, TrainsTableFrame frame) {
        this._table = table;
        this._frame = frame;
        table.setDefaultRenderer(Object.class, new MyTableCellRenderer());
        table.setDefaultRenderer(Integer.class, new MyTableCellRenderer());
        this.initTable();
    }

    void initTable() {
        XTableColumnModel tcm = new XTableColumnModel();
        this._table.setColumnModel(tcm);
        this._table.createDefaultColumnsFromModel();
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        ButtonRenderer buttonRenderer2 = new ButtonRenderer();
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        tcm.getColumn(19).setCellRenderer(buttonRenderer);
        tcm.getColumn(19).setCellEditor(buttonEditor);
        tcm.getColumn(18).setCellRenderer(buttonRenderer);
        tcm.getColumn(18).setCellEditor(buttonEditor);
        tcm.getColumn(3).setCellRenderer(buttonRenderer2);
        tcm.getColumn(3).setCellEditor(buttonEditor);
        this._table.setDefaultRenderer(Boolean.class, new EnablingCheckboxRenderer());
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            tcm.getColumn(i).setPreferredWidth(this._tableColumnWidths[i]);
        }
        this._frame.loadTableDetails(this._table);
        this.updateColumnVisible();
    }

    private void updateColumnVisible() {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        tcm.setColumnVisible(tcm.getColumnByModelIndex(0), this._sort == 7);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(1), this._sort == 2);
        tcm.setColumnVisible(tcm.getColumnByModelIndex(6), this.trainManager.isBuiltRestricted());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(7), this.trainManager.isCarRoadRestricted());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(8), this.trainManager.isCabooseRoadRestricted());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(9), this.trainManager.isLocoRoadRestricted());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(10), this.trainManager.isLoadRestricted());
        tcm.setColumnVisible(tcm.getColumnByModelIndex(11), this.trainManager.isOwnerRestricted());
    }

    @Override
    public int getRowCount() {
        return this.sysList.size();
    }

    @Override
    public int getColumnCount() {
        return 20;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return IDCOLUMNNAME;
            }
            case 1: {
                return TIMECOLUMNNAME;
            }
            case 2: {
                return BUILDBOXCOLUMNNAME;
            }
            case 3: {
                return BUILDCOLUMNNAME;
            }
            case 4: {
                return NAMECOLUMNNAME;
            }
            case 5: {
                return DESCRIPTIONCOLUMNNAME;
            }
            case 6: {
                return Bundle.getMessage("Built");
            }
            case 7: {
                return Bundle.getMessage("RoadsCar");
            }
            case 8: {
                return Bundle.getMessage("RoadsCaboose");
            }
            case 9: {
                return Bundle.getMessage("RoadsLoco");
            }
            case 10: {
                return Bundle.getMessage("Load");
            }
            case 11: {
                return Bundle.getMessage("Owner");
            }
            case 12: {
                return ROUTECOLUMNNAME;
            }
            case 13: {
                return DEPARTSCOLUMNNAME;
            }
            case 15: {
                return CURRENTCOLUMNNAME;
            }
            case 14: {
                return TERMINATESCOLUMNNAME;
            }
            case 16: {
                return Bundle.getMessage("Cars");
            }
            case 17: {
                return STATUSCOLUMNNAME;
            }
            case 18: {
                return ACTIONCOLUMNNAME;
            }
            case 19: {
                return EDITCOLUMNNAME;
            }
        }
        return "unknown";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 2: {
                return Boolean.class;
            }
            case 0: 
            case 16: {
                return Integer.class;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: {
                return String.class;
            }
            case 3: 
            case 18: 
            case 19: {
                return JButton.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.getRowCount()) {
            return "ERROR row " + row;
        }
        Train train = this.getTrainByRow(row);
        if (train == null) {
            return "ERROR train unknown " + row;
        }
        switch (col) {
            case 0: {
                return Integer.parseInt(train.getId());
            }
            case 1: {
                return train.getDepartureTime();
            }
            case 4: {
                return train.getIconName();
            }
            case 5: {
                return train.getDescription();
            }
            case 2: {
                return train.isBuildEnabled();
            }
            case 6: {
                return this.getBuiltString(train);
            }
            case 7: {
                return this.getModifiedString(train.getCarRoadNames().length, train.getCarRoadOption().equals(Train.ALL_ROADS), train.getCarRoadOption().equals(Train.INCLUDE_ROADS));
            }
            case 8: {
                return this.getModifiedString(train.getCabooseRoadNames().length, train.getCabooseRoadOption().equals(Train.ALL_ROADS), train.getCabooseRoadOption().equals(Train.INCLUDE_ROADS));
            }
            case 9: {
                return this.getModifiedString(train.getLocoRoadNames().length, train.getLocoRoadOption().equals(Train.ALL_ROADS), train.getLocoRoadOption().equals(Train.INCLUDE_ROADS));
            }
            case 10: {
                return this.getModifiedString(train.getLoadNames().length, train.getLoadOption().equals(Train.ALL_LOADS), train.getLoadOption().equals(Train.INCLUDE_LOADS));
            }
            case 11: {
                return this.getModifiedString(train.getOwnerNames().length, train.getOwnerOption().equals(Train.ALL_OWNERS), train.getOwnerOption().equals(Train.INCLUDE_OWNERS));
            }
            case 12: {
                return train.getTrainRouteName();
            }
            case 13: {
                if (train.getDepartureTrack() == null) {
                    return train.getTrainDepartsName();
                }
                return train.getTrainDepartsName() + " (" + train.getDepartureTrack().getName() + ")";
            }
            case 15: {
                return train.getCurrentLocationName();
            }
            case 14: {
                if (train.getTerminationTrack() == null) {
                    return train.getTrainTerminatesName();
                }
                return train.getTrainTerminatesName() + " (" + train.getTerminationTrack().getName() + ")";
            }
            case 16: {
                return train.getNumberCarsInTrain();
            }
            case 17: {
                return train.getStatus();
            }
            case 3: {
                if (train.isBuilt()) {
                    if (Setup.isGenerateCsvManifestEnabled() && this.trainManager.isOpenFileEnabled()) {
                        this.setToolTip(Bundle.getMessage("OpenTrainTip", train.getName()), row, col);
                        return Bundle.getMessage("OpenFile");
                    }
                    if (Setup.isGenerateCsvManifestEnabled() && this.trainManager.isRunFileEnabled()) {
                        this.setToolTip(Bundle.getMessage("RunTrainTip", train.getName()), row, col);
                        return Bundle.getMessage("RunFile");
                    }
                    this.setToolTip(Bundle.getMessage("PrintTrainTip"), row, col);
                    if (this.trainManager.isPrintPreviewEnabled()) {
                        return Bundle.getMessage("Preview");
                    }
                    if (train.isPrinted()) {
                        return Bundle.getMessage("Printed");
                    }
                    return Bundle.getMessage("Print");
                }
                this.setToolTip(Bundle.getMessage("BuildTrainTip", train.getName()), row, col);
                return Bundle.getMessage("Build");
            }
            case 18: {
                if (train.isBuildFailed()) {
                    return Bundle.getMessage("Report");
                }
                if (train.getCurrentRouteLocation() == train.getTrainTerminatesRouteLocation() && this.trainManager.getTrainsFrameTrainAction().equals(TrainsTableFrame.MOVE)) {
                    return Bundle.getMessage("Terminate");
                }
                return this.trainManager.getTrainsFrameTrainAction();
            }
            case 19: {
                return Bundle.getMessage("ButtonEdit");
            }
        }
        return "unknown " + col;
    }

    private void setToolTip(String text, int row, int col) {
        XTableColumnModel tcm = (XTableColumnModel)this._table.getColumnModel();
        ButtonRenderer buttonRenderer = (ButtonRenderer)tcm.getColumnByModelIndex(col).getCellRenderer();
        if (buttonRenderer != null) {
            buttonRenderer.setToolTipText(text);
        }
    }

    private String getBuiltString(Train train) {
        if (!train.getBuiltStartYear().equals("") && train.getBuiltEndYear().equals("")) {
            return "A " + train.getBuiltStartYear();
        }
        if (train.getBuiltStartYear().equals("") && !train.getBuiltEndYear().equals("")) {
            return "B " + train.getBuiltEndYear();
        }
        if (!train.getBuiltStartYear().equals("") && !train.getBuiltEndYear().equals("")) {
            return "R " + train.getBuiltStartYear() + ":" + train.getBuiltEndYear();
        }
        return "";
    }

    private String getModifiedString(int number, boolean all, boolean accept) {
        if (all) {
            return "";
        }
        if (accept) {
            return "A " + Integer.toString(number);
        }
        return "E " + Integer.toString(number);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 19: {
                this.editTrain(row);
                break;
            }
            case 3: {
                this.buildTrain(row);
                break;
            }
            case 18: {
                this.actionTrain(row);
                break;
            }
            case 2: {
                Train train = this.getTrainByRow(row);
                train.setBuildEnabled((Boolean)value);
                break;
            }
        }
    }

    public Color getRowColor(int row) {
        Train train = this.getTrainByRow(row);
        return train.getTableRowColor();
    }

    private void editTrain(int row) {
        if (this.tef != null) {
            this.tef.dispose();
        }
        SwingUtilities.invokeLater(() -> {
            Train train = this.getTrainByRow(row);
            log.debug("Edit train ({})", (Object)train.getName());
            this.tef = new TrainEditFrame(train);
        });
    }

    private void buildTrain(int row) {
        final Train train = this.getTrainByRow(row);
        if (!train.isBuilt()) {
            if (this.build != null && this.build.isAlive()) {
                return;
            }
            this.build = ThreadingUtil.newThread(new Runnable(){

                @Override
                public void run() {
                    train.build();
                }
            });
            this.build.setName("Build Train (" + train.getName() + ")");
            this.build.start();
        } else {
            if (this.trainManager.isBuildReportEnabled()) {
                train.printBuildReport();
            }
            if (Setup.isGenerateCsvManifestEnabled() && this.trainManager.isOpenFileEnabled()) {
                train.openFile();
            } else if (Setup.isGenerateCsvManifestEnabled() && this.trainManager.isRunFileEnabled()) {
                train.runFile();
            } else if (!train.printManifestIfBuilt()) {
                log.debug("Manifest file for train ({}) not found", (Object)train.getName());
                int result = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("TrainManifestFileMissing", train.getName()), Bundle.getMessage("TrainManifestFileError"), 0);
                if (result == 0) {
                    train.setModified(true);
                    if (!train.printManifestIfBuilt()) {
                        log.error("Unable to create manifest for train ({})", (Object)train.getName());
                    }
                }
            }
        }
    }

    private void actionTrain(int row) {
        if (this.build != null && this.build.isAlive()) {
            return;
        }
        Train train = this.getTrainByRow(row);
        if (train.isBuildFailed()) {
            train.printBuildReport();
        } else if (this.trainManager.getTrainsFrameTrainAction().equals(TrainsTableFrame.RESET)) {
            log.debug("Reset train ({})", (Object)train.getName());
            if (this.checkDepartureTrack(train)) {
                log.debug("Train is departing staging that already has inbound cars");
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("StagingTrackUsed", train.getDepartureTrack().getName()), Bundle.getMessage("CanNotResetTrain"), 1);
            } else if (!train.reset()) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("TrainIsInRoute", train.getTrainTerminatesName()), Bundle.getMessage("CanNotResetTrain"), 0);
            }
        } else if (!train.isBuilt()) {
            int reply = JmriJOptionPane.showOptionDialog(null, Bundle.getMessage("TrainNeedsBuild", train.getName()), Bundle.getMessage("CanNotPerformAction"), 1, 1, null, new Object[]{Bundle.getMessage("ButtonOK"), Bundle.getMessage("Build")}, null);
            if (reply == 1) {
                train.build();
            }
        } else if (train.isBuilt() && this.trainManager.getTrainsFrameTrainAction().equals(TrainsTableFrame.MOVE)) {
            log.debug("Move train ({})", (Object)train.getName());
            train.move();
        } else if (train.isBuilt() && this.trainManager.getTrainsFrameTrainAction().equals(TrainsTableFrame.TERMINATE)) {
            log.debug("Terminate train ({})", (Object)train.getName());
            int status = JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("TerminateTrain", train.getName(), train.getDescription()), Bundle.getMessage("DoYouWantToTermiate", train.getName()), 0);
            if (status == 0) {
                train.terminate();
            }
        } else if (train.isBuilt() && this.trainManager.getTrainsFrameTrainAction().equals(TrainsTableFrame.CONDUCTOR)) {
            log.debug("Enable conductor for train ({})", (Object)train.getName());
            this.launchConductor(train);
        }
    }

    private boolean checkDepartureTrack(Train train) {
        return Setup.isStagingTrackImmediatelyAvail() && !train.isTrainEnRoute() && train.getDepartureTrack() != null && train.getDepartureTrack().isStaging() && train.getDepartureTrack() != train.getTerminationTrack() && train.getDepartureTrack().getIgnoreUsedLengthPercentage() == 0 && train.getDepartureTrack().getDropRS() > 0;
    }

    private void launchConductor(Train train) {
        SwingUtilities.invokeLater(() -> {
            TrainConductorFrame f = _trainConductorHashTable.get(train.getId());
            if (f == null || !f.isVisible()) {
                f = new TrainConductorFrame(train);
                _trainConductorHashTable.put(train.getId(), f);
            } else {
                f.setExtendedState(0);
            }
            f.setVisible(true);
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("TrainBuiltYear") || e.getPropertyName().equals("TrainRoads") || e.getPropertyName().equals("TrainLoads") || e.getPropertyName().equals("TrainOwners")) {
            this.updateColumnVisible();
        }
        if (e.getPropertyName().equals("TrainsListLength") || e.getPropertyName().equals("TrainsPrintPreview") || e.getPropertyName().equals("TrainsOpenFile") || e.getPropertyName().equals("TrainsRunFile") || e.getPropertyName().equals("setupManifestCSVChange") || e.getPropertyName().equals("TrainsAction") || e.getPropertyName().equals("TrainDepartureTime") || e.getPropertyName().equals("TrainBuild") && !this.isShowAll()) {
            SwingUtilities.invokeLater(() -> {
                this.updateList();
                this.fireTableDataChanged();
            });
        } else if (e.getSource().getClass().equals(Train.class)) {
            Train train = (Train)e.getSource();
            SwingUtilities.invokeLater(() -> {
                int row = this.sysList.indexOf(train);
                if (row >= 0 && this._table != null) {
                    this.fireTableRowsUpdated(row, row);
                    int viewRow = this._table.convertRowIndexToView(row);
                    log.debug("Scroll table to row: {}, property: {}", (Object)viewRow, (Object)e.getPropertyName());
                    this._table.scrollRectToVisible(this._table.getCellRect(viewRow, 0, true));
                }
            });
        }
    }

    private void removePropertyChangeTrains() {
        for (Train train : this.trainManager.getTrainsByIdList()) {
            train.removePropertyChangeListener(this);
        }
    }

    private void addPropertyChangeTrains() {
        for (Train train : this.trainManager.getTrainsByIdList()) {
            train.addPropertyChangeListener(this);
        }
    }

    public void dispose() {
        if (this.tef != null) {
            this.tef.dispose();
        }
        this.trainManager.removePropertyChangeListener(this);
        Setup.getDefault().removePropertyChangeListener(this);
        this.removePropertyChangeTrains();
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        Color[] darkColors = new Color[]{Color.BLACK, Color.BLUE, Color.GRAY, Color.RED, Color.MAGENTA};

        MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                int modelRow = table.convertRowIndexToModel(row);
                Color background = TrainsTableModel.this.getRowColor(modelRow);
                component.setBackground(background);
                component.setForeground(this.getForegroundColor(background));
            }
            return component;
        }

        private Color getForegroundColor(Color background) {
            if (background == null) {
                return null;
            }
            for (Color color : this.darkColors) {
                if (background != color) continue;
                return Color.WHITE;
            }
            return Color.BLACK;
        }
    }
}

