/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.schedules;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.schedules.Bundle;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsScheduleEditFrame
extends OperationsFrame
implements PropertyChangeListener {
    JTextField addTextBox = new JTextField(Control.max_len_string_attibute);
    private JComboBox<TrainSchedule> comboBox = null;
    JButton addButton = new JButton(Bundle.getMessage("Add"));
    JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
    JButton replaceButton = new JButton(Bundle.getMessage("Replace"));
    JButton restoreButton = new JButton(Bundle.getMessage("Restore"));
    TrainScheduleManager trainScheduleManager = InstanceManager.getDefault(TrainScheduleManager.class);
    private static final Logger log = LoggerFactory.getLogger(TrainsScheduleEditFrame.class);

    public TrainsScheduleEditFrame() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.trainScheduleManager.addPropertyChangeListener(this);
        this.initComponents();
    }

    @Override
    public void initComponents() {
        try {
            this.comboBox = this.trainScheduleManager.getComboBox();
        }
        catch (IllegalArgumentException iae) {
            this.comboBox = new JComboBox();
            this.trainScheduleManager.updateComboBox(this.comboBox);
        }
        this.addItem(this.addTextBox, 2, 2);
        this.addItem(this.addButton, 3, 2);
        this.addItem(this.comboBox, 2, 3);
        this.addItem(this.deleteButton, 3, 3);
        this.addItem(this.replaceButton, 3, 4);
        this.addItem(this.restoreButton, 2, 5);
        this.restoreButton.setToolTipText(Bundle.getMessage("RestoreScheduleTip"));
        this.addButtonAction(this.addButton);
        this.addButtonAction(this.deleteButton);
        this.addButtonAction(this.replaceButton);
        this.addButtonAction(this.restoreButton);
        this.setTitle(Bundle.getMessage("MenuItemEditSchedule"));
        this.initMinimumSize(new Dimension(300, 200));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.deleteButton && this.comboBox.getSelectedItem() != null) {
            this.trainScheduleManager.deregister((TrainSchedule)this.comboBox.getSelectedItem());
        }
        if (ae.getSource() == this.restoreButton) {
            this.trainScheduleManager.createDefaultSchedules();
        }
        String s = this.addTextBox.getText();
        if ((s = s.trim()).isEmpty()) {
            return;
        }
        if (ae.getSource() == this.addButton) {
            this.trainScheduleManager.newSchedule(s);
        }
        if (ae.getSource() == this.replaceButton && this.comboBox.getSelectedItem() != null) {
            TrainSchedule ts = (TrainSchedule)this.comboBox.getSelectedItem();
            ts.setName(s);
        }
    }

    @Override
    public void dispose() {
        this.trainScheduleManager.removePropertyChangeListener(this);
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        this.trainScheduleManager.updateComboBox(this.comboBox);
    }
}

