/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.routes.RouteManager;
import jmri.jmrit.operations.setup.OperationsSetupXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.util.ColorUtil;
import jmri.util.swing.JmriJOptionPane;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportTimetable
extends XmlFile {
    List<Location> locationList = new ArrayList<Location>();
    private static String operationsFileName = "ExportOperationsTimetable.csv";
    private static final Logger log = LoggerFactory.getLogger(ExportTimetable.class);

    public void writeOperationsTimetableFile() {
        this.makeBackupFile(ExportTimetable.defaultOperationsFilename());
        try {
            if (!this.checkFile(ExportTimetable.defaultOperationsFilename())) {
                File file = new File(ExportTimetable.defaultOperationsFilename());
                File parentDir = file.getParentFile();
                if (!parentDir.exists() && !parentDir.mkdir()) {
                    log.error("Directory wasn't created");
                }
                if (file.createNewFile()) {
                    log.debug("File created");
                }
            }
            this.writeFile(ExportTimetable.defaultOperationsFilename());
        }
        catch (IOException e) {
            log.error("Exception while writing the new CSV operations file, may not be complete: {}", (Object)e.getLocalizedMessage());
        }
    }

    public void writeFile(String name) {
        log.debug("writeFile {}", (Object)name);
        File file = this.findFile(name);
        if (file == null) {
            file = new File(name);
        }
        try (CSVPrinter fileOut = new CSVPrinter((Appendable)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), CSVFormat.DEFAULT);){
            this.loadLayout(fileOut);
            this.loadTrainTypes(fileOut);
            this.loadSegment(fileOut);
            this.loadStations(fileOut);
            this.loadSchedule(fileOut);
            this.loadTrains(fileOut);
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedTimetableToFile", ExportTimetable.defaultOperationsFilename()), Bundle.getMessage("ExportComplete"), 1);
            fileOut.flush();
            fileOut.close();
        }
        catch (IOException e) {
            log.error("Can not open export timetable CSV file: {}", (Object)e.getLocalizedMessage());
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("ExportedTimetableToFile", ExportTimetable.defaultOperationsFilename()), Bundle.getMessage("ExportFailed"), 0);
        }
    }

    private void loadLayout(CSVPrinter fileOut) throws IOException {
        fileOut.printRecord(new Object[]{"Layout", Setup.getRailroadName(), "HO", "4", "0", "No"});
    }

    private void loadTrainTypes(CSVPrinter fileOut) throws IOException {
        fileOut.printRecord(new Object[]{"TrainType", "Freight_Black", ColorUtil.colorToHexString(Color.BLACK)});
        fileOut.printRecord(new Object[]{"TrainType", "Freight_Red", ColorUtil.colorToHexString(Color.RED)});
        fileOut.printRecord(new Object[]{"TrainType", "Freight_Blue", ColorUtil.colorToHexString(Color.BLUE)});
        fileOut.printRecord(new Object[]{"TrainType", "Freight_Yellow", ColorUtil.colorToHexString(Color.YELLOW)});
    }

    private void loadSegment(CSVPrinter fileOut) throws IOException {
        fileOut.printRecord(new Object[]{"Segment", "Locations"});
    }

    private void loadStations(CSVPrinter fileOut) throws IOException {
        Route route = InstanceManager.getDefault(RouteManager.class).getRouteByName("Timetable");
        if (route != null) {
            route.getLocationsBySequenceList().forEach(rl -> this.locationList.add(rl.getLocation()));
        } else {
            InstanceManager.getDefault(LocationManager.class).getLocationsByNameList().forEach(location -> this.locationList.add((Location)location));
        }
        double distance = 0.0;
        for (Location location2 : this.locationList) {
            fileOut.printRecord(new Object[]{"Station", location2.getName(), distance += 1.0, "No", "0", location2.isStaging() ? Integer.valueOf(location2.getTracksList().size()) : "0"});
        }
    }

    private void loadSchedule(CSVPrinter fileOut) throws IOException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd kk:mm");
        String scheduleName = simpleDateFormat.format(Calendar.getInstance().getTime());
        fileOut.printRecord(new Object[]{"Schedule", scheduleName, "Today", "0", "24"});
    }

    private void loadTrains(CSVPrinter fileOut) throws IOException {
        int type = 1;
        int defaultSpeed = 4;
        if (Setup.getTravelTime() > 0) {
            defaultSpeed /= Setup.getTravelTime();
        }
        for (Train train : InstanceManager.getDefault(TrainManager.class).getTrainsByTimeList()) {
            if (!train.isBuildEnabled() || train.getRoute() == null) continue;
            fileOut.printRecord(new Object[]{"Train", train.getName(), train.getDescription(), type++, defaultSpeed, train.getDepartTimeMinutes(), "0", train.getComment()});
            if (type > 4) {
                type = 1;
            }
            for (RouteLocation rl : train.getRoute().getLocationsBySequenceList()) {
                int station = 0;
                for (Location location : this.locationList) {
                    ++station;
                    if (rl.getLocation() != location) continue;
                    break;
                }
                int duration = 0;
                if (rl != train.getTrainDepartsRouteLocation() && rl.getLocation() != null && !rl.getLocation().isStaging()) {
                    if (train.isBuilt()) {
                        duration = train.getWorkTimeAtLocation(rl) + rl.getWait();
                        if (!rl.getDepartureTime().isEmpty() && !train.getExpectedArrivalTime(rl).equals("-1")) {
                            duration = 60 * Integer.parseInt(rl.getDepartureTimeHour()) + Integer.parseInt(rl.getDepartureTimeMinute()) - train.getExpectedTravelTimeInMinutes(rl);
                        }
                    } else {
                        duration = rl.getMaxCarMoves() * Setup.getSwitchTime() + rl.getWait();
                    }
                }
                fileOut.printRecord(new Object[]{"Stop", station, duration, "0", "0", rl.getComment()});
            }
        }
    }

    public File getExportFile() {
        return this.findFile(ExportTimetable.defaultOperationsFilename());
    }

    public static String defaultOperationsFilename() {
        return OperationsSetupXml.getFileLocation() + OperationsSetupXml.getOperationsDirectoryName() + File.separator + ExportTimetable.getOperationsFileName();
    }

    public static void setOperationsFileName(String name) {
        operationsFileName = name;
    }

    public static String getOperationsFileName() {
        return operationsFileName;
    }
}

