/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileNameExtensionFilter;
import jmri.InstanceManager;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.TrainPrintUtilities;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.util.swing.JmriJFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintSavedBuildReportAction
extends AbstractAction
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(PrintSavedBuildReportAction.class);
    boolean _isPreview;
    Train _train;

    public PrintSavedBuildReportAction(boolean isPreview, Train train) {
        super(isPreview ? Bundle.getMessage("MenuItemPreviewSavedBuildReport") : Bundle.getMessage("MenuItemPrintSavedBuildReport"));
        this._isPreview = isPreview;
        this._train = train;
        this.setEnabled(Setup.isSaveTrainManifestsEnabled());
        Setup.getDefault().addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("saveTrainManifestChange")) {
            this.setEnabled(Setup.isSaveTrainManifestsEnabled());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = this.getFile();
        if (file == null || !file.exists()) {
            log.debug("User didn't select a file");
            return;
        }
        if (this._isPreview && Setup.isBuildReportEditorEnabled()) {
            TrainPrintUtilities.editReport(file, this._train.getName());
            return;
        }
        TrainPrintUtilities.printReport(file, Bundle.getMessage("buildReport", this._train.getDescription()), this._isPreview, "", true, "", "", Setup.PORTRAIT, Setup.getBuildReportFontSize(), true, null);
    }

    protected File getFile() {
        String pathName = InstanceManager.getDefault(TrainManagerXml.class).getBackupBuildStatusDirectoryName();
        if (this._train != null) {
            pathName = InstanceManager.getDefault(TrainManagerXml.class).getBackupBuildStatusDirectoryName(this._train.getName());
        }
        JmriJFileChooser fc = new JmriJFileChooser(pathName);
        fc.setFileFilter(new FileNameExtensionFilter(Bundle.getMessage("TextFiles"), "txt"));
        int retVal = fc.showOpenDialog(null);
        if (retVal != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }
}

