/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Frame;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintShowCarsInTrain
extends TrainCommon {
    static final String NEW_LINE = "\n";
    static int fieldSize = InstanceManager.getDefault(CarRoads.class).getMaxNameLength() + Control.max_len_string_road_number;
    static final String TAB = PrintShowCarsInTrain.padString("", fieldSize);
    List<Car> carsInTrain = new ArrayList<Car>();
    private static final Logger log = LoggerFactory.getLogger(PrintShowCarsInTrain.class);

    public void printCarsInTrain(Train train, boolean isPreview) {
        if (train.isBuilt()) {
            try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleShowCarsInTrain", train.getName()), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, isPreview);){
                this.printCarsAtLocation(writer, train, train.getCurrentRouteLocation());
            }
            catch (HardcopyWriter.PrintCanceledException ex) {
                log.debug("Print canceled");
            }
            catch (IOException ex) {
                log.error("Error printing car roster: {}", (Object)ex.getLocalizedMessage());
            }
        }
    }

    public void printCarsAtLocation(HardcopyWriter writer, Train train, RouteLocation rl) throws IOException {
        if (rl != null) {
            log.debug("RouteLocation rl: {}", (Object)rl.getName());
            writer.write(rl.getSplitName() + NEW_LINE);
            writer.write(this.getHeader());
            for (RouteLocation rld : train.getRoute().getBlockingOrder()) {
                log.debug("RouteLocation rld: {}", (Object)rld.getName());
                for (Car car : this.carManager.getByTrainDestinationList(train)) {
                    if (!PrintShowCarsInTrain.isNextCar(car, rl, rld, true)) continue;
                    log.debug("car ({}) routelocation ({}) track ({}) route destination ({})", new Object[]{car.toString(), car.getRouteLocation().getName(), car.getTrackName(), car.getRouteDestination().getName()});
                    String s = this.getCarId(car) + NEW_LINE;
                    if (car.getRouteDestination() == rl) {
                        writer.write(TAB + TAB + s);
                        continue;
                    }
                    if (car.getRouteLocation() == rl && car.getTrack() != null) {
                        writer.write(s);
                        continue;
                    }
                    writer.write(TAB + s);
                }
            }
        }
    }

    public void printCarsInTrainRoute(Train train, boolean isPreview) {
        if (train.isBuilt()) {
            try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleShowCarsInTrain", train.getName()), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, isPreview);){
                this.printCarsRoute(writer, train);
            }
            catch (HardcopyWriter.PrintCanceledException ex) {
                log.debug("Print canceled");
            }
            catch (IOException ex) {
                log.error("Error printing car roster: {}", (Object)ex.getLocalizedMessage());
            }
        }
    }

    public void printCarsRoute(HardcopyWriter writer, Train train) throws IOException {
        this.loadCarsInTrain(train);
        boolean foundTrainLoc = false;
        for (RouteLocation rl : train.getRoute().getLocationsBySequenceList()) {
            if (rl == null || !foundTrainLoc && rl != train.getCurrentRouteLocation()) continue;
            foundTrainLoc = true;
            log.debug("RouteLocation rl: {}", (Object)rl.getName());
            writer.write(rl.getSplitName() + NEW_LINE);
            if (!this.isThereWorkAtLocation(this.carManager.getByTrainDestinationList(train), null, rl)) continue;
            writer.write(this.getHeader());
            this.printCars(writer, train, rl);
            writer.write(NEW_LINE);
        }
    }

    private void printCars(HardcopyWriter writer, Train train, RouteLocation rl) throws IOException {
        for (Car car : this.carManager.getByTrainDestinationList(train)) {
            if (car.getRouteLocation() == rl && !this.carsInTrain.contains(car)) {
                this.carsInTrain.add(car);
                writer.write(this.getCarId(car) + NEW_LINE);
                continue;
            }
            if (car.getRouteDestination() == rl) {
                this.carsInTrain.remove(car);
                writer.write(TAB + TAB + this.getCarId(car) + NEW_LINE);
                continue;
            }
            if (!this.carsInTrain.contains(car)) continue;
            writer.write(TAB + this.getCarId(car) + NEW_LINE);
        }
    }

    private void loadCarsInTrain(Train train) {
        this.carsInTrain.clear();
        for (Car car : this.carManager.getByTrainDestinationList(train)) {
            if (car.getTrack() != null) continue;
            this.carsInTrain.add(car);
        }
    }

    private String getCarId(Car car) {
        return car.getRoadName().split("-")[0] + " " + PrintShowCarsInTrain.splitString(car.getNumber());
    }

    private String getHeader() {
        int fieldSize = InstanceManager.getDefault(CarRoads.class).getMaxNameLength() + Control.max_len_string_road_number;
        String header = PrintShowCarsInTrain.padString(Bundle.getMessage("Pickup"), fieldSize) + PrintShowCarsInTrain.padString(Bundle.getMessage("InTrain"), fieldSize) + PrintShowCarsInTrain.padString(Bundle.getMessage("SetOut"), fieldSize) + NEW_LINE;
        return header;
    }
}

