/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintTrainsByCarTypesAction
extends AbstractAction {
    static final String NEW_LINE = "\n";
    static final String TAB = "\t";
    boolean _isPreview;
    HardcopyWriter writer;
    int max_name_length = Control.max_len_string_train_name + 1;
    private static final Logger log = LoggerFactory.getLogger(PrintTrainsByCarTypesAction.class);

    public PrintTrainsByCarTypesAction(boolean isPreview) {
        super(isPreview ? Bundle.getMessage("MenuItemPreviewByType") : Bundle.getMessage("MenuItemPrintByType"));
        this._isPreview = isPreview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleTrainsByType"), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
            return;
        }
        String[] carTypes = InstanceManager.getDefault(CarTypes.class).getNames();
        List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByNameList();
        try {
            String s = Bundle.getMessage("Type") + TAB + TrainCommon.padString(Bundle.getMessage("Trains"), this.max_name_length) + Bundle.getMessage("Description") + NEW_LINE;
            this.writer.write(s);
            for (String type : carTypes) {
                s = type + NEW_LINE;
                this.writer.write(s);
                for (Train train : trains) {
                    if (!train.isTypeNameAccepted(type)) continue;
                    s = TAB + TrainCommon.padString(train.getName(), this.max_name_length) + train.getDescription() + NEW_LINE;
                    this.writer.write(s);
                }
            }
            this.writer.close();
        }
        catch (IOException we) {
            log.error("Error printing PrintLocationAction: {}", (Object)we.getLocalizedMessage());
        }
    }
}

