/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsPanel;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.gui.TrainsTableFrame;
import jmri.jmrit.operations.trains.gui.TrainsTableModel;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintTrainsFrame
extends OperationsFrame {
    static final String TAB = "\t";
    static final char FORM_FEED = '\f';
    public static final int MAX_NAME_LENGTH = Control.max_len_string_train_name - 10;
    boolean _isPreview;
    Train _train;
    TrainsTableFrame _trainsTableFrame;
    JComboBox<String> sortByComboBox = new JComboBox();
    JComboBox<String> manifestOrientationComboBox = new JComboBox();
    JComboBox<Integer> fontSizeComboBox = new JComboBox();
    JCheckBox printSummary = new JCheckBox(Bundle.getMessage("PrintSummary"));
    JCheckBox printDetails = new JCheckBox(Bundle.getMessage("PrintDetails"));
    JButton okayButton = new JButton(Bundle.getMessage("ButtonOK"));
    private static final int NUMBER_OF_HEADER_LINES = 8;
    private static final Logger log = LoggerFactory.getLogger(PrintTrainsFrame.class);

    public PrintTrainsFrame(boolean isPreview, Train train) {
        this._isPreview = isPreview;
        this._train = train;
        this.printTrain();
    }

    public PrintTrainsFrame(boolean isPreview, TrainsTableFrame trainsTableFrame) {
        this._isPreview = isPreview;
        this._trainsTableFrame = trainsTableFrame;
        JPanel pSortBy = new JPanel();
        pSortBy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SortBy")));
        pSortBy.add(this.sortByComboBox);
        this.loadSortByComboBox(this.sortByComboBox);
        this.addComboBoxAction(this.sortByComboBox);
        JPanel pOrientation = new JPanel();
        pOrientation.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutOrientation")));
        pOrientation.add(this.manifestOrientationComboBox);
        this.manifestOrientationComboBox.addItem(Setup.PORTRAIT);
        this.manifestOrientationComboBox.addItem(Setup.LANDSCAPE);
        JPanel pFontSize = new JPanel();
        pFontSize.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutFontSize")));
        pFontSize.add(this.fontSizeComboBox);
        OperationsPanel.loadFontSizeComboBox(this.fontSizeComboBox);
        this.fontSizeComboBox.setSelectedItem(Control.reportFontSize);
        JPanel pPanel = new JPanel();
        pPanel.setLayout(new GridBagLayout());
        pPanel.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("PrintOptions")));
        this.addItemLeft(pPanel, this.printSummary, 0, 0);
        this.addItemLeft(pPanel, this.printDetails, 0, 1);
        this.printSummary.setSelected(true);
        this.printDetails.setSelected(true);
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.add(this.okayButton);
        this.addButtonAction(this.okayButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.getContentPane().add(pSortBy);
        this.getContentPane().add(pOrientation);
        this.getContentPane().add(pFontSize);
        this.getContentPane().add(pPanel);
        this.getContentPane().add(pButtons);
        this.setPreferredSize(null);
        if (this._isPreview) {
            this.setTitle(Bundle.getMessage("MenuItemPreview"));
        } else {
            this.setTitle(Bundle.getMessage("MenuItemPrint"));
        }
        this.initMinimumSize(new Dimension(300, 250));
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        this.setVisible(false);
        this.printTrains();
    }

    private void printTrains() {
        if (!this.printSummary.isSelected() && !this.printDetails.isSelected()) {
            return;
        }
        boolean isLandscape = false;
        if (this.manifestOrientationComboBox.getSelectedItem() != null && this.manifestOrientationComboBox.getSelectedItem().equals(Setup.LANDSCAPE)) {
            isLandscape = true;
        }
        int fontSize = (Integer)this.fontSizeComboBox.getSelectedItem();
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleTrainsTable"), fontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview, "", isLandscape, true, null, null);){
            List<Train> trains = this._trainsTableFrame.getSortByList((String)this.sortByComboBox.getSelectedItem());
            if (this.printSummary.isSelected()) {
                this.printSummaryTrains(writer, trains, this._trainsTableFrame);
                if (this.printDetails.isSelected()) {
                    writer.write(12);
                }
            }
            if (this.printDetails.isSelected()) {
                for (Train train : trains) {
                    if (!train.isBuildEnabled() && !this._trainsTableFrame.showAllBox.isSelected() || train.getRoute() == null) continue;
                    List<RouteLocation> route = train.getRoute().getLocationsBySequenceList();
                    if (writer.getLinesPerPage() - writer.getCurrentLineNumber() < route.size() + this.getNumberOfLines(writer, Bundle.getMessage("Comment") + ": " + train.getComment()) + 8) {
                        writer.write(12);
                    } else if (writer.getCurrentLineNumber() > 0) {
                        writer.write("\n");
                    }
                    this.printTrain(writer, train);
                }
            }
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException e1) {
            log.error("Exception in print train details: {}", (Object)e1.getLocalizedMessage());
        }
    }

    private void printSummaryTrains(HardcopyWriter writer, List<Train> trains, TrainsTableFrame trainsTableFrame) throws IOException {
        int maxLineLength = writer.getCharactersPerLine() - 1;
        int maxTrainNameLength = InstanceManager.getDefault(TrainManager.class).getMaxTrainNameLength();
        int maxLocationNameLength = InstanceManager.getDefault(LocationManager.class).getMaxLocationNameLength();
        String s = Bundle.getMessage("Time") + "  " + this.truncate(Bundle.getMessage("Name"), maxTrainNameLength) + this.truncate(Bundle.getMessage("Description")) + this.truncate(Bundle.getMessage("Route")) + this.truncate(Bundle.getMessage("Departs"), maxLocationNameLength) + this.truncate(Bundle.getMessage("Terminates"), maxLocationNameLength);
        writer.write(this.truncate(s, maxLineLength) + "\n");
        for (Train train : trains) {
            if (!train.isBuildEnabled() && !trainsTableFrame.showAllBox.isSelected()) continue;
            String name = this.truncate(train.getName(), maxTrainNameLength);
            String desc = this.truncate(train.getDescription());
            String route = this.truncate(train.getTrainRouteName());
            String departs = this.truncate(train.getTrainDepartsName(), maxLocationNameLength);
            String terminates = this.truncate(train.getTrainTerminatesName(), maxLocationNameLength);
            s = train.getDepartureTime() + " " + name + desc + route + departs + terminates;
            writer.write(this.truncate(s, maxLineLength) + "\n");
        }
    }

    private String truncate(String string) {
        return this.truncate(string, MAX_NAME_LENGTH);
    }

    private String truncate(String string, int length) {
        return TrainCommon.padAndTruncate(string, length) + " ";
    }

    private void printTrain() {
        if (this._train == null) {
            return;
        }
        try (HardcopyWriter writer = new HardcopyWriter(new Frame(), Bundle.getMessage("TitleTrain", this._train.getName()), Control.reportFontSize, 0.5, 0.5, 0.5, 0.5, this._isPreview);){
            this.printTrain(writer, this._train);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print canceled");
        }
        catch (IOException ex) {
            log.error("Exception in print train: {}", (Object)ex.getLocalizedMessage());
        }
    }

    private void printTrain(HardcopyWriter writer, Train train) throws IOException {
        String s = Bundle.getMessage("Name") + ": " + train.getName() + "\n";
        writer.write(s);
        s = Bundle.getMessage("Description") + ": " + train.getDescription() + "\n";
        writer.write(s);
        s = Bundle.getMessage("Departs") + ": " + train.getTrainDepartsName() + "\n";
        writer.write(s);
        s = Bundle.getMessage("DepartTime") + ": " + train.getDepartureTime() + "\n";
        writer.write(s);
        s = Bundle.getMessage("Terminates") + ": " + train.getTrainTerminatesName() + "\n";
        writer.write(s);
        writer.write("\n");
        s = Bundle.getMessage("Route") + ": " + train.getTrainRouteName() + "\n";
        writer.write(s);
        Route route = train.getRoute();
        if (route != null) {
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                s = TAB + rl.getName() + "\n";
                writer.write(s);
            }
        }
        if (!train.getComment().equals("")) {
            s = Bundle.getMessage("Comment") + ": " + train.getComment() + "\n";
            writer.write(s);
        }
    }

    private void loadSortByComboBox(JComboBox<String> box) {
        box.addItem(TrainsTableModel.IDCOLUMNNAME);
        box.addItem(TrainsTableModel.TIMECOLUMNNAME);
        box.addItem(TrainsTableModel.NAMECOLUMNNAME);
        box.addItem(TrainsTableModel.DESCRIPTIONCOLUMNNAME);
        box.addItem(TrainsTableModel.ROUTECOLUMNNAME);
        box.addItem(TrainsTableModel.DEPARTSCOLUMNNAME);
        box.addItem(TrainsTableModel.TERMINATESCOLUMNNAME);
        box.addItem(TrainsTableModel.STATUSCOLUMNNAME);
        box.setSelectedItem(this._trainsTableFrame.getSortBy());
    }

    private int getNumberOfLines(HardcopyWriter writer, String string) {
        String[] lines = string.split("\n");
        int count = lines.length;
        for (String line : lines) {
            int add = line.length() / writer.getCharactersPerLine();
            count += add;
        }
        return count;
    }
}

