/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.jmrit.operations.trains.tools.PrintShowCarsInTrainAction;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowCarsInTrainFrame
extends OperationsFrame
implements PropertyChangeListener {
    Train _train = null;
    CarManager carManager = InstanceManager.getDefault(CarManager.class);
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    JLabel textTrainName = new JLabel();
    JLabel textLocationName = new JLabel();
    JLabel textNextLocationName = new JLabel();
    JTextPane textStatus = new JTextPane();
    JLabel textPickUp = new JLabel(Bundle.getMessage("Pickup"));
    JLabel textInTrain = new JLabel(Bundle.getMessage("InTrain"));
    JLabel textSetOut = new JLabel(Bundle.getMessage("SetOut"));
    JPanel pCars = new JPanel();
    private static final Logger log = LoggerFactory.getLogger(ShowCarsInTrainFrame.class);

    public void initComponents(Train train) {
        this._train = train;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JScrollPane carPane = new JScrollPane(this.pCars);
        carPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Cars")));
        carPane.setVerticalScrollBarPolicy(20);
        JPanel pRow2 = new JPanel();
        pRow2.setLayout(new BoxLayout(pRow2, 0));
        JPanel pTrainName = new JPanel();
        pTrainName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        pTrainName.add(this.textTrainName);
        pRow2.add(pTrainName);
        JPanel pRow6 = new JPanel();
        pRow6.setLayout(new BoxLayout(pRow6, 0));
        JPanel pRow10 = new JPanel();
        pRow10.setLayout(new BoxLayout(pRow10, 0));
        JPanel pLocationName = new JPanel();
        pLocationName.setBorder(BorderFactory.createTitledBorder("Location"));
        pLocationName.add(this.textLocationName);
        JPanel pNextLocationName = new JPanel();
        pNextLocationName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("NextLocation")));
        pNextLocationName.add(this.textNextLocationName);
        pRow10.add(pLocationName);
        pRow10.add(pNextLocationName);
        JPanel pRow12 = new JPanel();
        pRow12.setLayout(new BoxLayout(pRow12, 0));
        this.pCars.setLayout(new GridBagLayout());
        pRow12.add(carPane);
        this.textStatus.setBorder(BorderFactory.createTitledBorder(""));
        this.textStatus.setBackground(null);
        this.textStatus.setEditable(false);
        this.getContentPane().add(pRow2);
        this.getContentPane().add(pRow6);
        this.getContentPane().add(pRow10);
        this.getContentPane().add(pRow12);
        this.getContentPane().add(this.textStatus);
        if (this._train != null) {
            this.setTitle(Bundle.getMessage("TitleShowCarsInTrain", this._train.getName()));
            this._train.addPropertyChangeListener(this);
        }
        JMenuBar menuBar = new JMenuBar();
        if (train != null) {
            JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
            toolMenu.add(new PrintShowCarsInTrainAction(false, train));
            toolMenu.add(new PrintShowCarsInTrainAction(true, train));
            menuBar.add(toolMenu);
        }
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ShowCarsInTrain", true);
        this.initMinimumSize(new Dimension(300, 500));
        this.update();
    }

    private void update() {
        log.debug("queue update");
        SwingUtilities.invokeLater(() -> {
            log.debug("update");
            if (this._train == null || this._train.getRoute() == null) {
                return;
            }
            this.textTrainName.setText(this._train.getIconName());
            this.pCars.removeAll();
            RouteLocation rl = this._train.getCurrentRouteLocation();
            if (rl != null) {
                this.textLocationName.setText(this.trainManager.isShowLocationHyphenNameEnabled() ? rl.getLocation().getName() : rl.getLocation().getSplitName());
                this.textNextLocationName.setText(this.trainManager.isShowLocationHyphenNameEnabled() ? this._train.getNextLocationName() : TrainCommon.splitString(this._train.getNextLocationName()));
                int i = 0;
                this.addItemLeft(this.pCars, this.textPickUp, 0, 0);
                this.addItemLeft(this.pCars, this.textInTrain, 1, 0);
                this.addItemLeft(this.pCars, this.textSetOut, 2, i++);
                for (RouteLocation rld : this._train.getRoute().getLocationsBySequenceList()) {
                    for (Car car : this.carManager.getByTrainDestinationList(this._train)) {
                        if (!TrainCommon.isNextCar(car, rl, rld, true)) continue;
                        log.debug("car ({}) routelocation ({}) track ({}) route destination ({})", new Object[]{car.toString(), car.getRouteLocation().getName(), car.getTrackName(), car.getRouteDestination().getName()});
                        JCheckBox checkBox = new JCheckBox(car.getRoadName().split("-")[0] + " " + TrainCommon.splitString(car.getNumber()));
                        if (car.getRouteDestination() == rl) {
                            this.addItemLeft(this.pCars, checkBox, 2, i++);
                            continue;
                        }
                        if (car.getRouteLocation() == rl && car.getTrack() != null) {
                            this.addItemLeft(this.pCars, checkBox, 0, i++);
                            continue;
                        }
                        this.addItemLeft(this.pCars, checkBox, 1, i++);
                    }
                }
                if (rl != this._train.getTrainTerminatesRouteLocation()) {
                    this.textStatus.setText(this.getStatus(rl));
                } else {
                    this.textStatus.setText(MessageFormat.format(TrainManifestText.getStringTrainTerminates(), this._train.getTrainTerminatesName()));
                }
            }
            this.pCars.repaint();
        });
    }

    private String getStatus(RouteLocation rl) {
        if (Setup.isPrintLoadsAndEmptiesEnabled()) {
            int emptyCars = this._train.getNumberEmptyCarsInTrain(rl);
            return MessageFormat.format(TrainManifestText.getStringTrainDepartsLoads(), rl.getSplitName(), rl.getTrainDirectionString(), this._train.getNumberCarsInTrain(rl) - emptyCars, emptyCars, this._train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), this._train.getTrainWeight(rl));
        }
        return MessageFormat.format(TrainManifestText.getStringTrainDepartsCars(), rl.getSplitName(), rl.getTrainDirectionString(), this._train.getNumberCarsInTrain(), this._train.getTrainLength(rl), Setup.getLengthUnit().toLowerCase(), this._train.getTrainWeight(rl));
    }

    @Override
    public void dispose() {
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change {} from: {} old: {} new: {}", new Object[]{e.getPropertyName(), e.getSource().toString(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("TrainBuilt") || e.getPropertyName().equals("TrainMoveComplete")) {
            this.update();
        }
    }
}

