/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.Schedule;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainByCarTypeFrame
extends OperationsFrame
implements PropertyChangeListener {
    protected static final String POINTER = "    -->";
    Train _train;
    LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    JPanel pRoute = new JPanel();
    JComboBox<Train> trainsComboBox = InstanceManager.getDefault(TrainManager.class).getTrainComboBox();
    JComboBox<String> typeComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JComboBox<Car> carsComboBox = new JComboBox();
    Car _car;
    private static final Logger log = LoggerFactory.getLogger(TrainByCarTypeFrame.class);

    public TrainByCarTypeFrame(Train train) {
        this._train = train;
        this.initComponents(null);
    }

    public TrainByCarTypeFrame(Car car) {
        if (car != null) {
            this._train = car.getTrain();
        }
        this.initComponents(car);
    }

    private void initComponents(Car car) {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pTrain = new JPanel();
        pTrain.setLayout(new GridBagLayout());
        pTrain.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Train")));
        pTrain.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pTrain, this.trainsComboBox, 0, 0);
        this.trainsComboBox.setSelectedItem(this._train);
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        pCarType.setMaximumSize(new Dimension(2000, 50));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        this.addItem(pCarType, this.carsComboBox, 1, 0);
        Dimension boxsize = this.typeComboBox.getMinimumSize();
        if (boxsize != null) {
            boxsize.setSize(boxsize.width + 10, boxsize.height);
            this.typeComboBox.setMinimumSize(boxsize);
        }
        this.adjustCarsComboBoxSize();
        this.pRoute.setLayout(new GridBagLayout());
        JScrollPane locationPane = new JScrollPane(this.pRoute);
        locationPane.setVerticalScrollBarPolicy(20);
        locationPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Route")));
        this.updateCarsComboBox();
        this.updateRoute();
        this.getContentPane().add(pTrain);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(locationPane);
        this.addComboBoxAction(this.trainsComboBox);
        this.addComboBoxAction(this.typeComboBox);
        this.addComboBoxAction(this.carsComboBox);
        if (car != null) {
            this.typeComboBox.setSelectedItem(car.getTypeName());
            this.carsComboBox.setSelectedItem(car);
        }
        this.locationManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        this.addLocationAndTrackPropertyChange();
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainShowCarTypesServiced", true);
        this.setPreferredSize(null);
        this.initMinimumSize();
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action");
        if (ae.getSource().equals(this.typeComboBox)) {
            this.updateCarsComboBox();
        }
        this.updateRoute();
        if (ae.getSource().equals(this.trainsComboBox)) {
            this.pack();
        }
    }

    private void updateRoute() {
        Route route;
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        this.pRoute.removeAll();
        this._train = this.trainsComboBox.getSelectedItem() == null ? null : (Train)this.trainsComboBox.getSelectedItem();
        if (this._train == null) {
            this.setTitle(Bundle.getMessage("MenuItemShowCarTypes"));
            this.repaint();
            return;
        }
        this.setTitle(Bundle.getMessage("MenuItemShowCarTypes") + " " + this._train.getName());
        this._train.addPropertyChangeListener(this);
        log.debug("update locations served by train ({})", (Object)this._train.getName());
        int y = 0;
        String carType = (String)this.typeComboBox.getSelectedItem();
        if (this._car != null) {
            this._car.removePropertyChangeListener(this);
        }
        this._car = null;
        if (this.carsComboBox.getSelectedItem() != null) {
            this._car = (Car)this.carsComboBox.getSelectedItem();
            this._car.addPropertyChangeListener(this);
        }
        if ((route = this._train.getRoute()) == null) {
            this.repaint();
            return;
        }
        List<RouteLocation> routeList = route.getLocationsBySequenceList();
        for (RouteLocation rl : routeList) {
            JLabel loc = new JLabel();
            String locationName = rl.getName();
            loc.setText(locationName);
            this.addItemLeft(this.pRoute, loc, 0, y++);
            Location location = this.locationManager.getLocationByName(locationName);
            if (location == null) continue;
            if (this._car != null && this._car.getTrack() != null && !this._car.getTrack().isDestinationAccepted(location)) {
                JLabel locText = new JLabel();
                locText.setText(Bundle.getMessage("CarOnTrackDestinationRestriction", this._car.toString(), this._car.getLocationName(), this._car.getTrackName(), locationName));
                this.addItemWidth(this.pRoute, locText, 2, 1, y++);
                if (this._car.getLocation() != location) continue;
            }
            List<Track> tracks = location.getTracksByNameList(null);
            for (Track track : tracks) {
                if (this._car != null && this._car.getTrack() != null && !this._car.getTrack().isDestinationAccepted(location) && this._car.getTrack() != track) continue;
                JLabel trk = new JLabel();
                trk.setText(track.getName());
                this.addItemLeft(this.pRoute, trk, 1, y);
                if (this._car != null && location.equals(this._car.getLocation()) && track.equals(this._car.getTrack())) {
                    JLabel here = new JLabel(POINTER);
                    this.addItemLeft(this.pRoute, here, 0, y);
                }
                JLabel op = new JLabel();
                this.addItemLeft(this.pRoute, op, 2, y++);
                if (!this._train.isTypeNameAccepted(carType)) {
                    op.setText(Bundle.getMessage("X(TrainType)"));
                    continue;
                }
                if (this._car != null && !this._car.isCaboose() && !this._train.isCarRoadNameAccepted(this._car.getRoadName())) {
                    op.setText(Bundle.getMessage("X(TrainRoad)"));
                    continue;
                }
                if (this._car != null && this._car.isCaboose() && this._train.isCabooseNeeded() && location.equals(this._car.getLocation()) && track.equals(this._car.getTrack()) && !this._train.getCabooseRoad().equals("") && !this._car.getRoadName().equals(this._train.getCabooseRoad()) && location.getName().equals(this._train.getTrainDepartsName())) {
                    op.setText(Bundle.getMessage("X(TrainRoad)"));
                    continue;
                }
                if (this._car != null && this._car.hasFred() && this._train.isFredNeeded() && location.equals(this._car.getLocation()) && track.equals(this._car.getTrack()) && !this._train.getCabooseRoad().equals("") && !this._car.getRoadName().equals(this._train.getCabooseRoad()) && location.getName().equals(this._train.getTrainDepartsName())) {
                    op.setText(Bundle.getMessage("X(TrainRoad)"));
                    continue;
                }
                if (!(this._car == null || this._car.isCaboose() || this._car.isPassenger() || this._train.isLoadNameAccepted(this._car.getLoadName(), this._car.getTypeName()))) {
                    op.setText(Bundle.getMessage("X(TrainLoad)"));
                    continue;
                }
                if (this._car != null && !this._train.isBuiltDateAccepted(this._car.getBuilt())) {
                    op.setText(Bundle.getMessage("X(TrainBuilt)"));
                    continue;
                }
                if (this._car != null && !this._train.isOwnerNameAccepted(this._car.getOwnerName())) {
                    op.setText(Bundle.getMessage("X(TrainOwner)"));
                    continue;
                }
                if (this._train.isLocationSkipped(rl)) {
                    op.setText(Bundle.getMessage("X(TrainSkips)"));
                    continue;
                }
                if (!rl.isDropAllowed() && !rl.isPickUpAllowed()) {
                    op.setText(Bundle.getMessage("X(Route)"));
                    continue;
                }
                if (rl.getMaxCarMoves() <= 0) {
                    op.setText(Bundle.getMessage("X(RouteMoves)"));
                    continue;
                }
                if (!location.acceptsTypeName(carType)) {
                    op.setText(Bundle.getMessage("X(LocationType)"));
                    continue;
                }
                if (!track.isPickupRouteAccepted(route) && !track.isDropRouteAccepted(route)) {
                    op.setText(Bundle.getMessage("X(TrackRoute)"));
                    continue;
                }
                if (!track.isPickupTrainAccepted(this._train) && !track.isDropTrainAccepted(this._train)) {
                    op.setText(Bundle.getMessage("X(TrackTrain)"));
                    continue;
                }
                if (!track.isTypeNameAccepted(carType)) {
                    op.setText(Bundle.getMessage("X(TrackType)"));
                    continue;
                }
                if (this._car != null && !track.isRoadNameAccepted(this._car.getRoadName())) {
                    op.setText(Bundle.getMessage("X(TrackRoad)"));
                    continue;
                }
                if (this._car != null && this._car.getTrack() != track && !track.isLoadNameAndCarTypeAccepted(this._car.getLoadName(), this._car.getTypeName())) {
                    op.setText(Bundle.getMessage("X(TrackLoad)"));
                    continue;
                }
                if (this._car != null && !track.isDestinationAccepted(this._car.getFinalDestination()) && this._car.getDestination() == null) {
                    op.setText(Bundle.getMessage("X(TrackDestination)"));
                    continue;
                }
                if ((rl.getTrainDirection() & location.getTrainDirections()) == 0) {
                    op.setText(Bundle.getMessage("X(DirLoc)"));
                    continue;
                }
                if ((rl.getTrainDirection() & track.getTrainDirections()) == 0) {
                    op.setText(Bundle.getMessage("X(DirTrk)"));
                    continue;
                }
                if (!track.checkScheduleAttribute(Track.TYPE, carType, null)) {
                    op.setText(Bundle.getMessage("X(ScheduleType)"));
                    continue;
                }
                if (!track.checkScheduleAttribute(Track.LOAD, carType, this._car)) {
                    op.setText(Bundle.getMessage("X(ScheduleLoad)"));
                    continue;
                }
                if (!track.checkScheduleAttribute(Track.ROAD, carType, this._car)) {
                    op.setText(Bundle.getMessage("X(ScheduleRoad)"));
                    continue;
                }
                if (!track.checkScheduleAttribute("trainSchedule", carType, this._car)) {
                    op.setText(Bundle.getMessage("X(ScheduleTrain)"));
                    continue;
                }
                if (!track.checkScheduleAttribute("all", carType, this._car)) {
                    op.setText(Bundle.getMessage("X(Schedule)"));
                    continue;
                }
                if (!track.isPickupTrainAccepted(this._train)) {
                    if (rl.isDropAllowed() && track.isDropTrainAccepted(this._train)) {
                        op.setText(Bundle.getMessage("DropOnly"));
                        continue;
                    }
                    op.setText(Bundle.getMessage("X(TrainPickup)"));
                    continue;
                }
                if (!track.isDropTrainAccepted(this._train)) {
                    if (rl.isPickUpAllowed() && track.isPickupTrainAccepted(this._train)) {
                        op.setText(Bundle.getMessage("PickupOnly"));
                        continue;
                    }
                    op.setText(Bundle.getMessage("X(TrainDrop)"));
                    continue;
                }
                if (!this._train.isLocalSwitcher() && this._car != null && this._car.getTrack() != track && this._car.getLocation() == track.getLocation() && this._car.getFinalDestination() == null && this._car.getDivision() == null && (this._car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) || this._car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName()))) {
                    op.setText(Bundle.getMessage("X(LocalMove)"));
                    continue;
                }
                if (!(this._train.isAllowLocalMovesEnabled() || this._car == null || this._car.getTrack() == track || this._car.getLocation() != track.getLocation() || this._car.getDivision() == null && this._car.getFinalDestination() == null && (this._car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) || this._car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName())))) {
                    op.setText(Bundle.getMessage("X(TrainLocalMove)"));
                    continue;
                }
                if (track.isSpur() && track.getSchedule() == null && this._car != null && this._car.getTrack() != track && !this._car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultEmptyName()) && !this._car.getLoadName().equals(InstanceManager.getDefault(CarLoads.class).getDefaultLoadName())) {
                    op.setText(Bundle.getMessage("X(TrackCustomLoad)"));
                    continue;
                }
                if (this._car != null && this._car.getDivision() != null && this._car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY) && this._car.getDivision() != track.getDivision() && !track.isInterchange()) {
                    op.setText(Bundle.getMessage("X(Division)"));
                    continue;
                }
                if (this._car != null && this._car.getDivision() != null && this._car.getLoadType().equals(CarLoad.LOAD_TYPE_LOAD) && this._car.getDivision() != this._car.getTrack().getDivision() && this._car.getDivision() != track.getDivision() && !track.isInterchange()) {
                    op.setText(Bundle.getMessage("X(Division)"));
                    continue;
                }
                if (rl.isDropAllowed() && rl.isPickUpAllowed()) {
                    op.setText(Bundle.getMessage("ButtonOK"));
                    continue;
                }
                if (rl.isDropAllowed()) {
                    op.setText(Bundle.getMessage("DropOnly"));
                    continue;
                }
                if (rl.isPickUpAllowed()) {
                    op.setText(Bundle.getMessage("PickupOnly"));
                    continue;
                }
                op.setText("X");
            }
        }
        this.pRoute.revalidate();
        this.repaint();
    }

    private void updateComboBox() {
        log.debug("update combobox");
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
    }

    private void updateCarsComboBox() {
        log.debug("update car combobox");
        this.carsComboBox.removeAllItems();
        String carType = (String)this.typeComboBox.getSelectedItem();
        this.carsComboBox.addItem(null);
        List cars = InstanceManager.getDefault(CarManager.class).getByTypeList(carType);
        for (Car car : cars) {
            this.carsComboBox.addItem(car);
        }
    }

    private void adjustCarsComboBoxSize() {
        List cars = InstanceManager.getDefault(CarManager.class).getList();
        for (Car car : cars) {
            this.carsComboBox.addItem(car);
        }
        Dimension boxsize = this.carsComboBox.getMinimumSize();
        if (boxsize != null) {
            boxsize.setSize(boxsize.width + 10, boxsize.height);
            this.carsComboBox.setMinimumSize(boxsize);
        }
        this.carsComboBox.removeAllItems();
    }

    private void addLocationAndTrackPropertyChange() {
        for (Location loc : this.locationManager.getList()) {
            loc.addPropertyChangeListener(this);
            for (Track track : loc.getTracksList()) {
                track.addPropertyChangeListener(this);
                Schedule schedule = track.getSchedule();
                if (schedule == null) continue;
                schedule.addPropertyChangeListener(this);
            }
        }
    }

    private void removeLocationAndTrackPropertyChange() {
        for (Location loc : this.locationManager.getList()) {
            loc.removePropertyChangeListener(this);
            for (Track track : loc.getTracksList()) {
                track.removePropertyChangeListener(this);
                Schedule schedule = track.getSchedule();
                if (schedule == null) continue;
                schedule.removePropertyChangeListener(this);
            }
        }
    }

    @Override
    public void dispose() {
        this.locationManager.removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        this.removeLocationAndTrackPropertyChange();
        if (this._train != null) {
            this._train.removePropertyChangeListener(this);
        }
        if (this._car != null) {
            this._car.removePropertyChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change ({}) old: ({}) new: ({})", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getSource().equals(this._car) || e.getSource().equals(this._train) || e.getSource().getClass().equals(Track.class) || e.getSource().getClass().equals(Location.class) || e.getSource().getClass().equals(Schedule.class) || e.getPropertyName().equals("locationsListLength") || e.getPropertyName().equals("routeListChange")) {
            this.updateRoute();
        }
        if (e.getPropertyName().equals("TrainDispose")) {
            this.dispose();
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("CarTypes Name")) {
            this.updateComboBox();
        }
        if (e.getPropertyName().equals("locationTrackLengths")) {
            this.removeLocationAndTrackPropertyChange();
            this.addLocationAndTrackPropertyChange();
        }
    }
}

