/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.gui.TrainEditFrame;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCopyFrame
extends OperationsFrame {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    JTextField trainNameTextField = new JTextField(Control.max_len_string_train_name);
    JButton copyButton = new JButton(Bundle.getMessage("ButtonCopy"));
    JComboBox<Train> trainBox = InstanceManager.getDefault(TrainManager.class).getTrainComboBox();
    private static final Logger log = LoggerFactory.getLogger(TrainCopyFrame.class);

    public TrainCopyFrame(Train train) {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainNameTextField, 0, 0);
        JPanel pCopy = new JPanel();
        pCopy.setLayout(new GridBagLayout());
        pCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("SelectTrain")));
        this.addItem(pCopy, this.trainBox, 0, 0);
        this.trainBox.setSelectedItem(train);
        JPanel pButton = new JPanel();
        pButton.add(this.copyButton);
        this.getContentPane().add(pName);
        this.getContentPane().add(pCopy);
        this.getContentPane().add(pButton);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_CopyTrain", true);
        this.pack();
        this.setMinimumSize(new Dimension(400, 200));
        this.setTitle(Bundle.getMessage("TitleTrainCopy"));
        this.addButtonAction(this.copyButton);
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyButton) {
            log.debug("copy train button activated");
            if (!this.checkName()) {
                return;
            }
            Train newTrain = this.trainManager.getTrainByName(this.trainNameTextField.getText());
            if (newTrain != null) {
                this.reportTrainExists();
                return;
            }
            if (this.trainBox.getSelectedItem() == null) {
                this.reportTrainDoesNotExist();
                return;
            }
            Train oldTrain = (Train)this.trainBox.getSelectedItem();
            if (oldTrain == null) {
                this.reportTrainDoesNotExist();
                return;
            }
            newTrain = this.trainManager.copyTrain(oldTrain, this.trainNameTextField.getText());
            new TrainEditFrame(newTrain);
        }
    }

    private void reportTrainExists() {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrainNameExists"), Bundle.getMessage("CanNotTrain", Bundle.getMessage("copy")), 0);
    }

    private void reportTrainDoesNotExist() {
        JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("SelectTrain"), Bundle.getMessage("CanNotTrain", Bundle.getMessage("copy")), 0);
    }

    private boolean checkName() {
        if (this.trainNameTextField.getText().trim().isEmpty()) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("EnterTrainName"), Bundle.getMessage("CanNotTrain", Bundle.getMessage("copy")), 0);
            return false;
        }
        if (this.trainNameTextField.getText().length() > Control.max_len_string_train_name) {
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("TrainNameLess", Control.max_len_string_train_name + 1), Bundle.getMessage("CanNot", Bundle.getMessage("copy")), 0);
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

