/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jmri.jmrit.XmlFile;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.gui.TrainEditFrame;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainManifestOptionFrame
extends OperationsFrame {
    Train _train = null;
    JLabel textPad = new JLabel("   ");
    JLabel logoURL = new JLabel("");
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JButton addLogoButton = new JButton(Bundle.getMessage("AddLogo"));
    JButton removeLogoButton = new JButton(Bundle.getMessage("RemoveLogo"));
    JCheckBox showTimesCheckBox = new JCheckBox(Bundle.getMessage("ShowTimes"));
    JTextField railroadNameTextField = new JTextField(35);
    JTextField logoTextField = new JTextField(35);
    JFileChooser fc = XmlFile.userFileChooser(Bundle.getMessage("Images"), new String[0]);
    private static final Logger log = LoggerFactory.getLogger(TrainManifestOptionFrame.class);

    public TrainManifestOptionFrame() {
        super(Bundle.getMessage("TitleOptions"));
    }

    public void initComponents(TrainEditFrame parent) {
        parent.setChildFrame(this);
        this._train = parent._train;
        this.addLogoButton.setToolTipText(Bundle.getMessage("AddLogoToolTip"));
        this.removeLogoButton.setToolTipText(Bundle.getMessage("RemoveLogoToolTip"));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pOptionName = new JPanel();
        pOptionName.setLayout(new GridBagLayout());
        JScrollPane pOptionNamePane = new JScrollPane(pOptionName);
        pOptionNamePane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutRailRoadName")));
        this.addItem(pOptionName, this.railroadNameTextField, 0, 0);
        JPanel pOptionLogo = new JPanel();
        pOptionLogo.setLayout(new GridBagLayout());
        JScrollPane pOptionLogoPane = new JScrollPane(pOptionLogo);
        pOptionLogoPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutLogo")));
        this.addItem(pOptionLogo, this.textPad, 2, 18);
        this.addItem(pOptionLogo, this.addLogoButton, 2, 20);
        this.addItemLeft(pOptionLogo, this.removeLogoButton, 0, 21);
        this.addItemWidth(pOptionLogo, this.logoURL, 6, 1, 21);
        this.updateLogoButtons();
        JPanel pCheckboxes = new JPanel();
        pCheckboxes.setLayout(new GridBagLayout());
        JScrollPane pCheckboxesPane = new JScrollPane(pCheckboxes);
        pCheckboxesPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("BorderLayoutManifest")));
        this.addItem(pCheckboxes, this.showTimesCheckBox, 0, 0);
        JPanel pControl = new JPanel();
        pControl.setLayout(new GridBagLayout());
        this.addItem(pControl, this.saveButton, 3, 9);
        this.getContentPane().add(pOptionNamePane);
        this.getContentPane().add(pOptionLogoPane);
        this.getContentPane().add(pCheckboxesPane);
        this.getContentPane().add(pControl);
        this.addButtonAction(this.addLogoButton);
        this.addButtonAction(this.removeLogoButton);
        this.addButtonAction(this.saveButton);
        if (this._train != null) {
            this.railroadNameTextField.setText(this._train.getRailroadName());
            this.showTimesCheckBox.setSelected(this._train.isShowArrivalAndDepartureTimesEnabled());
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainManifestOptions", true);
        this.pack();
        this.setMinimumSize(new Dimension(400, 250));
        this.setVisible(true);
    }

    private void updateLogoButtons() {
        if (this._train != null) {
            boolean flag = this._train.getManifestLogoPathName().isEmpty();
            this.addLogoButton.setVisible(flag);
            this.removeLogoButton.setVisible(!flag);
            this.logoURL.setText(this._train.getManifestLogoPathName());
            this.pack();
        }
    }

    private File selectFile() {
        if (this.fc == null) {
            log.error("Could not find user directory");
        } else {
            this.fc.setDialogTitle(Bundle.getMessage("FindDesiredImage"));
            this.fc.rescanCurrentDirectory();
            int retVal = this.fc.showOpenDialog(null);
            if (retVal == 0) {
                return this.fc.getSelectedFile();
            }
        }
        return null;
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.addLogoButton) {
            log.debug("add logo button pressed");
            File f = this.selectFile();
            if (f != null && this._train != null) {
                this._train.setManifestLogoPathName(FileUtil.getPortableFilename(f));
            }
            this.updateLogoButtons();
        }
        if (ae.getSource() == this.removeLogoButton) {
            log.debug("remove logo button pressed");
            if (this._train != null) {
                this._train.setManifestLogoPathName("");
            }
            this.updateLogoButtons();
        }
        if (ae.getSource() == this.saveButton) {
            if (this._train != null) {
                this._train.setRailroadName(this.railroadNameTextField.getText());
                this._train.setShowArrivalAndDepartureTimes(this.showTimesCheckBox.isSelected());
                this._train.setModified(true);
            }
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }
}

