/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.gui.TrainEditFrame;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.script.JmriScriptEngineManager;
import jmri.script.swing.ScriptFileChooser;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainScriptFrame
extends OperationsFrame {
    TrainManager manager;
    TrainManagerXml managerXml;
    Train _train = null;
    JPanel pBuildScript = new JPanel();
    JPanel pAfterBuildScript = new JPanel();
    JPanel pMoveScript = new JPanel();
    JPanel pTerminationScript = new JPanel();
    JScrollPane buildScriptPane;
    JScrollPane afterBuildScriptPane;
    JScrollPane moveScriptPane;
    JScrollPane terminationScriptPane;
    JLabel trainName = new JLabel();
    JLabel trainDescription = new JLabel();
    JButton addBuildScriptButton = new JButton(Bundle.getMessage("AddScript"));
    JButton addAfterBuildScriptButton = new JButton(Bundle.getMessage("AddScript"));
    JButton addMoveScriptButton = new JButton(Bundle.getMessage("AddScript"));
    JButton addTerminationScriptButton = new JButton(Bundle.getMessage("AddScript"));
    JButton runBuildScriptButton = new JButton(Bundle.getMessage("RunScripts"));
    JButton runAfterBuildScriptButton = new JButton(Bundle.getMessage("RunScripts"));
    JButton runMoveScriptButton = new JButton(Bundle.getMessage("RunScripts"));
    JButton runTerminationScriptButton = new JButton(Bundle.getMessage("RunScripts"));
    JButton saveTrainButton = new JButton(Bundle.getMessage("SaveTrain"));
    ScriptFileChooser fc = new ScriptFileChooser(FileUtil.getUserFilesPath());
    private static final Logger log = LoggerFactory.getLogger(TrainScriptFrame.class);

    public TrainScriptFrame() {
        super(Bundle.getMessage("MenuItemScripts"));
    }

    public void initComponents(TrainEditFrame parent) {
        this.buildScriptPane = new JScrollPane(this.pBuildScript);
        this.buildScriptPane.setVerticalScrollBarPolicy(20);
        this.buildScriptPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScriptsBeforeBuild")));
        this.afterBuildScriptPane = new JScrollPane(this.pAfterBuildScript);
        this.afterBuildScriptPane.setVerticalScrollBarPolicy(20);
        this.afterBuildScriptPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScriptsAfterBuild")));
        this.moveScriptPane = new JScrollPane(this.pMoveScript);
        this.moveScriptPane.setVerticalScrollBarPolicy(20);
        this.moveScriptPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScriptsWhenMoved")));
        this.terminationScriptPane = new JScrollPane(this.pTerminationScript);
        this.terminationScriptPane.setVerticalScrollBarPolicy(20);
        this.terminationScriptPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScriptsWhenTerminated")));
        parent.setChildFrame(this);
        this._train = parent._train;
        this.manager = InstanceManager.getDefault(TrainManager.class);
        this.managerXml = InstanceManager.getDefault(TrainManagerXml.class);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 0));
        JPanel pName = new JPanel();
        pName.setLayout(new GridBagLayout());
        pName.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Name")));
        this.addItem(pName, this.trainName, 0, 0);
        JPanel pDesc = new JPanel();
        pDesc.setLayout(new GridBagLayout());
        pDesc.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Description")));
        this.addItem(pDesc, this.trainDescription, 0, 0);
        p1.add(pName);
        p1.add(pDesc);
        this.updateBuildScriptPanel();
        this.updateAfterBuildScriptPanel();
        this.updateMoveScriptPanel();
        this.updateTerminationScriptPanel();
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.saveTrainButton, 3, 0);
        this.getContentPane().add(p1);
        this.getContentPane().add(this.buildScriptPane);
        this.getContentPane().add(this.afterBuildScriptPane);
        this.getContentPane().add(this.moveScriptPane);
        this.getContentPane().add(this.terminationScriptPane);
        this.getContentPane().add(pB);
        this.addButtonAction(this.addBuildScriptButton);
        this.addButtonAction(this.addAfterBuildScriptButton);
        this.addButtonAction(this.addMoveScriptButton);
        this.addButtonAction(this.addTerminationScriptButton);
        this.addButtonAction(this.runBuildScriptButton);
        this.addButtonAction(this.runAfterBuildScriptButton);
        this.addButtonAction(this.runMoveScriptButton);
        this.addButtonAction(this.runTerminationScriptButton);
        this.addButtonAction(this.saveTrainButton);
        if (this._train != null) {
            this.trainName.setText(this._train.getName());
            this.trainDescription.setText(this._train.getDescription());
            this.enableButtons(true);
        } else {
            this.enableButtons(false);
        }
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainScripts", true);
        this.initMinimumSize();
    }

    private void updateBuildScriptPanel() {
        this.pBuildScript.removeAll();
        this.pBuildScript.setLayout(new GridBagLayout());
        this.addItem(this.pBuildScript, this.addBuildScriptButton, 0, 0);
        if (this._train != null) {
            List<String> scripts = this._train.getBuildScripts();
            if (scripts.size() > 0) {
                this.addItem(this.pBuildScript, this.runBuildScriptButton, 1, 0);
            }
            for (int i = 0; i < scripts.size(); ++i) {
                JButton removeBuildScripts = new JButton(Bundle.getMessage("RemoveScript"));
                removeBuildScripts.setName(scripts.get(i));
                removeBuildScripts.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrainScriptFrame.this.buttonActionRemoveBuildScript(e);
                    }
                });
                this.addButtonAction(removeBuildScripts);
                JLabel pathname = new JLabel(scripts.get(i));
                this.addItem(this.pBuildScript, removeBuildScripts, 0, i + 1);
                this.addItem(this.pBuildScript, pathname, 1, i + 1);
            }
        }
    }

    private void updateAfterBuildScriptPanel() {
        this.pAfterBuildScript.removeAll();
        this.pAfterBuildScript.setLayout(new GridBagLayout());
        this.addItem(this.pAfterBuildScript, this.addAfterBuildScriptButton, 0, 0);
        if (this._train != null) {
            List<String> scripts = this._train.getAfterBuildScripts();
            if (scripts.size() > 0) {
                this.addItem(this.pAfterBuildScript, this.runAfterBuildScriptButton, 1, 0);
            }
            for (int i = 0; i < scripts.size(); ++i) {
                JButton removeAfterBuildScripts = new JButton(Bundle.getMessage("RemoveScript"));
                removeAfterBuildScripts.setName(scripts.get(i));
                removeAfterBuildScripts.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrainScriptFrame.this.buttonActionRemoveAfterBuildScript(e);
                    }
                });
                this.addButtonAction(removeAfterBuildScripts);
                JLabel pathname = new JLabel(scripts.get(i));
                this.addItem(this.pAfterBuildScript, removeAfterBuildScripts, 0, i + 1);
                this.addItem(this.pAfterBuildScript, pathname, 1, i + 1);
            }
        }
    }

    private void updateMoveScriptPanel() {
        this.pMoveScript.removeAll();
        this.pMoveScript.setLayout(new GridBagLayout());
        this.addItem(this.pMoveScript, this.addMoveScriptButton, 0, 0);
        if (this._train != null) {
            List<String> scripts = this._train.getMoveScripts();
            if (scripts.size() > 0) {
                this.addItem(this.pMoveScript, this.runMoveScriptButton, 1, 0);
            }
            for (int i = 0; i < scripts.size(); ++i) {
                JButton removeMoveScripts = new JButton(Bundle.getMessage("RemoveScript"));
                removeMoveScripts.setName(scripts.get(i));
                removeMoveScripts.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrainScriptFrame.this.buttonActionRemoveMoveScript(e);
                    }
                });
                this.addButtonAction(removeMoveScripts);
                JLabel pathname = new JLabel(scripts.get(i));
                this.addItem(this.pMoveScript, removeMoveScripts, 0, i + 1);
                this.addItem(this.pMoveScript, pathname, 1, i + 1);
            }
        }
    }

    private void updateTerminationScriptPanel() {
        this.pTerminationScript.removeAll();
        this.pTerminationScript.setLayout(new GridBagLayout());
        this.addItem(this.pTerminationScript, this.addTerminationScriptButton, 0, 0);
        if (this._train != null) {
            List<String> scripts = this._train.getTerminationScripts();
            if (scripts.size() > 0) {
                this.addItem(this.pTerminationScript, this.runTerminationScriptButton, 1, 0);
            }
            for (int i = 0; i < scripts.size(); ++i) {
                JButton removeTerminationScripts = new JButton(Bundle.getMessage("RemoveScript"));
                removeTerminationScripts.setName(scripts.get(i));
                removeTerminationScripts.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TrainScriptFrame.this.buttonActionRemoveTerminationScript(e);
                    }
                });
                JLabel pathname = new JLabel(scripts.get(i));
                this.addItem(this.pTerminationScript, removeTerminationScripts, 0, i + 1);
                this.addItem(this.pTerminationScript, pathname, 1, i + 1);
            }
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (this._train != null) {
            File f;
            if (ae.getSource() == this.addBuildScriptButton) {
                log.debug("train add build script button activated");
                f = this.selectFile();
                if (f != null) {
                    this._train.addBuildScript(FileUtil.getPortableFilename(f));
                    this.updateBuildScriptPanel();
                    this.pack();
                }
            }
            if (ae.getSource() == this.addAfterBuildScriptButton) {
                log.debug("train add after build script button activated");
                f = this.selectFile();
                if (f != null) {
                    this._train.addAfterBuildScript(FileUtil.getPortableFilename(f));
                    this.updateAfterBuildScriptPanel();
                    this.pack();
                }
            }
            if (ae.getSource() == this.addMoveScriptButton) {
                log.debug("train add move script button activated");
                f = this.selectFile();
                if (f != null) {
                    this._train.addMoveScript(FileUtil.getPortableFilename(f));
                    this.updateMoveScriptPanel();
                    this.pack();
                }
            }
            if (ae.getSource() == this.addTerminationScriptButton) {
                log.debug("train add termination script button activated");
                f = this.selectFile();
                if (f != null) {
                    this._train.addTerminationScript(FileUtil.getPortableFilename(f));
                    this.updateTerminationScriptPanel();
                    this.pack();
                }
            }
            if (ae.getSource() == this.runBuildScriptButton) {
                this.runScripts(this._train.getBuildScripts());
            }
            if (ae.getSource() == this.runAfterBuildScriptButton) {
                this.runScripts(this._train.getAfterBuildScripts());
            }
            if (ae.getSource() == this.runMoveScriptButton) {
                this.runScripts(this._train.getMoveScripts());
            }
            if (ae.getSource() == this.runTerminationScriptButton) {
                this.runScripts(this._train.getTerminationScripts());
            }
            if (ae.getSource() == this.saveTrainButton) {
                log.debug("train save button activated");
                OperationsXml.save();
                if (Setup.isCloseWindowOnSaveEnabled()) {
                    this.dispose();
                }
            }
        }
    }

    public void buttonActionRemoveBuildScript(ActionEvent ae) {
        if (this._train != null) {
            JButton rbutton = (JButton)ae.getSource();
            log.debug("remove build script button activated {}", (Object)rbutton.getName());
            this._train.deleteBuildScript(rbutton.getName());
            this.updateBuildScriptPanel();
            this.pack();
        }
    }

    public void buttonActionRemoveAfterBuildScript(ActionEvent ae) {
        if (this._train != null) {
            JButton rbutton = (JButton)ae.getSource();
            log.debug("remove after build script button activated {}", (Object)rbutton.getName());
            this._train.deleteAfterBuildScript(rbutton.getName());
            this.updateAfterBuildScriptPanel();
            this.pack();
        }
    }

    public void buttonActionRemoveMoveScript(ActionEvent ae) {
        if (this._train != null) {
            JButton rbutton = (JButton)ae.getSource();
            log.debug("remove move script button activated {}", (Object)rbutton.getName());
            this._train.deleteMoveScript(rbutton.getName());
            this.updateMoveScriptPanel();
            this.pack();
        }
    }

    public void buttonActionRemoveTerminationScript(ActionEvent ae) {
        if (this._train != null) {
            JButton rbutton = (JButton)ae.getSource();
            log.debug("remove termination script button activated {}", (Object)rbutton.getName());
            this._train.deleteTerminationScript(rbutton.getName());
            this.updateTerminationScriptPanel();
            this.pack();
        }
    }

    private void runScripts(List<String> scripts) {
        for (String script : scripts) {
            String scriptPathname = FileUtil.getExternalFilename(script);
            File file = new File(scriptPathname);
            if (file.exists()) {
                JmriScriptEngineManager.getDefault().runScript(file);
                continue;
            }
            JmriJOptionPane.showMessageDialog(this, script, Bundle.getMessage("ScriptFileNotFound"), 0);
        }
    }

    private File selectFile() {
        if (this.fc == null) {
            log.error("Could not find user directory");
        } else {
            this.fc.setDialogTitle(Bundle.getMessage("FindDesiredScriptFile"));
            this.fc.rescanCurrentDirectory();
            int retVal = this.fc.showOpenDialog(null);
            if (retVal == 0) {
                return this.fc.getSelectedFile();
            }
        }
        return null;
    }

    private void enableButtons(boolean enabled) {
        this.addBuildScriptButton.setEnabled(enabled);
        this.addAfterBuildScriptButton.setEnabled(enabled);
        this.addMoveScriptButton.setEnabled(enabled);
        this.addTerminationScriptButton.setEnabled(enabled);
        this.saveTrainButton.setEnabled(enabled);
    }
}

