/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.jmrit.operations.trains.tools.PrintTrainsByCarTypesAction;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsByCarTypeFrame
extends OperationsFrame
implements PropertyChangeListener {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    ArrayList<JCheckBox> trainList = new ArrayList();
    JPanel trainCheckBoxes = new JPanel();
    JPanel pTrains;
    JButton clearButton = new JButton(Bundle.getMessage("ClearAll"));
    JButton setButton = new JButton(Bundle.getMessage("SelectAll"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    JCheckBox copyCheckBox = new JCheckBox(Bundle.getMessage("ButtonCopy"));
    JComboBox<String> typeComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    JComboBox<String> copyComboBox = InstanceManager.getDefault(CarTypes.class).getComboBox();
    private static final Logger log = LoggerFactory.getLogger(TrainsByCarTypeFrame.class);

    public TrainsByCarTypeFrame() {
        super(Bundle.getMessage("TitleModifyTrains"));
    }

    public void initComponents(String carType) {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel pCarType = new JPanel();
        pCarType.setLayout(new GridBagLayout());
        pCarType.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Type")));
        JPanel pCarCopy = new JPanel();
        pCarCopy.setLayout(new GridBagLayout());
        this.addItem(pCarCopy, this.copyComboBox, 0, 0);
        pCarCopy.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("CopyType")));
        this.addItem(pCarType, this.typeComboBox, 0, 0);
        this.addItem(pCarType, this.copyCheckBox, 1, 0);
        this.addItem(pCarType, pCarCopy, 2, 0);
        this.typeComboBox.setSelectedItem(carType);
        this.copyCheckBox.setToolTipText(Bundle.getMessage("TipCopyCarType"));
        this.pTrains = new JPanel();
        this.pTrains.setLayout(new GridBagLayout());
        JScrollPane trainPane = new JScrollPane(this.pTrains);
        trainPane.setVerticalScrollBarPolicy(20);
        trainPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("Trains")));
        this.updateTrains();
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new GridBagLayout());
        pButtons.setBorder(BorderFactory.createEtchedBorder());
        this.addItem(pButtons, this.clearButton, 0, 0);
        this.addItem(pButtons, this.setButton, 1, 0);
        this.addItem(pButtons, this.saveButton, 2, 0);
        this.getContentPane().add(pCarType);
        this.getContentPane().add(trainPane);
        this.getContentPane().add(pButtons);
        this.addComboBoxAction(this.typeComboBox);
        this.addComboBoxAction(this.copyComboBox);
        this.addButtonAction(this.setButton);
        this.addButtonAction(this.clearButton);
        this.addButtonAction(this.saveButton);
        this.addCheckBoxAction(this.copyCheckBox);
        this.trainManager.addPropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).addPropertyChangeListener(this);
        JMenuBar menuBar = new JMenuBar();
        JMenu toolMenu = new JMenu(Bundle.getMessage("MenuTools"));
        toolMenu.add(new PrintTrainsByCarTypesAction(false));
        toolMenu.add(new PrintTrainsByCarTypesAction(true));
        menuBar.add(toolMenu);
        this.setJMenuBar(menuBar);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_ModifyTrainsByCarType", true);
        this.setPreferredSize(null);
        this.initMinimumSize(new Dimension(300, 250));
    }

    @Override
    public void comboBoxActionPerformed(ActionEvent ae) {
        log.debug("combo box action");
        this.updateTrains();
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.save();
        }
        if (ae.getSource() == this.setButton) {
            this.selectCheckboxes(true);
        }
        if (ae.getSource() == this.clearButton) {
            this.selectCheckboxes(false);
        }
    }

    private void save() {
        if (this.copyCheckBox.isSelected() && JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("CopyCarType", this.typeComboBox.getSelectedItem(), this.copyComboBox.getSelectedItem()), Bundle.getMessage("CopyCarTypeTitle"), 0) != 0) {
            return;
        }
        log.debug("Save {} trains", (Object)this.trainList.size());
        this.removePropertyChangeTrains();
        for (JCheckBox cb : new ArrayList<JCheckBox>(this.trainList)) {
            Train train = this.trainManager.getTrainById(cb.getName());
            if (cb.isSelected()) {
                train.addTypeName((String)this.typeComboBox.getSelectedItem());
                continue;
            }
            train.deleteTypeName((String)this.typeComboBox.getSelectedItem());
        }
        OperationsXml.save();
        this.updateTrains();
        if (Setup.isCloseWindowOnSaveEnabled()) {
            this.dispose();
        }
    }

    private void updateTrains() {
        log.debug("update trains");
        this.removePropertyChangeTrains();
        this.trainList.clear();
        int x = 0;
        this.pTrains.removeAll();
        String carType = (String)this.typeComboBox.getSelectedItem();
        if (this.copyCheckBox.isSelected()) {
            carType = (String)this.copyComboBox.getSelectedItem();
        }
        List<Train> trains = this.trainManager.getTrainsByNameList();
        for (Train train : trains) {
            train.addPropertyChangeListener(this);
            JCheckBox cb = new JCheckBox(train.getName());
            cb.setName(train.getId());
            cb.setToolTipText(Bundle.getMessage("TipTrainCarType", carType));
            this.addCheckBoxAction(cb);
            this.trainList.add(cb);
            cb.setSelected(train.isTypeNameAccepted(carType));
            this.addItemLeft(this.pTrains, cb, 0, x);
            JLabel description = new JLabel(train.getDescription());
            this.addItemLeft(this.pTrains, description, 1, x++);
        }
        this.pTrains.revalidate();
        this.repaint();
    }

    private void updateComboBox() {
        log.debug("update combobox");
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.typeComboBox);
        InstanceManager.getDefault(CarTypes.class).updateComboBox(this.copyComboBox);
    }

    private void selectCheckboxes(boolean b) {
        for (JCheckBox checkBox : new ArrayList<JCheckBox>(this.trainList)) {
            checkBox.setSelected(b);
        }
    }

    @Override
    public void checkBoxActionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.copyCheckBox) {
            this.updateTrains();
        } else {
            JCheckBox cb = (JCheckBox)ae.getSource();
            log.debug("Checkbox {} text: {}", (Object)cb.getName(), (Object)cb.getText());
            if (this.trainList.contains(cb)) {
                log.debug("Checkbox train {}", (Object)cb.getText());
            } else {
                log.error("Error checkbox not found");
            }
        }
    }

    private void removePropertyChangeTrains() {
        for (JCheckBox checkBox : new ArrayList<JCheckBox>(this.trainList)) {
            Train train = this.trainManager.getTrainById(checkBox.getName());
            if (train == null) continue;
            train.removePropertyChangeListener(this);
        }
    }

    @Override
    public void dispose() {
        this.trainManager.removePropertyChangeListener(this);
        InstanceManager.getDefault(CarTypes.class).removePropertyChangeListener(this);
        this.removePropertyChangeTrains();
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        log.debug("Property change {} old: {} new: {}", new Object[]{e.getPropertyName(), e.getOldValue(), e.getNewValue()});
        if (e.getPropertyName().equals("TrainsListLength") || e.getPropertyName().equals("TrainTypes") || e.getPropertyName().equals("TrainName") || e.getPropertyName().equals("TrainDescription")) {
            this.updateTrains();
        }
        if (e.getPropertyName().equals("CarTypes Length") || e.getPropertyName().equals("CarTypes Name")) {
            this.updateComboBox();
        }
    }
}

