/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.tools;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jmri.InstanceManager;
import jmri.jmrit.operations.OperationsFrame;
import jmri.jmrit.operations.OperationsXml;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.tools.Bundle;
import jmri.script.JmriScriptEngineManager;
import jmri.script.swing.ScriptFileChooser;
import jmri.util.FileUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainsScriptFrame
extends OperationsFrame {
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    JPanel pStartUpScript = new JPanel();
    JPanel pShutDownScript = new JPanel();
    JScrollPane startUpScriptPane;
    JScrollPane shutDownScriptPane;
    JButton addStartUpScriptButton = new JButton(Bundle.getMessage("AddScript"));
    JButton addShutDownScriptButton = new JButton(Bundle.getMessage("AddScript"));
    JButton runStartUpScriptButton = new JButton(Bundle.getMessage("RunScripts"));
    JButton runShutDownScriptButton = new JButton(Bundle.getMessage("RunScripts"));
    JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
    ScriptFileChooser fc;
    private static final Logger log = LoggerFactory.getLogger((String)TrainsScriptFrame.class.getName());

    @Override
    public void initComponents() {
        this.startUpScriptPane = new JScrollPane(this.pStartUpScript);
        this.startUpScriptPane.setVerticalScrollBarPolicy(20);
        this.startUpScriptPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScriptsStartUp")));
        this.shutDownScriptPane = new JScrollPane(this.pShutDownScript);
        this.shutDownScriptPane.setVerticalScrollBarPolicy(20);
        this.shutDownScriptPane.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("ScriptsShutDown")));
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.updateStartUpScriptPanel();
        this.updateShutDownScriptPanel();
        JPanel pB = new JPanel();
        pB.setLayout(new GridBagLayout());
        this.addItem(pB, this.saveButton, 3, 0);
        this.getContentPane().add(this.startUpScriptPane);
        this.getContentPane().add(this.shutDownScriptPane);
        this.getContentPane().add(pB);
        this.addButtonAction(this.addStartUpScriptButton);
        this.addButtonAction(this.addShutDownScriptButton);
        this.addButtonAction(this.runStartUpScriptButton);
        this.addButtonAction(this.runShutDownScriptButton);
        this.addButtonAction(this.saveButton);
        this.enableButtons(true);
        this.addHelpMenu("package.jmri.jmrit.operations.Operations_TrainScripts", true);
        this.packFrame();
        this.initMinimumSize();
    }

    private void updateStartUpScriptPanel() {
        this.pStartUpScript.removeAll();
        this.pStartUpScript.setLayout(new GridBagLayout());
        this.addItem(this.pStartUpScript, this.addStartUpScriptButton, 0, 0);
        List<String> scripts = this.trainManager.getStartUpScripts();
        if (scripts.size() > 0) {
            this.addItem(this.pStartUpScript, this.runStartUpScriptButton, 1, 0);
        }
        for (int i = 0; i < scripts.size(); ++i) {
            JButton removeStartUpScripts = new JButton(Bundle.getMessage("RemoveScript"));
            removeStartUpScripts.setName(scripts.get(i));
            removeStartUpScripts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrainsScriptFrame.this.buttonActionRemoveStartUpScript(e);
                }
            });
            this.addButtonAction(removeStartUpScripts);
            JLabel pathname = new JLabel(scripts.get(i));
            this.addItem(this.pStartUpScript, removeStartUpScripts, 0, i + 1);
            this.addItem(this.pStartUpScript, pathname, 1, i + 1);
        }
    }

    private void updateShutDownScriptPanel() {
        this.pShutDownScript.removeAll();
        this.pShutDownScript.setLayout(new GridBagLayout());
        this.addItem(this.pShutDownScript, this.addShutDownScriptButton, 0, 0);
        List<String> scripts = this.trainManager.getShutDownScripts();
        if (scripts.size() > 0) {
            this.addItem(this.pShutDownScript, this.runShutDownScriptButton, 1, 0);
        }
        for (int i = 0; i < scripts.size(); ++i) {
            JButton removeShutDownScripts = new JButton(Bundle.getMessage("RemoveScript"));
            removeShutDownScripts.setName(scripts.get(i));
            removeShutDownScripts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TrainsScriptFrame.this.buttonActionRemoveShutDownScript(e);
                }
            });
            JLabel pathname = new JLabel(scripts.get(i));
            this.addItem(this.pShutDownScript, removeShutDownScripts, 0, i + 1);
            this.addItem(this.pShutDownScript, pathname, 1, i + 1);
        }
    }

    @Override
    public void buttonActionPerformed(ActionEvent ae) {
        File f;
        if (ae.getSource() == this.addStartUpScriptButton) {
            log.debug("train add move script button activated");
            f = this.selectFile();
            if (f != null) {
                this.trainManager.addStartUpScript(FileUtil.getPortableFilename(f));
                this.updateStartUpScriptPanel();
                this.packFrame();
            }
        }
        if (ae.getSource() == this.addShutDownScriptButton) {
            log.debug("train add termination script button activated");
            f = this.selectFile();
            if (f != null) {
                this.trainManager.addShutDownScript(FileUtil.getPortableFilename(f));
                this.updateShutDownScriptPanel();
                this.packFrame();
            }
        }
        if (ae.getSource() == this.runStartUpScriptButton) {
            this.runScripts(this.trainManager.getStartUpScripts());
        }
        if (ae.getSource() == this.runShutDownScriptButton) {
            this.runScripts(this.trainManager.getShutDownScripts());
        }
        if (ae.getSource() == this.saveButton) {
            log.debug("Save button activated");
            OperationsXml.save();
            if (Setup.isCloseWindowOnSaveEnabled()) {
                this.dispose();
            }
        }
    }

    public void buttonActionRemoveStartUpScript(ActionEvent ae) {
        JButton rbutton = (JButton)ae.getSource();
        log.debug("remove move script button activated {}", (Object)rbutton.getName());
        this.trainManager.deleteStartUpScript(rbutton.getName());
        this.updateStartUpScriptPanel();
        this.packFrame();
    }

    public void buttonActionRemoveShutDownScript(ActionEvent ae) {
        JButton rbutton = (JButton)ae.getSource();
        log.debug("remove termination script button activated {}", (Object)rbutton.getName());
        this.trainManager.deleteShutDownScript(rbutton.getName());
        this.updateShutDownScriptPanel();
        this.packFrame();
    }

    private File selectFile() {
        if (this.fc == null) {
            this.fc = new ScriptFileChooser(FileUtil.getUserFilesPath());
            this.fc.setDialogTitle(Bundle.getMessage("FindDesiredScriptFile"));
        }
        this.fc.rescanCurrentDirectory();
        int retVal = this.fc.showOpenDialog(null);
        if (retVal == 0) {
            return this.fc.getSelectedFile();
        }
        return null;
    }

    private void enableButtons(boolean enabled) {
        this.addStartUpScriptButton.setEnabled(enabled);
        this.addShutDownScriptButton.setEnabled(enabled);
        this.saveButton.setEnabled(enabled);
    }

    private void runScripts(List<String> scripts) {
        for (String script : scripts) {
            String scriptPathname = FileUtil.getExternalFilename(script);
            File file = new File(scriptPathname);
            if (file.exists()) {
                JmriScriptEngineManager.getDefault().runScript(file);
                continue;
            }
            JmriJOptionPane.showMessageDialog(this, script, Bundle.getMessage("ScriptFileNotFound"), 0);
        }
    }

    private void packFrame() {
        this.setPreferredSize(null);
        this.pack();
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

