/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.trainbuilder;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.JsonManifest;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManifest;
import jmri.jmrit.operations.trains.csv.TrainCsvManifest;
import jmri.jmrit.operations.trains.trainbuilder.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainBuilderCars;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainBuilder
extends TrainBuilderCars {
    private static final Logger log = LoggerFactory.getLogger(TrainBuilder.class);

    public boolean build(Train train) {
        this._train = train;
        try {
            this.build();
            return true;
        }
        catch (BuildFailedException e) {
            this.buildFailed(e);
            return false;
        }
    }

    private void build() throws BuildFailedException {
        this._startTime = new Date();
        log.debug("Building train ({})", (Object)this._train.getName());
        this._train.setStatusCode(1);
        this._train.setBuilt(false);
        this._train.setLeadEngine(null);
        this.createBuildReportFile();
        this.showBuildReportInfo();
        this.setUpRoute();
        this.showTrainBuildOptions();
        this.showSpecificTrainBuildOptions();
        this.showAndInitializeTrainRoute();
        this.showIfLocalSwitcher();
        this.showTrainRequirements();
        this.showTrainServices();
        this.getAndRemoveEnginesFromList();
        this.showEnginesByLocation();
        this.determineIfTrainTerminatesIntoStaging();
        this.determineIfTrainDepartsStagingAndAddEngines();
        this.addEnginesToTrain();
        this.showTrainCarRoads();
        this.showTrainCabooseRoads();
        this.showTrainCarTypes();
        this.showTrainLoadNames();
        this.getCarList();
        this.adjustCarsInStaging();
        this.showCarsByLocation();
        this.sortCarsOnFifoLifoTracks();
        this.saveCarFinalDestinations();
        this.addCabooseOrFredToTrain();
        this.removeCaboosesAndCarsWithFred();
        this.blockCarsFromStaging();
        this.addCarsToTrain();
        this.checkStuckCarsInStaging();
        this.showTrainBuildStatus();
        this.checkEngineHP();
        this.checkNumnberOfEnginesNeededHPT();
        this.showCarsNotRoutable();
        if (this._warnings > 0) {
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildWarningMsg", this._train.getName(), this._warnings));
        }
        TrainBuilder.addLine(this._buildReport, "5", Bundle.getMessage("buildTime", this._train.getName(), new Date().getTime() - this._startTime.getTime()));
        this._buildReport.flush();
        this._buildReport.close();
        this.createManifests();
        for (Location location : this._modifiedLocations) {
            location.setStatus(Location.MODIFIED);
        }
        this._train.setPrinted(false);
        this._train.setSwitchListStatus("");
        this._train.setCurrentLocation(this._train.getTrainDepartsRouteLocation());
        this._train.setBuilt(true);
        this._train.moveTrainIcon(this._train.getTrainDepartsRouteLocation());
        log.debug("Done building train ({})", (Object)this._train.getName());
        this.showWarningMessage();
    }

    private void determineIfTrainTerminatesIntoStaging() throws BuildFailedException {
        this._terminateStageTrack = null;
        List<Track> stagingTracksTerminate = this._terminateLocation.getTracksByMoves("Staging");
        if (stagingTracksTerminate.size() > 0) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildTerminateStaging", this._terminateLocation.getName(), Integer.toString(stagingTracksTerminate.size())));
            if (stagingTracksTerminate.size() > 1 && Setup.isStagingPromptToEnabled()) {
                this._terminateStageTrack = this.promptToStagingDialog();
                this._startTime = new Date();
            } else if (this._departLocation == this._terminateLocation && Setup.isBuildAggressive() && Setup.isStagingTrackImmediatelyAvail()) {
                TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildStagingReturn", this._terminateLocation.getName()));
            } else {
                for (Track track : stagingTracksTerminate) {
                    if (!this.checkTerminateStagingTrack(track)) continue;
                    this._terminateStageTrack = track;
                    TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildStagingAvail", this._terminateStageTrack.getName(), this._terminateLocation.getName()));
                    break;
                }
            }
            if (this._terminateStageTrack == null) {
                if (this._departLocation == this._terminateLocation && Setup.isBuildAggressive() && Setup.isStagingTrackImmediatelyAvail()) {
                    log.debug("Train is returning to same track in staging");
                } else {
                    TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildErrorStagingFullNote"));
                    throw new BuildFailedException(Bundle.getMessage("buildErrorStagingFull", this._terminateLocation.getName()));
                }
            }
        }
    }

    private void determineIfTrainDepartsStagingAndAddEngines() throws BuildFailedException {
        RouteLocation engineTerminatesFirstLeg = this._train.getTrainTerminatesRouteLocation();
        if ((this._train.getSecondLegOptions() & 1) == 1 && this._train.getSecondLegStartRouteLocation() != null) {
            engineTerminatesFirstLeg = this._train.getSecondLegStartRouteLocation();
        } else if ((this._train.getThirdLegOptions() & 1) == 1 && this._train.getThirdLegStartRouteLocation() != null) {
            engineTerminatesFirstLeg = this._train.getThirdLegStartRouteLocation();
        }
        List<Track> stagingTracks = this._departLocation.getTracksByMoves("Staging");
        if (stagingTracks.size() > 0) {
            TrainBuilder.addLine(this._buildReport, "3", " ");
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildDepartStaging", this._departLocation.getName(), Integer.toString(stagingTracks.size())));
            if (stagingTracks.size() > 1 && Setup.isStagingPromptFromEnabled()) {
                this.setDepartureTrack(this.promptFromStagingDialog());
                this._startTime = new Date();
                if (this._departStageTrack == null) {
                    this.showTrainRequirements();
                    throw new BuildFailedException(Bundle.getMessage("buildErrorStagingEmpty", this._departLocation.getName()));
                }
            } else {
                for (Track track : stagingTracks) {
                    if (!this.checkDepartureStagingTrack(track)) {
                        TrainBuilder.addLine(this._buildReport, "7", Bundle.getMessage("buildStagingTrackRestriction", track.getName(), this._train.getName()));
                        continue;
                    }
                    this.setDepartureTrack(track);
                    if (this.getEngines(this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad(), this._train.getTrainDepartsRouteLocation(), engineTerminatesFirstLeg)) {
                        TrainBuilder.addLine(this._buildReport, "7", Bundle.getMessage("buildDoneAssignEnginesStaging"));
                        break;
                    }
                    this.setDepartureTrack(null);
                }
            }
            if (this._departStageTrack == null) {
                this.showTrainRequirements();
                throw new BuildFailedException(Bundle.getMessage("buildErrorStagingEmpty", this._departLocation.getName()));
            }
        }
        this._train.setTerminationTrack(this._terminateStageTrack);
        this._train.setDepartureTrack(this._departStageTrack);
    }

    private void addCabooseOrFredToTrain() throws BuildFailedException {
        RouteLocation cabooseOrFredTerminatesFirstLeg = this._train.getTrainTerminatesRouteLocation();
        RouteLocation cabooseOrFredTerminatesSecondLeg = this._train.getTrainTerminatesRouteLocation();
        if ((this._train.getSecondLegOptions() & 8) == 8 || (this._train.getSecondLegOptions() & 4) == 4) {
            cabooseOrFredTerminatesFirstLeg = this._train.getSecondLegStartRouteLocation();
        } else if ((this._train.getThirdLegOptions() & 8) == 8 || (this._train.getThirdLegOptions() & 4) == 4) {
            cabooseOrFredTerminatesFirstLeg = this._train.getThirdLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 8) == 8 || (this._train.getThirdLegOptions() & 4) == 4) {
            cabooseOrFredTerminatesSecondLeg = this._train.getThirdLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 4) == 4 && this._train.getThirdLegStartRouteLocation() != null && this._train.getTrainTerminatesRouteLocation() != null) {
            this.getCaboose(this._train.getThirdLegCabooseRoad(), this._thirdLeadEngine, this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation(), true);
        }
        if ((this._train.getSecondLegOptions() & 4) == 4 && this._train.getSecondLegStartRouteLocation() != null && cabooseOrFredTerminatesSecondLeg != null) {
            this.getCaboose(this._train.getSecondLegCabooseRoad(), this._secondLeadEngine, this._train.getSecondLegStartRouteLocation(), cabooseOrFredTerminatesSecondLeg, true);
        }
        this.getCaboose(this._train.getCabooseRoad(), this._train.getLeadEngine(), this._train.getTrainDepartsRouteLocation(), cabooseOrFredTerminatesFirstLeg, this._train.isCabooseNeeded());
        this.getCarWithFred(this._train.getCabooseRoad(), this._train.getTrainDepartsRouteLocation(), cabooseOrFredTerminatesFirstLeg);
    }

    private void addCarsToTrain() throws BuildFailedException {
        TrainBuilder.addLine(this._buildReport, "3", " ");
        TrainBuilder.addLine(this._buildReport, "3", Bundle.getMessage("buildTrain", this._train.getNumberCarsRequested(), this._train.getName(), this._carList.size()));
        if (Setup.isBuildAggressive() && !this._train.isBuildTrainNormalEnabled()) {
            int pass = 0;
            while (pass++ < Setup.getNumberPasses()) {
                this.addCarsToTrain(pass, false);
            }
            this.secondAttemptNormalBuild();
        } else {
            this.addCarsToTrain(Setup.getNumberPasses(), true);
        }
    }

    private void secondAttemptNormalBuild() throws BuildFailedException {
        if (Setup.isStagingTryNormalBuildEnabled() && this.isCarStuckStaging()) {
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildFailedTryNormalMode"));
            TrainBuilder.addLine(this._buildReport, "1", " ");
            this._train.reset();
            this._train.setStatusCode(1);
            this._train.setLeadEngine(null);
            this._train.setDepartureTrack(this._departStageTrack);
            this._train.setTerminationTrack(this._terminateStageTrack);
            this.showAndInitializeTrainRoute();
            this.getAndRemoveEnginesFromList();
            this.addEnginesToTrain();
            this.getCarList();
            this.adjustCarsInStaging();
            this.showCarsByLocation();
            this.addCabooseOrFredToTrain();
            this.removeCaboosesAndCarsWithFred();
            this.saveCarFinalDestinations();
            this.blockCarsFromStaging();
            this.addCarsToTrain(Setup.getNumberPasses(), true);
        }
    }

    private void addCarsToTrain(int pass, boolean normal) throws BuildFailedException {
        TrainBuilder.addLine(this._buildReport, "3", " ");
        if (normal) {
            TrainBuilder.addLine(this._buildReport, "3", Bundle.getMessage("NormalModeWhenBuilding"));
        } else {
            TrainBuilder.addLine(this._buildReport, "3", Bundle.getMessage("buildMultiplePass", pass, Setup.getNumberPasses()));
        }
        for (RouteLocation rl : this._routeList) {
            if (this._train.isLocationSkipped(rl)) {
                TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildLocSkipped", rl.getName(), rl.getId(), this._train.getName()));
                continue;
            }
            if (!rl.isPickUpAllowed() && !rl.isLocalMovesAllowed()) {
                TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildLocNoPickups", this._train.getRoute().getName(), rl.getId(), rl.getName()));
                continue;
            }
            if (rl != this._train.getTrainDepartsRouteLocation() && rl.getLocation().isStaging()) {
                TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildNoPickupsFromStaging", rl.getName()));
                continue;
            }
            if (!this.checkPickUpTrainDirection(rl)) continue;
            this._completedMoves = 0;
            this._reqNumOfMoves = rl.getMaxCarMoves() - rl.getCarMoves();
            if (!normal) {
                if (rl == this._train.getTrainDepartsRouteLocation()) {
                    this._reqNumOfMoves = (rl.getMaxCarMoves() - rl.getCarMoves()) * pass / Setup.getNumberPasses();
                } else if (pass == 1) {
                    this._reqNumOfMoves = (rl.getMaxCarMoves() - rl.getCarMoves()) / 2;
                    int remainder = (rl.getMaxCarMoves() - rl.getCarMoves()) % 2;
                    if (remainder > 0) {
                        ++this._reqNumOfMoves;
                    }
                }
            }
            if (rl == this._train.getTrainDepartsRouteLocation()) {
                if (pass == 1) {
                    this.makeAdjustmentsIfDepartingStaging();
                } else {
                    this.restoreCarsIfDepartingStaging();
                }
            }
            int saveReqMoves = this._reqNumOfMoves;
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildLocReqMoves", rl.getName(), rl.getId(), this._reqNumOfMoves, rl.getMaxCarMoves() - rl.getCarMoves(), rl.getMaxCarMoves()));
            TrainBuilder.addLine(this._buildReport, "5", " ");
            if (rl == this._train.getTrainDepartsRouteLocation()) {
                this.showLoadGenerationOptionsStaging();
            }
            this._carIndex = 0;
            this.findDestinationsForCarsFromLocation(rl, false);
            if (Setup.isBuildAggressive() && saveReqMoves != this._reqNumOfMoves) {
                log.debug("Perform extra pass at location ({})", (Object)rl.getName());
                if (this._reqNumOfMoves < (rl.getMaxCarMoves() - rl.getCarMoves()) / 2) {
                    this._reqNumOfMoves = (rl.getMaxCarMoves() - rl.getCarMoves()) / 2;
                }
                this.findDestinationsForCarsFromLocation(rl, true);
                if (this.redirectCarsFromAlternateTrack()) {
                    TrainBuilder.addLine(this._buildReport, "7", " ");
                }
            }
            if (rl == this._train.getTrainDepartsRouteLocation() && pass == Setup.getNumberPasses() && this.isCarStuckStaging()) {
                return;
            }
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildStatusMsg", saveReqMoves <= this._completedMoves ? Bundle.getMessage("Success") : Bundle.getMessage("Partial"), Integer.toString(this._completedMoves), Integer.toString(saveReqMoves), rl.getName(), this._train.getName()));
            if (this._reqNumOfMoves > 0 || pass != Setup.getNumberPasses()) continue;
            this.showCarsNotMoved(rl);
        }
    }

    private void showTrainBuildStatus() {
        if (this._numberCars < this._train.getNumberCarsRequested()) {
            this._train.setStatusCode(20);
            TrainBuilder.addLine(this._buildReport, "1", Train.PARTIAL_BUILT + " " + this._train.getNumberCarsWorked() + "/" + this._train.getNumberCarsRequested() + " " + Bundle.getMessage("cars"));
        } else {
            this._train.setStatusCode(16);
            TrainBuilder.addLine(this._buildReport, "1", Train.BUILT + " " + this._train.getNumberCarsWorked() + " " + Bundle.getMessage("cars"));
        }
    }

    private void createManifests() throws BuildFailedException {
        new TrainManifest(this._train);
        try {
            new JsonManifest(this._train).build();
        }
        catch (IOException ex) {
            log.error("Unable to create JSON manifest: {}", (Object)ex.getLocalizedMessage());
            throw new BuildFailedException(ex);
        }
        new TrainCsvManifest(this._train);
    }

    private void showWarningMessage() {
        if (this.trainManager.isBuildMessagesEnabled() && this._warnings > 0) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("buildCheckReport", this._train.getName(), this._train.getDescription()), Bundle.getMessage("buildWarningMsg", this._train.getName(), this._warnings), 2);
        }
    }

    private void buildFailed(BuildFailedException e) {
        String msg = e.getMessage();
        this._train.setBuildFailedMessage(msg);
        this._train.setBuildFailed(true);
        log.debug(msg);
        if (this.trainManager.isBuildMessagesEnabled()) {
            String trainName = this._train.getName();
            String trainDescription = this._train.getDescription();
            if (e.getExceptionType().equals("normal")) {
                JmriJOptionPane.showMessageDialog(null, msg, Bundle.getMessage("buildErrorMsg", trainName, trainDescription), 0);
            } else {
                Object[] options = new Object[]{Bundle.getMessage("buttonRemoveCars"), Bundle.getMessage("ButtonOK")};
                int results = JmriJOptionPane.showOptionDialog(null, msg, Bundle.getMessage("buildErrorMsg", trainName, trainDescription), -1, 0, null, options, options[1]);
                if (results == 0) {
                    log.debug("User requested that cars be removed from staging track");
                    this.removeCarsFromStaging();
                }
            }
            int size = this.carManager.getList(this._train).size();
            if (size > 0) {
                if (JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("buildCarsResetTrain", size, trainName), Bundle.getMessage("buildResetTrain"), 0) == 0) {
                    this._train.setStatusCode(0);
                }
            } else {
                size = this.engineManager.getList(this._train).size();
                if (size > 0 && JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("buildEnginesResetTrain", size, trainName), Bundle.getMessage("buildResetTrain"), 0) == 0) {
                    this._train.setStatusCode(0);
                }
            }
        } else {
            this._train.setStatusCode(0);
        }
        this._train.setStatusCode(2);
        if (this._buildReport != null) {
            TrainBuilder.addLine(this._buildReport, "1", msg);
            TrainBuilder.addLine(this._buildReport, "1", Bundle.getMessage("buildFailedMsg", this._train.getName()));
            this._buildReport.flush();
            this._buildReport.close();
        }
    }
}

