/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.trainbuilder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.router.Router;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManagerXml;
import jmri.jmrit.operations.trains.schedules.TrainSchedule;
import jmri.jmrit.operations.trains.schedules.TrainScheduleManager;
import jmri.jmrit.operations.trains.trainbuilder.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainBuilderBase
extends TrainCommon {
    protected static final String ONE = "1";
    protected static final String THREE = "3";
    protected static final String FIVE = "5";
    protected static final String SEVEN = "7";
    protected static final int DISPLAY_CAR_LIMIT_20 = 20;
    protected static final int DISPLAY_CAR_LIMIT_50 = 50;
    protected static final int DISPLAY_CAR_LIMIT_100 = 100;
    protected static final boolean USE_BUNIT = true;
    protected static final String TIMING = "timing of trains";
    Date _startTime;
    Train _train;
    int _numberCars = 0;
    List<Engine> _engineList;
    Engine _lastEngine;
    Engine _secondLeadEngine;
    Engine _thirdLeadEngine;
    int _carIndex;
    List<Car> _carList;
    List<RouteLocation> _routeList;
    Hashtable<String, Integer> _numOfBlocks;
    int _completedMoves;
    int _reqNumOfMoves;
    Location _departLocation;
    Track _departStageTrack;
    Location _terminateLocation;
    Track _terminateStageTrack;
    PrintWriter _buildReport;
    List<Car> _notRoutable = new ArrayList<Car>();
    List<Location> _modifiedLocations = new ArrayList<Location>();
    int _warnings = 0;
    TrainManager trainManager = InstanceManager.getDefault(TrainManager.class);
    TrainScheduleManager trainScheduleManager = InstanceManager.getDefault(TrainScheduleManager.class);
    CarLoads carLoads = InstanceManager.getDefault(CarLoads.class);
    Router router = InstanceManager.getDefault(Router.class);
    boolean routeToTrackFound;
    private static final Logger log = LoggerFactory.getLogger(TrainBuilderBase.class);

    protected void createBuildReportFile() throws BuildFailedException {
        InstanceManager.getDefault(TrainManagerXml.class).savePreviousBuildStatusFile(this._train.getName());
        File file = InstanceManager.getDefault(TrainManagerXml.class).createTrainBuildReportFile(this._train.getName());
        try {
            this._buildReport = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8)), true);
        }
        catch (IOException e) {
            log.error("Can not open build report file: {}", (Object)e.getLocalizedMessage());
            throw new BuildFailedException(e);
        }
    }

    protected void showBuildReportInfo() {
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("BuildReportMsg", this._train.getName(), TrainBuilderBase.getDate(this._startTime)));
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("BuildReportVersion", Version.name()));
        if (!this.trainScheduleManager.getTrainScheduleActiveId().equals("")) {
            if (this.trainScheduleManager.getTrainScheduleActiveId().equals("ANY")) {
                TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildActiveSchedule", Bundle.getMessage("Any")));
            } else {
                TrainSchedule sch = this.trainScheduleManager.getActiveSchedule();
                if (sch != null) {
                    TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildActiveSchedule", sch.getName()));
                }
            }
        }
        TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildReportLevelThree"));
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildReportLevelFive"));
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildReportLevelSeven"));
        if (Setup.getRouterBuildReportLevel().equals(FIVE)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRouterReportLevelDetailed"));
        } else if (Setup.getRouterBuildReportLevel().equals(SEVEN)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRouterReportLevelVeryDetailed"));
        }
        if (!Setup.getComment().trim().isEmpty()) {
            TrainBuilderBase.addLine(this._buildReport, ONE, " ");
            TrainBuilderBase.addLine(this._buildReport, ONE, Setup.getComment());
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
    }

    protected void setUpRoute() throws BuildFailedException {
        if (this._train.getRoute() == null) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorRoute", this._train.getName()));
        }
        this._routeList = this._train.getRoute().getLocationsBySequenceList();
        if (this._routeList.size() < 1) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorNeedRoute", this._train.getName()));
        }
        this._departLocation = this.locationManager.getLocationByName(this._train.getTrainDepartsName());
        if (this._departLocation == null) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorNeedDepLoc", this._train.getName()));
        }
        this._terminateLocation = this.locationManager.getLocationByName(this._train.getTrainTerminatesName());
        if (this._terminateLocation == null) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorNeedTermLoc", this._train.getName()));
        }
    }

    protected void showTrainBuildOptions() {
        ResourceBundle rb = ResourceBundle.getBundle("jmri.jmrit.operations.setup.JmritOperationsSetupBundle");
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("MenuItemBuildOptions") + ":");
        if (Setup.isBuildAggressive()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildModeAggressive"));
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildNumberPasses", Setup.getNumberPasses()));
            if (Setup.isStagingTrackImmediatelyAvail() && this._departLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildStagingTrackAvail"));
            }
        } else {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildModeNormal"));
        }
        if (this._train.isLocalSwitcher()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("BorderLayoutSwitcherService") + ":");
            if (Setup.isLocalInterchangeMovesEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowLocalInterchange"));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("NoAllowLocalInterchange"));
            }
            if (Setup.isLocalSpurMovesEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowLocalSpur"));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("NoAllowLocalSpur"));
            }
            if (Setup.isLocalYardMovesEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowLocalYard"));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("NoAllowLocalYard"));
            }
        }
        if (this._departLocation.isStaging() || this._terminateLocation.isStaging()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingOptions"));
            if (Setup.isStagingTrainCheckEnabled() && this._terminateLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOptionRestrictStaging"));
            }
            if (Setup.isStagingTrackImmediatelyAvail() && this._terminateLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("StagingAvailable"));
            }
            if (Setup.isStagingAllowReturnEnabled() && this._departLocation.isStaging() && this._terminateLocation.isStaging() && this._departLocation == this._terminateLocation) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllowCarsToReturn"));
            }
            if (Setup.isStagingPromptFromEnabled() && this._departLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("PromptFromStaging"));
            }
            if (Setup.isStagingPromptToEnabled() && this._terminateLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("PromptToStaging"));
            }
            if (Setup.isStagingTryNormalBuildEnabled() && this._departLocation.isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("TryNormalStaging"));
            }
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCarRoutingOptions"));
        if (!Setup.isCarRoutingEnabled()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("RoutingDisabled"));
            ++this._warnings;
        } else {
            if (Setup.isCarRoutingViaYardsEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("RoutingViaYardsEnabled"));
            }
            if (Setup.isCarRoutingViaStagingEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("RoutingViaStagingEnabled"));
            }
            if (Setup.isOnlyActiveTrainsEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("OnlySelectedTrains"));
                ++this._warnings;
                for (Train train : this.trainManager.getTrainsByNameList()) {
                    if (!train.isBuildEnabled()) continue;
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrainNameAndDesc", train.getName(), train.getDescription()));
                }
                if (!this._train.isBuildEnabled()) {
                    TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainNotSelected", this._train.getName()));
                }
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, rb.getString("AllTrains"));
            }
            if (Setup.isCheckCarDestinationEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("CheckCarDestination"));
            }
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
    }

    protected void showSpecificTrainBuildOptions() {
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOptionsForTrain", this._train.getName()));
        this.showSpecificTrainBuildOptions(true);
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildDisabledOptionsForTrain", this._train.getName()));
        this.showSpecificTrainBuildOptions(false);
    }

    private void showSpecificTrainBuildOptions(boolean enabled) {
        if (this._train.isBuildTrainNormalEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("NormalModeWhenBuilding"));
        }
        if (this._train.isSendCarsToTerminalEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("SendToTerminal", this._terminateLocation.getName()));
        }
        if ((this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled()) ^ !enabled && this._departLocation.isStaging() && this._departLocation == this._terminateLocation) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("AllowCarsToReturn"));
        }
        if (this._train.isAllowLocalMovesEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("AllowLocalMoves"));
        }
        if (this._train.isAllowThroughCarsEnabled() ^ !enabled && this._departLocation != this._terminateLocation) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("AllowThroughCars"));
        }
        if (this._train.isServiceAllCarsWithFinalDestinationsEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("ServiceAllCars"));
        }
        if (this._train.isSendCarsWithCustomLoadsToStagingEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("SendCustomToStaging"));
        }
        if (this._train.isBuildConsistEnabled() ^ !enabled) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildConsist"));
            if (enabled) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("BuildConsistHPT", Setup.getHorsePowerPerTon()));
            }
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
    }

    protected void showTrainServices() {
        if (!this._train.getLocoRoadOption().equals(Train.ALL_ROADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainLocoRoads", this._train.getName(), this._train.getLocoRoadOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getLocoRoadNames())));
        }
        if (!this._train.getOwnerOption().equals(Train.ALL_OWNERS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainOwners", this._train.getName(), this._train.getOwnerOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getOwnerNames())));
        }
        if (!this._train.getBuiltStartYear().equals("")) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainBuiltAfter", this._train.getName(), this._train.getBuiltStartYear()));
        }
        if (!this._train.getBuiltEndYear().equals("")) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainBuiltBefore", this._train.getName(), this._train.getBuiltEndYear()));
        }
        if (!this._train.getNumberEngines().equals("0")) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainServicesEngineTypes", this._train.getName()));
            TrainBuilderBase.addLine(this._buildReport, FIVE, TrainBuilderBase.formatStringToCommaSeparated(this._train.getLocoTypeNames()));
        }
    }

    protected void showAndInitializeTrainRoute() throws BuildFailedException {
        int requestedCarMoves = 0;
        TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildTrainRoute", this._train.getName(), this._train.getRoute().getName()));
        for (RouteLocation rl : this._routeList) {
            Location location = this.locationManager.getLocationByName(rl.getName());
            if (location == null || rl.getLocation() == null) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorLocMissing", this._train.getRoute().getName()));
            }
            if (location.isStaging() && rl != this._train.getTrainDepartsRouteLocation() && rl != this._train.getTrainTerminatesRouteLocation()) {
                TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildLocStaging", rl.getName()));
                rl.setCarMoves(rl.getMaxCarMoves());
            } else if (this._train.isLocationSkipped(rl)) {
                TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildLocSkippedMaxTrain", rl.getId(), rl.getName(), rl.getTrainDirectionString(), this._train.getName(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                rl.setCarMoves(rl.getMaxCarMoves());
            } else {
                rl.setCarMoves(0);
                requestedCarMoves += rl.getMaxCarMoves();
                if (!(rl.isDropAllowed() || rl.isPickUpAllowed() || rl.isLocalMovesAllowed())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildLocNoDropsOrPickups", rl.getId(), location.isStaging() ? Bundle.getMessage("Staging") : Bundle.getMessage("Location"), rl.getName(), rl.getTrainDirectionString(), rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                } else if (rl == this._train.getTrainTerminatesRouteLocation()) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildLocTerminates", rl.getId(), location.isStaging() ? Bundle.getMessage("Staging") : Bundle.getMessage("Location"), rl.getName(), rl.getTrainDirectionString(), rl.getMaxCarMoves(), rl.isPickUpAllowed() ? Bundle.getMessage("Pickups").toLowerCase() + ", " : "", rl.isDropAllowed() ? Bundle.getMessage("Drop").toLowerCase() + ", " : "", rl.isLocalMovesAllowed() ? Bundle.getMessage("LocalMoves").toLowerCase() + ", " : ""));
                } else {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildLocRequestMoves", rl.getId(), location.isStaging() ? Bundle.getMessage("Staging") : Bundle.getMessage("Location"), rl.getName(), rl.getTrainDirectionString(), rl.getMaxCarMoves(), rl.isPickUpAllowed() ? Bundle.getMessage("Pickups").toLowerCase() + ", " : "", rl.isDropAllowed() ? Bundle.getMessage("Drop").toLowerCase() + ", " : "", rl.isLocalMovesAllowed() ? Bundle.getMessage("LocalMoves").toLowerCase() + ", " : "", rl.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase()));
                }
            }
            rl.setTrainWeight(0);
            rl.setTrainLength(0);
        }
        for (RouteLocation rl : this._routeList) {
            if (rl.getRandomControl().equals("Off") || rl.getCarMoves() != 0 || rl.getMaxCarMoves() <= 0) continue;
            log.debug("Location ({}) has random control value {} and maximum moves {}", new Object[]{rl.getName(), rl.getRandomControl(), rl.getMaxCarMoves()});
            try {
                int value = Integer.parseInt(rl.getRandomControl());
                double random = Math.random();
                log.debug("random {}", (Object)random);
                int moves = (int)(random * (double)(rl.getMaxCarMoves() * value / 100 + 1));
                log.debug("Reducing number of moves for location ({}) by {}", (Object)rl.getName(), (Object)moves);
                rl.setCarMoves(moves);
                requestedCarMoves -= moves;
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildRouteRandomControl", rl.getName(), rl.getId(), rl.getRandomControl(), rl.getMaxCarMoves(), rl.getMaxCarMoves() - moves));
            }
            catch (NumberFormatException e) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorRandomControl", this._train.getRoute().getName(), rl.getName(), rl.getRandomControl()));
            }
        }
        int numMoves = requestedCarMoves;
        if (!this._train.isLocalSwitcher()) {
            requestedCarMoves /= 2;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildRouteRequest", this._train.getRoute().getName(), Integer.toString(requestedCarMoves), Integer.toString(numMoves)));
        this._train.setNumberCarsRequested(requestedCarMoves);
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
    }

    protected void showIfLocalSwitcher() {
        if (this._train.isLocalSwitcher()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildTrainIsSwitcher", this._train.getName(), TrainCommon.splitString(this._train.getTrainDepartsName())));
            TrainBuilderBase.addLine(this._buildReport, THREE, " ");
        }
    }

    protected void showTrainRequirements() {
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("TrainRequirements"));
        if (this._train.isBuildConsistEnabled() && Setup.getHorsePowerPerTon() > 0.0) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainReqConsist", Setup.getHorsePowerPerTon(), this._train.getNumberEngines()));
        } else if (this._train.getNumberEngines().equals("0")) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainReq0Engine"));
        } else if (this._train.getNumberEngines().equals(ONE)) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainReq1Engine", this._train.getTrainDepartsName(), this._train.getEngineModel(), this._train.getEngineRoad()));
        } else {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainReqEngine", this._train.getTrainDepartsName(), this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad()));
        }
        if ((this._train.getSecondLegOptions() & 1) == 1) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainEngineChange", this._train.getSecondLegStartLocationName(), this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
        }
        if ((this._train.getSecondLegOptions() & 0x10) == 16) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainAddEngines", this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartLocationName(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
        }
        if ((this._train.getSecondLegOptions() & 0x20) == 32) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainRemoveEngines", this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartLocationName(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
        }
        if ((this._train.getSecondLegOptions() & 2) == 2) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainHelperEngines", this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartLocationName(), this._train.getSecondLegEndLocationName(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
        }
        if ((this._train.getThirdLegOptions() & 1) == 1) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainEngineChange", this._train.getThirdLegStartLocationName(), this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
        }
        if ((this._train.getThirdLegOptions() & 0x10) == 16) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainAddEngines", this._train.getThirdLegNumberEngines(), this._train.getThirdLegStartLocationName(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
        }
        if ((this._train.getThirdLegOptions() & 0x20) == 32) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainRemoveEngines", this._train.getThirdLegNumberEngines(), this._train.getThirdLegStartLocationName(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
        }
        if ((this._train.getThirdLegOptions() & 2) == 2) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainHelperEngines", this._train.getThirdLegNumberEngines(), this._train.getThirdLegStartLocationName(), this._train.getThirdLegEndLocationName(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
        }
        if (this._train.isCabooseNeeded()) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainRequiresCaboose", this._train.getTrainDepartsName(), this._train.getCabooseRoad()));
        }
        if ((this._train.getSecondLegOptions() & 8) == 8 || (this._train.getSecondLegOptions() & 4) == 4) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildCabooseChange", this._train.getSecondLegStartRouteLocation()));
        }
        if ((this._train.getThirdLegOptions() & 8) == 8 || (this._train.getThirdLegOptions() & 4) == 4) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildCabooseChange", this._train.getThirdLegStartRouteLocation()));
        }
        if (this._train.isFredNeeded()) {
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainRequiresFRED", this._train.getTrainDepartsName(), this._train.getCabooseRoad()));
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
    }

    protected void setDepartureTrack(Track departStageTrack) {
        if ((this._terminateStageTrack == null || this._terminateStageTrack == this._departStageTrack) && this._departLocation == this._terminateLocation && Setup.isBuildAggressive() && Setup.isStagingTrackImmediatelyAvail()) {
            this._terminateStageTrack = departStageTrack;
        }
        this._departStageTrack = departStageTrack;
    }

    protected void showTrainCarRoads() {
        if (!this._train.getCarRoadOption().equals(Train.ALL_ROADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainRoads", this._train.getName(), this._train.getCarRoadOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getCarRoadNames())));
        }
    }

    protected void showTrainCabooseRoads() {
        if (!this._train.getCabooseRoadOption().equals(Train.ALL_ROADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainCabooseRoads", this._train.getName(), this._train.getCabooseRoadOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getCabooseRoadNames())));
        }
    }

    protected void showTrainCarTypes() {
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainServicesCarTypes", this._train.getName()));
        TrainBuilderBase.addLine(this._buildReport, FIVE, TrainBuilderBase.formatStringToCommaSeparated(this._train.getCarTypeNames()));
    }

    protected void showTrainLoadNames() {
        if (!this._train.getLoadOption().equals(Train.ALL_LOADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainLoads", this._train.getName(), this._train.getLoadOption(), TrainBuilderBase.formatStringToCommaSeparated(this._train.getLoadNames())));
        }
    }

    protected Track promptFromStagingDialog() {
        List<Track> tracksIn = this._departLocation.getTracksByNameList(null);
        ArrayList<Track> validTracks = new ArrayList<Track>();
        for (Track track : tracksIn) {
            if (!this.checkDepartureStagingTrack(track)) continue;
            validTracks.add(track);
        }
        if (validTracks.size() > 1) {
            Object[] tracks = new Object[validTracks.size()];
            for (int i = 0; i < validTracks.size(); ++i) {
                tracks[i] = validTracks.get(i);
            }
            Track selected = (Track)JmriJOptionPane.showInputDialog(null, Bundle.getMessage("TrainDepartingStaging", this._train.getName(), this._departLocation.getName()), Bundle.getMessage("SelectDepartureTrack"), 3, null, tracks, null);
            if (selected != null) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildUserSelectedDeparture", selected.getName(), selected.getLocation().getName()));
            }
            return selected;
        }
        if (validTracks.size() == 1) {
            Track track = (Track)validTracks.get(0);
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOnlyOneDepartureTrack", track.getName(), track.getLocation().getName()));
            return track;
        }
        return null;
    }

    protected Track promptToStagingDialog() {
        List<Track> tracksIn = this._terminateLocation.getTracksByNameList(null);
        ArrayList<Track> validTracks = new ArrayList<Track>();
        for (Track track : tracksIn) {
            if (!this.checkTerminateStagingTrack(track)) continue;
            validTracks.add(track);
        }
        if (validTracks.size() > 1) {
            Object[] tracks = new Object[validTracks.size()];
            for (int i = 0; i < validTracks.size(); ++i) {
                tracks[i] = validTracks.get(i);
            }
            Track selected = (Track)JmriJOptionPane.showInputDialog(null, Bundle.getMessage("TrainTerminatingStaging", this._train.getName(), this._terminateLocation.getName()), Bundle.getMessage("SelectArrivalTrack"), 3, null, tracks, null);
            if (selected != null) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildUserSelectedArrival", selected.getName(), selected.getLocation().getName()));
            }
            return selected;
        }
        if (validTracks.size() == 1) {
            return (Track)validTracks.get(0);
        }
        return null;
    }

    protected void removeCaboosesAndCarsWithFred() throws BuildFailedException {
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRemoveCarsNotNeeded"));
        for (int i = 0; i < this._carList.size(); ++i) {
            Car car = this._carList.get(i);
            if (!car.isCaboose() && !car.hasFred()) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeCarTypeAtLoc", car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName()));
            if (car.getTrack() == this._departStageTrack) {
                throw new BuildFailedException("ERROR: Attempt to removed car with FRED or Caboose from staging");
            }
            this._carList.remove(car);
            --i;
        }
    }

    protected void saveCarFinalDestinations() {
        for (Car car : this._carList) {
            car.setPreviousFinalDestination(car.getFinalDestination());
            car.setPreviousFinalDestinationTrack(car.getFinalDestinationTrack());
            car.setPreviousScheduleId(car.getScheduleItemId());
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void getCarList() throws BuildFailedException {
        this._carList = this.carManager.getAvailableTrainList(this._train);
        TrainBuilderBase.addLine(this._buildReport, "7", " ");
        TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildRemoveCars"));
        showCar = true;
        carListSize = this._carList.size();
        for (i = 0; i < this._carList.size(); ++i) {
            block31: {
                car = this._carList.get(i);
                if (showCar && carListSize - this._carList.size() == 100) {
                    showCar = false;
                    TrainBuilderBase.addLine(this._buildReport, "5", Bundle.getMessage("buildOnlyFirstXXXCars", new Object[]{100, Bundle.getMessage("Type")}));
                }
                if (car.getTrack() == null) {
                    ++this._warnings;
                    TrainBuilderBase.addLine(this._buildReport, "1", Bundle.getMessage("buildWarningRsNoTrack", new Object[]{car.toString(), car.getLocationName()}));
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (car.isLocationUnknown()) {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarLocUnknown", new Object[]{car.toString(), car.getLocationName(), car.getTrackName()}));
                    if (car.getTrack().equals(this._departStageTrack)) {
                        throw new BuildFailedException(Bundle.getMessage("buildErrorLocationUnknown", new Object[]{car.getLocationName(), car.getTrackName(), car.toString()}));
                    }
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (car.isOutOfService()) {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarOutOfService", new Object[]{car.toString(), car.getLocationName(), car.getTrackName()}));
                    if (car.getTrack().equals(this._departStageTrack)) {
                        throw new BuildFailedException(Bundle.getMessage("buildErrorLocationOutOfService", new Object[]{car.getLocationName(), car.getTrackName(), car.toString()}));
                    }
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (car.getDestination() != null && (rld = this._train.getRoute().getLastLocationByName(car.getDestinationName())) == null) {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarDestNotPartRoute", new Object[]{car.toString(), car.getDestinationName(), car.getDestinationTrackName(), this._train.getRoute().getName()}));
                    if (car.getLocation().equals(this._departLocation) && this._departStageTrack != null) {
                        throw new BuildFailedException(Bundle.getMessage("buildErrorCarNotPartRoute", new Object[]{car.toString()}));
                    }
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (car.hasFred() && car.getDestination() != null && car.getDestination() != this._terminateLocation) {
                    TrainBuilderBase.addLine(this._buildReport, "5", Bundle.getMessage("buildExcludeCarWrongDest", new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getDestinationName()}));
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (car.isCaboose() && car.getDestination() != null && car.getDestination() != this._terminateLocation && (this._train.getSecondLegOptions() & 12) == 0 && (this._train.getThirdLegOptions() & 12) == 0) {
                    TrainBuilderBase.addLine(this._buildReport, "5", Bundle.getMessage("buildExcludeCarWrongDest", new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getDestinationName()}));
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (car.getTrack().isInterchange() && car.getTrack().getPickupOption().equals("Any") && car.getLastRouteId().equals(this._train.getRoute().getId())) {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarDropByTrain", new Object[]{car.toString(), car.getTypeName(), this._train.getRoute().getName(), car.getLocationName(), car.getTrackName()}));
                    this._carList.remove(car);
                    --i;
                    continue;
                }
                if (!car.getTrack().isInterchange() && !car.getTrack().isSpur()) break block31;
                if (!car.getTrack().getPickupOption().equals("trains") && !car.getTrack().getPickupOption().equals("excludeTrains")) ** GOTO lbl70
                if (car.getTrack().isPickupTrainAccepted(this._train)) {
                    TrainBuilderBase.log.debug("Car ({}) can be picked up by this train", (Object)car.toString());
                } else {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarByTrain", new Object[]{car.toString(), car.getTypeName(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName()}));
                    this._carList.remove(car);
                    --i;
                    continue;
lbl70:
                    // 1 sources

                    if (car.getTrack().getPickupOption().equals("routes") || car.getTrack().getPickupOption().equals("excludeRoutes")) {
                        if (car.getTrack().isPickupRouteAccepted(this._train.getRoute())) {
                            TrainBuilderBase.log.debug("Car ({}) can be picked up by this route", (Object)car.toString());
                        } else {
                            TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarByRoute", new Object[]{car.toString(), car.getTypeName(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName()}));
                            this._carList.remove(car);
                            --i;
                            continue;
                        }
                    }
                }
            }
            if (!car.isCaboose() && !this._train.isCarRoadNameAccepted(car.getRoadName()) || car.isCaboose() && !this._train.isCabooseRoadNameAccepted(car.getRoadName())) {
                TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarWrongRoad", new Object[]{car.toString(), car.getLocationName(), car.getTrackName(), car.getTypeName(), car.getTypeExtensions(), car.getRoadName()}));
                this._carList.remove(car);
                --i;
                continue;
            }
            if (!this._train.isTypeNameAccepted(car.getTypeName())) {
                if (showCar && (car.getKernel() == null || car.isLead())) {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarWrongType", new Object[]{car.toString(), car.getLocationName(), car.getTrackName(), car.getTypeName()}));
                }
                this._carList.remove(car);
                --i;
                continue;
            }
            if (!this._train.isOwnerNameAccepted(car.getOwnerName())) {
                TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarOwnerAtLoc", new Object[]{car.toString(), car.getOwnerName(), car.getLocationName(), car.getTrackName()}));
                this._carList.remove(car);
                --i;
                continue;
            }
            if (!this._train.isBuiltDateAccepted(car.getBuilt())) {
                TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarBuiltAtLoc", new Object[]{car.toString(), car.getBuilt(), car.getLocationName(), car.getTrackName()}));
                this._carList.remove(car);
                --i;
                continue;
            }
            if (this._departStageTrack != null && car.getTrack() == this._departStageTrack) continue;
            if (!(car.isCaboose() || car.isPassenger() || this._train.isLoadNameAccepted(car.getLoadName(), car.getTypeName()))) {
                TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarLoadAtLoc", new Object[]{car.toString(), car.getTypeName(), car.getLoadName()}));
                this._carList.remove(car);
                --i;
                continue;
            }
            if (car.hasFred() && !this._train.isFredNeeded()) {
                TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarWithFredAtLoc", new Object[]{car.toString(), car.getTypeName(), car.getLocationName() + ", " + car.getTrackName()}));
                this._carList.remove(car);
                --i;
                continue;
            }
            if (!car.getPickupScheduleId().equals("")) {
                if (this.trainScheduleManager.getTrainScheduleActiveId().equals("ANY") || car.getPickupScheduleId().equals(this.trainScheduleManager.getTrainScheduleActiveId())) {
                    car.setPickupScheduleId("");
                } else {
                    sch = this.trainScheduleManager.getScheduleById(car.getPickupScheduleId());
                    if (sch != null) {
                        TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarSchedule", new Object[]{car.toString(), car.getTypeName(), car.getLocationName(), car.getTrackName(), sch.getName()}));
                        this._carList.remove(car);
                        --i;
                        continue;
                    }
                }
            }
            if (car.getWait() <= 0) continue;
            TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarWait", new Object[]{car.toString(), car.getTypeName(), car.getLocationName(), car.getTrackName(), car.getWait()}));
            if (this._train.isServiceable(car)) {
                TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildTrainCanServiceWait", new Object[]{this._train.getName(), car.toString(), car.getWait() - 1}));
                car.setWait(car.getWait() - 1);
                oldLoad = car.getLoadName();
                if (car.getTrack().isSpur()) {
                    car.updateLoad(car.getTrack());
                }
                if (!oldLoad.equals(newLoad = car.getLoadName())) {
                    TrainBuilderBase.addLine(this._buildReport, "7", Bundle.getMessage("buildCarLoadChangedWait", new Object[]{car.toString(), car.getTypeName(), oldLoad, newLoad}));
                }
            }
            this._carList.remove(car);
            --i;
        }
    }

    protected void adjustCarsInStaging() throws BuildFailedException {
        if (!this._train.isDepartingStaging()) {
            return;
        }
        int numCarsFromStaging = 0;
        this._numOfBlocks = new Hashtable();
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRemoveCarsStaging"));
        for (int i = 0; i < this._carList.size(); ++i) {
            Car car = this._carList.get(i);
            if (!car.getLocationName().equals(this._departLocation.getName())) continue;
            if (car.getTrackName().equals(this._departStageTrack.getName())) {
                ++numCarsFromStaging;
                if (car.isCaboose() || car.hasFred() || car.isPassenger() || car.getKernel() != null && !car.isLead()) continue;
                log.debug("Car {} last location id: {}", (Object)car.toString(), (Object)car.getLastLocationId());
                Integer number = 1;
                if (this._numOfBlocks.containsKey(car.getLastLocationId())) {
                    number = this._numOfBlocks.get(car.getLastLocationId()) + 1;
                    this._numOfBlocks.remove(car.getLastLocationId());
                }
                this._numOfBlocks.put(car.getLastLocationId(), number);
                continue;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeCarAtLoc", car.toString(), car.getTypeName(), car.getLocationName(), car.getTrackName()));
            this._carList.remove(car);
            --i;
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildDepartingStagingCars", this._departStageTrack.getLocation().getName(), this._departStageTrack.getName(), numCarsFromStaging));
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingCarAtLoc", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName()));
        }
        if (numCarsFromStaging != this._departStageTrack.getNumberCars()) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorNotAllCars", this._departStageTrack.getName(), Integer.toString(this._departStageTrack.getNumberCars() - numCarsFromStaging)));
        }
        log.debug("Staging departure track ({}) has {} cars and {} blocks", new Object[]{this._departStageTrack.getName(), numCarsFromStaging, this._numOfBlocks.size()});
    }

    protected void showCarsByLocation() throws BuildFailedException {
        TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildFoundCars", Integer.toString(this._carList.size()), this._train.getName()));
        ArrayList<String> locationNames = new ArrayList<String>();
        for (RouteLocation rl : this._train.getRoute().getLocationsBySequenceList()) {
            if (locationNames.contains(rl.getName())) continue;
            locationNames.add(rl.getName());
            int count = this.countRollingStockAt(rl, new ArrayList<RollingStock>(this._carList));
            if (rl.getLocation().isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCarsInStaging", count, rl.getName()));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCarsAtLocation", count, rl.getName()));
            }
            int carCount = 0;
            for (int i = 0; i < this._carList.size(); ++i) {
                Car car = this._carList.get(i);
                if (!car.getLocationName().equals(rl.getName())) continue;
                if (carCount < 50 && (car.getKernel() == null || car.isLead())) {
                    if (car.getLoadPriority().equals(CarLoad.PRIORITY_LOW)) {
                        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarAtLocWithMoves", car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName(), car.getMoves()));
                    } else {
                        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarAtLocWithMovesPriority", car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName(), car.getMoves(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getLoadPriority()));
                    }
                    if (car.isLead()) {
                        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarLeadKernel", car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
                        for (Car k : car.getKernel().getCars()) {
                            if (k.isLead()) continue;
                            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarPartOfKernel", k.toString(), k.getKernelName(), k.getKernel().getSize(), k.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
                        }
                    }
                    if (++carCount == 50) {
                        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildOnlyFirstXXXCars", carCount, rl.getName()));
                    }
                }
                if (car.getKernel() != null && !this._carList.contains(car.getKernel().getLead())) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarPartOfKernel", car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
                }
                if (car.getKernel() != null) {
                    this.checkKernel(car);
                    if (!car.isLead()) {
                        this._carList.remove(car);
                        --i;
                        continue;
                    }
                }
                if (!this._train.equals(car.getTrain())) continue;
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCarAlreadyAssigned", car.toString()));
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        }
    }

    protected void sortCarsOnFifoLifoTracks() {
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildSortCarsByLastDate"));
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            Car car = this._carList.get(this._carIndex);
            if (!car.getTrack().getServiceOrder().equals(Track.NORMAL) && !car.getTrack().isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackModePriority", car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), car.getTrack().getServiceOrder(), car.getLastDate()));
                Car bestCar = car;
                for (int i = this._carIndex + 1; i < this._carList.size(); ++i) {
                    Car testCar = this._carList.get(i);
                    if (testCar.getTrack() != car.getTrack()) continue;
                    log.debug("{} car ({}) last moved date: {}", new Object[]{car.getTrack().getTrackTypeName(), testCar.toString(), testCar.getLastDate()});
                    if (car.getTrack().getServiceOrder().equals(Track.FIFO)) {
                        if (!bestCar.getLastMoveDate().after(testCar.getLastMoveDate()) || !bestCar.getLoadPriority().equals(testCar.getLoadPriority())) continue;
                        bestCar = testCar;
                        log.debug("New best car ({})", (Object)bestCar.toString());
                        continue;
                    }
                    if (!car.getTrack().getServiceOrder().equals(Track.LIFO) || !bestCar.getLastMoveDate().before(testCar.getLastMoveDate()) || !bestCar.getLoadPriority().equals(testCar.getLoadPriority())) continue;
                    bestCar = testCar;
                    log.debug("New best car ({})", (Object)bestCar.toString());
                }
                if (car != bestCar) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackModeCarPriority", car.getTrack().getTrackTypeName(), car.getTrackName(), car.getTrack().getServiceOrder(), bestCar.toString(), bestCar.getLastDate(), car.toString(), car.getLastDate()));
                    this._carList.remove(bestCar);
                    this._carList.add(this._carIndex, bestCar);
                }
            }
            ++this._carIndex;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
    }

    private void checkKernel(Car car) throws BuildFailedException {
        boolean foundLeadCar = false;
        for (Car c : car.getKernel().getCars()) {
            if (c.isLead() && !c.isOutOfService()) {
                foundLeadCar = true;
            }
            if (car.getLocation() == c.getLocation() && car.getTrack().getSplitName().equals(c.getTrack().getSplitName())) continue;
            throw new BuildFailedException(Bundle.getMessage("buildErrorCarKernelLocation", c.toString(), car.getKernelName(), c.getLocationName(), c.getTrackName(), car.toString(), car.getLocationName(), car.getTrackName()));
        }
        if (!foundLeadCar) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorCarKernelNoLead", car.getKernelName()));
        }
    }

    protected String getLargestBlock() {
        Enumeration<String> en = this._numOfBlocks.keys();
        String largestBlock = "";
        int maxCars = 0;
        while (en.hasMoreElements()) {
            String locId = en.nextElement();
            if (this._numOfBlocks.get(locId) <= maxCars) continue;
            largestBlock = locId;
            maxCars = this._numOfBlocks.get(locId);
        }
        return largestBlock;
    }

    protected RouteLocation getLocationWithMaximumMoves(List<RouteLocation> blockRouteList, String blockId) {
        RouteLocation rlMax = null;
        int maxMoves = 0;
        for (RouteLocation rl : blockRouteList) {
            if (rl == this._train.getTrainDepartsRouteLocation()) continue;
            if (rl.getMaxCarMoves() - rl.getCarMoves() > maxMoves) {
                maxMoves = rl.getMaxCarMoves() - rl.getCarMoves();
                rlMax = rl;
            }
            if (rl.getMaxCarMoves() - rl.getCarMoves() != maxMoves || rl.getLocation().getId().equals(blockId)) continue;
            rlMax = rl;
        }
        return rlMax;
    }

    protected void makeAdjustmentsIfDepartingStaging() {
        if (this._train.isDepartingStaging()) {
            this._reqNumOfMoves = 0;
            if (this._departStageTrack == this._terminateStageTrack) {
                if (!this._train.isAllowReturnToStagingEnabled() && !Setup.isStagingAllowReturnEnabled()) {
                    for (Car car : this.carManager.getList()) {
                        if (car.getTrack() != this._departStageTrack || car.getRouteDestination() != null) continue;
                        car.setLocation(car.getLocation(), null);
                    }
                } else {
                    TrainBuilderBase.addLine(this._buildReport, THREE, " ");
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildWarnDepartStaging", this._departStageTrack.getLocation().getName(), this._departStageTrack.getName()));
                    TrainBuilderBase.addLine(this._buildReport, THREE, " ");
                }
            }
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildDepartStagingAggressive", this._departStageTrack.getLocation().getName()));
        }
    }

    protected void restoreCarsIfDepartingStaging() {
        if (this._train.isDepartingStaging() && this._departStageTrack == this._terminateStageTrack && !this._train.isAllowReturnToStagingEnabled() && !Setup.isStagingAllowReturnEnabled()) {
            for (Car car : this._carList) {
                if (car.getLocation() != this._departStageTrack.getLocation() || car.getTrack() != null) continue;
                car.setLocation(this._departStageTrack.getLocation(), this._departStageTrack, true);
                if (car.getKernel() == null) continue;
                for (Car k : car.getKernel().getCars()) {
                    k.setLocation(this._departStageTrack.getLocation(), this._departStageTrack, true);
                }
            }
        }
    }

    protected void showLoadGenerationOptionsStaging() {
        if (this._departStageTrack != null && this._reqNumOfMoves > 0 && (this._departStageTrack.isAddCustomLoadsEnabled() || this._departStageTrack.isAddCustomLoadsAnySpurEnabled() || this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled())) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCustomLoadOptions", this._departStageTrack.getName()));
            if (this._departStageTrack.isAddCustomLoadsEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLoadCarLoads"));
            }
            if (this._departStageTrack.isAddCustomLoadsAnySpurEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLoadAnyCarLoads"));
            }
            if (this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLoadsStaging"));
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
        }
    }

    protected void checkStuckCarsInStaging() throws BuildFailedException {
        if (!this._train.isDepartingStaging()) {
            return;
        }
        int carCount = 0;
        StringBuffer buf = new StringBuffer();
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack || car.getDestination() != null && car.getDestinationTrack() != null && car.getTrain() != null) continue;
            if (car.getKernel() != null) {
                for (Car c : car.getKernel().getCars()) {
                    this.addCarToStuckStagingList(c, buf, ++carCount);
                }
                continue;
            }
            this.addCarToStuckStagingList(car, buf, ++carCount);
        }
        if (carCount > 0) {
            log.debug("{} cars stuck in staging", (Object)carCount);
            String msg = Bundle.getMessage("buildStagingCouldNotFindDest", carCount, this._departStageTrack.getLocation().getName(), this._departStageTrack.getName());
            throw new BuildFailedException(msg + buf.toString(), "staging");
        }
    }

    private void addCarToStuckStagingList(Car car, StringBuffer buf, int carCount) {
        if (carCount <= 20) {
            buf.append("\n " + car.toString());
        } else if (carCount == 21) {
            buf.append("\n" + Bundle.getMessage("buildOnlyFirstXXXCars", 20, this._departStageTrack.getName()));
        }
    }

    protected boolean isCarStuckStaging() {
        if (this._train.isDepartingStaging()) {
            for (Car car : this._carList) {
                if (car.getTrack() != this._departStageTrack || car.getDestination() != null && car.getDestinationTrack() != null && car.getTrain() != null) continue;
                return true;
            }
        }
        return false;
    }

    protected void addCarToTrain(Car car, RouteLocation rl, RouteLocation rld, Track track) {
        TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildCarAssignedDest", car.toString(), rld.getName(), track.getName()));
        car.setDestination(track.getLocation(), track, true);
        int length = car.getTotalLength();
        int weightTons = car.getAdjustedWeightTons();
        if (car.getKernel() != null) {
            length = car.getKernel().getTotalLength();
            weightTons = car.getKernel().getAdjustedWeightTons();
            List<Car> kCars = car.getKernel().getCars();
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildCarPartOfKernel", car.toString(), car.getKernelName(), kCars.size(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
            for (Car kCar : kCars) {
                if (kCar == car) continue;
                TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildCarKernelAssignedDest", kCar.toString(), kCar.getKernelName(), rld.getName(), track.getName()));
                kCar.setTrain(this._train);
                kCar.setRouteLocation(rl);
                kCar.setRouteDestination(rld);
                kCar.setDestination(track.getLocation(), track, true);
                kCar.setPreviousFinalDestination(car.getPreviousFinalDestination());
                kCar.setPreviousFinalDestinationTrack(car.getPreviousFinalDestinationTrack());
            }
            car.updateKernel();
        }
        if (!this._train.isLoadNameAccepted(car.getLoadName(), car.getTypeName())) {
            ++this._warnings;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildWarnCarDepartStaging", car.toString(), car.getLoadName()));
        }
        TrainBuilderBase.addLine(this._buildReport, THREE, " ");
        ++this._numberCars;
        ++this._completedMoves;
        --this._reqNumOfMoves;
        if (this._carList.remove(car)) {
            --this._carIndex;
        }
        rl.setCarMoves(rl.getCarMoves() + 1);
        if (rl != rld) {
            rld.setCarMoves(rld.getCarMoves() + 1);
        }
        this.finishAddRsToTrain(car, rl, rld, length, weightTons);
    }

    protected void finishAddRsToTrain(RollingStock rs, RouteLocation rl, RouteLocation rld, int length, int weightTons) {
        if (!this._modifiedLocations.contains(rl.getLocation())) {
            this._modifiedLocations.add(rl.getLocation());
        }
        if (!this._modifiedLocations.contains(rld.getLocation())) {
            this._modifiedLocations.add(rld.getLocation());
        }
        rs.setTrain(this._train);
        rs.setRouteLocation(rl);
        rs.setRouteDestination(rld);
        boolean inTrain = false;
        for (RouteLocation routeLocation : this._routeList) {
            if (rl == routeLocation) {
                inTrain = true;
            }
            if (rld == routeLocation) break;
            if (!inTrain) continue;
            routeLocation.setTrainLength(routeLocation.getTrainLength() + length);
            routeLocation.setTrainWeight(routeLocation.getTrainWeight() + weightTons);
        }
    }

    protected boolean checkPickUpTrainDirection(RollingStock rs, RouteLocation rl) throws BuildFailedException {
        if (rs.getTrack() == null) {
            throw new BuildFailedException(Bundle.getMessage("buildWarningRsNoTrack", rs.toString(), rs.getLocationName()));
        }
        if (this._train.isLocalSwitcher()) {
            return true;
        }
        if ((rl.getTrainDirection() & rs.getLocation().getTrainDirections() & rs.getTrack().getTrainDirections()) != 0) {
            return true;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildRsCanNotPickupUsingTrain", rs.toString(), rl.getTrainDirectionString(), rs.getTrackName(), rs.getLocationName(), rl.getId()));
        return false;
    }

    protected boolean checkPickUpTrainDirection(RouteLocation rl) {
        if (this._train.isLocalSwitcher()) {
            return true;
        }
        if ((rl.getTrainDirection() & rl.getLocation().getTrainDirections()) != 0) {
            return true;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildLocDirection", rl.getName(), rl.getTrainDirectionString()));
        return false;
    }

    protected boolean checkTrainLength(Car car, RouteLocation rl, RouteLocation rld) {
        int length = car.getTotalKernelLength();
        boolean carInTrain = false;
        for (RouteLocation rlt : this._routeList) {
            if (rl == rlt) {
                carInTrain = true;
            }
            if (rld == rlt) break;
            if (!carInTrain || rlt.getTrainLength() + length <= rlt.getMaxTrainLength()) continue;
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCanNotPickupCarLength", car.toString(), length, Setup.getLengthUnit().toLowerCase(), rlt.getMaxTrainLength(), Setup.getLengthUnit().toLowerCase(), rlt.getTrainLength() + length - rlt.getMaxTrainLength(), rlt.getName(), rlt.getId()));
            return false;
        }
        return true;
    }

    protected boolean checkDropTrainDirection(RollingStock rs, RouteLocation rld, Track track) {
        Car car;
        if (this._train.isLocalSwitcher()) {
            return true;
        }
        int serviceTrainDir = rld.getLocation().getTrainDirections();
        if (track != null) {
            serviceTrainDir &= track.getTrainDirections();
        }
        if ((rld.getTrainDirection() & serviceTrainDir) != 0 && rs != null && track != null && Car.class.isInstance(rs) && (car = (Car)rs).getFinalDestinationTrack() != null && track == car.getFinalDestinationTrack().getAlternateTrack() && (track.getTrainDirections() & car.getFinalDestinationTrack().getTrainDirections()) == 0) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropRsUsingTrain4", car.getFinalDestinationTrack().getName(), TrainBuilderBase.formatStringToCommaSeparated(Setup.getDirectionStrings(car.getFinalDestinationTrack().getTrainDirections())), car.getFinalDestinationTrack().getAlternateTrack().getName(), TrainBuilderBase.formatStringToCommaSeparated(Setup.getDirectionStrings(car.getFinalDestinationTrack().getAlternateTrack().getTrainDirections()))));
            return false;
        }
        if ((rld.getTrainDirection() & serviceTrainDir) != 0) {
            return true;
        }
        if (rs == null || track == null) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildDestinationDoesNotService", rld.getName(), rld.getTrainDirectionString()));
        } else {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropRsUsingTrain", rs.toString(), rld.getTrainDirectionString(), track.getName()));
        }
        return false;
    }

    protected boolean checkDropTrainDirection(RouteLocation rld) {
        return this.checkDropTrainDirection(null, rld, null);
    }

    protected boolean checkTrainCanDrop(RollingStock rs, Track track) {
        if (track.isInterchange() || track.isSpur()) {
            if (track.getDropOption().equals("trains") || track.getDropOption().equals("excludeTrains")) {
                if (track.isDropTrainAccepted(this._train)) {
                    log.debug("Rolling stock ({}) can be droped by train to track ({})", (Object)rs.toString(), (Object)track.getName());
                } else {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropTrain", rs.toString(), this._train.getName(), track.getTrackTypeName(), track.getLocation().getName(), track.getName()));
                    return false;
                }
            }
            if (track.getDropOption().equals("routes") || track.getDropOption().equals("excludeRoutes")) {
                if (track.isDropRouteAccepted(this._train.getRoute())) {
                    log.debug("Rolling stock ({}) can be droped by route to track ({})", (Object)rs.toString(), (Object)track.getName());
                } else {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropRoute", rs.toString(), this._train.getRoute().getName(), track.getTrackTypeName(), track.getLocation().getName(), track.getName()));
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean checkDepartureStagingTrack(Track departStageTrack) {
        TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingHas", departStageTrack.getName(), Integer.toString(departStageTrack.getNumberEngines()), Integer.toString(departStageTrack.getNumberCars())));
        if (!departStageTrack.isPickupTrainAccepted(this._train)) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingNotTrain", departStageTrack.getName()));
            return false;
        }
        if (departStageTrack.getNumberRS() == 0 && this._train.getTrainDepartsRouteLocation().getMaxCarMoves() > 0) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingEmpty", departStageTrack.getName()));
            return false;
        }
        if (departStageTrack.getUsedLength() > this._train.getTrainDepartsRouteLocation().getMaxTrainLength()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingTrainTooLong", departStageTrack.getName(), departStageTrack.getUsedLength(), Setup.getLengthUnit().toLowerCase(), this._train.getTrainDepartsRouteLocation().getMaxTrainLength()));
            return false;
        }
        if (departStageTrack.getNumberCars() > this._train.getTrainDepartsRouteLocation().getMaxCarMoves()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingTooManyCars", departStageTrack.getName(), departStageTrack.getNumberCars(), this._train.getTrainDepartsRouteLocation().getMaxCarMoves()));
            return false;
        }
        if (!this._train.getNumberEngines().equals("0") && this.getNumberEngines(this._train.getNumberEngines()) != departStageTrack.getNumberEngines()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingNotEngines", departStageTrack.getName(), departStageTrack.getNumberEngines(), this._train.getNumberEngines()));
            return false;
        }
        if ((departStageTrack.getTrainDirections() & this._train.getTrainDepartsRouteLocation().getTrainDirection()) == 0) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingNotDirection", departStageTrack.getName()));
            return false;
        }
        if (!this.checkStagingEngines(departStageTrack)) {
            return false;
        }
        if (!this.checkStagingCarTypeRoadLoadOwnerBuiltCabooseOrFRED(departStageTrack)) {
            return false;
        }
        if (!this.checkStagingPool(departStageTrack)) {
            return false;
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrainCanDepartTrack", this._train.getName(), departStageTrack.getName()));
        return true;
    }

    private boolean checkStagingEngines(Track departStageTrack) {
        if (departStageTrack.getNumberEngines() > 0) {
            for (Engine eng : this.engineManager.getList()) {
                if (eng.getTrack() != departStageTrack) continue;
                if (eng.getRouteLocation() != null) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepart", departStageTrack.getName(), eng.getTrainName()));
                    return false;
                }
                if (eng.getTrain() != null && eng.getTrain() != this._train) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineTrain", departStageTrack.getName(), eng.toString(), eng.getTrainName()));
                    return false;
                }
                if (!this._train.isTypeNameAccepted(eng.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineType", departStageTrack.getName(), eng.toString(), eng.getTypeName(), this._train.getName()));
                    return false;
                }
                if (!this._train.getEngineModel().equals("") && !this._train.getEngineModel().equals(eng.getModel())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineModel", departStageTrack.getName(), eng.toString(), eng.getModel(), this._train.getName()));
                    return false;
                }
                if (!(this._train.getCarRoadOption().equals(Train.ALL_ROADS) || this._train.getEngineRoad().equals("") || this._train.getEngineRoad().equals(eng.getRoadName()))) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineRoad", departStageTrack.getName(), eng.toString(), eng.getRoadName(), this._train.getName()));
                    return false;
                }
                if (this._train.getEngineRoad().equals("") && !this._train.isLocoRoadNameAccepted(eng.getRoadName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineRoad", departStageTrack.getName(), eng.toString(), eng.getRoadName(), this._train.getName()));
                    return false;
                }
                if (!this._train.isOwnerNameAccepted(eng.getOwnerName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineOwner", departStageTrack.getName(), eng.toString(), eng.getOwnerName(), this._train.getName()));
                    return false;
                }
                if (this._train.isBuiltDateAccepted(eng.getBuilt())) continue;
                TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartEngineBuilt", departStageTrack.getName(), eng.toString(), eng.getBuilt(), this._train.getName()));
                return false;
            }
        }
        return true;
    }

    private boolean checkStagingCarTypeRoadLoadOwnerBuiltCabooseOrFRED(Track departStageTrack) {
        boolean foundCaboose = false;
        boolean foundFRED = false;
        if (departStageTrack.getNumberCars() > 0) {
            for (Car car : this.carManager.getList()) {
                if (car.getTrack() != departStageTrack || car.getKernel() != null && !car.isLead()) continue;
                if (car.getRouteLocation() != null) {
                    log.debug("Car ({}) has route location ({})", (Object)car.toString(), (Object)car.getRouteLocation().getName());
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepart", departStageTrack.getName(), car.getTrainName()));
                    return false;
                }
                if (car.getTrain() != null && car.getTrain() != this._train) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarTrain", departStageTrack.getName(), car.toString(), car.getTrainName()));
                    return false;
                }
                if (!this._train.isTypeNameAccepted(car.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarType", departStageTrack.getName(), car.toString(), car.getTypeName(), this._train.getName()));
                    return false;
                }
                if (!car.isCaboose() && !this._train.isCarRoadNameAccepted(car.getRoadName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarRoad", departStageTrack.getName(), car.toString(), car.getRoadName(), this._train.getName()));
                    return false;
                }
                if (!(car.isCaboose() || car.isPassenger() || car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && (departStageTrack.isAddCustomLoadsEnabled() || departStageTrack.isAddCustomLoadsAnySpurEnabled() || departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled()) || this._train.isLoadNameAccepted(car.getLoadName(), car.getTypeName()))) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarLoad", departStageTrack.getName(), car.toString(), car.getLoadName(), this._train.getName()));
                    return false;
                }
                if (!this._train.isOwnerNameAccepted(car.getOwnerName())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarOwner", departStageTrack.getName(), car.toString(), car.getOwnerName(), this._train.getName()));
                    return false;
                }
                if (!this._train.isBuiltDateAccepted(car.getBuilt())) {
                    TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarBuilt", departStageTrack.getName(), car.toString(), car.getBuilt(), this._train.getName()));
                    return false;
                }
                if (car.getDestination() != null) {
                    log.debug("Car ({}) has a destination ({}, {})", new Object[]{car.toString(), car.getDestinationName(), car.getDestinationTrackName()});
                    if (!this._train.isServiceable(car)) {
                        TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingDepartCarDestination", departStageTrack.getName(), car.toString(), car.getDestinationName(), this._train.getName()));
                        return false;
                    }
                }
                if (car.isCaboose() && (this._train.getCabooseRoad().equals("") || this._train.getCabooseRoad().equals(car.getRoadName()))) {
                    foundCaboose = true;
                }
                if (!car.hasFred() || !this._train.getCabooseRoad().equals("") && !this._train.getCabooseRoad().equals(car.getRoadName())) continue;
                foundFRED = true;
            }
        }
        if (this._train.isCabooseNeeded() && !foundCaboose) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingNoCaboose", departStageTrack.getName(), this._train.getCabooseRoad()));
            return false;
        }
        if (this._train.isFredNeeded() && !foundFRED) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildStagingNoCarFRED", departStageTrack.getName(), this._train.getCabooseRoad()));
            return false;
        }
        return true;
    }

    private boolean checkStagingPool(Track departStageTrack) {
        if (departStageTrack.getPool() == null || departStageTrack.getServiceOrder().equals(Track.NORMAL) || departStageTrack.getNumberCars() == 0) {
            return true;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingTrackPool", departStageTrack.getName(), departStageTrack.getPool().getName(), departStageTrack.getPool().getSize(), departStageTrack.getServiceOrder()));
        List<Car> carList = this.carManager.getAvailableTrainList(this._train);
        Date carDepartStageTrackDate = null;
        for (Car car : carList) {
            if (car.getTrack() != departStageTrack) continue;
            carDepartStageTrackDate = car.getLastMoveDate();
            break;
        }
        if (carDepartStageTrackDate == null) {
            return true;
        }
        for (Track track : departStageTrack.getPool().getTracks()) {
            if (track == departStageTrack || track.getNumberCars() == 0) continue;
            Date carOtherStageTrackDate = null;
            for (Car car : carList) {
                if (car.getTrack() != track) continue;
                carOtherStageTrackDate = car.getLastMoveDate();
                break;
            }
            if (carOtherStageTrackDate == null) continue;
            if (departStageTrack.getServiceOrder().equals(Track.LIFO)) {
                if (!carDepartStageTrackDate.before(carOtherStageTrackDate)) continue;
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingCarsBefore", departStageTrack.getName(), track.getName()));
                return false;
            }
            if (!carOtherStageTrackDate.before(carDepartStageTrackDate)) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingCarsBefore", track.getName(), departStageTrack.getName()));
            return false;
        }
        return true;
    }

    protected boolean checkTerminateStagingTrack(Track terminateStageTrack) {
        if (!terminateStageTrack.isDropTrainAccepted(this._train)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingNotTrain", terminateStageTrack.getName()));
            return false;
        }
        if ((!Setup.isBuildAggressive() || !Setup.isStagingTrackImmediatelyAvail()) && terminateStageTrack.getNumberRS() != 0 || terminateStageTrack.getNumberRS() != terminateStageTrack.getPickupRS()) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackOccupied", terminateStageTrack.getName(), terminateStageTrack.getNumberEngines(), terminateStageTrack.getNumberCars()));
            if (terminateStageTrack.getIgnoreUsedLengthPercentage() == 0) {
                return false;
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildTrackHasPlannedPickups", terminateStageTrack.getName(), terminateStageTrack.getIgnoreUsedLengthPercentage(), terminateStageTrack.getLength(), Setup.getLengthUnit().toLowerCase(), terminateStageTrack.getUsedLength(), terminateStageTrack.getReserved(), terminateStageTrack.getReservedLengthDrops(), terminateStageTrack.getReservedLengthDrops() - terminateStageTrack.getReserved(), terminateStageTrack.getAvailableTrackSpace()));
        }
        if (terminateStageTrack.getDropRS() != 0) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackReserved", terminateStageTrack.getName(), terminateStageTrack.getDropRS()));
            return false;
        }
        if (terminateStageTrack.getPickupRS() > 0) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackDepart", terminateStageTrack.getName()));
        }
        if (terminateStageTrack.getDropOption().equals("trains") || terminateStageTrack.getDropOption().equals("routes")) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrainCanTerminateTrack", this._train.getName(), terminateStageTrack.getName()));
            return true;
        }
        if (!Setup.isStagingTrainCheckEnabled()) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrainCanTerminateTrack", this._train.getName(), terminateStageTrack.getName()));
            return true;
        }
        if (!this.checkTerminateStagingTrackRestrictions(terminateStageTrack)) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingTrackRestriction", terminateStageTrack.getName(), this._train.getName()));
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildOptionRestrictStaging"));
            return false;
        }
        return true;
    }

    private boolean checkTerminateStagingTrackRestrictions(Track terminateStageTrack) {
        for (String name : this._train.getTypeNames()) {
            if (!this._terminateLocation.acceptsTypeName(name)) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildDestinationType", this._terminateLocation.getName(), name));
                return false;
            }
            if (terminateStageTrack.isTypeNameAccepted(name)) continue;
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackType", terminateStageTrack.getName(), name));
            return false;
        }
        if (this._train.getCarRoadOption().equals(Train.ALL_ROADS) && !terminateStageTrack.getRoadOption().equals(Track.ALL_ROADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackAllRoads", terminateStageTrack.getName()));
            return false;
        }
        for (String road : InstanceManager.getDefault(CarRoads.class).getNames()) {
            if (!this._train.isCarRoadNameAccepted(road) || terminateStageTrack.isRoadNameAccepted(road)) continue;
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackRoad", terminateStageTrack.getName(), road));
            return false;
        }
        if (this._train.getLoadOption().equals(Train.ALL_LOADS) && !terminateStageTrack.getLoadOption().equals(Track.ALL_LOADS)) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackAllLoads", terminateStageTrack.getName()));
            return false;
        }
        for (String type : this._train.getTypeNames()) {
            for (String load : this.carLoads.getNames(type)) {
                if (!this._train.isLoadNameAccepted(load, type) || terminateStageTrack.isLoadNameAndCarTypeAccepted(load, type)) continue;
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildStagingTrackLoad", terminateStageTrack.getName(), type + " & " + load));
                return false;
            }
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrainCanTerminateTrack", this._train.getName(), terminateStageTrack.getName()));
        return true;
    }

    protected boolean checkBasicMoves(Car car, Track track) {
        if (car.getTrack() == track) {
            return false;
        }
        if (car.getSplitLocationName().equals(track.getLocation().getSplitName()) && car.getSplitTrackName().equals(track.getSplitName())) {
            return false;
        }
        if (track.isStaging() && car.getLocation() == track.getLocation()) {
            return false;
        }
        if (!this.checkThroughCarsAllowed(car, track.getLocation().getName())) {
            return false;
        }
        return this.checkLocalMovesAllowed(car, track);
    }

    protected ScheduleItem getScheduleItem(Car car, Track track) throws BuildFailedException {
        if (track.getSchedule() == null) {
            return null;
        }
        if (!track.isTypeNameAccepted(car.getTypeName())) {
            log.debug("Track ({}) doesn't service car type ({})", (Object)track.getName(), (Object)car.getTypeName());
            if (!Setup.getRouterBuildReportLevel().equals(THREE)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildSpurNotThisType", track.getLocation().getName(), track.getName(), track.getScheduleName(), car.getTypeName()));
            }
            return null;
        }
        ScheduleItem si = null;
        if (track.getScheduleMode() == 0) {
            si = track.getCurrentScheduleItem();
            if (si == null) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorNoScheduleItem", track.getScheduleItemId(), track.getScheduleName(), track.getName(), track.getLocation().getName()));
            }
            return this.checkScheduleItem(si, car, track);
        }
        log.debug("Track ({}) in match mode", (Object)track.getName());
        for (int i = 0; i < track.getSchedule().getSize(); ++i) {
            si = track.getNextScheduleItem();
            if (si == null) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorNoScheduleItem", track.getScheduleItemId(), track.getScheduleName(), track.getName(), track.getLocation().getName()));
            }
            if ((si = this.checkScheduleItem(si, car, track)) != null) break;
        }
        return si;
    }

    private ScheduleItem checkScheduleItem(ScheduleItem si, Car car, Track track) {
        if (!car.getTypeName().equals(si.getTypeName()) || si.getReceiveLoadName().equals("") || si.getReceiveLoadName().equals(this.carLoads.getDefaultEmptyName()) || si.getReceiveLoadName().equals(this.carLoads.getDefaultLoadName())) {
            log.debug("Not using track ({}) schedule request type ({}) road ({}) load ({})", new Object[]{track.getName(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()});
            if (!Setup.getRouterBuildReportLevel().equals(THREE)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildSpurScheduleNotUsed", track.getLocation().getName(), track.getName(), track.getScheduleName(), si.getId(), track.getScheduleModeName().toLowerCase(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()));
            }
            return null;
        }
        if (!si.getRoadName().equals("") && !car.getRoadName().equals(si.getRoadName())) {
            log.debug("Not using track ({}) schedule request type ({}) road ({}) load ({})", new Object[]{track.getName(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()});
            if (!Setup.getRouterBuildReportLevel().equals(THREE)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildSpurScheduleNotUsed", track.getLocation().getName(), track.getName(), track.getScheduleName(), si.getId(), track.getScheduleModeName().toLowerCase(), si.getTypeName(), si.getRoadName(), si.getReceiveLoadName()));
            }
            return null;
        }
        if (!this._train.isLoadNameAccepted(si.getReceiveLoadName(), si.getTypeName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrainNotNewLoad", this._train.getName(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName()));
            return null;
        }
        if (!car.getTrack().isLoadNameAndCarTypeShipped(si.getReceiveLoadName(), car.getTypeName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackNotLoadSchedule", car.getTrackName(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName(), si.getId()));
            return null;
        }
        if (!si.getSetoutTrainScheduleId().equals("") && !this.trainScheduleManager.getTrainScheduleActiveId().equals(si.getSetoutTrainScheduleId())) {
            log.debug("Schedule item isn't active");
            TrainSchedule aSch = this.trainScheduleManager.getScheduleById(this.trainScheduleManager.getTrainScheduleActiveId());
            TrainSchedule tSch = this.trainScheduleManager.getScheduleById(si.getSetoutTrainScheduleId());
            String aName = "";
            String tName = "";
            if (aSch != null) {
                aName = aSch.getName();
            }
            if (tSch != null) {
                tName = tSch.getName();
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildScheduleNotActive", track.getName(), si.getId(), tName, aName));
            return null;
        }
        if (!si.getRandom().equals("") && !si.doRandom()) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildScheduleRandom", track.getLocation().getName(), track.getName(), track.getScheduleName(), si.getId(), si.getReceiveLoadName(), si.getRandom(), si.getCalculatedRandom()));
            return null;
        }
        log.debug("Found track ({}) schedule item id ({}) for car ({})", new Object[]{track.getName(), si.getId(), car.toString()});
        return si;
    }

    protected void showCarServiceOrder(Car car) {
        if (!car.getTrack().getServiceOrder().equals(Track.NORMAL) && !car.getTrack().isStaging()) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackModePriority", car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), car.getTrack().getServiceOrder(), car.getLastDate()));
        }
    }

    protected List<Track> getTracksAtDestination(Car car, RouteLocation rld) {
        ArrayList<Track> tracks = new ArrayList<Track>();
        Location testDestination = rld.getLocation();
        for (Track track : testDestination.getTracksByNameList(null)) {
            if (!track.isAlternate()) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackIsAlternate", car.toString(), track.getTrackTypeName(), track.getLocation().getName(), track.getName()));
        }
        for (Track testTrack : testDestination.getTracksByMoves(null)) {
            String status;
            if (car.getSplitLocationName().equals(testTrack.getLocation().getSplitName()) && car.getSplitTrackName().equals(testTrack.getSplitName()) && !car.isPassenger() && !car.isCaboose() && !car.hasFred()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarSameTrack", car.toString(), testTrack.getName()));
                continue;
            }
            if (!this.checkDropTrainDirection(car, rld, testTrack) || !this.checkTrainCanDrop(car, testTrack)) continue;
            if (testTrack.getIgnoreUsedLengthPercentage() > 0) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackHasPlannedPickups", testTrack.getName(), testTrack.getIgnoreUsedLengthPercentage(), testTrack.getLength(), Setup.getLengthUnit().toLowerCase(), testTrack.getUsedLength(), testTrack.getReserved(), testTrack.getReservedLengthDrops(), testTrack.getReservedLengthDrops() - testTrack.getReserved(), testTrack.getAvailableTrackSpace()));
            }
            if ((status = car.checkDestination(testDestination, testTrack)).equals(Track.OKAY) && !testTrack.getScheduleId().equals("") && !car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && !car.getLoadName().equals(this.carLoads.getDefaultLoadName())) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildSpurScheduleLoad", testTrack.getName(), car.getLoadName()));
            }
            if (status.startsWith(Track.LENGTH)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), testTrack.getTrackTypeName(), testTrack.getLocation().getName(), testTrack.getName(), status));
                if (!this.checkForAlternate(car, testTrack)) continue;
                tracks.add(testTrack.getAlternateTrack());
                tracks.add(testTrack);
                break;
            }
            if (status.equals(Track.OKAY) && (status = this.checkReserved(this._train, rld, car, testTrack, true)).equals(TIMING) && this.checkForAlternate(car, testTrack)) {
                tracks.add(testTrack.getAlternateTrack());
                tracks.add(testTrack);
                break;
            }
            if (!status.equals(Track.OKAY)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), testTrack.getTrackTypeName(), testTrack.getLocation().getName(), testTrack.getName(), status));
                continue;
            }
            if (!this.checkForLocalMove(car, testTrack)) continue;
            tracks.add(testTrack);
            tracks.add(null);
            break;
        }
        return tracks;
    }

    protected boolean checkForAlternate(Car car, Track testTrack) {
        if (testTrack.getAlternateTrack() != null && car.getTrack() != testTrack.getAlternateTrack() && this.checkTrainCanDrop(car, testTrack.getAlternateTrack())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackFullHasAlternate", testTrack.getLocation().getName(), testTrack.getName(), testTrack.getAlternateTrack().getName()));
            String status = car.checkDestination(testTrack.getLocation(), testTrack.getAlternateTrack());
            if (status.equals(Track.OKAY)) {
                return true;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), testTrack.getAlternateTrack().getTrackTypeName(), testTrack.getLocation().getName(), testTrack.getAlternateTrack().getName(), status));
        }
        return false;
    }

    protected RouteLocation checkForEarlierDrop(Car car, Track trackTemp, RouteLocation rld, int start, int routeEnd) {
        RouteLocation rle;
        for (int m = start; m < routeEnd && (rle = this._routeList.get(m)) != rld; ++m) {
            if (!rle.getName().equals(rld.getName()) || rle.getCarMoves() >= rle.getMaxCarMoves() || !rle.isDropAllowed() || !this.checkDropTrainDirection(car, rle, trackTemp)) continue;
            log.debug("Found an earlier drop for car ({}) destination ({})", (Object)car.toString(), (Object)rle.getName());
            return rle;
        }
        return rld;
    }

    protected String checkReserved(Train train, RouteLocation rld, Car car, Track destTrack, boolean printMsg) {
        if (car.getTrack() != destTrack) {
            int length = car.getTotalKernelLength();
            log.debug("Car length: {}, available track space: {}, reserved: {}", new Object[]{length, destTrack.getAvailableTrackSpace(), destTrack.getReserved()});
            if (length > destTrack.getAvailableTrackSpace() + destTrack.getReserved()) {
                String trainExpectedArrival = train.getExpectedArrivalTime(rld, true);
                int trainArrivalTimeMinutes = this.convertStringTime(trainExpectedArrival);
                int reservedReturned = 0;
                if (car.getDestinationTrack() == destTrack) {
                    reservedReturned = -car.getTotalKernelLength();
                }
                List cars = this.carManager.getList(destTrack);
                for (Car kar : cars) {
                    int carPullTime;
                    if (kar.getTrain() == null || kar.getTrain() == train || trainArrivalTimeMinutes >= (carPullTime = this.convertStringTime(kar.getPickupTime()))) continue;
                    if (printMsg) {
                        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarTrainTiming", kar.toString(), kar.getTrack().getTrackTypeName(), kar.getLocationName(), kar.getTrackName(), kar.getTrainName(), kar.getPickupTime(), this._train.getName(), trainExpectedArrival));
                    }
                    reservedReturned += kar.getTotalLength();
                }
                if (length > destTrack.getAvailableTrackSpace() - reservedReturned) {
                    if (printMsg) {
                        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildWarnTrainTiming", car.toString(), destTrack.getTrackTypeName(), destTrack.getLocation().getName(), destTrack.getName(), this._train.getName(), destTrack.getAvailableTrackSpace() - reservedReturned, Setup.getLengthUnit().toLowerCase()));
                    }
                    return TIMING;
                }
            }
        }
        return Track.OKAY;
    }

    private boolean checkForLocalMove(Car car, Track testTrack) {
        if (this._train.isLocalSwitcher()) {
            if (!Setup.isLocalSpurMovesEnabled() && testTrack.isSpur() && car.getTrack().isSpur()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoSpurToSpurMove", car.getTrackName(), testTrack.getName()));
                return false;
            }
            if (!Setup.isLocalYardMovesEnabled() && testTrack.isYard() && car.getTrack().isYard() && !car.isCaboose() && !car.hasFred()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoYardToYardMove", car.getTrackName(), testTrack.getName()));
                return false;
            }
            if (!Setup.isLocalInterchangeMovesEnabled() && testTrack.isInterchange() && car.getTrack().isInterchange()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoInterchangeToInterchangeMove", car.getTrackName(), testTrack.getName()));
                return false;
            }
        }
        return true;
    }

    protected Track tryStaging(Car car, RouteLocation rldSave) throws BuildFailedException {
        if (this._train.isLocalSwitcher() && !car.isPassenger() && !car.isCaboose() && !car.hasFred() && car.getTrack() == this._terminateStageTrack) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarSameTrack", car.toString(), car.getTrack().getName()));
            return null;
        }
        String status = car.checkDestination(this._terminateStageTrack.getLocation(), this._terminateStageTrack);
        if (status.equals(Track.OKAY)) {
            return this._terminateStageTrack;
        }
        if (status.startsWith(Track.LOAD) && car.getTrack() == this._departStageTrack && car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && rldSave == null && (this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled() || this._departStageTrack.isAddCustomLoadsEnabled() || this._departStageTrack.isAddCustomLoadsAnySpurEnabled()) && this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack)) {
            return this._terminateStageTrack;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), this._terminateStageTrack.getTrackTypeName(), this._terminateStageTrack.getLocation().getName(), this._terminateStageTrack.getName(), status));
        return null;
    }

    protected boolean checkForLaterPickUp(Car car, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        if (rl != rld && rld.getName().equals(car.getLocationName())) {
            if (car.isCaboose() || car.isPassenger() || car.hasFred()) {
                return false;
            }
            if (car.getLocation().isStaging()) {
                return false;
            }
            if (!this.checkPickUpTrainDirection(car, rld)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoPickupLaterDirection", car.toString(), rld.getName(), rld.getId()));
                return false;
            }
            if (!rld.isPickUpAllowed()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoPickupLater", car.toString(), rld.getName(), rld.getId()));
                return false;
            }
            if (rld.getCarMoves() >= rld.getMaxCarMoves()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoPickupLaterMoves", car.toString(), rld.getName(), rld.getId()));
                return false;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildPickupLaterOkay", car.toString(), rld.getName(), rld.getId()));
            return true;
        }
        return false;
    }

    protected boolean checkThroughCarsAllowed(Car car, String destinationName) {
        if (!(this._train.isAllowThroughCarsEnabled() || this._train.isLocalSwitcher() || car.isCaboose() || car.hasFred() || car.isPassenger() || !car.getSplitLocationName().equals(this._departLocation.getSplitName()) || !TrainBuilderBase.splitString(destinationName).equals(this._terminateLocation.getSplitName()) || this._departLocation.getSplitName().equals(this._terminateLocation.getSplitName()))) {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildThroughTrafficNotAllow", this._departLocation.getName(), this._terminateLocation.getName()));
            return false;
        }
        return true;
    }

    private boolean checkLocalMovesAllowed(Car car, Track track) {
        if (!this._train.isLocalSwitcher() && !this._train.isAllowLocalMovesEnabled() && car.getSplitLocationName().equals(track.getLocation().getSplitName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoLocalMoveToTrack", car.getLocationName(), car.getTrackName(), track.getLocation().getName(), track.getName(), this._train.getName()));
            return false;
        }
        return true;
    }

    protected boolean generateLoadCarDepartingAndTerminatingIntoStaging(Car car, Track stageTrack) throws BuildFailedException {
        if (stageTrack == null || !stageTrack.isStaging()) {
            throw new BuildFailedException("ERROR coding issue, staging track null or not staging");
        }
        if (!stageTrack.isTypeNameAccepted(car.getTypeName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingTrackType", stageTrack.getName(), car.getTypeName()));
            return false;
        }
        if (!stageTrack.isRoadNameAccepted(car.getRoadName())) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingTrackRoad", stageTrack.getName(), car.getRoadName()));
            return false;
        }
        if (!(this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled() || car.isCaboose() || car.hasFred() || car.isPassenger() || !car.getSplitLocationName().equals(stageTrack.getLocation().getSplitName()))) {
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoReturnStaging", car.toString(), stageTrack.getLocation().getName()));
            return false;
        }
        List<String> loads = this.carLoads.getNames(car.getTypeName());
        loads.remove(this.carLoads.getDefaultEmptyName());
        loads.remove(this.carLoads.getDefaultLoadName());
        if (loads.size() == 0) {
            log.debug("No custom loads for car type ({}) ignoring staging track ({})", (Object)car.getTypeName(), (Object)stageTrack.getName());
            return false;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildSearchTrackLoadStaging", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getLocationName(), car.getTrackName(), stageTrack.getLocation().getName(), stageTrack.getName()));
        String oldLoad = car.getLoadName();
        for (int i = loads.size() - 1; i >= 0; --i) {
            String load = loads.get(i);
            log.debug("Try custom load ({}) for car ({})", (Object)load, (Object)car.toString());
            if (!(car.getTrack().isLoadNameAndCarTypeShipped(load, car.getTypeName()) && stageTrack.isLoadNameAndCarTypeAccepted(load, car.getTypeName()) && this._train.isLoadNameAccepted(load, car.getTypeName()))) {
                if (!car.getTrack().isLoadNameAndCarTypeShipped(load, car.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrackNotNewLoad", car.getTrackName(), load, stageTrack.getLocation().getName(), stageTrack.getName()));
                }
                if (!stageTrack.isLoadNameAndCarTypeAccepted(load, car.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildDestTrackNoLoad", stageTrack.getLocation().getName(), stageTrack.getName(), car.toString(), load));
                }
                if (!this._train.isLoadNameAccepted(load, car.getTypeName())) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildTrainNotNewLoad", this._train.getName(), load, stageTrack.getLocation().getName(), stageTrack.getName()));
                }
                loads.remove(i);
                continue;
            }
            car.setLoadName(load);
            if (car.getDivision() == null) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarHasDivisionStaging", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
            if ((!car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY) || car.getDivision() == stageTrack.getDivision()) && (!car.getLoadType().equals(CarLoad.LOAD_TYPE_LOAD) || car.getTrack().getDivision() == car.getDivision() || car.getDivision() == stageTrack.getDivision())) continue;
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildNoDivisionTrack", stageTrack.getTrackTypeName(), stageTrack.getLocation().getName(), stageTrack.getName(), stageTrack.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
            loads.remove(i);
        }
        boolean loadRestrictions = this.isLoadRestrictions();
        for (int i = loads.size() - 1; i >= 0; --i) {
            String load = loads.get(i);
            car.setLoadName(load);
            if (!this.router.isCarRouteable(car, this._train, stageTrack, this._buildReport)) {
                loads.remove(i);
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildStagingTrackNotReachable", stageTrack.getLocation().getName(), stageTrack.getName(), load));
                if (loadRestrictions) continue;
                loads.clear();
                break;
            }
            if (!loadRestrictions) break;
        }
        if (loads.size() > 0) {
            int rnd = (int)(Math.random() * (double)loads.size());
            car.setLoadName(loads.get(rnd));
            String status = car.checkDestination(stageTrack.getLocation(), stageTrack);
            if (status.equals(Track.OKAY) || status.startsWith(Track.LENGTH) && stageTrack != this._terminateStageTrack) {
                car.setLoadGeneratedFromStaging(true);
                car.setFinalDestination(stageTrack.getLocation());
                if (stageTrack == this._terminateStageTrack) {
                    car.setFinalDestinationTrack(stageTrack);
                } else {
                    car.setFinalDestinationTrack(null);
                }
                car.updateKernel();
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildAddingScheduleLoad", loads.size(), car.getLoadName(), car.toString()));
                return true;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), stageTrack.getTrackTypeName(), stageTrack.getLocation().getName(), stageTrack.getName(), status));
        }
        car.setLoadName(oldLoad);
        TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildUnableNewLoadStaging", car.toString(), car.getTrackName(), stageTrack.getLocation().getName(), stageTrack.getName()));
        return false;
    }

    private boolean isLoadRestrictions() {
        boolean restrictions;
        boolean bl = restrictions = this.isLoadRestrictionsTrain() || this.isLoadRestrictions("Interchange");
        if (Setup.isCarRoutingViaYardsEnabled()) {
            restrictions = restrictions || this.isLoadRestrictions("Yard");
        }
        return restrictions;
    }

    private boolean isLoadRestrictions(String type) {
        for (Track track : this.locationManager.getTracks(type)) {
            if (track.getLoadOption().equals(Track.ALL_LOADS)) continue;
            return true;
        }
        return false;
    }

    private boolean isLoadRestrictionsTrain() {
        for (Train train : this.trainManager.getTrainsByIdList()) {
            if (train.getLoadOption().equals(Train.ALL_LOADS)) continue;
            return true;
        }
        return false;
    }

    protected void showCarsNotMoved(RouteLocation rl) {
        if (this._carIndex < 0) {
            this._carIndex = 0;
        }
        int numberCars = 0;
        for (int i = this._carIndex; i < this._carList.size(); ++i) {
            if (numberCars == 100) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOnlyFirstXXXCars", numberCars, rl.getName()));
                break;
            }
            Car car = this._carList.get(i);
            if (!car.getLocationName().equals(rl.getName()) || car.getRouteDestination() != null) continue;
            if (numberCars == 0) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildMovesCompleted", rl.getMaxCarMoves(), rl.getName()));
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCarIgnored", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getLocationName(), car.getTrackName()));
            ++numberCars;
        }
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
    }

    protected void removeRollingStockFromTrain(RollingStock rs) {
        boolean inTrain = false;
        for (RouteLocation routeLocation : this._routeList) {
            if (rs.getRouteLocation() == routeLocation) {
                inTrain = true;
            }
            if (rs.getRouteDestination() == routeLocation) break;
            if (!inTrain) continue;
            routeLocation.setTrainLength(routeLocation.getTrainLength() - rs.getTotalLength());
            routeLocation.setTrainWeight(routeLocation.getTrainWeight() - rs.getAdjustedWeightTons());
        }
        rs.reset();
    }

    protected void showCarsNotRoutable() {
        if (this._notRoutable.size() > 0) {
            TrainBuilderBase.addLine(this._buildReport, ONE, " ");
            TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildCarsNotRoutable"));
            for (Car car : this._notRoutable) {
                ++this._warnings;
                TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildCarNotRoutable", car.toString(), car.getLocationName(), car.getTrackName(), car.getPreviousFinalDestinationName(), car.getPreviousFinalDestinationTrackName()));
            }
            TrainBuilderBase.addLine(this._buildReport, ONE, " ");
        }
    }

    protected void removeCarsFromStaging() {
        if (this._departStageTrack == null) {
            log.error("Error, called when cars in staging not assigned to train");
            return;
        }
        for (Car car : this._carList) {
            if (car.getTrack() != this._departStageTrack || car.getTrain() != null) continue;
            if (car.getKernel() != null) {
                for (Car c : car.getKernel().getCars()) {
                    c.setLocation(car.getLocation(), null);
                }
                continue;
            }
            car.setLocation(car.getLocation(), null);
        }
    }

    protected void addEnginesBasedHPT(int hpAvailable, int extraHpNeeded, RouteLocation rlNeedHp, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        if (rlNeedHp == null) {
            return;
        }
        int numberLocos = 0;
        List engines = this.engineManager.getList(this._train);
        for (Engine rs : engines) {
            if (rs.getRouteLocation() != rl) continue;
            ++numberLocos;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, " ");
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildTrainReqExtraHp", extraHpNeeded, rlNeedHp.getName(), rld.getName(), numberLocos));
        String model = this._train.getEngineModel();
        String road = this._train.getEngineRoad();
        if ((this._train.getSecondLegOptions() & 1) == 1 && rl == this._train.getSecondLegStartRouteLocation()) {
            model = this._train.getSecondLegEngineModel();
            road = this._train.getSecondLegEngineRoad();
        } else if ((this._train.getThirdLegOptions() & 1) == 1 && rl == this._train.getThirdLegStartRouteLocation()) {
            model = this._train.getThirdLegEngineModel();
            road = this._train.getThirdLegEngineRoad();
        }
        while (numberLocos < Setup.getMaxNumberEngines()) {
            if (!this.getEngines(ONE, model, road, rl, rld, numberLocos > 0)) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorEngines", Bundle.getMessage("additional"), rl.getName(), rld.getName()));
            }
            ++numberLocos;
            int currentHp = this._train.getTrainHorsePower(rlNeedHp);
            if (currentHp > hpAvailable + extraHpNeeded) break;
            if (numberLocos < Setup.getMaxNumberEngines()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, " ");
                TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildContinueAddLocos", hpAvailable + extraHpNeeded - currentHp, rlNeedHp.getName(), rld.getName(), numberLocos, currentHp));
                continue;
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildMaxNumberLocoAssigned", Setup.getMaxNumberEngines()));
        }
    }

    private void addEngineToTrain(Engine engine, RouteLocation rl, RouteLocation rld, Track track) {
        this._lastEngine = engine;
        if (this._train.getLeadEngine() == null) {
            this._train.setLeadEngine(engine);
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildEngineAssigned", engine.toString(), rl.getName(), rld.getName(), track.getName()));
        engine.setDestination(track.getLocation(), track);
        int length = engine.getTotalLength();
        int weightTons = engine.getAdjustedWeightTons();
        if (engine.getConsist() != null) {
            length = engine.getConsist().getTotalLength();
            weightTons = engine.getConsist().getAdjustedWeightTons();
            for (Engine cEngine : engine.getConsist().getEngines()) {
                if (cEngine == engine) continue;
                TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildEngineAssigned", cEngine.toString(), rl.getName(), rld.getName(), track.getName()));
                cEngine.setTrain(this._train);
                cEngine.setRouteLocation(rl);
                cEngine.setRouteDestination(rld);
                cEngine.setDestination(track.getLocation(), track, true);
            }
        }
        this.finishAddRsToTrain(engine, rl, rld, length, weightTons);
    }

    private boolean buildConsistFromSingleLocos(int reqNumberEngines, List<Engine> singleLocos, RouteLocation rl, RouteLocation rld) {
        block6: {
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOptionBuildConsist", reqNumberEngines, rl.getName()));
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildOptionSingleLocos", singleLocos.size(), rl.getName()));
            if (singleLocos.size() < reqNumberEngines) break block6;
            int locos = 0;
            for (Engine engine : singleLocos) {
                if (engine.isBunit() || !this.setEngineDestination(engine, rl, rld)) continue;
                this._engineList.remove(engine);
                singleLocos.remove(engine);
                ++locos;
                break;
            }
            if (locos > 0) {
                for (Engine engine : singleLocos) {
                    if (this.setEngineDestination(engine, rl, rld)) {
                        this._engineList.remove(engine);
                        ++locos;
                    }
                    if (locos != reqNumberEngines) continue;
                    return true;
                }
            } else {
                for (Engine engine : singleLocos) {
                    if (!engine.isBunit()) continue;
                    TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("BuildEngineBunit", engine.toString(), engine.getLocationName(), engine.getTrackName()));
                }
            }
        }
        return false;
    }

    protected int getNumberEngines(String requestEngines) {
        int numberEngines = 0;
        numberEngines = requestEngines.equals(Train.AUTO) ? this.getAutoEngines() : (requestEngines.equals(Train.AUTO_HPT) ? 1 : Integer.parseInt(requestEngines));
        return numberEngines;
    }

    protected boolean setEngineDestination(Engine engine, RouteLocation rl, RouteLocation rld) {
        if (rld == this._train.getTrainTerminatesRouteLocation() && this._terminateStageTrack != null) {
            String status = engine.checkDestination(this._terminateStageTrack.getLocation(), this._terminateStageTrack);
            if (status.equals(Track.OKAY)) {
                this.addEngineToTrain(engine, rl, rld, this._terminateStageTrack);
                return true;
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropEngineToTrack", engine.toString(), this._terminateStageTrack.getTrackTypeName(), this._terminateStageTrack.getLocation().getName(), this._terminateStageTrack.getName(), status));
        } else {
            Location destination = rld.getLocation();
            List<Track> destTracks = destination.getTracksByMoves(null);
            if (destTracks.size() == 0) {
                TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildNoTracksAtDestination", rld.getName()));
            }
            for (Track track : destTracks) {
                if (!this.checkDropTrainDirection(engine, rld, track) || !this.checkTrainCanDrop(engine, track)) continue;
                String status = engine.checkDestination(destination, track);
                if (status.equals(Track.OKAY)) {
                    this.addEngineToTrain(engine, rl, rld, track);
                    return true;
                }
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildCanNotDropEngineToTrack", engine.toString(), track.getTrackTypeName(), track.getLocation().getName(), track.getName(), status));
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildCanNotDropEngToDest", engine.toString(), rld.getName()));
        }
        return false;
    }

    private int getAutoEngines() {
        double numberEngines = 1.0;
        int moves = 0;
        int carLength = 40 + Car.COUPLERS;
        if (!Setup.getLengthUnit().equals(Setup.FEET)) {
            carLength = 12 + Car.COUPLERS;
        }
        for (RouteLocation rl : this._routeList) {
            if (!rl.isPickUpAllowed() || rl == this._train.getTrainTerminatesRouteLocation()) continue;
            moves += rl.getMaxCarMoves();
            double carDivisor = 16.0;
            if (rl.getGrade() > 1.0) {
                carDivisor /= rl.getGrade();
            }
            log.debug("Maximum train length {} for location ({})", (Object)rl.getMaxTrainLength(), (Object)rl.getName());
            if (!((double)rl.getMaxTrainLength() / (carDivisor * (double)carLength) > numberEngines)) continue;
            numberEngines = (double)rl.getMaxTrainLength() / (carDivisor * (double)carLength);
            if (!((numberEngines = Math.ceil(numberEngines)) > (double)moves / carDivisor)) continue;
            numberEngines = Math.ceil((double)moves / carDivisor);
        }
        int nE = (int)numberEngines;
        if (this._train.isLocalSwitcher()) {
            nE = 1;
        }
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildAutoBuildMsg", Integer.toString(nE)));
        if (nE > Setup.getMaxNumberEngines()) {
            TrainBuilderBase.addLine(this._buildReport, THREE, Bundle.getMessage("buildMaximumNumberEngines", Setup.getMaxNumberEngines()));
            nE = Setup.getMaxNumberEngines();
        }
        return nE;
    }

    protected boolean getConsist(String reqNumEngines, String model, String road, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        if (reqNumEngines.equals(Train.AUTO_HPT)) {
            for (int i = 2; i < Setup.getMaxNumberEngines(); ++i) {
                if (!this.getEngines(Integer.toString(i), model, road, rl, rld)) continue;
                return true;
            }
        }
        return false;
    }

    protected void showEnginesByLocation() {
        TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        TrainBuilderBase.addLine(this._buildReport, ONE, Bundle.getMessage("buildFoundLocos", Integer.toString(this._engineList.size()), this._train.getName()));
        ArrayList<String> locationNames = new ArrayList<String>();
        for (RouteLocation rl : this._train.getRoute().getLocationsBySequenceList()) {
            if (locationNames.contains(rl.getName())) continue;
            locationNames.add(rl.getName());
            int count = this.countRollingStockAt(rl, new ArrayList<RollingStock>(this._engineList));
            if (rl.getLocation().isStaging()) {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLocosInStaging", count, rl.getName()));
            } else {
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLocosAtLocation", count, rl.getName()));
            }
            for (Engine engine : this._engineList) {
                if (!engine.getLocationName().equals(rl.getName())) continue;
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildLocoAtLocWithMoves", engine.toString(), engine.getTypeName(), engine.getModel(), engine.getLocationName(), engine.getTrackName(), engine.getMoves()));
            }
            TrainBuilderBase.addLine(this._buildReport, SEVEN, " ");
        }
    }

    protected int countRollingStockAt(RouteLocation rl, List<RollingStock> list) {
        int count = 0;
        for (RollingStock rs : list) {
            if (!rs.getLocationName().equals(rl.getName())) continue;
            ++count;
        }
        return count;
    }

    protected boolean getEngines(String requestedEngines, String model, String road, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        return this.getEngines(requestedEngines, model, road, rl, rld, false);
    }

    protected boolean getEngines(String requestedEngines, String model, String road, RouteLocation rl, RouteLocation rld, boolean useBunit) throws BuildFailedException {
        Track departStageTrack = null;
        if (rl == this._train.getTrainDepartsRouteLocation()) {
            departStageTrack = this._departStageTrack;
        }
        int reqNumberEngines = this.getNumberEngines(requestedEngines);
        if (departStageTrack == null && reqNumberEngines == 0) {
            return true;
        }
        if (departStageTrack != null && reqNumberEngines == 0 && departStageTrack.getNumberEngines() == 0) {
            return true;
        }
        if (departStageTrack != null && reqNumberEngines != 0 && departStageTrack.getNumberEngines() != reqNumberEngines) {
            throw new BuildFailedException(Bundle.getMessage("buildStagingNotEngines", departStageTrack.getName(), departStageTrack.getNumberEngines(), reqNumberEngines));
        }
        if (rl == null || rld == null) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorEngLocUnknown"));
        }
        TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildBegineSearchEngines", reqNumberEngines, model, road, rl.getName(), rld.getName()));
        int assignedLocos = 0;
        ArrayList<Engine> singleLocos = new ArrayList<Engine>();
        for (int indexEng = 0; indexEng < this._engineList.size(); ++indexEng) {
            Engine engine = this._engineList.get(indexEng);
            log.debug("Engine ({}) at location ({}, {})", new Object[]{engine.toString(), engine.getLocationName(), engine.getTrackName()});
            if (departStageTrack != null && !departStageTrack.equals(engine.getTrack())) continue;
            if (!engine.getLocationName().equals(rl.getName())) {
                log.debug("Skipping engine ({}) at location ({})", (Object)engine.toString(), (Object)engine.getLocationName());
                continue;
            }
            if (!model.equals("") && !engine.getModel().equals(model)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeEngineModel", engine.toString(), engine.getModel(), engine.getLocationName()));
                continue;
            }
            if (!road.equals("") && !engine.getRoadName().equals(road)) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeEngineRoad", engine.toString(), engine.getLocationName(), engine.getTrackName(), engine.getRoadName()));
                continue;
            }
            if (!this.checkPickUpTrainDirection(engine, rl)) continue;
            if (engine.getDestination() != null && !engine.getDestinationName().equals(rld.getName())) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeEngineDestination", engine.toString(), engine.getDestinationName()));
                continue;
            }
            if (engine.getConsist() != null) {
                if (!engine.isLead()) continue;
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildEngineLeadConsist", engine.toString(), engine.getConsist().getName(), engine.getConsist().getEngines().size()));
            }
            if (departStageTrack != null) {
                if (!this.setEngineDestination(engine, rl, rld)) {
                    return false;
                }
                this._engineList.remove(indexEng--);
                if (engine.getConsist() != null) {
                    assignedLocos += engine.getConsist().getSize();
                    continue;
                }
                ++assignedLocos;
                continue;
            }
            if (!useBunit && reqNumberEngines == 1 && engine.isBunit()) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeEngineBunit", engine.toString(), engine.getModel()));
                continue;
            }
            if (engine.getConsist() == null) {
                if (reqNumberEngines > 1) {
                    TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeEngineSingle", engine.toString(), reqNumberEngines));
                    singleLocos.add(engine);
                    continue;
                }
            } else if (engine.getConsist().getSize() == reqNumberEngines) {
                log.debug("Consist ({}) has the required number of engines", (Object)engine.getConsist().getName());
            } else if (reqNumberEngines != 0) {
                TrainBuilderBase.addLine(this._buildReport, SEVEN, Bundle.getMessage("buildExcludeEngConsistNumber", engine.toString(), engine.getConsist().getName(), engine.getConsist().getSize()));
                continue;
            }
            ++assignedLocos;
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildEngineRoadModelType", engine.toString(), engine.getRoadName(), engine.getModel(), engine.getTypeName(), engine.getLocationName(), engine.getTrackName(), rld.getName()));
            if (!this.setEngineDestination(engine, rl, rld)) continue;
            this._engineList.remove(indexEng--);
            return true;
        }
        if (assignedLocos == 0 && reqNumberEngines > 1 && this._train.isBuildConsistEnabled() && this.buildConsistFromSingleLocos(reqNumberEngines, singleLocos, rl, rld)) {
            return true;
        }
        if (assignedLocos == 0) {
            Object locationName = rl.getName();
            if (departStageTrack != null) {
                locationName = (String)locationName + ", " + departStageTrack.getName();
            }
            TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildNoLocosFoundAtLocation", locationName));
        } else if (departStageTrack != null && (reqNumberEngines == 0 || reqNumberEngines == assignedLocos)) {
            return true;
        }
        return false;
    }

    protected void getNewEngine(int hpNeeded, Engine leadEngine, String model, String road) throws BuildFailedException {
        RouteLocation rl = leadEngine.getRouteLocation();
        RouteLocation rld = leadEngine.getRouteDestination();
        this.removeEngineFromTrain(leadEngine);
        this._engineList.add(0, leadEngine);
        if (hpNeeded < 50) {
            hpNeeded = 50;
        }
        int hpMax = hpNeeded;
        boolean foundLoco = false;
        ArrayList<Engine> rejectedLocos = new ArrayList<Engine>();
        block0: while (hpMax < 20000) {
            log.debug("Max hp {}", (Object)(hpMax += hpNeeded / 2));
            for (Engine engine : this._engineList) {
                if (rejectedLocos.contains(engine) || engine.getConsist() != null && !engine.isLead() || engine.getLocation() != rl.getLocation() || !model.equals("") && !engine.getModel().equals(model) || !road.equals("") && !engine.getRoadName().equals(road) || road.equals("") && !this._train.isLocoRoadNameAccepted(engine.getRoadName())) continue;
                int engineHp = engine.getHpInteger();
                if (engine.getConsist() != null) {
                    for (Engine e : engine.getConsist().getEngines()) {
                        if (e == engine) continue;
                        engineHp += e.getHpInteger();
                    }
                }
                if (engineHp <= hpNeeded || engineHp > hpMax) continue;
                TrainBuilderBase.addLine(this._buildReport, FIVE, Bundle.getMessage("buildLocoHasRequiredHp", engine.toString(), engineHp, hpNeeded));
                if (this.setEngineDestination(engine, rl, rld)) {
                    foundLoco = true;
                    break block0;
                }
                rejectedLocos.add(engine);
            }
        }
        if (!foundLoco && !this._train.isBuildConsistEnabled()) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorEngHp", rl.getLocation().getName()));
        }
    }

    protected void removeEngineFromTrain(Engine engine) {
        if (this._train.getLeadEngine() == engine) {
            this._train.setLeadEngine(null);
        }
        if (engine.getConsist() != null) {
            for (Engine e : engine.getConsist().getEngines()) {
                this.removeRollingStockFromTrain(e);
            }
        } else {
            this.removeRollingStockFromTrain(engine);
        }
    }
}

