/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.trainbuilder;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jmri.InstanceManager;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.schedules.ScheduleItem;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarLoad;
import jmri.jmrit.operations.rollingstock.cars.Kernel;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.router.Router;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.trainbuilder.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainBuilderEngines;
import jmri.jmrit.operations.trains.trainbuilder.TrainCommon;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainBuilderCars
extends TrainBuilderEngines {
    private static final boolean HOME_DIVISION = true;
    boolean _routeToTrackFound;
    private static final Logger log = LoggerFactory.getLogger(TrainBuilderCars.class);

    /*
     * Unable to fully structure code
     */
    protected void getCaboose(String roadCaboose, Engine leadEngine, RouteLocation rl, RouteLocation rld, boolean requiresCaboose) throws BuildFailedException {
        if (rl == null) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorCabooseNoLocation", new Object[]{this._train.getName()}));
        }
        if (rld == null) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorCabooseNoDestination", new Object[]{this._train.getName(), rl.getName()}));
        }
        departTrack = null;
        if (rl == this._train.getTrainDepartsRouteLocation()) {
            departTrack = this._departStageTrack;
        }
        if (!requiresCaboose) {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildTrainNoCaboose", new Object[]{rl.getName()}));
            if (departTrack == null) {
                return;
            }
        } else {
            TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildTrainReqCaboose", new Object[]{this._train.getName(), roadCaboose, rl.getName(), rld.getName()}));
        }
        cabooseTip = true;
        cabooseAtDeparture = false;
        foundCaboose = false;
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            block28: {
                block30: {
                    block29: {
                        car = (Car)this._carList.get(this._carIndex);
                        if (!car.isCaboose()) break block28;
                        this.showCarServiceOrder(car);
                        cabooseTip = false;
                        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarIsCaboose", new Object[]{car.toString(), car.getRoadName(), car.getLocationName(), car.getTrackName()}));
                        if (car.getTrack() != departTrack) break block29;
                        foundCaboose = false;
                        if (!this.generateCarLoadFromStaging(car, rld) && car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() && rld.getLocation() == this._terminateLocation && this._terminateStageTrack != null) {
                            this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack);
                        }
                        if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                            if (car.getTrain() == this._train) {
                                foundCaboose = true;
                            }
                        } else if (this.findDestinationAndTrack(car, rl, rld)) {
                            foundCaboose = true;
                        }
                        if (!foundCaboose) {
                            throw new BuildFailedException(Bundle.getMessage("buildErrorCarStageDest", new Object[]{car.toString()}));
                        }
                        break block28;
                    }
                    if (!roadCaboose.equals("") && !roadCaboose.equals(car.getRoadName()) || foundCaboose || !car.getLocationName().equals(rl.getName())) break block28;
                    if (this.checkPickUpTrainDirection(car, rl)) break block30;
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarTypeAtLoc", new Object[]{car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName()}));
                    this._carList.remove(car);
                    --this._carIndex;
                    break block28;
                }
                if (leadEngine == null || !car.getRoadName().equals(leadEngine.getRoadName())) ** GOTO lbl-1000
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCabooseRoadMatches", new Object[]{car.toString(), car.getRoadName(), leadEngine.toString()}));
                if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                    if (car.getTrain() == this._train) {
                        foundCaboose = true;
                    }
                } else if (this.findDestinationAndTrack(car, rl, rld)) {
                    foundCaboose = true;
                }
                if (!foundCaboose) {
                    this._carList.remove(car);
                    --this._carIndex;
                } else if (foundCaboose && departTrack == null) break;
            }
            ++this._carIndex;
        }
        if (requiresCaboose && !foundCaboose && roadCaboose.equals("")) {
            TrainBuilderCars.log.debug("Second pass looking for caboose");
            for (Car car : this._carList) {
                if (!car.isCaboose() || !car.getLocationName().equals(rl.getName()) || leadEngine == null || !TrainCommon.splitString(car.getRoadName()).equals(TrainCommon.splitString(leadEngine.getRoadName()))) continue;
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCabooseRoadMatches", new Object[]{car.toString(), car.getRoadName(), leadEngine.toString()}));
                if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                    if (car.getTrain() != this._train) continue;
                    foundCaboose = true;
                    break;
                }
                if (!this.findDestinationAndTrack(car, rl, rld)) continue;
                foundCaboose = true;
                break;
            }
        }
        if (requiresCaboose && !foundCaboose) {
            TrainBuilderCars.log.debug("Third pass looking for caboose");
            for (Car car : this._carList) {
                if (!car.isCaboose() || !car.getLocationName().equals(rl.getName()) || !roadCaboose.equals("") && !roadCaboose.equals(car.getRoadName())) continue;
                cabooseAtDeparture = true;
                if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                    if (car.getTrain() != this._train) continue;
                    foundCaboose = true;
                    break;
                }
                if (!this.findDestinationAndTrack(car, rl, rld)) continue;
                foundCaboose = true;
                break;
            }
        }
        if (requiresCaboose && !foundCaboose) {
            if (cabooseTip) {
                TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildNoteCaboose"));
                TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildNoteCaboose2"));
            }
            if (!cabooseAtDeparture) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorReqDepature", new Object[]{this._train.getName(), Bundle.getMessage("Caboose").toLowerCase(), rl.getName()}));
            }
            throw new BuildFailedException(Bundle.getMessage("buildErrorReqDest", new Object[]{this._train.getName(), Bundle.getMessage("Caboose"), rld.getName()}));
        }
    }

    protected void getCarWithFred(String road, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        Track departTrack = null;
        if (rl == this._train.getTrainDepartsRouteLocation()) {
            departTrack = this._departStageTrack;
        }
        boolean foundCarWithFred = false;
        if (this._train.isFredNeeded()) {
            TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildTrainReqFred", this._train.getName(), road, rl.getName(), rld.getName()));
        } else {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildTrainNoFred"));
            if (departTrack == null) {
                return;
            }
        }
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            Car car = (Car)this._carList.get(this._carIndex);
            if (car.hasFred()) {
                this.showCarServiceOrder(car);
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarHasFRED", car.toString(), car.getRoadName(), car.getLocationName(), car.getTrackName()));
                if (car.getTrack() == departTrack) {
                    foundCarWithFred = false;
                    if (!this.generateCarLoadFromStaging(car, rld) && car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() && rld.getLocation() == this._terminateLocation && this._terminateStageTrack != null) {
                        this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack);
                    }
                    if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                        if (car.getTrain() == this._train) {
                            foundCarWithFred = true;
                        }
                    } else if (this.findDestinationAndTrack(car, rl, rld)) {
                        foundCarWithFred = true;
                    }
                    if (!foundCarWithFred) {
                        throw new BuildFailedException(Bundle.getMessage("buildErrorCarStageDest", car.toString()));
                    }
                } else if (!road.equals("") && !road.equals(car.getRoadName())) {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarWrongRoad", car.toString(), car.getLocationName(), car.getTrackName(), car.getTypeName(), car.getRoadName()));
                    this._carList.remove(car);
                    --this._carIndex;
                } else if (!foundCarWithFred && car.getLocationName().equals(rl.getName())) {
                    if (!this.checkPickUpTrainDirection(car, rl)) {
                        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeCarTypeAtLoc", car.toString(), car.getTypeName(), car.getTypeExtensions(), car.getLocationName(), car.getTrackName()));
                        this._carList.remove(car);
                        --this._carIndex;
                    } else {
                        if (this.checkAndAddCarForDestinationAndTrack(car, rl, rld)) {
                            if (car.getTrain() == this._train) {
                                foundCarWithFred = true;
                            }
                        } else if (this.findDestinationAndTrack(car, rl, rld)) {
                            foundCarWithFred = true;
                        }
                        if (foundCarWithFred && departTrack == null) break;
                    }
                }
            }
            ++this._carIndex;
        }
        if (this._train.isFredNeeded() && !foundCarWithFred) {
            throw new BuildFailedException(Bundle.getMessage("buildErrorRequirements", this._train.getName(), Bundle.getMessage("FRED"), rl.getName(), rld.getName()));
        }
    }

    private boolean checkAndAddCarForDestinationAndTrack(Car car, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        return this.checkCarForDestination(car, rl, this._routeList.indexOf(rld));
    }

    protected void blockCarsFromStaging() throws BuildFailedException {
        if (this._departStageTrack == null || !this._departStageTrack.isBlockCarsEnabled()) {
            return;
        }
        TrainBuilderCars.addLine(this._buildReport, "3", " ");
        TrainBuilderCars.addLine(this._buildReport, "3", Bundle.getMessage("blockDepartureHasBlocks", this._departStageTrack.getName(), this._numOfBlocks.size()));
        Enumeration en = this._numOfBlocks.keys();
        while (en.hasMoreElements()) {
            String locId = (String)en.nextElement();
            int numCars = (Integer)this._numOfBlocks.get(locId);
            String locName = "";
            Location l = this.locationManager.getLocationById(locId);
            if (l != null) {
                locName = l.getName();
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockFromHasCars", locId, locName, numCars));
            if (this._numOfBlocks.size() >= 2) continue;
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockUnable"));
            return;
        }
        this.blockCarsByLocationMoves();
        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockDone", this._departStageTrack.getName()));
    }

    private void blockCarsByLocationMoves() throws BuildFailedException {
        RouteLocation rld;
        String blockId;
        List<RouteLocation> blockRouteList = this._train.getRoute().getLocationsBySequenceList();
        for (RouteLocation rl : blockRouteList) {
            if (rl == this._train.getTrainDepartsRouteLocation()) continue;
            int possibleMoves = rl.getMaxCarMoves() - rl.getCarMoves();
            if (!rl.isDropAllowed() || possibleMoves <= 0) continue;
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockLocationHasMoves", rl.getName(), possibleMoves));
        }
        while (!(blockId = this.getLargestBlock()).isEmpty() && (Integer)this._numOfBlocks.get(blockId) != 1 && (rld = this.getLocationWithMaximumMoves(blockRouteList, blockId)) != null) {
            if (rld.getMaxCarMoves() > (Integer)this._numOfBlocks.get(blockId)) {
                this._numOfBlocks.remove(blockId);
                if (blockId.equals("0")) continue;
                blockRouteList.remove(rld);
                Location loc = this.locationManager.getLocationById(blockId);
                Location setOutLoc = rld.getLocation();
                if (loc == null || setOutLoc == null || !this.checkDropTrainDirection(rld)) continue;
                this._carIndex = 0;
                while (this._carIndex < this._carList.size()) {
                    Car car = (Car)this._carList.get(this._carIndex);
                    if (car.getTrack() == this._departStageTrack && car.getLastLocationId().equals(blockId)) {
                        if (car.getDestination() != null) {
                            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockNotAbleDest", car.toString(), car.getDestinationName()));
                        } else if (car.getFinalDestination() != null) {
                            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockNotAbleFinalDest", car.toString(), car.getFinalDestination().getName()));
                        } else if (!car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && !car.getLoadName().equals(this.carLoads.getDefaultLoadName())) {
                            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockNotAbleCustomLoad", car.toString(), car.getLoadName()));
                        } else if (car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && (this._departStageTrack.isAddCustomLoadsEnabled() || this._departStageTrack.isAddCustomLoadsAnySpurEnabled() || this._departStageTrack.isAddCustomLoadsAnyStagingTrackEnabled())) {
                            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockNotAbleCarTypeGenerate", car.toString(), car.getLoadName()));
                        } else {
                            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockingCar", car.toString(), loc.getName(), rld.getName()));
                            if (!this.findDestinationAndTrack(car, this._train.getTrainDepartsRouteLocation(), rld)) {
                                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockNotAbleCarType", car.toString(), rld.getName(), car.getTypeName()));
                            }
                        }
                    }
                    ++this._carIndex;
                }
                continue;
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("blockDestNotEnoughMoves", rld.getName(), blockId));
            this._numOfBlocks.remove(blockId);
        }
    }

    protected void findDestinationsForCarsFromLocation(RouteLocation rl, boolean isSecondPass) throws BuildFailedException {
        if (this._reqNumOfMoves <= 0) {
            return;
        }
        if (!rl.isLocalMovesAllowed() && isSecondPass) {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRouteNoLocalLocation", this._train.getRoute().getName(), rl.getId(), rl.getName()));
            TrainBuilderCars.addLine(this._buildReport, "5", " ");
            return;
        }
        boolean messageFlag = true;
        boolean foundCar = false;
        this._carIndex = 0;
        while (this._carIndex < this._carList.size()) {
            Car car = (Car)this._carList.get(this._carIndex);
            if ((!isSecondPass || car.getFinalDestinationName().equals(rl.getName())) && car.getLocationName().equals(rl.getName())) {
                foundCar = true;
                if (isSecondPass && messageFlag) {
                    messageFlag = false;
                    TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildExtraPassForLocation", rl.getName()));
                    TrainBuilderCars.addLine(this._buildReport, "7", " ");
                }
                if (!(rl.isPickUpAllowed() || car.isLocalMove() || car.getSplitFinalDestinationName().equals(rl.getSplitName()))) {
                    TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoPickUpCar", car.toString(), rl.getLocation().getName(), rl.getId()));
                    TrainBuilderCars.addLine(this._buildReport, "5", " ");
                } else {
                    if (!rl.isLocalMovesAllowed() && car.getSplitFinalDestinationName().equals(rl.getSplitName())) {
                        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRouteNoLocalLocation", this._train.getRoute().getName(), rl.getId(), rl.getName()));
                    }
                    if (!this.checkPickUpTrainDirection(car, rl)) {
                        TrainBuilderCars.addLine(this._buildReport, "5", " ");
                    } else {
                        this.showCarServiceOrder(car);
                        if (!(this.generateCarLoadFromStaging(car) || this.generateCarLoadStagingToStaging(car) || car.getTrack() != this._departStageTrack || this._departStageTrack.isLoadNameAndCarTypeShipped(car.getLoadName(), car.getTypeName()))) {
                            TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildErrorCarStageLoad", car.toString(), car.getLoadName(), this._departStageTrack.getName()));
                            TrainBuilderCars.addLine(this._buildReport, "5", " ");
                        } else if (this.checkQuickServiceDeparting(car, rl)) {
                            if (!this.findDestinationsForCarsWithHomeDivision(car)) {
                                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoDestForCar", car.toString()));
                                TrainBuilderCars.addLine(this._buildReport, "5", " ");
                            } else if (this.findFinalDestinationForCarLoad(car) && car.getDestination() == null && car.getTrack() != this._departStageTrack) {
                                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoDestForCar", car.toString()));
                                TrainBuilderCars.addLine(this._buildReport, "5", " ");
                            } else {
                                if (this.checkCarForFinalDestination(car)) {
                                    log.debug("Car ({}) has a final desination that can't be serviced by train", (Object)car.toString());
                                } else if (this.checkCarForDestination(car, rl, this._routeList.indexOf(rl))) {
                                    log.debug("Car ({}) has desination ({}) using train ({})", new Object[]{car.toString(), car.getDestinationName(), car.getTrainName()});
                                } else {
                                    this.findDestinationAndTrack(car, rl, this._routeList.indexOf(rl), this._routeList.size());
                                }
                                if (this._reqNumOfMoves <= 0) break;
                                if (car.getTrack() == this._departStageTrack && (car.getDestination() == null || car.getDestinationTrack() == null || car.getTrain() == null)) {
                                    TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildWarningCarStageDest", car.toString()));
                                    if (car.getFinalDestinationTrack() != null && car.getFinalDestinationTrack() == this._terminateStageTrack) {
                                        TrainBuilderCars.addLine(this._buildReport, "3", Bundle.getMessage("buildStagingCarHasFinal", car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
                                        car.reset();
                                    }
                                    TrainBuilderCars.addLine(this._buildReport, "7", " ");
                                }
                            }
                        }
                    }
                }
            }
            ++this._carIndex;
        }
        if (!foundCar && !isSecondPass) {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoCarsAtLocation", rl.getName()));
            TrainBuilderCars.addLine(this._buildReport, "5", " ");
        }
    }

    private boolean generateCarLoadFromStaging(Car car) throws BuildFailedException {
        return this.generateCarLoadFromStaging(car, null);
    }

    private boolean generateCarLoadFromStaging(Car car, RouteLocation rld) throws BuildFailedException {
        if (car.getTrack() == null) {
            throw new BuildFailedException(Bundle.getMessage("buildWarningRsNoTrack", car.toString(), car.getLocationName()));
        }
        if (!car.getTrack().isStaging() || !car.getTrack().isAddCustomLoadsAnySpurEnabled() && !car.getTrack().isAddCustomLoadsEnabled() || !car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) || car.getDestination() != null || car.getFinalDestination() != null) {
            log.debug("No load generation for car ({}) isAddLoadsAnySpurEnabled: {}, car load ({}) destination ({}) final destination ({})", new Object[]{car.toString(), car.getTrack().isAddCustomLoadsAnySpurEnabled() ? "true" : "false", car.getLoadName(), car.getDestinationName(), car.getFinalDestinationName()});
            if (car.getTrack().isStaging() && car.getTrack().isAddCustomLoadsAnySpurEnabled() && car.getLoadName().equals(this.carLoads.getDefaultEmptyName())) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarNoLoadGenerated", car.toString(), car.getLoadName(), car.getDestinationName(), car.getFinalDestinationName()));
            }
            return false;
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildSearchTrackNewLoad", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getLocationName(), car.getTrackName(), rld != null ? rld.getLocation().getName() : ""));
        if (this.carLoads.getNames(car.getTypeName()).size() == 2) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarNoCustomLoad", car.toString(), car.getTypeName()));
            return false;
        }
        if (car.getKernel() != null) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarLeadKernel", car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        String oldCarLoad = car.getLoadName();
        List<Track> tracks = this.locationManager.getTracksByMoves("Spur");
        log.debug("Found {} spurs", (Object)tracks.size());
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        for (Track track : tracks) {
            ScheduleItem si;
            if (locationsNotServiced.contains(track.getLocation())) continue;
            if (rld != null && track.getLocation() != rld.getLocation()) {
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildDestinationNotServiced", track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (car.getTrack().isAddCustomLoadsEnabled() && !this._train.getRoute().isLocationNameInRoute(track.getLocation().getName()) || (si = this.getScheduleItem(car, track)) == null) continue;
            car.setLoadName(si.getReceiveLoadName());
            car.setScheduleItemId(si.getId());
            String status = car.checkDestination(track.getLocation(), track);
            if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackNewLoad", StringUtils.capitalize((String)track.getTrackTypeName()), track.getLocation().getName(), track.getName(), car.toString(), si.getReceiveLoadName(), status));
                continue;
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildTrySpurLoad", track.getLocation().getName(), track.getName(), car.getLoadName()));
            if (car.getDivision() != null) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarHasDivisionStaging", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
                if (car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY) && car.getDivision() != track.getDivision() || car.getLoadType().equals(CarLoad.LOAD_TYPE_LOAD) && car.getTrack().getDivision() != car.getDivision() && car.getDivision() != track.getDivision()) {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDivisionTrack", track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
                    continue;
                }
            }
            if (!track.isSpaceAvailable(car)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackSpace", car.toString(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase(), track.getReservationFactor()));
                continue;
            }
            car.setFinalDestination(track.getLocation());
            car.setFinalDestinationTrack(track);
            if (this.router.setDestination(car, this._train, this._buildReport) && car.getDestination() != null) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCreateNewLoadForCar", car.toString(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName()));
                car.setLoadGeneratedFromStaging(true);
                car.updateKernel();
                track.bumpMoves();
                track.bumpSchedule();
                return true;
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCanNotRouteCar", car.toString(), si.getReceiveLoadName(), track.getLocation().getName(), track.getName()));
            TrainBuilderCars.addLine(this._buildReport, "7", " ");
            car.setDestination(null, null);
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
        }
        car.setLoadName(oldCarLoad);
        car.setScheduleItemId("");
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildUnableNewLoad", car.toString()));
        return false;
    }

    private boolean generateCarLoadStagingToStaging(Car car) throws BuildFailedException {
        if (car.getTrack() == null) {
            throw new BuildFailedException(Bundle.getMessage("buildWarningRsNoTrack", car.toString(), car.getLocationName()));
        }
        if (!(car.getTrack().isStaging() && car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() && car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) && car.getDestination() == null && car.getFinalDestination() == null)) {
            log.debug("No load generation for car ({}) isAddCustomLoadsAnyStagingTrackEnabled: {}, car load ({}) destination ({}) final destination ({})", new Object[]{car.toString(), car.getTrack().isAddCustomLoadsAnyStagingTrackEnabled() ? "true" : "false", car.getLoadName(), car.getDestinationName(), car.getFinalDestinationName()});
            return false;
        }
        if (this.carLoads.getNames(car.getTypeName()).size() == 2) {
            return false;
        }
        List<Track> tracks = this.locationManager.getTracks("Staging");
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildTryStagingToStaging", car.toString(), tracks.size()));
        if (Setup.getRouterBuildReportLevel().equals("7")) {
            for (Track track : tracks) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildStagingLocationTrack", track.getLocation().getName(), track.getName()));
            }
        }
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        if (this._terminateStageTrack != null) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildIgnoreStagingFirstPass", this._terminateStageTrack.getLocation().getName()));
            locationsNotServiced.add(this._terminateStageTrack.getLocation());
        }
        while (tracks.size() > 0) {
            int rnd = (int)(Math.random() * (double)tracks.size());
            Track track = tracks.get(rnd);
            tracks.remove(track);
            log.debug("Try staging track ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
            if (track.getLocation() == this._departLocation) {
                log.debug("Can't use departure location ({})", (Object)track.getLocation().getName());
                continue;
            }
            if (!this._train.isAllowThroughCarsEnabled() && track.getLocation() == this._terminateLocation) {
                log.debug("Through cars to location ({}) not allowed", (Object)track.getLocation().getName());
                continue;
            }
            if (locationsNotServiced.contains(track.getLocation())) {
                log.debug("Location ({}) not reachable", (Object)track.getLocation().getName());
                continue;
            }
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildDestinationNotServiced", track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (!this.generateLoadCarDepartingAndTerminatingIntoStaging(car, track)) continue;
            if (this.router.setDestination(car, this._train, this._buildReport) && car.getDestination() != null) {
                return true;
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildStagingTrackNotReachable", track.getLocation().getName(), track.getName(), car.getLoadName()));
            car.setLoadName(this.carLoads.getDefaultEmptyName());
            car.setLoadGeneratedFromStaging(false);
            car.setFinalDestination(null);
            car.updateKernel();
            locationsNotServiced.add(track.getLocation());
        }
        if (this._train.isAllowThroughCarsEnabled() && this._terminateStageTrack != null && car.getTrack().isDestinationAccepted(this._terminateStageTrack.getLocation()) && this.generateLoadCarDepartingAndTerminatingIntoStaging(car, this._terminateStageTrack)) {
            return true;
        }
        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoStagingForCarCustom", car.toString()));
        TrainBuilderCars.addLine(this._buildReport, "7", " ");
        return false;
    }

    private boolean findDestinationsForCarsWithHomeDivision(Car car) throws BuildFailedException {
        if (car.getDivision() == null || car.getDestination() != null || car.getFinalDestination() != null) {
            return true;
        }
        if (car.getDivision() == car.getTrack().getDivision()) {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarDepartHomeDivision", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
        } else {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarDepartForeignDivision", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getDivisionName(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), car.getTrack().getDivisionName()));
        }
        if (car.getKernel() != null) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarLeadKernel", car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        if (this._terminateStageTrack != null) {
            log.debug("Train terminates into staging track ({})", (Object)this._terminateStageTrack.getName());
            if (car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY)) {
                log.debug("Car ({}) has home division ({}) and load type empty", (Object)car.toString(), (Object)car.getDivisionName());
                if (car.getTrack().isYard() && car.getTrack().getDivision() == car.getDivision()) {
                    log.debug("Car ({}) at it's home division yard", (Object)car.toString());
                    if (!this.sendCarToHomeDivisionTrack(car, "Staging", true)) {
                        return this.sendCarToHomeDivisionTrack(car, "Spur", true);
                    }
                } else if (!this.sendCarToHomeDivisionTrack(car, "Staging", true) && !this.sendCarToHomeDivisionTrack(car, "Yard", true)) {
                    return this.sendCarToHomeDivisionTrack(car, "Spur", true);
                }
            } else {
                log.debug("Car ({}) has home division ({}) and load type load", (Object)car.toString(), (Object)car.getDivisionName());
                if (!this.sendCarToHomeDivisionTrack(car, "Staging", car.getTrack().getDivision() != car.getDivision())) {
                    return this.sendCarToHomeDivisionTrack(car, "Spur", car.getTrack().getDivision() != car.getDivision());
                }
            }
        } else if (car.getLoadType().equals(CarLoad.LOAD_TYPE_EMPTY)) {
            log.debug("Car ({}) has home division ({}) and load type empty", (Object)car.toString(), (Object)car.getDivisionName());
            if (car.getTrack().isYard() && car.getTrack().getDivision() == car.getDivision()) {
                log.debug("Car ({}) at it's home division yard", (Object)car.toString());
                if (!this.sendCarToHomeDivisionTrack(car, "Spur", true)) {
                    return this.sendCarToHomeDivisionTrack(car, "Staging", true);
                }
            } else if (!this.sendCarToHomeDivisionTrack(car, "Yard", true) && !this.sendCarToHomeDivisionTrack(car, "Staging", true)) {
                return this.sendCarToHomeDivisionTrack(car, "Spur", true);
            }
        } else {
            log.debug("Car ({}) has home division ({}) and load type load", (Object)car.toString(), (Object)car.getDivisionName());
            if (!this.sendCarToHomeDivisionTrack(car, "Spur", car.getTrack().getDivision() != car.getDivision())) {
                return this.sendCarToHomeDivisionTrack(car, "Staging", car.getTrack().getDivision() != car.getDivision());
            }
        }
        return true;
    }

    private boolean sendCarToHomeDivisionTrack(Car car, String trackType, boolean home_division) {
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        List<Track> tracks = this.locationManager.getTracksByMoves(trackType);
        log.debug("Found {} {} tracks", (Object)tracks.size(), (Object)trackType);
        for (Track track : tracks) {
            if (home_division && car.getDivision() != track.getDivision()) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDivisionTrack", track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
                continue;
            }
            if (locationsNotServiced.contains(track.getLocation())) continue;
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildDestinationNotServiced", track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (trackType.equals("Staging") && this._terminateStageTrack != null && track.getLocation() == this._terminateLocation && track != this._terminateStageTrack || !(trackType.equals("Spur") ? this.sendCarToDestinationSpur(car, track) : this.sendCarToDestinationTrack(car, track))) continue;
            return true;
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCouldNotFindTrack", trackType.toLowerCase(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
        TrainBuilderCars.addLine(this._buildReport, "7", " ");
        return false;
    }

    private boolean findFinalDestinationForCarLoad(Car car) throws BuildFailedException {
        if (car.getLoadName().equals(this.carLoads.getDefaultEmptyName()) || car.getLoadName().equals(this.carLoads.getDefaultLoadName()) || car.getDestination() != null || car.getFinalDestination() != null) {
            return false;
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildSearchForSpur", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getTrackType(), car.getLocationName(), car.getTrackName()));
        if (car.getKernel() != null) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarLeadKernel", car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        this._routeToTrackFound = false;
        List<Track> tracks = this.locationManager.getTracksByMoves("Spur");
        log.debug("Found {} spurs", (Object)tracks.size());
        ArrayList<Location> locationsNotServiced = new ArrayList<Location>();
        for (Track track : tracks) {
            if (car.getTrack() == track) continue;
            if (track.getSchedule() == null) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildSpurNoSchedule", track.getLocation().getName(), track.getName()));
                continue;
            }
            if (locationsNotServiced.contains(track.getLocation())) continue;
            if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildDestinationNotServiced", track.getLocation().getName(), car.getTrackName()));
                locationsNotServiced.add(track.getLocation());
                continue;
            }
            if (!this.sendCarToDestinationSpur(car, track)) continue;
            return true;
        }
        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCouldNotFindTrack", Track.getTrackTypeName("Spur").toLowerCase(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
        if (this._routeToTrackFound && !this._train.isSendCarsWithCustomLoadsToStagingEnabled() && !car.getLocation().isStaging()) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildHoldCarValidRoute", car.toString(), car.getLocationName(), car.getTrackName()));
        } else {
            TrainBuilderCars.addLine(this._buildReport, "7", " ");
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildTrySendCarToStaging", car.toString(), car.getLoadName()));
            tracks = this.locationManager.getTracks("Staging");
            log.debug("Found {} staging tracks", (Object)tracks.size());
            while (tracks.size() > 0) {
                Track track;
                int rnd = (int)(Math.random() * (double)tracks.size());
                track = tracks.get(rnd);
                tracks.remove(track);
                log.debug("Staging track ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
                if (track.getLocation() == car.getLocation() || locationsNotServiced.contains(track.getLocation()) || this._terminateStageTrack != null && track.getLocation() == this._terminateLocation && track != this._terminateStageTrack) continue;
                if (!car.getTrack().isDestinationAccepted(track.getLocation())) {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildDestinationNotServiced", track.getLocation().getName(), car.getTrackName()));
                    locationsNotServiced.add(track.getLocation());
                    continue;
                }
                String status = track.isRollingStockAccepted(car);
                if (!status.equals(Track.OKAY) && !status.startsWith(Track.LENGTH)) {
                    log.debug("Staging track ({}) can't accept car ({})", (Object)track.getName(), (Object)car.toString());
                    continue;
                }
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildStagingCanAcceptLoad", track.getLocation(), track.getName(), car.getLoadName()));
                car.setFinalDestination(track.getLocation());
                if (this.router.setDestination(car, this._train, this._buildReport)) {
                    this._routeToTrackFound = true;
                }
                if (car.getDestination() != null) {
                    car.updateKernel();
                    return true;
                }
                locationsNotServiced.add(track.getLocation());
                car.setFinalDestination(null);
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoStagingForCarLoad", car.toString(), car.getLoadName()));
            if (!this._routeToTrackFound) {
                TrainBuilderCars.addLine(this._buildReport, "7", " ");
            }
        }
        log.debug("routeToSpurFound is {}", (Object)this._routeToTrackFound);
        return this._routeToTrackFound;
    }

    private boolean sendCarToDestinationSpur(Car car, Track track) {
        if (!this.checkBasicMoves(car, track)) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("trainCanNotDeliverToDestination", this._train.getName(), car.toString(), track.getLocation().getName(), track.getName()));
            return false;
        }
        String status = car.checkDestination(track.getLocation(), track);
        if (!status.equals(Track.OKAY)) {
            if (track.getScheduleMode() == 0 && status.startsWith(Track.SCHEDULE)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildTrackSequentialMode", track.getLocation().getName(), track.getName(), status));
            }
            if (!status.startsWith(Track.LENGTH)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackNewLoad", StringUtils.capitalize((String)track.getTrackTypeName()), track.getLocation().getName(), track.getName(), car.toString(), car.getLoadName(), status));
                return false;
            }
            String scheduleStatus = track.checkSchedule(car);
            if (!scheduleStatus.equals(Track.OKAY)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackNewLoad", StringUtils.capitalize((String)track.getTrackTypeName()), track.getLocation().getName(), track.getName(), car.toString(), car.getLoadName(), scheduleStatus));
                return false;
            }
            if (track.getAlternateTrack() == null) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildSpurFullNoAlternate", track.getLocation().getName(), track.getName()));
                return false;
            }
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildTrackFullHasAlternate", track.getLocation().getName(), track.getName(), track.getAlternateTrack().getName()));
            if (!this._train.isLocalSwitcher() && (track.getTrainDirections() & track.getAlternateTrack().getTrainDirections()) == 0) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCanNotDropRsUsingTrain4", track.getName(), TrainBuilderCars.formatStringToCommaSeparated(Setup.getDirectionStrings(track.getTrainDirections())), track.getAlternateTrack().getName(), TrainBuilderCars.formatStringToCommaSeparated(Setup.getDirectionStrings(track.getAlternateTrack().getTrainDirections()))));
                return false;
            }
        }
        TrainBuilderCars.addLine(this._buildReport, "7", " ");
        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildSetFinalDestDiv", track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
        if (track.isHoldCarsWithCustomLoadsEnabled()) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildHoldCarsCustom", track.getLocation().getName(), track.getName()));
        }
        if (!track.isSpaceAvailable(car)) {
            if (track.isHoldCarsWithCustomLoadsEnabled()) {
                String id = track.getScheduleItemId();
                if (this.router.isCarRouteable(car, this._train, track, this._buildReport)) {
                    this._routeToTrackFound = true;
                } else {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildRouteNotFound", car.toString(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
                }
                track.setScheduleItemId(id);
            }
            if (car.getTrack().isStaging()) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackSpace", car.toString(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase(), track.getReservationFactor()));
            } else {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestSpace", car.toString(), track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase()));
            }
            return false;
        }
        car.setFinalDestination(track.getLocation());
        car.setFinalDestinationTrack(track);
        if (this.router.setDestination(car, this._train, this._buildReport) && track.isHoldCarsWithCustomLoadsEnabled()) {
            this._routeToTrackFound = true;
        }
        if (car.getDestination() == null) {
            if (!this.router.getStatus().equals(Track.OKAY)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNotAbleToSetDestination", car.toString(), this.router.getStatus()));
            }
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            if (this.router.getStatus().startsWith(Router.STATUS_NOT_THIS_TRAIN_PREFIX)) {
                this._routeToTrackFound = true;
            }
            return false;
        }
        if (car.getDestinationTrack() != track) {
            track.bumpMoves();
            if (track.getSchedule() != null) {
                car.setScheduleItemId(track.getCurrentScheduleItem().getId());
                track.bumpSchedule();
            }
        }
        car.updateKernel();
        return true;
    }

    private boolean sendCarToDestinationTrack(Car car, Track track) {
        if (!this.checkBasicMoves(car, track)) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("trainCanNotDeliverToDestination", this._train.getName(), car.toString(), track.getLocation().getName(), track.getName()));
            return false;
        }
        String status = car.checkDestination(track.getLocation(), track);
        if (!status.equals(Track.OKAY)) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackNewLoad", StringUtils.capitalize((String)track.getTrackTypeName()), track.getLocation().getName(), track.getName(), car.toString(), car.getLoadName(), status));
            return false;
        }
        if (!track.isSpaceAvailable(car)) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestSpace", car.toString(), track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getNumberOfCarsInRoute(), track.getReservedInRoute(), Setup.getLengthUnit().toLowerCase()));
            return false;
        }
        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildSetFinalDestDiv", track.getTrackTypeName(), track.getLocation().getName(), track.getName(), track.getDivisionName(), car.toString(), car.getLoadType().toLowerCase(), car.getLoadName()));
        car.setFinalDestination(track.getLocation());
        car.setFinalDestinationTrack(track);
        if (this.router.setDestination(car, this._train, this._buildReport)) {
            log.debug("Can route car to destination ({}, {})", (Object)track.getLocation().getName(), (Object)track.getName());
        }
        if (car.getDestination() == null) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNotAbleToSetDestination", car.toString(), this.router.getStatus()));
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        car.updateKernel();
        return true;
    }

    private boolean checkCarForFinalDestination(Car car) {
        String status;
        if (car.getFinalDestination() == null || car.getDestination() != null) {
            return false;
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarRoutingBegins", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getTrackType(), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
        if (!this._train.isLocalSwitcher() && !this._train.isAllowLocalMovesEnabled() && car.getSplitLocationName().equals(car.getSplitFinalDestinationName()) && car.getTrack() != this._departStageTrack) {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarHasFinalDestNoMove", car.toString(), car.getLocationName(), car.getFinalDestinationName(), this._train.getName()));
            TrainBuilderCars.addLine(this._buildReport, "5", " ");
            log.debug("Removing car ({}) from list", (Object)car.toString());
            this._carList.remove(car);
            --this._carIndex;
            return true;
        }
        if (!this.checkThroughCarsAllowed(car, car.getFinalDestinationName())) {
            if (car.getTrack() == this._departStageTrack) {
                TrainBuilderCars.addLine(this._buildReport, "1", Bundle.getMessage("buildErrorCarStageDest", car.toString()));
            } else {
                log.debug("Removing car ({}) from list", (Object)car.toString());
                this._carList.remove(car);
                --this._carIndex;
            }
            return true;
        }
        if (!(car.getFinalDestinationTrack() == null || car.getFinalDestinationTrack().getScheduleMode() != 1 || (status = car.checkDestination(car.getFinalDestination(), car.getFinalDestinationTrack())).equals(Track.OKAY) || status.startsWith(Track.LENGTH) || status.contains(Track.CUSTOM) && status.contains(Track.LOAD))) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNoDestTrackNewLoad", StringUtils.capitalize((String)car.getFinalDestinationTrack().getTrackTypeName()), car.getFinalDestination().getName(), car.getFinalDestinationTrack().getName(), car.toString(), car.getLoadName(), status));
            if (status.startsWith(Track.CAPACITY)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildTrackTooShort", car.getFinalDestination().getName(), car.getFinalDestinationTrack().getName(), car.toString()));
            }
            ++this._warnings;
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildWarningRemovingFinalDest", car.getFinalDestination().getName(), car.getFinalDestinationTrack().getName(), car.toString()));
            car.setFinalDestination(null);
            car.setFinalDestinationTrack(null);
            return false;
        }
        if (!this.router.setDestination(car, this._train, this._buildReport)) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildNotAbleToSetDestination", car.toString(), this.router.getStatus()));
            if (!this.router.getStatus().startsWith(Track.LENGTH) && !this._train.isServiceAllCarsWithFinalDestinationsEnabled() || car.getTrack() == this._departStageTrack) {
                if (!this._notRoutable.contains(car)) {
                    this._notRoutable.add(car);
                }
                TrainBuilderCars.addLine(this._buildReport, "5", " ");
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildWarningCarNotRoutable", car.toString(), car.getLocationName(), car.getTrackName(), car.getFinalDestinationName(), car.getFinalDestinationTrackName()));
                TrainBuilderCars.addLine(this._buildReport, "5", " ");
                return false;
            }
        } else {
            if (car.getDestination() != null) {
                return false;
            }
            if (car.getTrack() == this._departStageTrack) {
                log.debug("Car ({}) departing staging with final destination ({}) and no destination", (Object)car.toString(), (Object)car.getFinalDestinationName());
                return false;
            }
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoDestForCar", car.toString()));
        TrainBuilderCars.addLine(this._buildReport, "5", " ");
        return true;
    }

    private boolean checkCarForDestination(Car car, RouteLocation rl, int routeIndex) throws BuildFailedException {
        if (car.getDestination() == null) {
            return false;
        }
        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarHasAssignedDest", car.toString(), car.getLoadName(), car.getDestinationName(), car.getDestinationTrackName()));
        RouteLocation rld = this._train.getRoute().getLastLocationByName(car.getDestinationName());
        if (rld == null) {
            throw new BuildFailedException(Bundle.getMessage("buildExcludeCarDestNotPartRoute", car.toString(), car.getDestinationName(), car.getDestinationTrackName(), this._train.getRoute().getName()));
        }
        for (int k = routeIndex; k < this._routeList.size(); ++k) {
            String status;
            rld = (RouteLocation)this._routeList.get(k);
            if (this.checkForLaterPickUp(car, rl, rld)) {
                TrainBuilderCars.addLine(this._buildReport, "7", " ");
                return true;
            }
            if (!rld.getName().equals(car.getDestinationName())) continue;
            if (!this.checkThroughCarsAllowed(car, car.getDestinationName())) {
                return true;
            }
            log.debug("Car ({}) found a destination in train's route", (Object)car.toString());
            if (!rld.isDropAllowed() && !car.isLocalMove()) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRouteNoDropLocation", this._train.getRoute().getName(), rld.getId(), rld.getName()));
                continue;
            }
            if (!rld.isLocalMovesAllowed() && car.isLocalMove()) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRouteNoLocalLocation", this._train.getRoute().getName(), rld.getId(), rld.getName()));
                continue;
            }
            if (this._train.isLocationSkipped(rld)) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildLocSkipped", rld.getName(), rld.getId(), this._train.getName()));
                continue;
            }
            if (rld.getCarMoves() >= rld.getMaxCarMoves()) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoAvailableMovesDest", rld.getCarMoves(), rld.getMaxCarMoves(), this._train.getRoute().getName(), rld.getId(), rld.getName()));
                continue;
            }
            if (!this.checkTrainLength(car, rl, rld)) continue;
            if (car.getDestinationTrack() == null) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarDoesNotHaveDest", car.toString()));
                if (rld == this._train.getTrainTerminatesRouteLocation() && this._terminateStageTrack != null) {
                    status = car.checkDestination(car.getDestination(), this._terminateStageTrack);
                    if (status.equals(Track.OKAY)) {
                        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarAssignedToStaging", car.toString(), this._terminateStageTrack.getName()));
                        this.addCarToTrain(car, rl, rld, this._terminateStageTrack);
                        return true;
                    }
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), this._terminateStageTrack.getTrackTypeName(), this._terminateStageTrack.getLocation().getName(), this._terminateStageTrack.getName(), status));
                    continue;
                }
                List<Track> tracks = this.getTracksAtDestination(car, rld);
                if (tracks.size() > 0) {
                    if (tracks.get(1) != null) {
                        car.setFinalDestination(car.getDestination());
                        car.setFinalDestinationTrack(tracks.get(1));
                        tracks.get(1).bumpMoves();
                    }
                    TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarCanDropMoves", car.toString(), tracks.get(0).getTrackTypeName(), tracks.get(0).getLocation().getName(), tracks.get(0).getName(), rld.getCarMoves(), rld.getMaxCarMoves()));
                    car = this.checkQuickServiceArrival(car, rld, tracks.get(0));
                    this.addCarToTrain(car, rl, rld, tracks.get(0));
                    return true;
                }
            } else {
                log.debug("Car ({}) has a destination track ({})", (Object)car.toString(), (Object)car.getDestinationTrack().getName());
                if (rld.equals(this._train.getTrainTerminatesRouteLocation()) && this._terminateStageTrack != null && this._terminateStageTrack != car.getDestinationTrack()) {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarDestinationStaging", car.toString(), car.getDestinationName(), car.getDestinationTrackName()));
                    car.setDestination(this._terminateStageTrack.getLocation(), this._terminateStageTrack);
                }
                if (!rld.equals(this._train.getTrainTerminatesRouteLocation()) || this._terminateStageTrack == null || this._terminateStageTrack == car.getDestinationTrack()) {
                    if (this.checkDropTrainDirection(car, rld, car.getDestinationTrack()) && this.checkTrainCanDrop(car, car.getDestinationTrack())) {
                        status = car.checkDestination(car.getDestination(), car.getDestinationTrack());
                        if (status.equals(Track.OKAY) && (status = this.checkReserved(this._train, rld, car, car.getDestinationTrack(), true)).equals(Track.OKAY)) {
                            Track destTrack = car.getDestinationTrack();
                            car = this.checkQuickServiceArrival(car, rld, destTrack);
                            this.addCarToTrain(car, rl, rld, destTrack);
                            return true;
                        }
                        if (status.equals("timing of trains") && this.checkForAlternate(car, car.getDestinationTrack())) {
                            car.setFinalDestination(car.getDestination());
                            car.setFinalDestinationTrack(car.getDestinationTrack());
                            this.addCarToTrain(car, rl, rld, car.getDestinationTrack().getAlternateTrack());
                            return true;
                        }
                        TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCanNotDropCarBecause", car.toString(), car.getDestinationTrack().getTrackTypeName(), car.getDestinationTrack().getLocation().getName(), car.getDestinationTrackName(), status));
                    }
                } else {
                    throw new BuildFailedException(Bundle.getMessage("buildCarDestinationStaging", car.toString(), car.getDestinationName(), car.getDestinationTrackName()));
                }
            }
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCanNotDropCar", car.toString(), car.getDestinationName(), rld.getId()));
            if (car.getDestinationTrack() != null) continue;
            log.debug("Could not find a destination track for location ({})", (Object)car.getDestinationName());
        }
        log.debug("car ({}) not added to train", (Object)car.toString());
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildDestinationNotReachable", car.getDestinationName(), rl.getName(), rl.getId()));
        if (car.getDestinationTrack() != null) {
            car.getDestinationTrack().setMoves(car.getDestinationTrack().getMoves() - 1);
            Track destTrack = car.getDestinationTrack();
            if (destTrack.getSchedule() != null && destTrack.getScheduleMode() == 0) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildPickupCanceled", destTrack.getLocation().getName(), destTrack.getName()));
            }
        }
        car.setFinalDestination(car.getPreviousFinalDestination());
        car.setFinalDestinationTrack(car.getPreviousFinalDestinationTrack());
        car.setDestination(null, null);
        car.updateKernel();
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoDestForCar", car.toString()));
        TrainBuilderCars.addLine(this._buildReport, "5", " ");
        return true;
    }

    private boolean findDestinationAndTrack(Car car, RouteLocation rl, RouteLocation rld) throws BuildFailedException {
        int index = this._routeList.indexOf(rld);
        if (this._train.isLocalSwitcher()) {
            return this.findDestinationAndTrack(car, rl, index, index + 1);
        }
        return this.findDestinationAndTrack(car, rl, index - 1, index + 1);
    }

    private boolean findDestinationAndTrack(Car car, RouteLocation rl, int routeIndex, int routeEnd) throws BuildFailedException {
        if (routeIndex + 1 == routeEnd) {
            log.debug("Car ({}) is at the last location in the train's route", (Object)car.toString());
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildFindDestinationForCar", car.toString(), car.getTypeName(), car.getLoadType().toLowerCase(), car.getLoadName(), car.getTrackType(), car.getLocationName(), car.getTrackName()));
        if (car.getKernel() != null) {
            TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarLeadKernel", car.toString(), car.getKernelName(), car.getKernel().getSize(), car.getKernel().getTotalLength(), Setup.getLengthUnit().toLowerCase()));
        }
        int start = routeIndex;
        RouteLocation rld = null;
        RouteLocation rldSave = null;
        Track trackSave = null;
        Track finalDestinationTrackSave = null;
        boolean multiplePickup = false;
        if (!this._train.isLocalSwitcher()) {
            ++start;
        }
        if (this._train.isSendCarsToTerminalEnabled() && !rl.getSplitName().equals(this._departLocation.getSplitName()) && routeEnd == this._routeList.size()) {
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildSendToTerminal", this._terminateLocation.getName()));
            for (start = routeEnd - 1; start > routeIndex && ((RouteLocation)this._routeList.get(start - 1)).getSplitName().equals(this._terminateLocation.getSplitName()); --start) {
            }
        }
        for (int k = start; k < routeEnd; ++k) {
            rld = (RouteLocation)this._routeList.get(k);
            if (this.checkForLaterPickUp(car, rl, rld)) {
                multiplePickup = true;
            }
            if (!(rld.isDropAllowed() || car.hasFred() || car.isCaboose())) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRouteNoDropLocation", this._train.getRoute().getName(), rld.getId(), rld.getName()));
                continue;
            }
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildSearchingLocation", rld.getName(), rld.getId()));
            if (this._train.isLocationSkipped(rld)) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildLocSkipped", rld.getName(), rld.getId(), this._train.getName()));
                continue;
            }
            if (rld.getCarMoves() >= rld.getMaxCarMoves()) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoAvailableMovesDest", rld.getCarMoves(), rld.getMaxCarMoves(), this._train.getRoute().getName(), rld.getId(), rld.getName()));
                continue;
            }
            Location testDestination = rld.getLocation();
            if (testDestination == null) {
                throw new BuildFailedException(Bundle.getMessage("buildErrorRouteLoc", this._train.getRoute().getName(), rld.getName()));
            }
            if (!(!rl.getSplitName().equals(rld.getSplitName()) || this._train.isLocalSwitcher() || car.isPassenger() || car.isCaboose() || car.hasFred())) {
                if ((this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled()) && testDestination.isStaging() && trackSave == null) {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildReturnCarToStaging", car.toString(), rld.getName()));
                } else {
                    TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCarLocEqualDestination", car.toString(), rld.getName()));
                    continue;
                }
            }
            if (!car.getTrack().isDestinationAccepted(testDestination)) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildDestinationNotServiced", testDestination.getName(), car.getTrackName()));
                continue;
            }
            if (!testDestination.acceptsTypeName(car.getTypeName())) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildCanNotDropLocation", car.toString(), car.getTypeName(), testDestination.getName()));
                continue;
            }
            if (!this.checkDropTrainDirection(rld)) continue;
            if (!this.checkTrainLength(car, rl, rld)) break;
            if (!this.checkThroughCarsAllowed(car, rld.getName())) continue;
            Track trackTemp = null;
            Track finalDestinationTrackTemp = null;
            if (rld == this._train.getTrainTerminatesRouteLocation() && this._terminateStageTrack != null) {
                trackTemp = this.tryStaging(car, rldSave);
                if (trackTemp == null) {
                    continue;
                }
            } else {
                List<Track> tracks = this.getTracksAtDestination(car, rld);
                if (tracks.size() > 0) {
                    trackTemp = tracks.get(0);
                    finalDestinationTrackTemp = tracks.get(1);
                }
            }
            if (trackTemp == null) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCouldNotFindDestForCar", car.toString(), rld.getName()));
                continue;
            }
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarCanDropMoves", car.toString(), trackTemp.getTrackTypeName(), trackTemp.getLocation().getName(), trackTemp.getName(), rld.getCarMoves(), rld.getMaxCarMoves()));
            if (multiplePickup) {
                if (rldSave != null) {
                    TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildTrackServicedLater", car.getLocationName(), trackTemp.getTrackTypeName(), trackTemp.getLocation().getName(), trackTemp.getName(), car.getLocationName()));
                    break;
                }
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarHasSecond", car.toString(), car.getLocationName()));
                trackSave = null;
                break;
            }
            if (rldSave != null) {
                rld = this.checkForEarlierDrop(car, trackTemp, rld, start, routeEnd);
                double saveCarMoves = rldSave.getCarMoves();
                double saveRatio = saveCarMoves / (double)rldSave.getMaxCarMoves();
                double nextCarMoves = rld.getCarMoves();
                double nextRatio = nextCarMoves / (double)rld.getMaxCarMoves();
                if (rld == this._train.getTrainTerminatesRouteLocation()) {
                    nextRatio *= nextRatio;
                    log.debug("Location ({}) is terminate location, adjusted nextRatio {}", (Object)rld.getName(), (Object)Double.toString(nextRatio));
                } else if (!trackTemp.getScheduleId().equals("")) {
                    nextRatio *= nextRatio;
                    log.debug("Track ({}) has schedule ({}), adjusted nextRatio {}", new Object[]{trackTemp.getName(), trackTemp.getScheduleName(), Double.toString(nextRatio)});
                }
                if (trackSave != null && !trackSave.getScheduleId().equals("")) {
                    saveRatio *= saveRatio;
                    log.debug("Saved track ({}) has schedule ({}), adjusted nextRatio {}", new Object[]{trackSave.getName(), trackSave.getScheduleName(), Double.toString(saveRatio)});
                }
                log.debug("Saved {} = {}, {} = {}", new Object[]{rldSave.getName(), Double.toString(saveRatio), rld.getName(), Double.toString(nextRatio)});
                if (saveRatio < nextRatio) {
                    rld = rldSave;
                    trackTemp = trackSave;
                    finalDestinationTrackTemp = finalDestinationTrackSave;
                }
            }
            rldSave = rld;
            trackSave = trackTemp;
            finalDestinationTrackSave = finalDestinationTrackTemp;
        }
        if (trackSave != null && rldSave != null) {
            if ((this._train.isAllowReturnToStagingEnabled() || Setup.isStagingAllowReturnEnabled()) && rl.isDropAllowed() && rl.getLocation().isStaging() && trackSave.isStaging() && rl.getLocation() == rldSave.getLocation() && !this._train.isLocalSwitcher() && !car.isPassenger() && !car.isCaboose() && !car.hasFred()) {
                TrainBuilderCars.addLine(this._buildReport, "7", Bundle.getMessage("buildLeaveCarInStaging", car.toString(), car.getLocationName(), car.getTrackName()));
                rldSave = rl;
            } else if (trackSave.isSpur()) {
                car.setScheduleItemId(trackSave.getScheduleItemId());
                car = this.checkQuickServiceArrival(car, rldSave, trackSave);
                trackSave.bumpSchedule();
                log.debug("Sending car to spur ({}, {}) with car schedule id ({}))", new Object[]{trackSave.getLocation().getName(), trackSave.getName(), car.getScheduleItemId()});
            } else {
                car.setScheduleItemId("");
            }
            if (finalDestinationTrackSave != null) {
                car.setFinalDestination(finalDestinationTrackSave.getLocation());
                car.setFinalDestinationTrack(finalDestinationTrackSave);
                if (trackSave.isAlternate()) {
                    finalDestinationTrackSave.bumpMoves();
                }
            }
            this.addCarToTrain(car, rl, rldSave, trackSave);
            return true;
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildNoDestForCar", car.toString()));
        TrainBuilderCars.addLine(this._buildReport, "5", " ");
        return false;
    }

    protected boolean redirectCarsFromAlternateTrack() throws BuildFailedException {
        if (!Setup.isBuildAggressive()) {
            throw new BuildFailedException("ERROR coding issue, should be using aggressive mode");
        }
        boolean redirected = false;
        List cars = this.carManager.getByTrainList(this._train);
        for (Car car : cars) {
            Track alternate;
            if (car.getFinalDestination() == null || car.getFinalDestinationTrack() == null || !car.getFinalDestinationName().equals(car.getDestinationName()) || (alternate = car.getFinalDestinationTrack().getAlternateTrack()) == null || car.getDestinationTrack() != alternate || car.getKernel() != null && !car.isLead()) continue;
            log.debug("Car ({}) alternate track ({}) has final destination track ({}) location ({})", new Object[]{car.toString(), car.getDestinationTrackName(), car.getFinalDestinationTrackName(), car.getDestinationName()});
            if (!alternate.isYard() && !alternate.isInterchange() || !car.checkDestination(car.getFinalDestination(), car.getFinalDestinationTrack()).equals(Track.OKAY) || !this.checkReserved(this._train, car.getRouteDestination(), car, car.getFinalDestinationTrack(), false).equals(Track.OKAY) || !this.checkDropTrainDirection(car, car.getRouteDestination(), car.getFinalDestinationTrack()) || !this.checkTrainCanDrop(car, car.getFinalDestinationTrack())) continue;
            log.debug("Car ({}) alternate track ({}) can be redirected to final destination track ({})", new Object[]{car.toString(), car.getDestinationTrackName(), car.getFinalDestinationTrackName()});
            if (car.getKernel() != null) {
                for (Car k : car.getKernel().getCars()) {
                    if (k.isLead()) continue;
                    TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRedirectFromAlternate", car.getFinalDestinationName(), car.getFinalDestinationTrackName(), k.toString(), car.getDestinationTrackName()));
                    k.setDestination(car.getFinalDestination(), car.getFinalDestinationTrack(), true);
                }
            }
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildRedirectFromAlternate", car.getFinalDestinationName(), car.getFinalDestinationTrackName(), car.toString(), car.getDestinationTrackName()));
            car.setDestination(car.getFinalDestination(), car.getFinalDestinationTrack(), true);
            this.checkQuickServiceRedirected(car);
            redirected = true;
        }
        return redirected;
    }

    private void checkQuickServiceRedirected(Car car) {
        if (car.getDestinationTrack().isQuickServiceEnabled()) {
            RouteLocation rl = car.getRouteLocation();
            RouteLocation rld = car.getRouteDestination();
            Track track = car.getDestinationTrack();
            if (car.getKernel() != null) {
                for (Car kar : car.getKernel().getCars()) {
                    kar.reset();
                }
            } else {
                car.reset();
            }
            this._carList.add(0, car);
            car = this.checkQuickServiceArrival(car, rld, track);
            this.addCarToTrain(car, rl, rld, track);
        }
    }

    private Car checkQuickServiceArrival(Car car, RouteLocation rld, Track track) {
        if (!track.isQuickServiceEnabled()) {
            return car;
        }
        TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildTrackQuickService", StringUtils.capitalize((String)track.getTrackTypeName()), track.getLocation().getName(), track.getName()));
        int cloneCreationOrder = this.carManager.getCloneCreationOrder();
        Car cloneCar = car.copy();
        cloneCar.setNumber(car.getNumber() + "-(Clone)" + cloneCreationOrder);
        cloneCar.setClone(true);
        this.carManager.register(cloneCar);
        cloneCar.setLocation(car.getLocation(), car.getTrack(), true);
        cloneCar.setPreviousFinalDestination(car.getPreviousFinalDestination());
        cloneCar.setPreviousFinalDestinationTrack(car.getPreviousFinalDestinationTrack());
        cloneCar.setPreviousScheduleId(car.getScheduleItemId());
        String expectedArrivalTime = this._train.getExpectedArrivalTime(rld, true);
        cloneCar.setSetoutTime(expectedArrivalTime);
        if (car.getKernel() != null) {
            String kernelName = car.getKernelName() + "-(Clone)" + cloneCreationOrder;
            Kernel kernel = InstanceManager.getDefault(KernelManager.class).newKernel(kernelName);
            cloneCar.setKernel(kernel);
            for (Car kar : car.getKernel().getCars()) {
                if (kar == car) continue;
                Car nCar = kar.copy();
                nCar.setNumber(kar.getNumber() + "-(Clone)" + cloneCreationOrder);
                nCar.setClone(true);
                nCar.setKernel(kernel);
                this.carManager.register(nCar);
                nCar.setLocation(car.getLocation(), car.getTrack(), true);
                nCar.setPreviousFinalDestination(car.getPreviousFinalDestination());
                nCar.setPreviousFinalDestinationTrack(car.getPreviousFinalDestinationTrack());
                kar.setLocation(track.getLocation(), track, true);
                kar.setLastTrain(this._train);
                kar.setCloneOrder(cloneCreationOrder);
            }
        }
        car.setLocation(track.getLocation(), track, true);
        car.setLastTrain(this._train);
        car.setLastDate(this._startTime);
        car.setCloneOrder(cloneCreationOrder);
        car.setDestination(null, null);
        track.scheduleNext(car);
        car.loadNext(track);
        if (car.getWait() > 0) {
            this._carList.remove(car);
            TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildExcludeCarWait", car.toString(), car.getTypeName(), car.getLocationName(), car.getTrackName(), car.getWait()));
            car.setWait(car.getWait() - 1);
            car.updateLoad(track);
        }
        car.setRouteDestination(rld);
        car.updateKernel();
        return cloneCar;
    }

    private boolean checkQuickServiceDeparting(Car car, RouteLocation rl) {
        if (car.getTrack().isQuickServiceEnabled()) {
            if (car.getRouteDestination() == rl) {
                TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarRouteLocation", car.toString(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), this._train.getName(), rl.getName(), rl.getId()));
                TrainBuilderCars.addLine(this._buildReport, "5", " ");
                return false;
            }
            Car clone = this.getClone(car);
            if (clone != null) {
                String trainExpectedArrival = this._train.getExpectedArrivalTime(rl, true);
                int trainArrivalTimeMinutes = this.convertStringTime(trainExpectedArrival);
                int cloneSetoutTimeMinutes = this.convertStringTime(clone.getSetoutTime());
                if (cloneSetoutTimeMinutes > trainArrivalTimeMinutes) {
                    TrainBuilderCars.addLine(this._buildReport, "5", Bundle.getMessage("buildCarDeliveryTiming", car.toString(), clone.getSetoutTime(), car.getTrack().getTrackTypeName(), car.getLocationName(), car.getTrackName(), clone.getTrainName(), this._train.getName(), trainExpectedArrival));
                    TrainBuilderCars.addLine(this._buildReport, "5", " ");
                    return false;
                }
            }
        }
        return true;
    }

    private Car getClone(Car car) {
        for (Car kar : this.carManager.getList()) {
            if (!kar.isClone() || kar.getDestinationTrack() != car.getTrack() || !kar.getRoadName().equals(car.getRoadName()) || !kar.getNumber().split("-\\(Clone\\)")[0].equals(car.getNumber())) continue;
            return kar;
        }
        return null;
    }
}

