/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.trainbuilder;

import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.routes.Route;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.BuildFailedException;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.trainbuilder.Bundle;
import jmri.jmrit.operations.trains.trainbuilder.TrainBuilderBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainBuilderEngines
extends TrainBuilderBase {
    private static final Logger log = LoggerFactory.getLogger(TrainBuilderEngines.class);

    protected void getAndRemoveEnginesFromList() {
        this._engineList = this.engineManager.getAvailableTrainList(this._train);
        for (int indexEng = 0; indexEng < this._engineList.size(); ++indexEng) {
            Engine engine = (Engine)this._engineList.get(indexEng);
            if (!this._train.isTypeNameAccepted(engine.getTypeName())) {
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineType", engine.toString(), engine.getLocationName(), engine.getTrackName(), engine.getTypeName()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (!this._train.isLocoRoadNameAccepted(engine.getRoadName())) {
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineRoad", engine.toString(), engine.getLocationName(), engine.getTrackName(), engine.getRoadName()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (!this._train.isOwnerNameAccepted(engine.getOwnerName())) {
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineOwner", engine.toString(), engine.getLocationName(), engine.getTrackName(), engine.getOwnerName()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (!this._train.isBuiltDateAccepted(engine.getBuilt())) {
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineBuilt", engine.toString(), engine.getLocationName(), engine.getTrackName(), engine.getBuilt()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (engine.isOutOfService()) {
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineOutOfService", engine.toString(), engine.getLocationName(), engine.getTrackName()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (this._train.getRoute().getLastLocationByName(engine.getLocationName()) == null) {
                log.debug("removing engine ({}) location ({}) not serviced by train", (Object)engine.toString(), (Object)engine.getLocationName());
                this._engineList.remove(indexEng--);
                continue;
            }
            if (engine.getTrack().isInterchange() && engine.getTrack().getPickupOption().equals("Any") && engine.getLastRouteId().equals(this._train.getRoute().getId())) {
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineDropByTrain", engine.toString(), engine.getTypeName(), this._train.getRoute().getName(), engine.getLocationName(), engine.getTrackName()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (!engine.getTrack().isInterchange() && !engine.getTrack().isSpur()) continue;
            if (engine.getTrack().getPickupOption().equals("trains") || engine.getTrack().getPickupOption().equals("excludeTrains")) {
                if (engine.getTrack().isPickupTrainAccepted(this._train)) {
                    log.debug("Engine ({}) can be picked up by this train", (Object)engine.toString());
                    continue;
                }
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineByTrain", engine.toString(), engine.getTypeName(), engine.getTrack().getTrackTypeName(), engine.getLocationName(), engine.getTrackName()));
                this._engineList.remove(indexEng--);
                continue;
            }
            if (!engine.getTrack().getPickupOption().equals("routes") && !engine.getTrack().getPickupOption().equals("excludeRoutes")) continue;
            if (engine.getTrack().isPickupRouteAccepted(this._train.getRoute())) {
                log.debug("Engine ({}) can be picked up by this route", (Object)engine.toString());
                continue;
            }
            TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildExcludeEngineByRoute", engine.toString(), engine.getTypeName(), engine.getTrack().getTrackTypeName(), engine.getLocationName(), engine.getTrackName()));
            this._engineList.remove(indexEng--);
        }
    }

    protected void addEnginesToTrain() throws BuildFailedException {
        RouteLocation engineTerminatesFirstLeg = this._train.getTrainTerminatesRouteLocation();
        RouteLocation engineTerminatesSecondLeg = this._train.getTrainTerminatesRouteLocation();
        if ((this._train.getSecondLegOptions() & 1) == 1 && this._train.getSecondLegStartRouteLocation() != null) {
            engineTerminatesFirstLeg = this._train.getSecondLegStartRouteLocation();
        }
        if ((this._train.getThirdLegOptions() & 1) == 1 && this._train.getThirdLegStartRouteLocation() != null) {
            engineTerminatesSecondLeg = this._train.getThirdLegStartRouteLocation();
            if ((this._train.getSecondLegOptions() & 1) != 1) {
                engineTerminatesFirstLeg = this._train.getThirdLegStartRouteLocation();
            }
        }
        if (this._train.getLeadEngine() == null) {
            if ((this._train.getSecondLegOptions() & 0x20) == 32 && this._train.getSecondLegStartRouteLocation() != null) {
                TrainBuilderEngines.addLine(this._buildReport, "3", " ");
                TrainBuilderEngines.addLine(this._buildReport, "3", Bundle.getMessage("buildTrainRemoveEngines", this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartLocationName(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
                if (!this.getEngines(this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad(), this._train.getTrainDepartsRouteLocation(), this._train.getSecondLegStartRouteLocation()) && !this.getConsist(this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad(), this._train.getTrainDepartsRouteLocation(), this._train.getSecondLegStartRouteLocation())) {
                    throw new BuildFailedException(Bundle.getMessage("buildErrorEngines", this._train.getSecondLegNumberEngines(), this._train.getTrainDepartsName(), this._train.getSecondLegStartRouteLocation().getLocation().getName()));
                }
            }
            if ((this._train.getThirdLegOptions() & 0x20) == 32 && this._train.getThirdLegStartRouteLocation() != null) {
                TrainBuilderEngines.addLine(this._buildReport, "3", " ");
                TrainBuilderEngines.addLine(this._buildReport, "3", Bundle.getMessage("buildTrainRemoveEngines", this._train.getThirdLegNumberEngines(), this._train.getThirdLegStartLocationName(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
                if (!this.getEngines(this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad(), this._train.getTrainDepartsRouteLocation(), this._train.getThirdLegStartRouteLocation()) && !this.getConsist(this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad(), this._train.getTrainDepartsRouteLocation(), this._train.getThirdLegStartRouteLocation())) {
                    throw new BuildFailedException(Bundle.getMessage("buildErrorEngines", this._train.getThirdLegNumberEngines(), this._train.getTrainDepartsName(), this._train.getThirdLegStartRouteLocation().getLocation().getName()));
                }
            }
            TrainBuilderEngines.addLine(this._buildReport, "3", " ");
            if (this.getEngines(this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad(), this._train.getTrainDepartsRouteLocation(), engineTerminatesFirstLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else if (this.getConsist(this._train.getNumberEngines(), this._train.getEngineModel(), this._train.getEngineRoad(), this._train.getTrainDepartsRouteLocation(), engineTerminatesFirstLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else {
                throw new BuildFailedException(Bundle.getMessage("buildErrorEngines", this._train.getNumberEngines(), this._train.getTrainDepartsName(), engineTerminatesFirstLeg.getName()));
            }
        }
        if ((this._train.getSecondLegOptions() & 1) == 1 || (this._train.getSecondLegOptions() & 0x10) == 16) {
            TrainBuilderEngines.addLine(this._buildReport, "3", " ");
            if ((this._train.getSecondLegOptions() & 1) == 1) {
                TrainBuilderEngines.addLine(this._buildReport, "3", Bundle.getMessage("buildTrainEngineChange", this._train.getSecondLegStartLocationName(), this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
            } else {
                TrainBuilderEngines.addLine(this._buildReport, "3", Bundle.getMessage("buildTrainAddEngines", this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartLocationName(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad()));
            }
            if (this.getEngines(this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad(), this._train.getSecondLegStartRouteLocation(), engineTerminatesSecondLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else if (this.getConsist(this._train.getSecondLegNumberEngines(), this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad(), this._train.getSecondLegStartRouteLocation(), engineTerminatesSecondLeg)) {
                this._secondLeadEngine = this._lastEngine;
                this._thirdLeadEngine = this._lastEngine;
            } else {
                throw new BuildFailedException(Bundle.getMessage("buildErrorEngines", this._train.getSecondLegNumberEngines(), this._train.getSecondLegStartRouteLocation(), engineTerminatesSecondLeg));
            }
        }
        if ((this._train.getThirdLegOptions() & 1) == 1 || (this._train.getThirdLegOptions() & 0x10) == 16) {
            TrainBuilderEngines.addLine(this._buildReport, "3", " ");
            if ((this._train.getThirdLegOptions() & 1) == 1) {
                TrainBuilderEngines.addLine(this._buildReport, "3", Bundle.getMessage("buildTrainEngineChange", this._train.getThirdLegStartLocationName(), this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
            } else {
                TrainBuilderEngines.addLine(this._buildReport, "3", Bundle.getMessage("buildTrainAddEngines", this._train.getThirdLegNumberEngines(), this._train.getThirdLegStartLocationName(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad()));
            }
            if (this.getEngines(this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad(), this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation())) {
                this._thirdLeadEngine = this._lastEngine;
            } else if (this.getConsist(this._train.getThirdLegNumberEngines(), this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad(), this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation())) {
                this._thirdLeadEngine = this._lastEngine;
            } else {
                throw new BuildFailedException(Bundle.getMessage("buildErrorEngines", Integer.parseInt(this._train.getThirdLegNumberEngines()), this._train.getThirdLegStartRouteLocation(), this._train.getTrainTerminatesRouteLocation()));
            }
        }
        if (!(this._train.getNumberEngines().equals("0") || this._train.isBuildConsistEnabled() && Setup.getHorsePowerPerTon() != 0.0)) {
            TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildDoneAssingEnginesTrain", this._train.getName()));
        }
    }

    protected void checkEngineHP() throws BuildFailedException {
        if (Setup.getHorsePowerPerTon() != 0.0) {
            if (this._train.getNumberEngines().equals(Train.AUTO_HPT)) {
                this.checkEngineHP(this._train.getLeadEngine(), this._train.getEngineModel(), this._train.getEngineRoad());
            }
            if ((this._train.getSecondLegOptions() & 1) == 1 && this._train.getSecondLegNumberEngines().equals(Train.AUTO_HPT)) {
                this.checkEngineHP(this._secondLeadEngine, this._train.getSecondLegEngineModel(), this._train.getSecondLegEngineRoad());
            }
            if ((this._train.getThirdLegOptions() & 1) == 1 && this._train.getThirdLegNumberEngines().equals(Train.AUTO_HPT)) {
                this.checkEngineHP(this._thirdLeadEngine, this._train.getThirdLegEngineModel(), this._train.getThirdLegEngineRoad());
            }
        }
    }

    private void checkEngineHP(Engine leadEngine, String model, String road) throws BuildFailedException {
        if (leadEngine == null) {
            throw new BuildFailedException("ERROR coding issue, engine missing from checkEngineHP()");
        }
        if (leadEngine.getRouteLocation() == this._train.getTrainDepartsRouteLocation() && this._train.isDepartingStaging()) {
            return;
        }
        TrainBuilderEngines.addLine(this._buildReport, "1", " ");
        TrainBuilderEngines.addLine(this._buildReport, "1", Bundle.getMessage("buildDetermineHpNeeded", leadEngine.toString(), leadEngine.getLocationName(), leadEngine.getDestinationName(), this._train.getTrainHorsePower(leadEngine.getRouteLocation()), Setup.getHorsePowerPerTon()));
        double hpNeeded = 0.0;
        int hpAvailable = 0;
        Route route = this._train.getRoute();
        if (route != null) {
            boolean helper = false;
            boolean foundStart = false;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                if (!foundStart && rl != leadEngine.getRouteLocation()) continue;
                foundStart = true;
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegStartRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegStartRouteLocation()) {
                    TrainBuilderEngines.addLine(this._buildReport, "5", Bundle.getMessage("AddHelpersAt", rl.getName()));
                    helper = true;
                }
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegEndRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegEndRouteLocation()) {
                    TrainBuilderEngines.addLine(this._buildReport, "5", Bundle.getMessage("RemoveHelpersAt", rl.getName()));
                    helper = false;
                }
                if (helper) continue;
                if (rl == leadEngine.getRouteDestination()) {
                    log.debug("Remove loco ({}) at ({})", (Object)leadEngine.toString(), (Object)rl.getName());
                    break;
                }
                if (this._train.getTrainHorsePower(rl) > hpAvailable) {
                    hpAvailable = this._train.getTrainHorsePower(rl);
                }
                int weight = rl.getTrainWeight();
                double hpRequired = (double)Control.speedHpt * rl.getGrade() / 12.0 * (double)weight;
                if (hpRequired < Setup.getHorsePowerPerTon() * (double)weight) {
                    hpRequired = Setup.getHorsePowerPerTon() * (double)weight;
                }
                if (!(hpRequired > hpNeeded)) continue;
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildReportTrainHpNeeds", weight, this._train.getNumberCarsInTrain(rl), rl.getGrade(), rl.getName(), rl.getId(), hpRequired));
                hpNeeded = hpRequired;
            }
        }
        if (hpNeeded > (double)hpAvailable) {
            TrainBuilderEngines.addLine(this._buildReport, "1", Bundle.getMessage("buildAssignedHpNotEnough", leadEngine.toString(), hpAvailable, hpNeeded));
            this.getNewEngine((int)hpNeeded, leadEngine, model, road);
        } else if ((double)hpAvailable > 2.0 * hpNeeded) {
            TrainBuilderEngines.addLine(this._buildReport, "1", Bundle.getMessage("buildAssignedHpTooMuch", leadEngine.toString(), hpAvailable, hpNeeded));
            this.getNewEngine((int)hpNeeded, leadEngine, model, road);
        } else {
            log.debug("Keeping engine ({}) it meets the train's HP requirement", (Object)leadEngine.toString());
        }
    }

    protected void checkNumnberOfEnginesNeededHPT() throws BuildFailedException {
        if (!this._train.isBuildConsistEnabled() || Setup.getHorsePowerPerTon() == 0.0) {
            return;
        }
        TrainBuilderEngines.addLine(this._buildReport, "1", " ");
        TrainBuilderEngines.addLine(this._buildReport, "1", Bundle.getMessage("buildDetermineNeeds", Setup.getHorsePowerPerTon()));
        Route route = this._train.getRoute();
        int hpAvailable = 0;
        int extraHpNeeded = 0;
        RouteLocation rlNeedHp = null;
        RouteLocation rlStart = this._train.getTrainDepartsRouteLocation();
        RouteLocation rlEnd = this._train.getTrainTerminatesRouteLocation();
        boolean departingStaging = this._train.isDepartingStaging();
        if (route != null) {
            boolean helper = false;
            for (RouteLocation rl : route.getLocationsBySequenceList()) {
                double weight;
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegStartRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegStartRouteLocation()) {
                    TrainBuilderEngines.addLine(this._buildReport, "5", Bundle.getMessage("AddHelpersAt", rl.getName()));
                    helper = true;
                }
                if (this._train.getSecondLegOptions() == 2 && rl == this._train.getSecondLegEndRouteLocation() || this._train.getThirdLegOptions() == 2 && rl == this._train.getThirdLegEndRouteLocation()) {
                    TrainBuilderEngines.addLine(this._buildReport, "5", Bundle.getMessage("RemoveHelpersAt", rl.getName()));
                    helper = false;
                }
                if (helper) continue;
                if ((this._train.getSecondLegOptions() & 1) == 1 && rl == this._train.getSecondLegStartRouteLocation() || (this._train.getThirdLegOptions() & 1) == 1 && rl == this._train.getThirdLegStartRouteLocation()) {
                    log.debug("Loco change at ({})", (Object)rl.getName());
                    this.addEnginesBasedHPT(hpAvailable, extraHpNeeded, rlNeedHp, rlStart, rl);
                    TrainBuilderEngines.addLine(this._buildReport, "3", " ");
                    rlStart = rl;
                    rlNeedHp = null;
                    extraHpNeeded = 0;
                    departingStaging = false;
                }
                if (departingStaging || !((weight = (double)rl.getTrainWeight()) > 0.0)) continue;
                double hptMinimum = Setup.getHorsePowerPerTon();
                double hptGrade = (double)Control.speedHpt * rl.getGrade() / 12.0;
                double hp = this._train.getTrainHorsePower(rl);
                double hpt = hp / weight;
                if (hptGrade > hptMinimum) {
                    hptMinimum = hptGrade;
                }
                if (!(hptMinimum > hpt)) continue;
                int addHp = (int)(hptMinimum * weight - hp);
                if (addHp > extraHpNeeded) {
                    hpAvailable = (int)hp;
                    extraHpNeeded = addHp;
                    rlNeedHp = rl;
                }
                TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildAddLocosStatus", weight, hp, Control.speedHpt, rl.getGrade(), hpt, hptMinimum, rl.getName(), rl.getId()));
                TrainBuilderEngines.addLine(this._buildReport, "5", Bundle.getMessage("buildTrainRequiresAddHp", addHp, rl.getName(), hptMinimum));
            }
        }
        this.addEnginesBasedHPT(hpAvailable, extraHpNeeded, rlNeedHp, rlStart, rlEnd);
        TrainBuilderEngines.addLine(this._buildReport, "7", Bundle.getMessage("buildDoneAssingEnginesTrain", this._train.getName()));
        TrainBuilderEngines.addLine(this._buildReport, "3", " ");
    }
}

