/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.operations.trains.trainbuilder;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.Timebase;
import jmri.jmrit.operations.locations.Location;
import jmri.jmrit.operations.locations.LocationManager;
import jmri.jmrit.operations.locations.Track;
import jmri.jmrit.operations.locations.divisions.DivisionManager;
import jmri.jmrit.operations.rollingstock.RollingStock;
import jmri.jmrit.operations.rollingstock.cars.Car;
import jmri.jmrit.operations.rollingstock.cars.CarColors;
import jmri.jmrit.operations.rollingstock.cars.CarLengths;
import jmri.jmrit.operations.rollingstock.cars.CarLoads;
import jmri.jmrit.operations.rollingstock.cars.CarManager;
import jmri.jmrit.operations.rollingstock.cars.CarOwners;
import jmri.jmrit.operations.rollingstock.cars.CarRoads;
import jmri.jmrit.operations.rollingstock.cars.CarTypes;
import jmri.jmrit.operations.rollingstock.cars.KernelManager;
import jmri.jmrit.operations.rollingstock.engines.ConsistManager;
import jmri.jmrit.operations.rollingstock.engines.Engine;
import jmri.jmrit.operations.rollingstock.engines.EngineManager;
import jmri.jmrit.operations.rollingstock.engines.EngineModels;
import jmri.jmrit.operations.routes.RouteLocation;
import jmri.jmrit.operations.setup.Control;
import jmri.jmrit.operations.setup.Setup;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.operations.trains.TrainManifestHeaderText;
import jmri.jmrit.operations.trains.TrainManifestText;
import jmri.jmrit.operations.trains.TrainSwitchListText;
import jmri.jmrit.operations.trains.trainbuilder.Bundle;
import jmri.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainCommon {
    protected static final String TAB = "    ";
    protected static final String NEW_LINE = "\n";
    public static final String SPACE = " ";
    public static final String BLANK_LINE = " ";
    protected static final char HORIZONTAL_LINE_CHAR = '-';
    protected static final String BUILD_REPORT_CHAR = "-";
    public static final String HYPHEN = "-";
    protected static final char VERTICAL_LINE_CHAR = '|';
    protected static final String TEXT_COLOR_START = "<FONT color=\"";
    protected static final String TEXT_COLOR_DONE = "\">";
    protected static final String TEXT_COLOR_END = "</FONT>";
    protected static final boolean PICKUP = true;
    protected static final boolean IS_MANIFEST = true;
    public static final boolean LOCAL = true;
    protected static final boolean ENGINE = true;
    public static final boolean IS_TWO_COLUMN_TRACK = true;
    protected CarManager carManager = InstanceManager.getDefault(CarManager.class);
    protected EngineManager engineManager = InstanceManager.getDefault(EngineManager.class);
    protected LocationManager locationManager = InstanceManager.getDefault(LocationManager.class);
    protected boolean _pickupCars;
    protected boolean _dropCars;
    boolean _printPickupHeader = true;
    boolean _printSetoutHeader = true;
    boolean _printLocalMoveHeader = true;
    List<Car> doneCars = new ArrayList<Car>();
    int index = 0;
    List<String> utilityCarTypes = new ArrayList<String>();
    private static final int UTILITY_CAR_COUNT_FIELD_SIZE = 3;
    protected static final Dimension PAPER_MARGINS = new Dimension(84, 72);
    private static final Logger log = LoggerFactory.getLogger(TrainCommon.class);

    protected void blockLocosTwoColumn(PrintWriter file, List<Engine> engineList, RouteLocation rl, boolean isManifest) {
        if (this.isThereWorkAtLocation(null, engineList, rl)) {
            this.printEngineHeader(file, isManifest);
        }
        int lineLength = TrainCommon.getLineLength(isManifest);
        for (Engine engine : engineList) {
            String s;
            if (engine.getRouteLocation() == rl && !engine.getTrackName().equals("")) {
                String pullText = TrainCommon.padAndTruncate(this.pickupEngine(engine).trim(), lineLength / 2);
                pullText = TrainCommon.formatColorString(pullText, Setup.getPickupEngineColor());
                s = pullText + "|" + TrainCommon.tabString("", lineLength / 2 - 1);
                this.addLine(file, s);
            }
            if (engine.getRouteDestination() != rl) continue;
            String dropText = TrainCommon.padAndTruncate(this.dropEngine(engine).trim(), lineLength / 2 - 1);
            dropText = TrainCommon.formatColorString(dropText, Setup.getDropEngineColor());
            s = TrainCommon.tabString("", lineLength / 2) + "|" + dropText;
            this.addLine(file, s);
        }
    }

    protected void pickupEngines(PrintWriter file, List<Engine> engineList, RouteLocation rl, boolean isManifest) {
        boolean printHeader = Setup.isPrintHeadersEnabled();
        for (Engine engine : engineList) {
            if (engine.getRouteLocation() != rl || engine.getTrackName().equals("")) continue;
            if (printHeader) {
                this.printPickupEngineHeader(file, isManifest);
                printHeader = false;
            }
            this.pickupEngine(file, engine, isManifest);
        }
    }

    private void pickupEngine(PrintWriter file, Engine engine, boolean isManifest) {
        String[] format;
        StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupEnginePrefix(), isManifest ? Setup.getManifestPrefixLength() : Setup.getSwitchListPrefixLength()));
        for (String attribute : format = Setup.getPickupEngineMessageFormat()) {
            String s = this.getEngineAttribute(engine, attribute, true);
            if (!this.checkStringLength(buf.toString() + s, isManifest)) {
                this.addLine(file, buf, Setup.getPickupEngineColor());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
        }
        this.addLine(file, buf, Setup.getPickupEngineColor());
    }

    protected void dropEngines(PrintWriter file, List<Engine> engineList, RouteLocation rl, boolean isManifest) {
        boolean printHeader = Setup.isPrintHeadersEnabled();
        for (Engine engine : engineList) {
            if (engine.getRouteDestination() != rl) continue;
            if (printHeader) {
                this.printDropEngineHeader(file, isManifest);
                printHeader = false;
            }
            this.dropEngine(file, engine, isManifest);
        }
    }

    private void dropEngine(PrintWriter file, Engine engine, boolean isManifest) {
        String[] format;
        StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getDropEnginePrefix(), isManifest ? Setup.getManifestPrefixLength() : Setup.getSwitchListPrefixLength()));
        for (String attribute : format = Setup.getDropEngineMessageFormat()) {
            String s = this.getEngineAttribute(engine, attribute, false);
            if (!this.checkStringLength(buf.toString() + s, isManifest)) {
                this.addLine(file, buf, Setup.getDropEngineColor());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
        }
        this.addLine(file, buf, Setup.getDropEngineColor());
    }

    public String pickupEngine(Engine engine) {
        StringBuilder builder = new StringBuilder();
        for (String attribute : Setup.getPickupEngineMessageFormat()) {
            builder.append(this.getEngineAttribute(engine, attribute, true));
        }
        return builder.toString();
    }

    public String dropEngine(Engine engine) {
        StringBuilder builder = new StringBuilder();
        for (String attribute : Setup.getDropEngineMessageFormat()) {
            builder.append(this.getEngineAttribute(engine, attribute, false));
        }
        return builder.toString();
    }

    protected void blockCarsByTrack(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, boolean printHeader, boolean isManifest) {
        if (printHeader) {
            this._printPickupHeader = true;
            this._printSetoutHeader = true;
            this._printLocalMoveHeader = true;
        }
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        this.clearUtilityCarTypes();
        for (Track track : tracks) {
            if (trackNames.contains(track.getSplitName())) continue;
            trackNames.add(track.getSplitName());
            this.blockCarsPickups(file, train, carList, rl, track, isManifest);
            this.blockCarsSetoutsAndMoves(file, train, carList, rl, track, isManifest, false, Setup.isGroupCarMovesEnabled());
            this.blockCarsSetoutsAndMoves(file, train, carList, rl, track, isManifest, true, !Setup.isGroupCarMovesEnabled());
            if (Setup.isSortByTrackNameEnabled()) continue;
            break;
        }
    }

    private void blockCarsPickups(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, Track track, boolean isManifest) {
        for (RouteLocation rld : train.getTrainBlockingOrder()) {
            for (Car car : carList) {
                boolean isTruncate;
                if (Setup.isSortByTrackNameEnabled() && !track.getSplitName().equals(car.getSplitTrackName()) || !TrainCommon.isNextCar(car, rl, rld)) continue;
                this.printPickupCarHeader(file, car, isManifest, false);
                boolean bl = isTruncate = Setup.isPrintTruncateManifestEnabled() && rl.getLocation().isSwitchListEnabled();
                if (car.isUtility()) {
                    this.pickupUtilityCars(file, carList, car, isTruncate, isManifest);
                } else if (isManifest && isTruncate) {
                    this.pickUpCarTruncated(file, car, isManifest);
                } else {
                    this.pickUpCar(file, car, isManifest);
                }
                this._pickupCars = true;
            }
        }
    }

    private void blockCarsSetoutsAndMoves(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, Track track, boolean isManifest, boolean isSetout, boolean isLocalMove) {
        for (Car car : carList) {
            boolean isTruncate;
            if ((car.isLocalMove() || !isSetout) && (!car.isLocalMove() || !isLocalMove) || Setup.isSortByTrackNameEnabled() && car.getRouteLocation() != null && car.getRouteDestination() == rl && !track.getSplitName().equals(car.getSplitDestinationTrackName()) || car.getRouteDestination() != rl || car.getDestinationTrack() == null) continue;
            this.printDropOrMoveCarHeader(file, car, isManifest, false);
            boolean bl = isTruncate = Setup.isPrintTruncateManifestEnabled() && rl.getLocation().isSwitchListEnabled() && !train.isLocalSwitcher();
            if (car.isUtility()) {
                this.setoutUtilityCars(file, carList, car, isTruncate, isManifest);
            } else if (isManifest && isTruncate) {
                this.truncatedDropCar(file, car, isManifest);
            } else {
                this.dropCar(file, car, isManifest);
            }
            this._dropCars = true;
        }
    }

    public static boolean isNextCar(Car car, RouteLocation rl, RouteLocation rld) {
        return TrainCommon.isNextCar(car, rl, rld, false);
    }

    public static boolean isNextCar(Car car, RouteLocation rl, RouteLocation rld, boolean isIgnoreTrack) {
        Train train = car.getTrain();
        return train != null && (car.getTrack() != null || isIgnoreTrack) && car.getRouteLocation() == rl && (rld == car.getRouteDestination() && !car.isCaboose() && !car.hasFred() && !car.isPassenger() || rld == train.getTrainDepartsRouteLocation() && car.isPassenger() && car.getBlocking() < 0 || rld == train.getTrainTerminatesRouteLocation() && (car.isCaboose() || car.hasFred() || car.isPassenger() && car.getBlocking() >= 0));
    }

    private void printPickupCarHeader(PrintWriter file, Car car, boolean isManifest, boolean isTwoColumnTrack) {
        if (this._printPickupHeader && !car.isLocalMove()) {
            this.printPickupCarHeader(file, isManifest, false);
            this._printPickupHeader = false;
            if (this.getPickupCarHeader(isManifest, false).equals(this.getDropCarHeader(isManifest, false))) {
                this._printSetoutHeader = false;
            }
            if (this.getPickupCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                this._printLocalMoveHeader = false;
            }
        }
    }

    private void printDropOrMoveCarHeader(PrintWriter file, Car car, boolean isManifest, boolean isTwoColumnTrack) {
        if (this._printSetoutHeader && !car.isLocalMove()) {
            this.printDropCarHeader(file, isManifest, false);
            this._printSetoutHeader = false;
            if (this.getPickupCarHeader(isManifest, false).equals(this.getDropCarHeader(isManifest, false))) {
                this._printPickupHeader = false;
            }
            if (this.getDropCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                this._printLocalMoveHeader = false;
            }
        }
        if (this._printLocalMoveHeader && car.isLocalMove()) {
            this.printLocalCarMoveHeader(file, isManifest);
            this._printLocalMoveHeader = false;
            if (this.getPickupCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                this._printPickupHeader = false;
            }
            if (this.getDropCarHeader(isManifest, false).equals(this.getLocalMoveHeader(isManifest))) {
                this._printSetoutHeader = false;
            }
        }
    }

    protected void blockCarsTwoColumn(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, boolean printHeader, boolean isManifest) {
        this.index = 0;
        int lineLength = TrainCommon.getLineLength(isManifest);
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        this.clearUtilityCarTypes();
        if (printHeader) {
            this.printCarHeader(file, isManifest, false);
        }
        for (Track track : tracks) {
            if (trackNames.contains(track.getSplitName())) continue;
            trackNames.add(track.getSplitName());
            for (RouteLocation rld : train.getTrainBlockingOrder()) {
                for (int k = 0; k < carList.size(); ++k) {
                    String s;
                    Car car = carList.get(k);
                    if (!TrainCommon.isNextCar(car, rl, rld) || Setup.isSortByTrackNameEnabled() && !track.getSplitName().equals(car.getSplitTrackName())) continue;
                    this._pickupCars = true;
                    if (car.isUtility()) {
                        s = this.pickupUtilityCars(carList, car, isManifest, false);
                        if (s == null) continue;
                        s = s.trim();
                    } else {
                        s = this.pickupCar(car, isManifest, false).trim();
                    }
                    s = TrainCommon.padAndTruncate(s, lineLength / 2);
                    if (car.isLocalMove()) {
                        String sl = this.appendSetoutString(s = TrainCommon.formatColorString(s, Setup.getLocalColor()), carList, car.getRouteDestination(), car, isManifest, false);
                        if (!sl.equals(s)) {
                            s = sl;
                            carList.remove(car);
                            --k;
                        } else {
                            s = TrainCommon.padAndTruncate(s + "|", TrainCommon.getLineLength(isManifest));
                        }
                    } else {
                        s = TrainCommon.formatColorString(s, Setup.getPickupColor());
                        s = this.appendSetoutString(s, carList, rl, true, isManifest, false);
                    }
                    this.addLine(file, s);
                }
            }
            if (Setup.isSortByTrackNameEnabled()) continue;
            break;
        }
        while (this.index < carList.size()) {
            String s = TrainCommon.padString("", lineLength / 2);
            String test = (s = this.appendSetoutString(s, carList, rl, false, isManifest, false)).trim();
            if (test.length() <= 1) continue;
            this.addLine(file, s);
        }
    }

    protected void blockCarsByTrackNameTwoColumn(PrintWriter file, Train train, List<Car> carList, RouteLocation rl, boolean printHeader, boolean isManifest) {
        this.index = 0;
        List<Track> tracks = rl.getLocation().getTracksByNameList(null);
        ArrayList<String> trackNames = new ArrayList<String>();
        this.doneCars.clear();
        this.clearUtilityCarTypes();
        if (printHeader) {
            this.printCarHeader(file, isManifest, true);
        }
        for (Track track : tracks) {
            String trackName = track.getSplitName();
            if (trackNames.contains(trackName)) continue;
            for (RouteLocation rld : train.getTrainBlockingOrder()) {
                for (Car car : carList) {
                    String s;
                    if (car.getTrack() == null || car.getRouteLocation() != rl || !trackName.equals(car.getSplitTrackName()) || (car.getRouteDestination() != rld || car.isCaboose() || car.hasFred()) && (rld != train.getTrainTerminatesRouteLocation() || !car.isCaboose() && !car.hasFred())) continue;
                    if (!trackNames.contains(trackName)) {
                        this.printTrackNameHeader(file, trackName, isManifest);
                    }
                    trackNames.add(trackName);
                    this._pickupCars = true;
                    if (car.isUtility()) {
                        s = this.pickupUtilityCars(carList, car, isManifest, true);
                        if (s == null) continue;
                        s = s.trim();
                    } else {
                        s = this.pickupCar(car, isManifest, true).trim();
                    }
                    s = TrainCommon.padAndTruncate(s, TrainCommon.getLineLength(isManifest) / 2);
                    s = TrainCommon.formatColorString(s, car.isLocalMove() ? Setup.getLocalColor() : Setup.getPickupColor());
                    s = this.appendSetoutString(s, trackName, carList, rl, isManifest, true);
                    this.addLine(file, s);
                }
            }
            for (Car car : carList) {
                String test;
                if (this.doneCars.contains(car) || car.getRouteDestination() != rl || !trackName.equals(car.getSplitDestinationTrackName())) continue;
                if (!trackNames.contains(trackName)) {
                    this.printTrackNameHeader(file, trackName, isManifest);
                }
                trackNames.add(trackName);
                String s = TrainCommon.padString("", TrainCommon.getLineLength(isManifest) / 2);
                String so = this.appendSetoutString(s, carList, rl, car, isManifest, true);
                if (so.equals(s) || (test = so.trim()).length() <= 1) continue;
                this.addLine(file, so);
            }
        }
    }

    protected void printTrackComments(PrintWriter file, RouteLocation rl, List<Car> carList, boolean isManifest) {
        Location location = rl.getLocation();
        if (location != null) {
            List<Track> tracks = location.getTracksByNameList(null);
            for (Track track : tracks) {
                if (isManifest && !track.isPrintManifestCommentEnabled() || !isManifest && !track.isPrintSwitchListCommentEnabled()) continue;
                boolean pickup = false;
                boolean setout = false;
                for (Car car : carList) {
                    if (car.getRouteLocation() == rl && car.getTrack() != null && car.getTrack() == track) {
                        pickup = true;
                    }
                    if (car.getRouteDestination() != rl || car.getDestinationTrack() == null || car.getDestinationTrack() != track) continue;
                    setout = true;
                }
                if (pickup && setout && !track.getCommentBothWithColor().equals("")) {
                    this.newLine(file, track.getCommentBothWithColor(), isManifest);
                    continue;
                }
                if (pickup && !setout && !track.getCommentPickupWithColor().equals("")) {
                    this.newLine(file, track.getCommentPickupWithColor(), isManifest);
                    continue;
                }
                if (pickup || !setout || track.getCommentSetoutWithColor().equals("")) continue;
                this.newLine(file, track.getCommentSetoutWithColor(), isManifest);
            }
        }
    }

    protected void setCarPickupAndSetoutTimes(Train train, RouteLocation rl, List<Car> carList) {
        String expectedDepartureTime = train.getExpectedDepartureTime(rl, true);
        for (Car car : carList) {
            if (car.getRouteLocation() == rl) {
                car.setPickupTime(expectedDepartureTime);
            }
            if (car.getRouteDestination() != rl) continue;
            car.setSetoutTime(expectedDepartureTime);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Only when exception")
    public static String getTrainMessage(Train train, RouteLocation rl) {
        String expectedArrivalTime = train.getExpectedArrivalTime(rl);
        String routeLocationName = rl.getSplitName();
        Object msg = "";
        String messageFormatText = "";
        try {
            messageFormatText = TrainManifestText.getStringScheduledWork();
            msg = MessageFormat.format(messageFormatText, routeLocationName, train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
            if (train.isShowArrivalAndDepartureTimesEnabled()) {
                if (rl == train.getTrainDepartsRouteLocation()) {
                    messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                    msg = MessageFormat.format(messageFormatText, routeLocationName, train.getFormatedDepartureTime(), train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
                } else if (!rl.getDepartureTime().equals("") && rl != train.getTrainTerminatesRouteLocation()) {
                    messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                    msg = MessageFormat.format(messageFormatText, routeLocationName, expectedArrivalTime.equals("-1") ? rl.getFormatedDepartureTime() : train.getExpectedDepartureTime(rl), train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
                } else if (Setup.isUseDepartureTimeEnabled() && rl != train.getTrainTerminatesRouteLocation() && !train.getExpectedDepartureTime(rl).equals("-1")) {
                    messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                    msg = MessageFormat.format(messageFormatText, routeLocationName, train.getExpectedDepartureTime(rl), train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
                } else if (!expectedArrivalTime.equals("-1")) {
                    messageFormatText = TrainManifestText.getStringWorkArrivalTime();
                    msg = MessageFormat.format(messageFormatText, routeLocationName, expectedArrivalTime, train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
                }
            }
            return msg;
        }
        catch (IllegalArgumentException e) {
            msg = Bundle.getMessage("ErrorIllegalArgument", Bundle.getMessage("TitleSwitchListText"), e.getLocalizedMessage()) + NEW_LINE + messageFormatText;
            log.error((String)msg);
            log.error("Illegal argument", (Throwable)e);
            return msg;
        }
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Only when exception")
    public static String getSwitchListTrainStatus(Train train, RouteLocation rl) {
        String expectedArrivalTime = train.getExpectedArrivalTime(rl);
        Object msg = "";
        String messageFormatText = "";
        try {
            if (train.isLocalSwitcher()) {
                messageFormatText = TrainManifestText.getStringWorkDepartureTime();
                msg = MessageFormat.format(messageFormatText, TrainCommon.splitString(train.getTrainDepartsName()), train.getFormatedDepartureTime(), train.getName(), train.getDescription(), rl.getLocation().getDivisionName());
            } else if (rl == train.getTrainDepartsRouteLocation()) {
                messageFormatText = TrainSwitchListText.getStringDepartsAt();
                msg = MessageFormat.format(messageFormatText, TrainCommon.splitString(train.getTrainDepartsName()), rl.getTrainDirectionString(), train.getFormatedDepartureTime());
            } else if (Setup.isUseSwitchListDepartureTimeEnabled() && rl != train.getTrainTerminatesRouteLocation() && !train.isTrainEnRoute()) {
                messageFormatText = TrainSwitchListText.getStringDepartsAtExpectedArrival();
                msg = MessageFormat.format(messageFormatText, TrainCommon.splitString(rl.getName()), train.getExpectedDepartureTime(rl), expectedArrivalTime, rl.getTrainDirectionString());
            } else if (Setup.isUseSwitchListDepartureTimeEnabled() && rl == train.getCurrentRouteLocation() && rl != train.getTrainTerminatesRouteLocation() && !rl.getDepartureTime().equals("")) {
                messageFormatText = TrainSwitchListText.getStringDepartsAt();
                msg = MessageFormat.format(messageFormatText, TrainCommon.splitString(rl.getName()), rl.getTrainDirectionString(), rl.getFormatedDepartureTime());
            } else if (train.isTrainEnRoute()) {
                if (!expectedArrivalTime.equals("-1")) {
                    messageFormatText = TrainSwitchListText.getStringDepartedExpected();
                    msg = MessageFormat.format(messageFormatText, TrainCommon.splitString(train.getTrainDepartsName()), expectedArrivalTime, rl.getTrainDirectionString(), train.getCurrentLocationName());
                }
            } else {
                messageFormatText = TrainSwitchListText.getStringDepartsAtExpectedArrival();
                msg = MessageFormat.format(messageFormatText, TrainCommon.splitString(train.getTrainDepartsName()), train.getFormatedDepartureTime(), expectedArrivalTime, rl.getTrainDirectionString());
            }
            return msg;
        }
        catch (IllegalArgumentException e) {
            msg = Bundle.getMessage("ErrorIllegalArgument", Bundle.getMessage("TitleSwitchListText"), e.getLocalizedMessage()) + NEW_LINE + messageFormatText;
            log.error((String)msg);
            log.error("Illegal argument", (Throwable)e);
            return msg;
        }
    }

    private String appendSetoutString(String s, List<Car> carList, RouteLocation rl, boolean local, boolean isManifest, boolean isTwoColumnTrack) {
        while (this.index < carList.size()) {
            String so;
            Car car = carList.get(this.index++);
            if (local && car.isLocalMove() || car.getRouteDestination() != rl || (so = this.appendSetoutString(s, carList, rl, car, isManifest, isTwoColumnTrack)).equals(s)) continue;
            return so;
        }
        return s + "|" + TrainCommon.padAndTruncate("", TrainCommon.getLineLength(isManifest) / 2 - 1);
    }

    private String appendSetoutString(String s, String trackName, List<Car> carList, RouteLocation rl, boolean isManifest, boolean isTwoColumnTrack) {
        for (Car car : carList) {
            if (this.doneCars.contains(car) || car.getRouteDestination() != rl || !trackName.equals(car.getSplitDestinationTrackName())) continue;
            this.doneCars.add(car);
            String so = this.appendSetoutString(s, carList, rl, car, isManifest, isTwoColumnTrack);
            if (so.equals(s)) continue;
            return so;
        }
        return s + "|" + TrainCommon.padAndTruncate("", TrainCommon.getLineLength(isManifest) / 2 - 1);
    }

    private String appendSetoutString(String s, List<Car> carList, RouteLocation rl, Car car, boolean isManifest, boolean isTwoColumnTrack) {
        String dropText;
        this._dropCars = true;
        if (car.isUtility()) {
            dropText = this.setoutUtilityCars(carList, car, false, isManifest, isTwoColumnTrack);
            if (dropText == null) {
                return s;
            }
        } else {
            dropText = this.dropCar(car, isManifest, isTwoColumnTrack).trim();
        }
        dropText = TrainCommon.padAndTruncate(dropText.trim(), TrainCommon.getLineLength(isManifest) / 2 - 1);
        dropText = TrainCommon.formatColorString(dropText, car.isLocalMove() ? Setup.getLocalColor() : Setup.getDropColor());
        return s + "|" + dropText;
    }

    protected void pickUpCarTruncated(PrintWriter file, Car car, boolean isManifest) {
        this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupCarPrefix(), Setup.getManifestPrefixLength())), Setup.getPickupTruncatedManifestMessageFormat(), isManifest);
    }

    protected void pickUpCar(PrintWriter file, Car car, boolean isManifest) {
        if (isManifest) {
            this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupCarPrefix(), Setup.getManifestPrefixLength())), Setup.getPickupManifestMessageFormat(), isManifest);
        } else {
            this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListPickupCarPrefix(), Setup.getSwitchListPrefixLength())), Setup.getPickupSwitchListMessageFormat(), isManifest);
        }
    }

    private void pickUpCar(PrintWriter file, Car car, StringBuffer buf, String[] format, boolean isManifest) {
        if (car.isLocalMove()) {
            return;
        }
        for (String attribute : format) {
            String s = this.getCarAttribute(car, attribute, true, false);
            if (!this.checkStringLength(buf.toString() + s, isManifest)) {
                this.addLine(file, buf, Setup.getPickupColor());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
        }
        this.addLine(file, buf, Setup.getPickupColor());
    }

    public String pickupCar(Car car, boolean isManifest, boolean isTwoColumnTrack) {
        StringBuffer buf = new StringBuffer();
        String[] format = isManifest && !isTwoColumnTrack ? Setup.getPickupManifestMessageFormat() : (!isManifest && !isTwoColumnTrack ? Setup.getPickupSwitchListMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getPickupTwoColumnByTrackManifestMessageFormat() : Setup.getPickupTwoColumnByTrackSwitchListMessageFormat()));
        for (String attribute : format) {
            buf.append(this.getCarAttribute(car, attribute, true, false));
        }
        return buf.toString();
    }

    protected void truncatedDropCar(PrintWriter file, Car car, boolean isManifest) {
        if (car.isLocalMove()) {
            return;
        }
        this.dropCar(file, car, new StringBuffer(Setup.getDropCarPrefix()), Setup.getDropTruncatedManifestMessageFormat(), false, isManifest);
    }

    protected void dropCar(PrintWriter file, Car car, boolean isManifest) {
        boolean isLocal = car.isLocalMove();
        if (isManifest) {
            StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getDropCarPrefix(), Setup.getManifestPrefixLength()));
            String[] format = Setup.getDropManifestMessageFormat();
            if (isLocal) {
                buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getLocalPrefix(), Setup.getManifestPrefixLength()));
                format = Setup.getLocalManifestMessageFormat();
            }
            this.dropCar(file, car, buf, format, isLocal, isManifest);
        } else {
            StringBuffer buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListDropCarPrefix(), Setup.getSwitchListPrefixLength()));
            String[] format = Setup.getDropSwitchListMessageFormat();
            if (isLocal) {
                buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListLocalPrefix(), Setup.getSwitchListPrefixLength()));
                format = Setup.getLocalSwitchListMessageFormat();
            }
            this.dropCar(file, car, buf, format, isLocal, isManifest);
        }
    }

    private void dropCar(PrintWriter file, Car car, StringBuffer buf, String[] format, boolean isLocal, boolean isManifest) {
        for (String attribute : format) {
            String s = this.getCarAttribute(car, attribute, false, isLocal);
            if (!this.checkStringLength(buf.toString() + s, isManifest)) {
                this.addLine(file, buf, isLocal ? Setup.getLocalColor() : Setup.getDropColor());
                buf = new StringBuffer(TAB);
            }
            buf.append(s);
        }
        this.addLine(file, buf, isLocal ? Setup.getLocalColor() : Setup.getDropColor());
    }

    public String dropCar(Car car, boolean isManifest, boolean isTwoColumnTrack) {
        StringBuffer buf = new StringBuffer();
        String[] format = isManifest && !isTwoColumnTrack ? Setup.getDropManifestMessageFormat() : (!isManifest && !isTwoColumnTrack ? Setup.getDropSwitchListMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getDropTwoColumnByTrackManifestMessageFormat() : Setup.getDropTwoColumnByTrackSwitchListMessageFormat()));
        boolean local = false;
        if (car.getTrack() == null) {
            local = true;
        }
        for (String attribute : format) {
            buf.append(this.getCarAttribute(car, attribute, false, local));
        }
        return buf.toString();
    }

    public String localMoveCar(Car car, boolean isManifest) {
        StringBuffer buf = new StringBuffer();
        String[] format = isManifest ? Setup.getLocalManifestMessageFormat() : Setup.getLocalSwitchListMessageFormat();
        for (String attribute : format) {
            buf.append(this.getCarAttribute(car, attribute, false, true));
        }
        return buf.toString();
    }

    protected void pickupUtilityCars(PrintWriter file, List<Car> carList, Car car, boolean isTruncate, boolean isManifest) {
        int count;
        String[] format = isManifest ? Setup.getPickupUtilityManifestMessageFormat() : Setup.getPickupUtilitySwitchListMessageFormat();
        if (isTruncate && isManifest) {
            format = Setup.createTruncatedManifestMessageFormat(format);
        }
        if ((count = this.countUtilityCars(format, carList, car, true)) == 0) {
            return;
        }
        this.pickUpCar(file, car, new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getPickupCarPrefix(), isManifest ? Setup.getManifestPrefixLength() : Setup.getSwitchListPrefixLength()) + " " + TrainCommon.padString(Integer.toString(count), 3)), format, isManifest);
    }

    protected void setoutUtilityCars(PrintWriter file, List<Car> carList, Car car, boolean isTruncate, boolean isManifest) {
        int count;
        String[] format;
        StringBuffer buf;
        boolean isLocal = car.isLocalMove();
        if (isLocal && isManifest) {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getLocalPrefix(), Setup.getManifestPrefixLength()));
            format = Setup.getLocalUtilityManifestMessageFormat();
        } else if (!isLocal && isManifest) {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getDropCarPrefix(), Setup.getManifestPrefixLength()));
            format = Setup.getDropUtilityManifestMessageFormat();
        } else if (isLocal && !isManifest) {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListLocalPrefix(), Setup.getSwitchListPrefixLength()));
            format = Setup.getLocalUtilitySwitchListMessageFormat();
        } else {
            buf = new StringBuffer(TrainCommon.padAndTruncateIfNeeded(Setup.getSwitchListDropCarPrefix(), Setup.getSwitchListPrefixLength()));
            format = Setup.getDropUtilitySwitchListMessageFormat();
        }
        if (isTruncate && isManifest) {
            format = Setup.createTruncatedManifestMessageFormat(format);
        }
        if ((count = this.countUtilityCars(format, carList, car, false)) == 0) {
            return;
        }
        buf.append(" " + TrainCommon.padString(Integer.toString(count), 3));
        this.dropCar(file, car, buf, format, isLocal, isManifest);
    }

    public String pickupUtilityCars(List<Car> carList, Car car, boolean isManifest, boolean isTwoColumnTrack) {
        int count = this.countPickupUtilityCars(carList, car, isManifest);
        if (count == 0) {
            return null;
        }
        String[] format = isManifest && !isTwoColumnTrack ? Setup.getPickupUtilityManifestMessageFormat() : (!isManifest && !isTwoColumnTrack ? Setup.getPickupUtilitySwitchListMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getPickupTwoColumnByTrackUtilityManifestMessageFormat() : Setup.getPickupTwoColumnByTrackUtilitySwitchListMessageFormat()));
        StringBuffer buf = new StringBuffer(" " + TrainCommon.padString(Integer.toString(count), 3));
        for (String attribute : format) {
            buf.append(this.getCarAttribute(car, attribute, true, false));
        }
        return buf.toString();
    }

    public int countPickupUtilityCars(List<Car> carList, Car car, boolean isManifest) {
        String[] format = isManifest ? Setup.getPickupUtilityManifestMessageFormat() : Setup.getPickupUtilitySwitchListMessageFormat();
        return this.countUtilityCars(format, carList, car, true);
    }

    public String setoutUtilityCars(List<Car> carList, Car car, boolean isLocal, boolean isManifest) {
        return this.setoutUtilityCars(carList, car, isLocal, isManifest, false);
    }

    protected String setoutUtilityCars(List<Car> carList, Car car, boolean isLocal, boolean isManifest, boolean isTwoColumnTrack) {
        int count = this.countSetoutUtilityCars(carList, car, isLocal, isManifest);
        if (count == 0) {
            return null;
        }
        String[] format = isLocal && isManifest && !isTwoColumnTrack ? Setup.getLocalUtilityManifestMessageFormat() : (isLocal && !isManifest && !isTwoColumnTrack ? Setup.getLocalUtilitySwitchListMessageFormat() : (!isLocal && !isManifest && !isTwoColumnTrack ? Setup.getDropUtilitySwitchListMessageFormat() : (!isLocal && isManifest && !isTwoColumnTrack ? Setup.getDropUtilityManifestMessageFormat() : (isManifest && isTwoColumnTrack ? Setup.getDropTwoColumnByTrackUtilityManifestMessageFormat() : Setup.getDropTwoColumnByTrackUtilitySwitchListMessageFormat()))));
        StringBuffer buf = new StringBuffer(" " + TrainCommon.padString(Integer.toString(count), 3));
        if (car.getTrack() == null) {
            isLocal = true;
        }
        for (String attribute : format) {
            buf.append(this.getCarAttribute(car, attribute, false, isLocal));
        }
        return buf.toString();
    }

    public int countSetoutUtilityCars(List<Car> carList, Car car, boolean isLocal, boolean isManifest) {
        String[] format = isLocal && isManifest ? Setup.getLocalUtilityManifestMessageFormat() : (isLocal && !isManifest ? Setup.getLocalUtilitySwitchListMessageFormat() : (!isLocal && !isManifest ? Setup.getDropUtilitySwitchListMessageFormat() : Setup.getDropUtilityManifestMessageFormat()));
        return this.countUtilityCars(format, carList, car, false);
    }

    protected int countUtilityCars(String[] format, List<Car> carList, Car car, boolean isPickup) {
        String carAttributes;
        int count = 0;
        boolean showLength = this.showUtilityCarLength(format);
        boolean showLoad = this.showUtilityCarLoad(format);
        boolean showLocation = false;
        boolean showDestination = false;
        String carType = car.getTypeName().split("-")[0];
        if (isPickup) {
            carAttributes = carType + car.getRouteLocationId() + car.getSplitTrackName();
            showDestination = this.showUtilityCarDestination(format);
            if (showDestination) {
                carAttributes = carAttributes + car.getRouteDestinationId();
            }
        } else {
            carAttributes = carType + car.getSplitDestinationTrackName() + car.getRouteDestinationId();
            showLocation = this.showUtilityCarLocation(format);
            if (showLocation && car.getTrack() != null) {
                carAttributes = carAttributes + car.getRouteLocationId();
            }
        }
        if (car.isLocalMove()) {
            carAttributes = carAttributes + car.getSplitTrackName();
        }
        if (showLength) {
            carAttributes = carAttributes + car.getLength();
        }
        if (showLoad) {
            carAttributes = carAttributes + car.getLoadName();
        }
        if (!this.utilityCarTypes.contains(carAttributes)) {
            this.utilityCarTypes.add(carAttributes);
            for (Car c : carList) {
                String cType;
                if (!c.isUtility() || !(cType = c.getTypeName().split("-")[0]).equals(carType) || showLength && !c.getLength().equals(car.getLength()) || showLoad && !c.getLoadName().equals(car.getLoadName()) || showLocation && !c.getRouteLocationId().equals(car.getRouteLocationId()) || showDestination && !c.getRouteDestinationId().equals(car.getRouteDestinationId()) || car.isLocalMove() ^ c.isLocalMove()) continue;
                if (isPickup && c.getRouteLocation() == car.getRouteLocation() && c.getSplitTrackName().equals(car.getSplitTrackName())) {
                    ++count;
                }
                if (isPickup || c.getRouteDestination() != car.getRouteDestination() || !c.getSplitDestinationTrackName().equals(car.getSplitDestinationTrackName()) || !c.getSplitTrackName().equals(car.getSplitTrackName()) && c.isLocalMove()) continue;
                ++count;
            }
        }
        return count;
    }

    public void clearUtilityCarTypes() {
        this.utilityCarTypes.clear();
    }

    private boolean showUtilityCarLength(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.LENGTH, mFormat);
    }

    private boolean showUtilityCarLoad(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.LOAD, mFormat);
    }

    private boolean showUtilityCarLocation(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.LOCATION, mFormat);
    }

    private boolean showUtilityCarDestination(String[] mFormat) {
        return this.showUtilityCarAttribute(Setup.DESTINATION, mFormat) || this.showUtilityCarAttribute(Setup.DEST_TRACK, mFormat);
    }

    private boolean showUtilityCarAttribute(String string, String[] mFormat) {
        for (String s : mFormat) {
            if (!s.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void addLine(PrintWriter file, String level, String string) {
        log.debug("addLine: {}", (Object)string);
        if (file != null) {
            String[] lines;
            for (String line : lines = string.split(NEW_LINE)) {
                TrainCommon.printLine(file, level, line);
            }
        }
    }

    private static void printLine(PrintWriter file, String level, String string) {
        int lineLengthMax = TrainCommon.getLineLength(Setup.PORTRAIT, Setup.MONOSPACED, 0, Setup.getBuildReportFontSize());
        if (string.length() > lineLengthMax) {
            String[] words = string.split(" ");
            StringBuffer sb = new StringBuffer();
            for (String word : words) {
                if (sb.length() + word.length() < lineLengthMax) {
                    sb.append(word + " ");
                    continue;
                }
                file.println(level + "- " + sb.toString());
                sb = new StringBuffer(word + " ");
            }
            string = sb.toString();
        }
        file.println(level + "- " + string);
    }

    protected void addLine(PrintWriter file, String string) {
        log.debug("addLine: {}", (Object)string);
        if (file != null) {
            file.println(string);
        }
    }

    protected void newLine(PrintWriter file, String string, boolean isManifest) {
        String[] lines;
        for (String line : lines = string.split(NEW_LINE)) {
            String[] words = line.split(" ");
            StringBuffer sb = new StringBuffer();
            for (String word : words) {
                if (this.checkStringLength(sb.toString() + word, isManifest)) {
                    sb.append(word + " ");
                    continue;
                }
                sb.setLength(sb.length() - 1);
                this.addLine(file, sb.toString());
                sb = new StringBuffer(word + " ");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            this.addLine(file, sb.toString());
        }
    }

    protected void newLine(PrintWriter file) {
        file.println(" ");
    }

    public static String splitString(String name) {
        String[] splitname = name.split("-");
        if (splitname.length > 1 && !splitname[1].startsWith("(")) {
            try {
                Integer.parseInt(splitname[1]);
            }
            catch (NumberFormatException e) {
                return name.trim();
            }
        }
        return splitname[0].trim();
    }

    private static String splitStringLeftParenthesis(String name) {
        String[] splitname = name.split("-");
        if (splitname.length > 1 && splitname[1].startsWith("(")) {
            return splitname[0].trim();
        }
        return name.trim();
    }

    protected boolean isThereWorkAtLocation(List<Car> carList, List<Engine> engList, RouteLocation rl) {
        if (carList != null) {
            for (Car car : carList) {
                if (car.getRouteLocation() != rl && car.getRouteDestination() != rl) continue;
                return true;
            }
        }
        if (engList != null) {
            for (Engine eng : engList) {
                if (eng.getRouteLocation() != rl && eng.getRouteDestination() != rl) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isThereWorkAtLocation(Train train, Location location) {
        if (TrainCommon.isThereWorkAtLocation(train, location, InstanceManager.getDefault(CarManager.class).getList(train))) {
            return true;
        }
        return TrainCommon.isThereWorkAtLocation(train, location, InstanceManager.getDefault(EngineManager.class).getList(train));
    }

    private static boolean isThereWorkAtLocation(Train train, Location location, List<? extends RollingStock> list) {
        for (RollingStock rollingStock : list) {
            if ((rollingStock.getRouteLocation() == null || rollingStock.getTrack() == null || !rollingStock.getRouteLocation().getSplitName().equals(location.getSplitName())) && (rollingStock.getRouteDestination() == null || !rollingStock.getRouteDestination().getSplitName().equals(location.getSplitName()))) continue;
            return true;
        }
        return false;
    }

    protected void addCarsLocationUnknown(PrintWriter file, boolean isManifest) {
        List<Car> cars = this.carManager.getCarsLocationUnknown();
        if (cars.size() == 0) {
            return;
        }
        this.newLine(file);
        this.newLine(file, Setup.getMiaComment(), isManifest);
        if (Setup.isPrintHeadersEnabled()) {
            this.printHorizontalLine1(file, isManifest);
            this.newLine(file, " " + this.getHeader(Setup.getMissingCarMessageFormat(), false, false, false), isManifest);
            this.printHorizontalLine2(file, isManifest);
        }
        for (Car car : cars) {
            this.addSearchForCar(file, car, isManifest);
        }
    }

    private void addSearchForCar(PrintWriter file, Car car, boolean isManifest) {
        String[] format;
        StringBuffer buf = new StringBuffer();
        for (String attribute : format = Setup.getMissingCarMessageFormat()) {
            buf.append(this.getCarAttribute(car, attribute, false, false));
        }
        this.newLine(file, buf.toString(), isManifest);
    }

    private String getEngineAttribute(Engine engine, String attribute, boolean isPickup) {
        if (!attribute.equals(" ")) {
            String s = " " + this.getEngineAttrib(engine, attribute, isPickup);
            if (Setup.isTabEnabled() || !s.isBlank()) {
                return s;
            }
        }
        return "";
    }

    private String getEngineAttrib(Engine engine, String attribute, boolean isPickup) {
        if (attribute.equals(Setup.MODEL)) {
            return TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitStringLeftParenthesis(engine.getModel()), InstanceManager.getDefault(EngineModels.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.HP)) {
            return TrainCommon.padAndTruncateIfNeeded(engine.getHp(), 5) + (Setup.isPrintHeadersEnabled() ? "" : TrainManifestHeaderText.getStringHeader_Hp());
        }
        if (attribute.equals(Setup.CONSIST)) {
            return TrainCommon.padAndTruncateIfNeeded(engine.getConsistName(), InstanceManager.getDefault(ConsistManager.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.DCC_ADDRESS)) {
            return TrainCommon.padAndTruncateIfNeeded(engine.getDccAddress(), TrainManifestHeaderText.getStringHeader_DCC_Address().length());
        }
        if (attribute.equals(Setup.COMMENT)) {
            return TrainCommon.padAndTruncateIfNeeded(engine.getComment(), this.engineManager.getMaxCommentLength());
        }
        return this.getRollingStockAttribute(engine, attribute, isPickup, false);
    }

    private String getCarAttribute(Car car, String attribute, boolean isPickup, boolean isLocal) {
        if (!attribute.equals(" ")) {
            String s = " " + this.getCarAttrib(car, attribute, isPickup, isLocal);
            if (Setup.isTabEnabled() || !s.isBlank()) {
                return s;
            }
        }
        return "";
    }

    private String getCarAttrib(Car car, String attribute, boolean isPickup, boolean isLocal) {
        if (attribute.equals(Setup.LOAD)) {
            return car.isCaboose() && !Setup.isPrintCabooseLoadEnabled() || car.isPassenger() && !Setup.isPrintPassengerLoadEnabled() ? TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarLoads.class).getMaxNameLength()) : TrainCommon.padAndTruncateIfNeeded(car.getLoadName().split("-")[0], InstanceManager.getDefault(CarLoads.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.LOAD_TYPE)) {
            return TrainCommon.padAndTruncateIfNeeded(car.getLoadType(), TrainManifestHeaderText.getStringHeader_Load_Type().length());
        }
        if (attribute.equals(Setup.HAZARDOUS)) {
            return car.isHazardous() ? Setup.getHazardousMsg() : TrainCommon.padAndTruncateIfNeeded("", Setup.getHazardousMsg().length());
        }
        if (attribute.equals(Setup.DROP_COMMENT)) {
            return TrainCommon.padAndTruncateIfNeeded(car.getDropComment(), InstanceManager.getDefault(CarLoads.class).getMaxLoadCommentLength());
        }
        if (attribute.equals(Setup.PICKUP_COMMENT)) {
            return TrainCommon.padAndTruncateIfNeeded(car.getPickupComment(), InstanceManager.getDefault(CarLoads.class).getMaxLoadCommentLength());
        }
        if (attribute.equals(Setup.KERNEL)) {
            return TrainCommon.padAndTruncateIfNeeded(car.getKernelName(), InstanceManager.getDefault(KernelManager.class).getMaxNameLength());
        }
        if (attribute.equals(Setup.KERNEL_SIZE)) {
            if (car.isLead()) {
                return TrainCommon.padAndTruncateIfNeeded(Integer.toString(car.getKernel().getSize()), 2);
            }
            return "  ";
        }
        if (attribute.equals(Setup.RWE)) {
            if (!car.getReturnWhenEmptyDestinationName().equals("")) {
                Object rweAndTrackName = car.getSplitReturnWhenEmptyDestinationName();
                if (!car.getReturnWhenEmptyDestTrackName().equals("")) {
                    rweAndTrackName = (String)rweAndTrackName + ", " + car.getSplitReturnWhenEmptyDestinationTrackName();
                }
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded((String)rweAndTrackName, this.locationManager.getMaxLocationAndTrackNameLength()) : TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_RWE() + " " + (String)rweAndTrackName, this.locationManager.getMaxLocationAndTrackNameLength() + TrainManifestHeaderText.getStringHeader_RWE().length() + 3);
            }
            return TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxLocationAndTrackNameLength());
        }
        if (attribute.equals(Setup.FINAL_DEST)) {
            return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded(car.getSplitFinalDestinationName(), this.locationManager.getMaxLocationNameLength()) : TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringFinalDestination() + " " + car.getSplitFinalDestinationName(), this.locationManager.getMaxLocationNameLength() + TrainManifestText.getStringFinalDestination().length() + 1);
        }
        if (attribute.equals(Setup.FINAL_DEST_TRACK)) {
            Object FDAndTrackName = car.getSplitFinalDestinationName();
            if (!car.getFinalDestinationTrackName().equals("")) {
                FDAndTrackName = (String)FDAndTrackName + ", " + car.getSplitFinalDestinationTrackName();
            }
            return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded((String)FDAndTrackName, this.locationManager.getMaxLocationAndTrackNameLength() + 2) : TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringFinalDestination() + " " + (String)FDAndTrackName, this.locationManager.getMaxLocationAndTrackNameLength() + TrainManifestText.getStringFinalDestination().length() + 3);
        }
        if (attribute.equals(Setup.DIVISION)) {
            return TrainCommon.padAndTruncateIfNeeded(car.getDivisionName(), InstanceManager.getDefault(DivisionManager.class).getMaxDivisionNameLength());
        }
        if (attribute.equals(Setup.BLOCKING_ORDER)) {
            if (car.isPassenger()) {
                return TrainCommon.padAndTruncateIfNeeded(Integer.toString(car.getBlocking()), 3);
            }
            return "   ";
        }
        if (attribute.equals(Setup.COMMENT)) {
            return TrainCommon.padAndTruncateIfNeeded(car.getComment(), this.carManager.getMaxCommentLength());
        }
        return this.getRollingStockAttribute(car, attribute, isPickup, isLocal);
    }

    private String getRollingStockAttribute(RollingStock rs, String attribute, boolean isPickup, boolean isLocal) {
        try {
            if (attribute.equals(Setup.NUMBER)) {
                return TrainCommon.padAndTruncateIfNeeded(TrainCommon.splitString(rs.getNumber()), Control.max_len_string_print_road_number);
            }
            if (attribute.equals(Setup.ROAD)) {
                String road = rs.getRoadName().split("-")[0];
                return TrainCommon.padAndTruncateIfNeeded(road, InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.TYPE)) {
                String type = rs.getTypeName().split("-")[0];
                return TrainCommon.padAndTruncateIfNeeded(type, InstanceManager.getDefault(CarTypes.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.LENGTH)) {
                return TrainCommon.padAndTruncateIfNeeded(rs.getLength() + Setup.getLengthUnitAbv(), InstanceManager.getDefault(CarLengths.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.WEIGHT)) {
                return TrainCommon.padAndTruncateIfNeeded(Integer.toString(rs.getAdjustedWeightTons()), Control.max_len_string_weight_name) + (Setup.isPrintHeadersEnabled() ? "" : TrainManifestHeaderText.getStringHeader_Weight());
            }
            if (attribute.equals(Setup.COLOR)) {
                return TrainCommon.padAndTruncateIfNeeded(rs.getColor(), InstanceManager.getDefault(CarColors.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.LOCATION) && (isPickup || isLocal) || attribute.equals(Setup.TRACK) && isPickup) {
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded(rs.getSplitTrackName(), this.locationManager.getMaxTrackNameLength()) : TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringFrom() + " " + rs.getSplitTrackName(), TrainManifestText.getStringFrom().length() + this.locationManager.getMaxTrackNameLength() + 1);
            }
            if (attribute.equals(Setup.LOCATION) && !isPickup && !isLocal) {
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded(rs.getSplitLocationName(), this.locationManager.getMaxLocationNameLength()) : TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringFrom() + " " + rs.getSplitLocationName(), this.locationManager.getMaxLocationNameLength() + TrainManifestText.getStringFrom().length() + 1);
            }
            if (attribute.equals(Setup.DESTINATION) && isPickup) {
                if (Setup.isPrintHeadersEnabled()) {
                    return TrainCommon.padAndTruncateIfNeeded(rs.getSplitDestinationName(), this.locationManager.getMaxLocationNameLength());
                }
                if (Setup.isTabEnabled()) {
                    return TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringDest() + " " + rs.getSplitDestinationName(), TrainManifestText.getStringDest().length() + this.locationManager.getMaxLocationNameLength() + 1);
                }
                return TrainManifestText.getStringDestination() + " " + rs.getSplitDestinationName();
            }
            if ((attribute.equals(Setup.DESTINATION) || attribute.equals(Setup.TRACK)) && !isPickup) {
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded(rs.getSplitDestinationTrackName(), this.locationManager.getMaxTrackNameLength()) : TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringTo() + " " + rs.getSplitDestinationTrackName(), this.locationManager.getMaxTrackNameLength() + TrainManifestText.getStringTo().length() + 1);
            }
            if (attribute.equals(Setup.DEST_TRACK)) {
                String destAndTrackName = rs.getSplitDestinationName() + ", " + rs.getSplitDestinationTrackName();
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded(destAndTrackName, this.locationManager.getMaxLocationAndTrackNameLength() + 2) : TrainCommon.padAndTruncateIfNeeded(TrainManifestText.getStringDest() + " " + destAndTrackName, this.locationManager.getMaxLocationAndTrackNameLength() + TrainManifestText.getStringDest().length() + 3);
            }
            if (attribute.equals(Setup.OWNER)) {
                return TrainCommon.padAndTruncateIfNeeded(rs.getOwnerName(), InstanceManager.getDefault(CarOwners.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.LAST_TRAIN)) {
                String lastTrainName = TrainCommon.padAndTruncateIfNeeded(rs.getLastTrainName(), InstanceManager.getDefault(TrainManager.class).getMaxTrainNameLength());
                return Setup.isPrintHeadersEnabled() ? lastTrainName : TrainManifestHeaderText.getStringHeader_Last_Train() + " " + lastTrainName;
            }
            if (attribute.equals("NO_NUMBER")) {
                return TrainCommon.padAndTruncateIfNeeded("", Control.max_len_string_print_road_number - 4);
            }
            if (attribute.equals("NO_ROAD")) {
                return TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            }
            if (attribute.equals("NO_COLOR")) {
                return TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarColors.class).getMaxNameLength());
            }
            if (attribute.equals("NO_DEST_TRACK")) {
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxLocationAndTrackNameLength() + 1) : "";
            }
            if (attribute.equals("NO_LOCATION") && !isPickup || attribute.equals("NO_DESTINATION") && isPickup) {
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxLocationNameLength()) : "";
            }
            if (attribute.equals("NO_TRACK") || attribute.equals("NO_LOCATION") || attribute.equals("NO_DESTINATION")) {
                return Setup.isPrintHeadersEnabled() ? TrainCommon.padAndTruncateIfNeeded("", this.locationManager.getMaxTrackNameLength()) : "";
            }
            if (attribute.equals(Setup.TAB)) {
                return TrainCommon.createTabIfNeeded(Setup.getTab1Length() - 1);
            }
            if (attribute.equals(Setup.TAB2)) {
                return TrainCommon.createTabIfNeeded(Setup.getTab2Length() - 1);
            }
            if (attribute.equals(Setup.TAB3)) {
                return TrainCommon.createTabIfNeeded(Setup.getTab3Length() - 1);
            }
            return Bundle.getMessage("ErrorPrintOptions", attribute);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (attribute.equals(Setup.ROAD)) {
                return TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarRoads.class).getMaxNameLength());
            }
            if (attribute.equals(Setup.TYPE)) {
                return TrainCommon.padAndTruncateIfNeeded("", InstanceManager.getDefault(CarTypes.class).getMaxNameLength());
            }
            return Bundle.getMessage("ErrorPrintOptions", attribute);
        }
    }

    public void printEngineHeader(PrintWriter file, boolean isManifest) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine(file, isManifest);
        if (Setup.isPrintHeadersEnabled()) {
            Object s;
            if (!Setup.getPickupEnginePrefix().isBlank() || !Setup.getDropEnginePrefix().isBlank()) {
                s = TrainCommon.padAndTruncate(TrainCommon.tabString(Setup.getPickupEnginePrefix().trim(), lineLength / 4 - Setup.getPickupEnginePrefix().length() / 2), lineLength / 2) + "|" + TrainCommon.tabString(Setup.getDropEnginePrefix(), lineLength / 4 - Setup.getDropEnginePrefix().length() / 2);
                s = TrainCommon.padAndTruncate((String)s, lineLength);
                this.addLine(file, (String)s);
                this.printHorizontalLine1(file, isManifest);
            }
            s = TrainCommon.padAndTruncate(this.getPickupEngineHeader(), lineLength / 2);
            s = TrainCommon.padAndTruncate((String)s + "|" + this.getDropEngineHeader(), lineLength);
            this.addLine(file, (String)s);
            this.printHorizontalLine2(file, isManifest);
        }
    }

    public void printPickupEngineHeader(PrintWriter file, boolean isManifest) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine1(file, isManifest);
        String s = TrainCommon.padAndTruncate(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1) + this.getPickupEngineHeader(), lineLength);
        this.addLine(file, s);
        this.printHorizontalLine2(file, isManifest);
    }

    public void printDropEngineHeader(PrintWriter file, boolean isManifest) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine1(file, isManifest);
        String s = TrainCommon.padAndTruncate(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1) + this.getDropEngineHeader(), lineLength);
        this.addLine(file, s);
        this.printHorizontalLine2(file, isManifest);
    }

    public void printCarHeader(PrintWriter file, boolean isManifest, boolean isTwoColumnTrack) {
        int lineLength = TrainCommon.getLineLength(isManifest);
        this.printHorizontalLine(file, isManifest);
        if (Setup.isPrintHeadersEnabled()) {
            Object s = TrainCommon.padAndTruncate(TrainCommon.tabString(Setup.getPickupCarPrefix(), lineLength / 4 - Setup.getPickupCarPrefix().length() / 2), lineLength / 2) + "|" + TrainCommon.tabString(Setup.getDropCarPrefix(), lineLength / 4 - Setup.getDropCarPrefix().length() / 2);
            s = TrainCommon.padAndTruncate((String)s, lineLength);
            this.addLine(file, (String)s);
            this.printHorizontalLine1(file, isManifest);
            s = TrainCommon.padAndTruncate(this.getPickupCarHeader(isManifest, isTwoColumnTrack), lineLength / 2);
            s = TrainCommon.padAndTruncate((String)s + "|" + this.getDropCarHeader(isManifest, isTwoColumnTrack), lineLength);
            this.addLine(file, (String)s);
            this.printHorizontalLine2(file, isManifest);
        }
    }

    public void printPickupCarHeader(PrintWriter file, boolean isManifest, boolean isTwoColumnTrack) {
        if (Setup.isPrintHeadersEnabled()) {
            this.printHorizontalLine1(file, isManifest);
            String s = TrainCommon.padAndTruncate(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1) + this.getPickupCarHeader(isManifest, isTwoColumnTrack), TrainCommon.getLineLength(isManifest));
            this.addLine(file, s);
            this.printHorizontalLine2(file, isManifest);
        }
    }

    public void printDropCarHeader(PrintWriter file, boolean isManifest, boolean isTwoColumnTrack) {
        if (!Setup.isPrintHeadersEnabled() || this.getDropCarHeader(isManifest, isTwoColumnTrack).isBlank()) {
            return;
        }
        this.printHorizontalLine1(file, isManifest);
        String s = TrainCommon.padAndTruncate(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1) + this.getDropCarHeader(isManifest, isTwoColumnTrack), TrainCommon.getLineLength(isManifest));
        this.addLine(file, s);
        this.printHorizontalLine2(file, isManifest);
    }

    public void printLocalCarMoveHeader(PrintWriter file, boolean isManifest) {
        if (!Setup.isPrintHeadersEnabled()) {
            return;
        }
        this.printHorizontalLine1(file, isManifest);
        String s = TrainCommon.padAndTruncate(TrainCommon.createTabIfNeeded(Setup.getManifestPrefixLength() + 1) + this.getLocalMoveHeader(isManifest), TrainCommon.getLineLength(isManifest));
        this.addLine(file, s);
        this.printHorizontalLine2(file, isManifest);
    }

    public String getPickupEngineHeader() {
        return this.getHeader(Setup.getPickupEngineMessageFormat(), true, false, true);
    }

    public String getDropEngineHeader() {
        return this.getHeader(Setup.getDropEngineMessageFormat(), false, false, true);
    }

    public String getPickupCarHeader(boolean isManifest, boolean isTwoColumnTrack) {
        if (isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getPickupManifestMessageFormat(), true, false, false);
        }
        if (!isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getPickupSwitchListMessageFormat(), true, false, false);
        }
        if (isManifest && isTwoColumnTrack) {
            return this.getHeader(Setup.getPickupTwoColumnByTrackManifestMessageFormat(), true, false, false);
        }
        return this.getHeader(Setup.getPickupTwoColumnByTrackSwitchListMessageFormat(), true, false, false);
    }

    public String getDropCarHeader(boolean isManifest, boolean isTwoColumnTrack) {
        if (isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getDropManifestMessageFormat(), false, false, false);
        }
        if (!isManifest && !isTwoColumnTrack) {
            return this.getHeader(Setup.getDropSwitchListMessageFormat(), false, false, false);
        }
        if (isManifest && isTwoColumnTrack) {
            return this.getHeader(Setup.getDropTwoColumnByTrackManifestMessageFormat(), false, false, false);
        }
        return this.getHeader(Setup.getDropTwoColumnByTrackSwitchListMessageFormat(), false, false, false);
    }

    public String getLocalMoveHeader(boolean isManifest) {
        if (isManifest) {
            return this.getHeader(Setup.getLocalManifestMessageFormat(), false, true, false);
        }
        return this.getHeader(Setup.getLocalSwitchListMessageFormat(), false, true, false);
    }

    private String getHeader(String[] format, boolean isPickup, boolean isLocal, boolean isEngine) {
        StringBuffer buf = new StringBuffer();
        for (String attribute : format) {
            if (attribute.equals(" ")) continue;
            if (attribute.equals(Setup.ROAD)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Road(), InstanceManager.getDefault(CarRoads.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.NUMBER) && !isEngine) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Number(), Control.max_len_string_print_road_number) + " ");
                continue;
            }
            if (attribute.equals(Setup.NUMBER) && isEngine) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_EngineNumber(), Control.max_len_string_print_road_number) + " ");
                continue;
            }
            if (attribute.equals(Setup.TYPE)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Type(), InstanceManager.getDefault(CarTypes.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.MODEL)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Model(), InstanceManager.getDefault(EngineModels.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.HP)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Hp(), 5) + " ");
                continue;
            }
            if (attribute.equals(Setup.CONSIST)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Consist(), InstanceManager.getDefault(ConsistManager.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.DCC_ADDRESS)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_DCC_Address(), TrainManifestHeaderText.getStringHeader_DCC_Address().length()) + " ");
                continue;
            }
            if (attribute.equals(Setup.KERNEL)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Kernel(), InstanceManager.getDefault(KernelManager.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.KERNEL_SIZE)) {
                buf.append("   ");
                continue;
            }
            if (attribute.equals(Setup.LOAD)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Load(), InstanceManager.getDefault(CarLoads.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.LOAD_TYPE)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Load_Type(), TrainManifestHeaderText.getStringHeader_Load_Type().length()) + " ");
                continue;
            }
            if (attribute.equals(Setup.COLOR)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Color(), InstanceManager.getDefault(CarColors.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.OWNER)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Owner(), InstanceManager.getDefault(CarOwners.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.LENGTH)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Length(), InstanceManager.getDefault(CarLengths.class).getMaxNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.WEIGHT)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Weight(), Control.max_len_string_weight_name) + " ");
                continue;
            }
            if (attribute.equals(Setup.TRACK)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Track(), this.locationManager.getMaxTrackNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.LOCATION) && (isPickup || isLocal)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Location(), this.locationManager.getMaxTrackNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.LOCATION) && !isPickup) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Location(), this.locationManager.getMaxLocationNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.DESTINATION) && !isPickup) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Destination(), this.locationManager.getMaxTrackNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.DESTINATION) && isPickup) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Destination(), this.locationManager.getMaxLocationNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.DEST_TRACK)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Dest_Track(), this.locationManager.getMaxLocationAndTrackNameLength() + 2) + " ");
                continue;
            }
            if (attribute.equals(Setup.FINAL_DEST)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Final_Dest(), this.locationManager.getMaxLocationNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.FINAL_DEST_TRACK)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Final_Dest_Track(), this.locationManager.getMaxLocationAndTrackNameLength() + 2) + " ");
                continue;
            }
            if (attribute.equals(Setup.HAZARDOUS)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Hazardous(), Setup.getHazardousMsg().length()) + " ");
                continue;
            }
            if (attribute.equals(Setup.RWE)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_RWE(), this.locationManager.getMaxLocationAndTrackNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.COMMENT)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Comment(), isEngine ? this.engineManager.getMaxCommentLength() : this.carManager.getMaxCommentLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.DROP_COMMENT)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Drop_Comment(), InstanceManager.getDefault(CarLoads.class).getMaxLoadCommentLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.PICKUP_COMMENT)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Pickup_Comment(), InstanceManager.getDefault(CarLoads.class).getMaxLoadCommentLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.DIVISION)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Division(), InstanceManager.getDefault(DivisionManager.class).getMaxDivisionNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.BLOCKING_ORDER)) {
                buf.append(TAB);
                continue;
            }
            if (attribute.equals(Setup.LAST_TRAIN)) {
                buf.append(TrainCommon.padAndTruncateIfNeeded(TrainManifestHeaderText.getStringHeader_Last_Train(), InstanceManager.getDefault(TrainManager.class).getMaxTrainNameLength()) + " ");
                continue;
            }
            if (attribute.equals(Setup.TAB)) {
                buf.append(TrainCommon.createTabIfNeeded(Setup.getTab1Length()));
                continue;
            }
            if (attribute.equals(Setup.TAB2)) {
                buf.append(TrainCommon.createTabIfNeeded(Setup.getTab2Length()));
                continue;
            }
            if (attribute.equals(Setup.TAB3)) {
                buf.append(TrainCommon.createTabIfNeeded(Setup.getTab3Length()));
                continue;
            }
            buf.append(attribute + " ");
        }
        return buf.toString().stripTrailing();
    }

    protected void printTrackNameHeader(PrintWriter file, String trackName, boolean isManifest) {
        this.printHorizontalLine(file, isManifest);
        int lineLength = TrainCommon.getLineLength(isManifest);
        Object s = TrainCommon.padAndTruncate(TrainCommon.tabString(trackName.trim(), lineLength / 4 - trackName.trim().length() / 2), lineLength / 2) + "|" + TrainCommon.tabString(trackName.trim(), lineLength / 4 - trackName.trim().length() / 2);
        s = TrainCommon.padAndTruncate((String)s, lineLength);
        this.addLine(file, (String)s);
        if (Setup.isPrintHeaderLine3Enabled()) {
            this.printHorizontalLine(file, isManifest);
        }
    }

    public void printHorizontalLine1(PrintWriter file, boolean isManifest) {
        if (Setup.isPrintHeaderLine1Enabled()) {
            this.printHorizontalLine(file, isManifest);
        }
    }

    public void printHorizontalLine2(PrintWriter file, boolean isManifest) {
        if (Setup.isPrintHeaderLine2Enabled()) {
            this.printHorizontalLine(file, isManifest);
        }
    }

    public void printHorizontalLine3(PrintWriter file, boolean isManifest) {
        if (Setup.isPrintHeadersEnabled() && Setup.isPrintHeaderLine3Enabled() || !Setup.getManifestFormat().equals(Setup.STANDARD_FORMAT)) {
            this.printHorizontalLine(file, isManifest);
        }
    }

    public void printHorizontalLine(PrintWriter file, boolean isManifest) {
        this.printHorizontalLine(file, 0, TrainCommon.getLineLength(isManifest));
    }

    public void printHorizontalLine(PrintWriter file, int start, int end) {
        StringBuffer sb = new StringBuffer();
        while (start-- > 0) {
            sb.append(" ");
        }
        while (end-- > 0) {
            sb.append('-');
        }
        this.addLine(file, sb.toString());
    }

    public static String getISO8601Date(boolean isModelYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(InstanceManager.getDefault(Timebase.class).getTime());
        if (isModelYear && !Setup.getYearModeled().isEmpty()) {
            try {
                calendar.set(1, Integer.parseInt(Setup.getYearModeled().trim()));
            }
            catch (NumberFormatException e) {
                return Setup.getYearModeled();
            }
        }
        return new StdDateFormat().format(calendar.getTime());
    }

    public static String getDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("M/dd/yyyy HH:mm");
        if (Setup.is12hrFormatEnabled()) {
            format = new SimpleDateFormat("M/dd/yyyy hh:mm a");
        }
        return format.format(date);
    }

    public static String getDate(boolean isModelYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(InstanceManager.getDefault(Timebase.class).getTime());
        if (isModelYear && !Setup.getYearModeled().equals("")) {
            try {
                calendar.set(1, Integer.parseInt(Setup.getYearModeled().trim()));
            }
            catch (NumberFormatException e) {
                return Setup.getYearModeled();
            }
        }
        return TrainCommon.getDate(calendar.getTime());
    }

    public static Date convertStringToDate(String date) {
        if (!date.isBlank()) {
            try {
                SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                return formatter.parse(date);
            }
            catch (ParseException pe1) {
                try {
                    SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy hh:mmaa");
                    return formatter.parse(date);
                }
                catch (ParseException pe2) {
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm");
                        return formatter.parse(date);
                    }
                    catch (ParseException pe3) {
                        log.debug("Not able to parse date: {}", (Object)date);
                    }
                }
            }
        }
        return null;
    }

    protected int convertStringTime(String time) {
        String[] splitTime;
        int minutes = 0;
        boolean hrFormat = false;
        String[] splitTimePM = time.split(" ");
        if (splitTimePM.length > 1) {
            hrFormat = true;
            if (splitTimePM[1].equals(Bundle.getMessage("PM"))) {
                minutes = 720;
            }
        }
        if ((splitTime = splitTimePM[0].split(":")).length > 2) {
            if (hrFormat && splitTime[1].equals("12")) {
                splitTime[1] = "00";
            }
            minutes += 1440 * Integer.parseInt(splitTime[0]);
            minutes += 60 * Integer.parseInt(splitTime[1]);
            minutes += Integer.parseInt(splitTime[2]);
        } else {
            if (hrFormat && splitTime[0].equals("12")) {
                splitTime[0] = "00";
            }
            minutes += 60 * Integer.parseInt(splitTime[0]);
            minutes += Integer.parseInt(splitTime[1]);
        }
        log.debug("convert time {} to minutes {}", (Object)time, (Object)minutes);
        return minutes;
    }

    public static String padAndTruncateIfNeeded(String s, int fieldSize) {
        if (Setup.isTabEnabled()) {
            return TrainCommon.padAndTruncate(s, fieldSize);
        }
        return s;
    }

    public static String padAndTruncate(String s, int fieldSize) {
        if ((s = TrainCommon.padString(s, fieldSize)).length() > fieldSize) {
            s = s.substring(0, fieldSize);
        }
        return s;
    }

    public static String padString(String s, int fieldSize) {
        StringBuffer buf = new StringBuffer(s);
        while (buf.length() < fieldSize) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static String createTabIfNeeded(int tabSize) {
        if (Setup.isTabEnabled()) {
            return TrainCommon.tabString("", tabSize);
        }
        return "";
    }

    protected static String tabString(String s, int tabSize) {
        StringBuffer buf = new StringBuffer();
        while (buf.length() < tabSize) {
            buf.append(" ");
        }
        buf.append(s);
        return buf.toString();
    }

    public static int getLineLength(boolean isManifest) {
        return TrainCommon.getLineLength(isManifest ? Setup.getManifestOrientation() : Setup.getSwitchListOrientation(), Setup.getFontName(), 0, Setup.getManifestFontSize());
    }

    public static int getManifestHeaderLineLength() {
        return TrainCommon.getLineLength(Setup.getManifestOrientation(), "SansSerif", 2, Setup.getManifestFontSize());
    }

    private static int getLineLength(String orientation, String fontName, int fontStyle, int fontSize) {
        int charLength;
        JLabel label = new JLabel();
        Font font = new Font(fontName, fontStyle, fontSize);
        FontMetrics metrics = label.getFontMetrics(font);
        int charwidth = metrics.charWidth('m');
        if (charwidth == 0) {
            log.error("Line length charater width equal to zero. font size: {}, fontName: {}", (Object)fontSize, (Object)fontName);
            charwidth = fontSize / 2;
        }
        if ((charLength = TrainCommon.getPageSize((String)orientation).width / charwidth) % 2 != 0) {
            --charLength;
        }
        return charLength;
    }

    private boolean checkStringLength(String string, boolean isManifest) {
        return this.checkStringLength(string, isManifest ? Setup.getManifestOrientation() : Setup.getSwitchListOrientation(), Setup.getFontName(), Setup.getManifestFontSize());
    }

    private boolean checkStringLength(String string, String orientation, String fontName, int fontSize) {
        Font font;
        JLabel label;
        FontMetrics metrics;
        int stringWidth;
        if (string.startsWith(TEXT_COLOR_START) && string.contains(TEXT_COLOR_DONE)) {
            string = string.substring(string.indexOf(TEXT_COLOR_DONE) + 2);
        }
        if (string.contains(TEXT_COLOR_END)) {
            string = string.substring(0, string.indexOf(TEXT_COLOR_END));
        }
        return (stringWidth = (metrics = (label = new JLabel()).getFontMetrics(font = new Font(fontName, 0, fontSize))).stringWidth(string)) <= TrainCommon.getPageSize((String)orientation).width;
    }

    protected static Dimension getPageSize(String orientation) {
        Dimension pagesize = new Dimension(523, 720);
        if (orientation.equals(Setup.LANDSCAPE)) {
            pagesize = new Dimension(702, 523);
        }
        if (orientation.equals(Setup.HALFPAGE)) {
            pagesize = new Dimension(261, 720);
        }
        if (orientation.equals(Setup.HANDHELD)) {
            pagesize = new Dimension(206, 720);
        }
        return pagesize;
    }

    public static String formatStringToCommaSeparated(String[] array) {
        StringBuffer sbuf = new StringBuffer("");
        for (String s : array) {
            if (s == null) continue;
            sbuf = sbuf.append(s + ", ");
        }
        if (sbuf.length() > 2) {
            sbuf.setLength(sbuf.length() - 2);
        }
        return sbuf.toString();
    }

    private void addLine(PrintWriter file, StringBuffer buf, Color color) {
        String s = buf.toString();
        if (!s.isBlank()) {
            this.addLine(file, TrainCommon.formatColorString(s, color));
        }
    }

    public static String formatColorString(String text, Color color) {
        Object s = text;
        if (!color.equals(Color.black)) {
            s = TEXT_COLOR_START + ColorUtil.colorToColorName(color) + TEXT_COLOR_DONE + text + TEXT_COLOR_END;
        }
        return s;
    }

    public static String getTextColorString(String string) {
        Object text = string;
        if (string.contains(TEXT_COLOR_START)) {
            text = string.substring(0, string.indexOf(TEXT_COLOR_START)) + string.substring(string.indexOf(TEXT_COLOR_DONE) + 2);
        }
        if (((String)text).contains(TEXT_COLOR_END)) {
            text = ((String)text).substring(0, ((String)text).indexOf(TEXT_COLOR_END)) + string.substring(string.indexOf(TEXT_COLOR_END) + TEXT_COLOR_END.length());
        }
        return text;
    }

    public static Color getTextColor(String string) {
        Color color = Color.black;
        if (string.contains(TEXT_COLOR_START)) {
            String c = string.substring(string.indexOf(TEXT_COLOR_START) + TEXT_COLOR_START.length());
            c = c.substring(0, c.indexOf("\""));
            color = ColorUtil.stringToColor(c);
        }
        return color;
    }

    public static String getTextColorName(String string) {
        return ColorUtil.colorToColorName(TrainCommon.getTextColor(string));
    }
}

