/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import jmri.Application;
import jmri.BooleanPermission;
import jmri.InstanceManager;
import jmri.Permission;
import jmri.PermissionFactory;
import jmri.PermissionManager;
import jmri.PermissionOwner;
import jmri.PermissionValue;
import jmri.PermissionsSystemAdmin;
import jmri.Role;
import jmri.User;
import jmri.jmrit.XmlFile;
import jmri.jmrit.permission.Bundle;
import jmri.jmrit.permission.DefaultRole;
import jmri.jmrit.permission.DefaultUser;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPermissionManager
implements PermissionManager {
    private static final DefaultUser USER_GUEST = new DefaultUser(Bundle.getMessage("PermissionManager_User_Guest").toLowerCase(), null, 50, "GUEST", new Role[]{DefaultRole.ROLE_GUEST});
    private static final DefaultUser REMOTE_USER_GUEST = new DefaultUser(Bundle.getMessage("PermissionManager_Remote_User_Guest"), null, 50, "REMOTE_GUEST", new Role[]{DefaultRole.ROLE_REMOTE_GUEST});
    private static final DefaultUser USER_ADMIN = new DefaultUser(Bundle.getMessage("PermissionManager_User_Admin").toLowerCase(), "jmri", 100, "ADMIN", new Role[]{DefaultRole.ROLE_ADMIN, DefaultRole.ROLE_STANDARD_USER});
    private final Map<String, DefaultRole> _roles = new HashMap<String, DefaultRole>();
    private final Map<String, DefaultUser> _users = new HashMap<String, DefaultUser>();
    private final Set<PermissionOwner> _owners = new HashSet<PermissionOwner>();
    private final Set<Permission> _permissions = new HashSet<Permission>();
    private final Map<String, Permission> _permissionClassNames = new HashMap<String, Permission>();
    private final List<PermissionManager.LoginListener> _loginListeners = new ArrayList<PermissionManager.LoginListener>();
    private final Map<String, DefaultUser> _remoteUsers = new HashMap<String, DefaultUser>();
    private boolean _permissionsEnabled = false;
    private boolean _allowEmptyPasswords = false;
    private User _currentUser = USER_GUEST;
    private static final Logger log = LoggerFactory.getLogger(DefaultPermissionManager.class);

    DefaultPermissionManager() {
    }

    DefaultPermissionManager(DefaultPermissionManager source) {
        this._permissionsEnabled = source._permissionsEnabled;
        this._allowEmptyPasswords = source._allowEmptyPasswords;
        this._owners.addAll(source._owners);
        this._permissions.addAll(source._permissions);
        this._permissionClassNames.putAll(source._permissionClassNames);
        for (Map.Entry<String, DefaultRole> entry : source._roles.entrySet()) {
            this._roles.put(entry.getKey(), new DefaultRole(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : source._users.entrySet()) {
            this._users.put(entry.getKey(), new DefaultUser((DefaultUser)entry.getValue()));
        }
    }

    public DefaultPermissionManager getTemporaryInstance() {
        return new DefaultPermissionManager(this);
    }

    synchronized DefaultPermissionManager init() {
        this._roles.put(DefaultRole.ROLE_GUEST.getName(), DefaultRole.ROLE_GUEST);
        this._roles.put(DefaultRole.ROLE_REMOTE_GUEST.getName(), DefaultRole.ROLE_REMOTE_GUEST);
        this._roles.put(DefaultRole.ROLE_STANDARD_USER.getName(), DefaultRole.ROLE_STANDARD_USER);
        this._roles.put(DefaultRole.ROLE_ADMIN.getName(), DefaultRole.ROLE_ADMIN);
        this._users.put(USER_GUEST.getUserName(), USER_GUEST);
        this._users.put(REMOTE_USER_GUEST.getUserName(), REMOTE_USER_GUEST);
        this._users.put(USER_ADMIN.getUserName(), USER_ADMIN);
        for (PermissionFactory factory : ServiceLoader.load(PermissionFactory.class)) {
            factory.register(this);
        }
        this.loadPermissionSettings();
        ThreadingUtil.runOnGUIEventually(() -> this.checkThatAllRolesKnowsAllPermissions());
        return this;
    }

    public synchronized Collection<Role> getRoles() {
        return Collections.unmodifiableSet(new HashSet<DefaultRole>(this._roles.values()));
    }

    public synchronized Collection<DefaultUser> getUsers() {
        return Collections.unmodifiableSet(new HashSet<DefaultUser>(this._users.values()));
    }

    public synchronized Set<PermissionOwner> getOwners() {
        return Collections.unmodifiableSet(new HashSet<PermissionOwner>(this._owners));
    }

    public synchronized Set<Permission> getPermissions(PermissionOwner owner) {
        HashSet<Permission> set = new HashSet<Permission>();
        for (Permission p : this._permissions) {
            if (!p.getOwner().equals(owner)) continue;
            set.add(p);
        }
        return Collections.unmodifiableSet(set);
    }

    private DefaultRole getSystemRole(String systemName) {
        for (DefaultRole role : this._roles.values()) {
            if (!role.isSystemRole() || !role.getSystemName().equals(systemName)) continue;
            return role;
        }
        return null;
    }

    private DefaultUser getSystemUser(String systemUsername) {
        for (User user : this._users.values()) {
            DefaultUser du = (DefaultUser)user;
            if (!du.isSystemUser() || !du.getSystemUsername().equals(systemUsername)) continue;
            return du;
        }
        return null;
    }

    private void loadPermissionSettings() {
        File file = new File(FileUtil.getPreferencesPath() + ".permissions.xml");
        log.info("Permission file: {}", (Object)file.getAbsolutePath());
        if (file.exists() && file.length() != 0L) {
            try {
                Element root = new XmlFile().rootFromFile(file);
                Element settings = root.getChild("Settings");
                this._permissionsEnabled = "yes".equals(settings.getChild("Enabled").getValue());
                this._allowEmptyPasswords = "yes".equals(settings.getChild("AllowEmptyPasswords").getValue());
                log.info("Permission system is enabled: {}", (Object)(this._permissionsEnabled ? "yes" : "no"));
                List roleElementList = root.getChild("Roles").getChildren("Role");
                for (Element roleElement : roleElementList) {
                    DefaultRole role;
                    Element systemNameElement = roleElement.getChild("SystemName");
                    if (systemNameElement != null) {
                        role = this.getSystemRole(systemNameElement.getValue());
                        if (role == null) {
                            log.error("SystemRole {} is not found.", (Object)systemNameElement.getValue());
                            continue;
                        }
                    } else {
                        role = new DefaultRole(roleElement.getChild("Name").getValue());
                        this._roles.put(role.getName(), role);
                    }
                    List permissionElementList = roleElement.getChild("Permissions").getChildren("Permission");
                    for (Element permissionElement : permissionElementList) {
                        String className = permissionElement.getChild("Class").getValue();
                        Permission permission = this._permissionClassNames.get(className);
                        if (permission != null) {
                            PermissionValue value = permission.valueOf(permissionElement.getChild("Enabled").getValue());
                            role.setPermissionWithoutCheck(permission, value);
                            continue;
                        }
                        log.error("Permission class {} does not exists", (Object)className);
                    }
                }
                List userElementList = root.getChild("Users").getChildren("User");
                for (Element userElement : userElementList) {
                    DefaultUser user;
                    Element systemNameElement = userElement.getChild("SystemUsername");
                    if (systemNameElement != null) {
                        user = this.getSystemUser(systemNameElement.getValue());
                        if (user == null) {
                            log.error("SystemUser {} is not found.", (Object)systemNameElement.getValue());
                            continue;
                        }
                        Element passwordElement = userElement.getChild("Password");
                        if (passwordElement != null) {
                            user.setPasswordMD5(passwordElement.getValue());
                            user.setSeed(userElement.getChild("Seed").getValue());
                        }
                    } else {
                        user = new DefaultUser(userElement.getChild("Username").getValue(), userElement.getChild("Password").getValue(), userElement.getChild("Seed").getValue());
                        this._users.put(user.getUserName(), user);
                    }
                    user.setName(userElement.getChild("Name").getValue());
                    user.setComment(userElement.getChild("Comment").getValue());
                    HashSet<Role> roles = new HashSet<Role>();
                    List userRoleElementList = userElement.getChild("Roles").getChildren("Role");
                    for (Element roleElement : userRoleElementList) {
                        Role role;
                        Element roleSystemNameElement = roleElement.getChild("SystemName");
                        if (roleSystemNameElement != null) {
                            role = this.getSystemRole(roleSystemNameElement.getValue());
                            if (role == null) {
                                log.error("SystemRole {} is not found.", (Object)roleSystemNameElement.getValue());
                                continue;
                            }
                        } else {
                            role = this._roles.get(roleElement.getChild("Name").getValue());
                            if (role == null) {
                                log.error("UserRole {} is not found.", (Object)roleElement.getValue());
                                continue;
                            }
                        }
                        roles.add(role);
                    }
                    user.setRoles(roles);
                }
            }
            catch (IOException | JDOMException ex) {
                log.error("Exception during loading of permissions", ex);
            }
        } else {
            log.info("Permission file not found or empty");
        }
    }

    @Override
    public synchronized void storePermissionSettings() {
        File file = new File(FileUtil.getPreferencesPath() + ".permissions.xml");
        try {
            Element rootElement = new Element("Permissions");
            Element settings = new Element("Settings");
            settings.addContent((Content)new Element("Enabled").addContent(this._permissionsEnabled ? "yes" : "no"));
            settings.addContent((Content)new Element("AllowEmptyPasswords").addContent(this._allowEmptyPasswords ? "yes" : "no"));
            rootElement.addContent((Content)settings);
            this.checkThatAllRolesKnowsAllPermissions();
            Element rolesElement = new Element("Roles");
            for (Role role : this._roles.values()) {
                Element roleElement = new Element("Role");
                if (role.isSystemRole()) {
                    roleElement.addContent((Content)new Element("SystemName").addContent(role.getSystemName()));
                }
                roleElement.addContent((Content)new Element("Name").addContent(role.getName()));
                Element rolePermissions = new Element("Permissions");
                for (Map.Entry<Permission, PermissionValue> entry : role.getPermissions().entrySet()) {
                    Permission permission = entry.getKey();
                    PermissionValue permissionValue = entry.getValue();
                    Element userPermission = new Element("Permission");
                    userPermission.addContent((Content)new Element("Class").addContent(entry.getKey().getClass().getName()));
                    userPermission.addContent((Content)new Element("Enabled").addContent(permission.getValue(permissionValue)));
                    rolePermissions.addContent((Content)userPermission);
                }
                roleElement.addContent((Content)rolePermissions);
                rolesElement.addContent((Content)roleElement);
            }
            rootElement.addContent((Content)rolesElement);
            Element usersElement = new Element("Users");
            for (DefaultUser user : this._users.values()) {
                Element userElement = new Element("User");
                if (user.isSystemUser()) {
                    userElement.addContent((Content)new Element("SystemUsername").addContent(user.getSystemUsername()));
                }
                userElement.addContent((Content)new Element("Username").addContent(user.getUserName()));
                if (user.getPassword() != null) {
                    userElement.addContent((Content)new Element("Password").addContent(user.getPassword()));
                    userElement.addContent((Content)new Element("Seed").addContent(user.getSeed()));
                }
                userElement.addContent((Content)new Element("Name").addContent(user.getName()));
                userElement.addContent((Content)new Element("Comment").addContent(user.getComment()));
                Element userRolesElement = new Element("Roles");
                for (Role role : user.getRoles()) {
                    Element roleElement = new Element("Role");
                    if (role.isSystemRole()) {
                        roleElement.addContent((Content)new Element("SystemName").addContent(role.getSystemName()));
                    }
                    roleElement.addContent((Content)new Element("Name").addContent(role.getName()));
                    userRolesElement.addContent((Content)roleElement);
                }
                userElement.addContent((Content)userRolesElement);
                usersElement.addContent((Content)userElement);
            }
            rootElement.addContent((Content)usersElement);
            Document document = XmlFile.newDocument(rootElement);
            new XmlFile().writeXML(file, document);
        }
        catch (FileNotFoundException ex3) {
            log.error("FileNotFound error writing file: {}", (Object)file);
        }
        catch (IOException ex2) {
            log.error("IO error writing file: {}", (Object)file);
        }
    }

    @Override
    public synchronized Role addRole(String name) throws PermissionManager.RoleAlreadyExistsException {
        if (this._users.containsKey(name)) {
            throw new PermissionManager.RoleAlreadyExistsException();
        }
        DefaultRole role = new DefaultRole(name);
        this._roles.put(name, role);
        return role;
    }

    @Override
    public synchronized void removeRole(String name) throws PermissionManager.RoleDoesNotExistException {
        if (!this._roles.containsKey(name)) {
            throw new PermissionManager.RoleDoesNotExistException();
        }
        this._roles.remove(name);
    }

    @Override
    public synchronized User addUser(String username, String password) throws PermissionManager.UserAlreadyExistsException {
        String u = username.toLowerCase();
        if (this._users.containsKey(u)) {
            throw new PermissionManager.UserAlreadyExistsException();
        }
        DefaultUser user = new DefaultUser(u, password);
        this._users.put(u, user);
        return user;
    }

    @Override
    public synchronized void removeUser(String username) throws PermissionManager.UserDoesNotExistException {
        if (!this._users.containsKey(username)) {
            throw new PermissionManager.UserDoesNotExistException();
        }
        this._users.remove(username);
    }

    @Override
    public synchronized void changePassword(String newPassword, String oldPassword) {
        if (this._currentUser.changePassword(newPassword, oldPassword)) {
            this.storePermissionSettings();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="The text is from an exception")
    public boolean login(String username, String password) {
        DefaultPermissionManager defaultPermissionManager = this;
        synchronized (defaultPermissionManager) {
            DefaultUser newUser = this._users.get(username);
            if (newUser == null || !newUser.checkPassword(password)) {
                String msg = new PermissionManager.BadUserOrPasswordException().getMessage();
                if (!GraphicsEnvironment.isHeadless()) {
                    JmriJOptionPane.showMessageDialog(null, msg, Application.getApplicationName(), 0);
                } else {
                    log.error(msg);
                }
                return false;
            }
            this._currentUser = newUser;
        }
        this.notifyLoginListeners(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remoteLogin(StringBuilder sessionId, Locale locale, String username, String password) {
        DefaultPermissionManager defaultPermissionManager = this;
        synchronized (defaultPermissionManager) {
            DefaultUser newUser = this._users.get(username);
            if (newUser == null || !newUser.checkPassword(password)) {
                return false;
            }
            if (sessionId.length() == 0) {
                sessionId.append(DefaultUser.getRandomString(10));
            }
            this._remoteUsers.put(sessionId.toString(), newUser);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout() {
        DefaultPermissionManager defaultPermissionManager = this;
        synchronized (defaultPermissionManager) {
            this._currentUser = USER_GUEST;
        }
        this.notifyLoginListeners(false);
    }

    @Override
    public synchronized void remoteLogout(String sessionId) {
        if (sessionId == null || sessionId.isBlank() || !this._remoteUsers.containsKey(sessionId)) {
            return;
        }
        this._remoteUsers.remove(sessionId);
    }

    private void notifyLoginListeners(boolean isLogin) {
        for (PermissionManager.LoginListener listener : this._loginListeners) {
            listener.loginLogout(isLogin);
        }
    }

    @Override
    public synchronized boolean isLoggedIn() {
        return this._currentUser != USER_GUEST;
    }

    @Override
    public synchronized boolean isRemotelyLoggedIn(String sessionId) {
        return sessionId != null && !sessionId.isBlank() && this._remoteUsers.containsKey(sessionId);
    }

    @Override
    public synchronized boolean isCurrentUser(String username) {
        return this._currentUser.getUserName().equals(username);
    }

    @Override
    public synchronized boolean isCurrentUser(User user) {
        return this._currentUser == user;
    }

    @Override
    public synchronized String getCurrentUserName() {
        return this._currentUser != null ? this._currentUser.getUserName() : null;
    }

    @Override
    public synchronized boolean isAGuestUser(String username) {
        DefaultUser user = this._users.get(username);
        if (user != null) {
            String systemUsername = user.getSystemUsername();
            return USER_GUEST.getSystemUsername().equals(systemUsername) || REMOTE_USER_GUEST.getSystemUsername().equals(systemUsername);
        }
        return false;
    }

    @Override
    public synchronized boolean isAGuestUser(User user) {
        if (user instanceof DefaultUser) {
            String systemUsername = ((DefaultUser)user).getSystemUsername();
            return USER_GUEST.getSystemUsername().equals(systemUsername) || REMOTE_USER_GUEST.getSystemUsername().equals(systemUsername);
        }
        return false;
    }

    @Override
    public synchronized boolean isCurrentUserPermittedToChangePassword() {
        return this._currentUser != null && this._currentUser.isPermittedToChangePassword();
    }

    @Override
    public synchronized void addLoginListener(PermissionManager.LoginListener listener) {
        this._loginListeners.add(listener);
    }

    @Override
    public synchronized boolean isEnabled() {
        return this._permissionsEnabled;
    }

    @Override
    public synchronized void setEnabled(boolean enabled) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PREFERENCES, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        this._permissionsEnabled = enabled;
    }

    @Override
    public synchronized boolean isAllowEmptyPasswords() {
        return this._allowEmptyPasswords;
    }

    @Override
    public synchronized void setAllowEmptyPasswords(boolean value) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PREFERENCES, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        this._allowEmptyPasswords = value;
    }

    @Override
    public synchronized boolean hasAtLeastPermission(Permission permission, PermissionValue minValue) {
        return !this._permissionsEnabled || this._currentUser.hasAtLeastPermission(permission, minValue);
    }

    @Override
    public synchronized boolean hasAtLeastRemotePermission(String sessionId, Permission permission, PermissionValue minValue) {
        if (!this._permissionsEnabled) {
            return true;
        }
        DefaultUser user = REMOTE_USER_GUEST;
        if (sessionId != null && !sessionId.isBlank() && this._remoteUsers.containsKey(sessionId)) {
            user = this._remoteUsers.get(sessionId);
        }
        return user.hasAtLeastPermission(permission, minValue);
    }

    @Override
    public synchronized boolean ensureAtLeastPermission(Permission permission, PermissionValue minValue) {
        return !this._permissionsEnabled || this._currentUser.ensureAtLeastPermission(permission, minValue);
    }

    @Override
    public synchronized void registerOwner(PermissionOwner owner) {
        this._owners.add(owner);
    }

    @Override
    public synchronized void registerPermission(Permission permission) {
        if (!this._owners.contains(permission.getOwner())) {
            throw new RuntimeException(String.format("Permission class %s has an owner that's not known: %s", permission.getClass().getName(), permission.getOwner()));
        }
        this._permissions.add(permission);
        this._permissionClassNames.put(permission.getClass().getName(), permission);
    }

    private void checkThatAllRolesKnowsAllPermissions() {
        for (Role role : this._roles.values()) {
            for (Permission p : this._permissions) {
                if (role.getPermissions().containsKey(p)) continue;
                ((DefaultRole)role).setPermissionWithoutCheck(p, p.getDefaultPermission(role));
            }
        }
    }
}

