/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.PrimitiveIterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.DatatypeConverter;
import jmri.Application;
import jmri.BooleanPermission;
import jmri.InstanceManager;
import jmri.Permission;
import jmri.PermissionManager;
import jmri.PermissionValue;
import jmri.PermissionsSystemAdmin;
import jmri.Role;
import jmri.User;
import jmri.jmrit.permission.Bundle;
import jmri.jmrit.permission.DefaultRole;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"DMI_RANDOM_USED_ONLY_ONCE"}, justification="False positive. The Random instance is kept by the iterator.")
public class DefaultUser
implements User {
    private final String _username;
    private final String _systemUserName;
    private final boolean _systemUser;
    private final int _priority;
    private String _seed;
    private String _passwordMD5;
    private String _name = "";
    private String _comment = "";
    private final Set<Role> _roles = new TreeSet<Role>((a, b) -> a.getName().compareTo(b.getName()));
    private static final PrimitiveIterator.OfInt iterator = new Random().ints(97, 132).iterator();
    private static final Logger log = LoggerFactory.getLogger(DefaultUser.class);

    public DefaultUser(String username, String password) {
        this(username, password, 0, null, new Role[0]);
        this.addRole(DefaultRole.ROLE_STANDARD_USER);
    }

    DefaultUser(DefaultUser u) {
        this._username = u._username;
        this._systemUserName = u._systemUserName;
        this._systemUser = u._systemUser;
        this._priority = u._priority;
        this._seed = u._seed;
        this._passwordMD5 = u._passwordMD5;
        this._name = u._name;
        this._comment = u._comment;
        this._roles.addAll(u._roles);
    }

    DefaultUser(String username, String password, int priority, String systemUserName, Role[] roles) {
        this._username = username;
        this._priority = priority;
        this._systemUser = priority != 0;
        this._systemUserName = systemUserName;
        if (password != null) {
            this._seed = DefaultUser.getRandomString(10);
            try {
                this._passwordMD5 = this.getPasswordSHA256(password);
            }
            catch (NoSuchAlgorithmException e) {
                log.error("MD5 algoritm doesn't exists", (Throwable)e);
            }
        } else {
            this._seed = null;
        }
        for (Role role : roles) {
            this._roles.add(role);
        }
    }

    public DefaultUser(String username, String passwordMD5, String seed) {
        this._username = username;
        this._systemUserName = null;
        this._systemUser = false;
        this._priority = 0;
        this._passwordMD5 = passwordMD5;
        this._seed = seed;
    }

    public static String getRandomString(int count) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            int r = iterator.nextInt();
            char c = (char)(r > 122 ? r - 122 + 48 : r);
            s.append(c);
        }
        return s.toString();
    }

    @Override
    public String getUserName() {
        return this._username;
    }

    @Override
    public boolean isSystemUser() {
        return this._systemUser;
    }

    @Override
    public int getPriority() {
        return this._priority;
    }

    String getSystemUsername() {
        return this._systemUserName;
    }

    String getPassword() {
        return this._passwordMD5;
    }

    void setPasswordMD5(String passwordMD5) {
        this._passwordMD5 = passwordMD5;
    }

    String getSeed() {
        return this._seed;
    }

    void setSeed(String seed) {
        this._seed = seed;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public String getComment() {
        return this._comment;
    }

    @Override
    public void setComment(String comment) {
        this._comment = comment;
    }

    @Override
    public Set<Role> getRoles() {
        return Collections.unmodifiableSet(this._roles);
    }

    @Override
    public void addRole(Role role) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PREFERENCES, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        this._roles.add(role);
    }

    @Override
    public void removeRole(Role role) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PREFERENCES, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        this._roles.remove(role);
    }

    void setRoles(Set<Role> roles) {
        this._roles.clear();
        this._roles.addAll(roles);
    }

    private String getPasswordSHA256(String password) throws NoSuchAlgorithmException {
        String passwd = this._seed + password;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(passwd.getBytes());
        return DatatypeConverter.printHexBinary((byte[])md.digest()).toUpperCase();
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="The text is from an exception")
    public void setPassword(String newPassword) {
        PermissionManager pMngr = InstanceManager.getDefault(PermissionManager.class);
        if (!pMngr.hasAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PERMISSIONS, BooleanPermission.BooleanValue.TRUE)) {
            log.warn("The current user has not permission to change password for user {}", (Object)this.getUserName());
            if (!GraphicsEnvironment.isHeadless()) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("DefaultPermissionManager_PermissionDenied"), Application.getApplicationName(), 0);
            }
        }
        try {
            this._passwordMD5 = this.getPasswordSHA256(newPassword);
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "MD5 algoritm doesn't exists";
            log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public boolean isPermittedToChangePassword() {
        PermissionManager pMngr = InstanceManager.getDefault(PermissionManager.class);
        boolean isCurrentUser = pMngr.isCurrentUser(this);
        boolean hasEditPasswordPermission = pMngr.hasAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_OWN_PASSWORD, BooleanPermission.BooleanValue.TRUE);
        boolean hasAdminPermission = pMngr.hasAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PERMISSIONS, BooleanPermission.BooleanValue.TRUE);
        return hasAdminPermission || isCurrentUser && hasEditPasswordPermission;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="The text is from an exception")
    public boolean changePassword(String oldPassword, String newPassword) {
        PermissionManager pMngr = InstanceManager.getDefault(PermissionManager.class);
        if (this.isPermittedToChangePassword()) {
            if (!this.checkPassword(oldPassword)) {
                String msg = new PermissionManager.BadPasswordException().getMessage();
                if (!GraphicsEnvironment.isHeadless()) {
                    JmriJOptionPane.showMessageDialog(null, msg, Application.getApplicationName(), 0);
                    return false;
                }
                log.error(msg);
                return false;
            }
            try {
                this._passwordMD5 = this.getPasswordSHA256(newPassword);
                return true;
            }
            catch (NoSuchAlgorithmException e) {
                String msg = "MD5 algoritm doesn't exists";
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        if (pMngr.isCurrentUser(this)) {
            log.warn("User {} has not permission to change its own password", (Object)this.getUserName());
        } else {
            log.warn("The current user has not permission to change password for user {}", (Object)this.getUserName());
        }
        if (GraphicsEnvironment.isHeadless()) return false;
        JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("DefaultPermissionManager_PermissionDenied"), Application.getApplicationName(), 0);
        return false;
    }

    public boolean checkPassword(String password) {
        try {
            return this._passwordMD5.equals(this.getPasswordSHA256(password));
        }
        catch (NoSuchAlgorithmException e) {
            String msg = "MD5 algoritm doesn't exists";
            log.error(msg);
            throw new RuntimeException(msg);
        }
    }

    @Override
    public boolean hasAtLeastPermission(Permission permission, PermissionValue minValue) {
        PermissionValue value;
        PermissionValue lastValue = null;
        for (Role role : this._roles) {
            value = role.getPermissionValue(permission);
            if (lastValue != null && permission.compare(lastValue, value) >= 0) continue;
            lastValue = value;
        }
        if (lastValue == null || lastValue.isDefault()) {
            for (Role role : this._roles) {
                value = permission.getDefaultPermission(role);
                if (lastValue != null && permission.compare(lastValue, value) >= 0) continue;
                lastValue = value;
            }
        }
        if (lastValue == null || lastValue.isDefault()) {
            lastValue = permission.getDefaultPermission();
        }
        return permission.compare(minValue, lastValue) <= 0;
    }

    @Override
    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="The text is from a bundle")
    public boolean ensureAtLeastPermission(Permission permission, PermissionValue minValue) {
        if (!this.hasAtLeastPermission(permission, minValue)) {
            log.warn("User {} has not permission {}", (Object)this.getUserName(), (Object)permission.getName());
            if (!GraphicsEnvironment.isHeadless()) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("DefaultPermissionManager_PermissionDenied"), Application.getApplicationName(), 0);
            }
            return false;
        }
        return true;
    }
}

