/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jmri.Application;
import jmri.PermissionManager;
import jmri.User;
import jmri.jmrit.permission.swing.Bundle;
import jmri.util.swing.JmriJOptionPane;

public class AddUserDialog
extends JDialog {
    private final PermissionManager _mngr;
    private final UserAdded _userAdded;
    private final JTextField _usernameTextField;
    private final JPasswordField _passwordTextField;
    private final JPasswordField _secondPasswordTextField;
    private final JTextField _nameTextField;
    private final JTextField _commentTextField;

    public AddUserDialog(PermissionManager mngr, Frame owner, UserAdded userAdded) {
        super(owner, Bundle.getMessage("AddUserDialog_AddUserTitle"), true);
        this._mngr = mngr;
        this._userAdded = userAdded;
        JPanel contentPanel = new JPanel();
        this.rootPane.getContentPane().add(contentPanel);
        JPanel p = contentPanel;
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_UserName")), c);
        c.gridy = 1;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_Password")), c);
        c.gridy = 2;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_PasswordAgain")), c);
        c.gridy = 3;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_Name")), c);
        c.gridy = 4;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_Comment")), c);
        c.gridx = 1;
        c.gridy = 0;
        contentPanel.add(Box.createHorizontalStrut(5), c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        this._usernameTextField = new JTextField(20);
        contentPanel.add((Component)this._usernameTextField, c);
        c.gridy = 1;
        this._passwordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._passwordTextField, c);
        c.gridy = 2;
        this._secondPasswordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._secondPasswordTextField, c);
        c.gridy = 3;
        this._nameTextField = new JTextField(40);
        contentPanel.add((Component)this._nameTextField, c);
        c.gridy = 4;
        this._commentTextField = new JTextField(40);
        contentPanel.add((Component)this._commentTextField, c);
        JPanel buttonPanel = new JPanel();
        JButton buttonCancel = new JButton(Bundle.getMessage("ButtonCancel"));
        buttonPanel.add(buttonCancel);
        buttonCancel.addActionListener(e -> this.dispose());
        JButton buttonOK = new JButton(Bundle.getMessage("ButtonOK"));
        buttonPanel.add(buttonOK);
        buttonOK.addActionListener(e -> {
            if (this.okPressed()) {
                this.dispose();
            }
        });
        buttonOK.setToolTipText(Bundle.getMessage("AddUserDialogOkHint"));
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.anchor = 10;
        contentPanel.add((Component)buttonPanel, c);
        this.setLocationRelativeTo(owner);
        this.pack();
    }

    private boolean okPressed() {
        String username = this._usernameTextField.getText();
        String passwd1 = new String(this._passwordTextField.getPassword());
        String passwd2 = new String(this._secondPasswordTextField.getPassword());
        String name = this._nameTextField.getText();
        String comment = this._commentTextField.getText();
        if (username.isBlank()) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_UsernameEmpty"), Application.getApplicationName(), 0);
            return false;
        }
        if (!username.equals(username.trim())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_SpaceNotAllowedInUsername"), Application.getApplicationName(), 0);
            return false;
        }
        if (passwd1.isBlank() && !this._mngr.isAllowEmptyPasswords()) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_PasswordEmpty"), Application.getApplicationName(), 0);
            return false;
        }
        if (!passwd1.equals(passwd1.trim())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_SpaceNotAllowedInPassword"), Application.getApplicationName(), 0);
            return false;
        }
        if (!passwd1.equals(passwd2)) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_PasswordsAreNotEqual"), Application.getApplicationName(), 0);
            return false;
        }
        try {
            User user = this._mngr.addUser(this._usernameTextField.getText(), passwd1);
            user.setName(name);
            user.setComment(comment);
            this._userAdded.userAdded(user);
            return true;
        }
        catch (PermissionManager.UserAlreadyExistsException e) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_UsernameExists", username.toLowerCase()), Application.getApplicationName(), 0);
            return false;
        }
    }

    public static interface UserAdded {
        public void userAdded(User var1);
    }
}

