/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission.swing;

import java.awt.event.ActionEvent;
import javax.swing.Icon;
import jmri.BooleanPermission;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.PermissionsSystemAdmin;
import jmri.jmrit.permission.swing.Bundle;
import jmri.jmrit.permission.swing.ChangePasswordDialog;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;

public class ChangePasswordAction
extends JmriAbstractAction {
    public ChangePasswordAction(String s, WindowInterface wi) {
        super(s, wi);
        this.checkPermission();
    }

    public ChangePasswordAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
        this.checkPermission();
    }

    public ChangePasswordAction() {
        super(Bundle.getMessage("ChangePasswordAction_Title"));
        this.checkPermission();
    }

    private void checkPermission() {
        PermissionManager permissionManager = InstanceManager.getDefault(PermissionManager.class);
        if (permissionManager.isEnabled()) {
            this.setEnabled(permissionManager.isLoggedIn());
            permissionManager.addLoginListener(isLogin -> this.setEnabled(isLogin && permissionManager.isCurrentUserPermittedToChangePassword()));
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PermissionManager permissionManager = InstanceManager.getDefault(PermissionManager.class);
        if (!permissionManager.hasAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PERMISSIONS, BooleanPermission.BooleanValue.TRUE) && !permissionManager.ensureAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_OWN_PASSWORD, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        new ChangePasswordDialog().setVisible(true);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

