/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import jmri.Application;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.jmrit.permission.swing.Bundle;
import jmri.util.swing.JmriJOptionPane;

public class ChangePasswordDialog
extends JDialog {
    private final JPasswordField _oldPasswordTextField;
    private final JPasswordField _passwordTextField;
    private final JPasswordField _secondPasswordTextField;

    public ChangePasswordDialog() {
        super((Frame)null, Bundle.getMessage("ChangePasswordDialog_Title", InstanceManager.getDefault(PermissionManager.class).getCurrentUserName()), true);
        JPanel contentPanel = new JPanel();
        this.rootPane.getContentPane().add(contentPanel);
        JPanel p = contentPanel;
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_UserName")), c);
        c.gridy = 1;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("ChangePasswordDialog_OldPassword")), c);
        c.gridy = 2;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("ChangePasswordDialog_NewPassword")), c);
        c.gridy = 3;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_PasswordAgain")), c);
        c.gridx = 1;
        c.gridy = 0;
        contentPanel.add(Box.createHorizontalStrut(5), c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        contentPanel.add((Component)new JLabel(InstanceManager.getDefault(PermissionManager.class).getCurrentUserName()), c);
        c.gridy = 1;
        this._oldPasswordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._oldPasswordTextField, c);
        c.gridy = 2;
        this._passwordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._passwordTextField, c);
        c.gridy = 3;
        this._secondPasswordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._secondPasswordTextField, c);
        JPanel buttonPanel = new JPanel();
        JButton buttonCancel = new JButton(Bundle.getMessage("ButtonCancel"));
        buttonPanel.add(buttonCancel);
        buttonCancel.addActionListener(e -> this.dispose());
        JButton buttonOK = new JButton(Bundle.getMessage("ButtonOK"));
        buttonPanel.add(buttonOK);
        buttonOK.addActionListener(e -> {
            if (this.okPressed()) {
                this.dispose();
            }
        });
        buttonOK.setToolTipText(Bundle.getMessage("ChangePasswordDialogOkButtonHint"));
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 2;
        c.anchor = 10;
        contentPanel.add((Component)buttonPanel, c);
        this.setLocationRelativeTo(null);
        this.pack();
    }

    private boolean okPressed() {
        PermissionManager mngr = InstanceManager.getDefault(PermissionManager.class);
        String oldPasswd = new String(this._oldPasswordTextField.getPassword());
        String passwd1 = new String(this._passwordTextField.getPassword());
        String passwd2 = new String(this._secondPasswordTextField.getPassword());
        if (passwd1.isBlank() && !mngr.isAllowEmptyPasswords()) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_PasswordEmpty"), Application.getApplicationName(), 0);
            return false;
        }
        if (!passwd1.equals(passwd1.trim())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_SpaceNotAllowedInPassword"), Application.getApplicationName(), 0);
            return false;
        }
        if (!passwd1.equals(passwd2)) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_PasswordsAreNotEqual"), Application.getApplicationName(), 0);
            return false;
        }
        InstanceManager.getDefault(PermissionManager.class).changePassword(oldPasswd, passwd1);
        return true;
    }
}

