/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import jmri.Application;
import jmri.PermissionManager;
import jmri.User;
import jmri.jmrit.permission.swing.Bundle;
import jmri.util.swing.JmriJOptionPane;

public class ChangeUserPasswordDialog
extends JDialog {
    private final PermissionManager _mngr;
    private final JPasswordField _passwordTextField;
    private final JPasswordField _secondPasswordTextField;

    public ChangeUserPasswordDialog(PermissionManager mngr, Frame owner, User user, Runnable passwordChangedRunnable) {
        super(owner, Bundle.getMessage("ChangeUserPasswordDialog_ChangePasswordTitle"), true);
        this._mngr = mngr;
        JPanel contentPanel = new JPanel();
        this.rootPane.getContentPane().add(contentPanel);
        JPanel p = contentPanel;
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_UserName")), c);
        c.gridy = 1;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_Password")), c);
        c.gridy = 2;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_PasswordAgain")), c);
        c.gridx = 1;
        c.gridy = 0;
        contentPanel.add(Box.createHorizontalStrut(5), c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        contentPanel.add((Component)new JLabel(user.getUserName()), c);
        c.gridy = 1;
        this._passwordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._passwordTextField, c);
        c.gridy = 2;
        this._secondPasswordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._secondPasswordTextField, c);
        JPanel buttonPanel = new JPanel();
        JButton buttonCancel = new JButton(Bundle.getMessage("ButtonCancel"));
        buttonPanel.add(buttonCancel);
        buttonCancel.addActionListener(e -> this.dispose());
        JButton buttonOK = new JButton(Bundle.getMessage("ButtonOK"));
        buttonPanel.add(buttonOK);
        buttonOK.addActionListener(e -> {
            if (this.okPressed(user)) {
                passwordChangedRunnable.run();
                this.dispose();
            }
        });
        buttonOK.setToolTipText(Bundle.getMessage("ChangePasswordDialogOkButtonHint"));
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.anchor = 10;
        contentPanel.add((Component)buttonPanel, c);
        this.setLocationRelativeTo(owner);
        this.pack();
    }

    private boolean okPressed(User user) {
        String passwd1 = new String(this._passwordTextField.getPassword());
        String passwd2 = new String(this._secondPasswordTextField.getPassword());
        if (passwd1.isBlank() && !this._mngr.isAllowEmptyPasswords()) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_PasswordEmpty"), Application.getApplicationName(), 0);
            return false;
        }
        if (!passwd1.equals(passwd1.trim())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_SpaceNotAllowedInPassword"), Application.getApplicationName(), 0);
            return false;
        }
        if (!passwd1.equals(passwd2)) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("AddUserDialog_PasswordsAreNotEqual"), Application.getApplicationName(), 0);
            return false;
        }
        user.setPassword(passwd1);
        return true;
    }
}

