/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import jmri.Application;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.jmrit.permission.swing.Bundle;
import jmri.util.swing.JmriJOptionPane;

public class LoginDialog
extends JDialog {
    private final JTextField _usernameTextField;
    private final JPasswordField _passwordTextField;

    public LoginDialog(Frame owner) {
        super(owner, Bundle.getMessage("LoginAction_Title"), true);
        JPanel contentPanel = new JPanel();
        this.rootPane.getContentPane().add(contentPanel);
        JPanel p = contentPanel;
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 1;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 13;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_UserName")), c);
        c.gridy = 1;
        contentPanel.add((Component)new JLabel(Bundle.getMessage("AddUserDialog_Password")), c);
        c.gridx = 1;
        c.gridy = 0;
        contentPanel.add(Box.createHorizontalStrut(5), c);
        c.gridx = 2;
        c.gridy = 0;
        c.anchor = 17;
        this._usernameTextField = new JTextField(20);
        contentPanel.add((Component)this._usernameTextField, c);
        c.gridy = 1;
        this._passwordTextField = new JPasswordField(20);
        contentPanel.add((Component)this._passwordTextField, c);
        JPanel buttonPanel = new JPanel();
        JButton buttonCancel = new JButton(Bundle.getMessage("ButtonCancel"));
        buttonPanel.add(buttonCancel);
        buttonCancel.addActionListener(e -> this.dispose());
        JButton buttonOK = new JButton(Bundle.getMessage("ButtonOK"));
        buttonPanel.add(buttonOK);
        buttonOK.addActionListener(e -> {
            PermissionManager mngr = InstanceManager.getDefault(PermissionManager.class);
            if (mngr.isAGuestUser(this._usernameTextField.getText())) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LoginAction_GuestMessage"), Application.getApplicationName(), 0);
            } else {
                String password = new String(this._passwordTextField.getPassword());
                if (mngr.login(this._usernameTextField.getText(), password)) {
                    JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("LoginAction_UserLoggedIn"), Application.getApplicationName(), 1);
                    this.dispose();
                }
            }
        });
        buttonOK.setToolTipText(Bundle.getMessage("LoginOkButtonHint"));
        this.getRootPane().setDefaultButton(buttonOK);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.anchor = 10;
        contentPanel.add((Component)buttonPanel, c);
        this.setLocationRelativeTo(owner);
        this.pack();
    }
}

