/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.permission.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import jmri.Application;
import jmri.BooleanPermission;
import jmri.InstanceManager;
import jmri.Permission;
import jmri.PermissionManager;
import jmri.PermissionOwner;
import jmri.PermissionsSystemAdmin;
import jmri.Role;
import jmri.User;
import jmri.jmrit.permission.DefaultPermissionManager;
import jmri.jmrit.permission.swing.AddUserDialog;
import jmri.jmrit.permission.swing.Bundle;
import jmri.jmrit.permission.swing.ChangeUserPasswordDialog;
import jmri.swing.PermissionSwing;
import jmri.swing.PermissionSwingTools;
import jmri.swing.PreferencesPanel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private final DefaultPermissionManager _temporaryPermissionManager;
    private final Map<User, UserFields> _userFieldsMap = new HashMap<User, UserFields>();
    private boolean _dirty = false;
    private static final Logger log = LoggerFactory.getLogger(PermissionPreferencesPanel.class);

    public PermissionPreferencesPanel() {
        PermissionManager mngr = InstanceManager.getDefault(PermissionManager.class);
        if (!(mngr instanceof DefaultPermissionManager)) {
            throw new RuntimeException("PermissionManager is not of type DefaultPermissionManager");
        }
        this._temporaryPermissionManager = ((DefaultPermissionManager)mngr).getTemporaryInstance();
        this.initGUI();
    }

    private void initGUI() {
        JTabbedPane rolesTabbedPane = new JTabbedPane();
        JTabbedPane usersTabbedPane = new JTabbedPane();
        ArrayList<Role> roleList = new ArrayList<Role>(this._temporaryPermissionManager.getRoles());
        roleList.sort((a, b) -> {
            if (a.getPriority() != b.getPriority()) {
                return Integer.compare(b.getPriority(), a.getPriority());
            }
            return a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
        });
        ArrayList<User> userList = new ArrayList<User>(this._temporaryPermissionManager.getUsers());
        userList.sort((a, b) -> {
            if (a.getPriority() != b.getPriority()) {
                return Integer.compare(b.getPriority(), a.getPriority());
            }
            return a.getUserName().toLowerCase().compareTo(b.getUserName().toLowerCase());
        });
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new BoxLayout(outerPanel, 3));
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new BoxLayout(settingsPanel, 3));
        settingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), new EmptyBorder(4, 4, 4, 4)));
        JCheckBox enablePermissionManagerCheckBox = new JCheckBox(Bundle.getMessage("PermissionPreferencesPanel_EnablePermissionManager"));
        enablePermissionManagerCheckBox.setSelected(this._temporaryPermissionManager.isEnabled());
        enablePermissionManagerCheckBox.addActionListener(evt -> {
            if (enablePermissionManagerCheckBox.isSelected()) {
                if (0 == JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("PermissionPreferencesPanel_WarnStartPermissions"), Bundle.getMessage("WarningTitle"), 0)) {
                    this._temporaryPermissionManager.setEnabled(enablePermissionManagerCheckBox.isSelected());
                    this._dirty = true;
                } else {
                    enablePermissionManagerCheckBox.setSelected(false);
                }
            } else {
                this._temporaryPermissionManager.setEnabled(false);
                this._dirty = true;
            }
        });
        settingsPanel.add(enablePermissionManagerCheckBox);
        JCheckBox allowEmptyPasswordsCheckBox = new JCheckBox(Bundle.getMessage("PermissionPreferencesPanel_AllowEmptyPasswords"));
        allowEmptyPasswordsCheckBox.setSelected(this._temporaryPermissionManager.isAllowEmptyPasswords());
        allowEmptyPasswordsCheckBox.addActionListener(evt -> {
            this._temporaryPermissionManager.setAllowEmptyPasswords(allowEmptyPasswordsCheckBox.isSelected());
            this._dirty = true;
        });
        settingsPanel.add(allowEmptyPasswordsCheckBox);
        outerPanel.add(settingsPanel);
        outerPanel.add(Box.createVerticalStrut(10));
        JPanel rolesPanel = new JPanel();
        rolesPanel.setLayout(new BoxLayout(rolesPanel, 3));
        for (Role role : roleList) {
            rolesTabbedPane.addTab(role.getName(), new JScrollPane(this.getRolePanel(role, rolesTabbedPane, usersTabbedPane, roleList, userList)));
        }
        rolesPanel.add(rolesTabbedPane);
        JButton addRoleButton = new JButton(Bundle.getMessage("PermissionPreferencesPanel_AddRole"));
        addRoleButton.addActionListener(evt -> this.createNewRole(rolesTabbedPane, usersTabbedPane, roleList, userList));
        rolesPanel.add(addRoleButton);
        JPanel usersPanel = new JPanel();
        usersPanel.setLayout(new BoxLayout(usersPanel, 3));
        this.reloadUsersTabbedPane(usersTabbedPane, roleList, userList);
        usersPanel.add(usersTabbedPane);
        JButton addUserButton = new JButton(Bundle.getMessage("PermissionPreferencesPanel_AddUser"));
        addUserButton.addActionListener(evt -> new AddUserDialog(this._temporaryPermissionManager, this.getFrame(), user -> {
            userList.clear();
            userList.addAll(this._temporaryPermissionManager.getUsers());
            userList.sort((a, b) -> {
                if (a.getPriority() != b.getPriority()) {
                    return Integer.compare(b.getPriority(), a.getPriority());
                }
                return a.getUserName().toLowerCase().compareTo(b.getUserName().toLowerCase());
            });
            usersTabbedPane.insertTab(user.getUserName(), null, new JScrollPane(this.getUserPanel(user, usersTabbedPane, roleList, userList)), null, userList.indexOf(user));
            this.getFrame().pack();
            this._dirty = true;
        }).setVisible(true));
        usersPanel.add(addUserButton);
        usersPanel.add(Box.createGlue());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Bundle.getMessage("PermissionPreferencesPanel_Roles"), new JScrollPane(rolesPanel));
        tabbedPane.addTab(Bundle.getMessage("PermissionPreferencesPanel_Users"), new JScrollPane(usersPanel));
        JPanel outerTabbedPanel = new JPanel();
        outerTabbedPanel.add(tabbedPane);
        outerPanel.add(outerTabbedPanel);
        this.add(outerPanel);
    }

    private Frame getFrame() {
        Container c;
        for (c = this; c != null && !(c instanceof Frame); c = c.getParent()) {
        }
        return (Frame)c;
    }

    private void createNewRole(JTabbedPane rolesTabbedPane, JTabbedPane usersTabbedPane, List<Role> roleList, List<User> userList) {
        String roleName = JOptionPane.showInputDialog(this.getFrame(), (Object)Bundle.getMessage("PermissionPreferencesPanel_EnterRoleName"));
        if (roleName == null) {
            return;
        }
        if (roleName.isBlank()) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("PermissionPreferencesPanel_NameEmpty"), Application.getApplicationName(), 0);
            return;
        }
        if (!roleName.equals(roleName.trim())) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("PermissionPreferencesPanel_SpaceNotAllowedInRoleName"), Application.getApplicationName(), 0);
            return;
        }
        try {
            Role role = this._temporaryPermissionManager.addRole(roleName);
            roleList.clear();
            roleList.addAll(this._temporaryPermissionManager.getRoles());
            roleList.sort((a, b) -> {
                if (a.getPriority() != b.getPriority()) {
                    return Integer.compare(b.getPriority(), a.getPriority());
                }
                return a.getName().toLowerCase().compareTo(b.getName().toLowerCase());
            });
            rolesTabbedPane.insertTab(role.getName(), null, new JScrollPane(this.getRolePanel(role, rolesTabbedPane, usersTabbedPane, roleList, userList)), null, roleList.indexOf(role));
            this.reloadUsersTabbedPane(usersTabbedPane, roleList, userList);
            this.getFrame().pack();
            this._dirty = true;
        }
        catch (PermissionManager.RoleAlreadyExistsException e) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("PermissionPreferencesPanel_RoleNameExists"), Application.getApplicationName(), 0);
        }
    }

    private JPanel getRolePanel(Role role, JTabbedPane rolesTabbedPane, JTabbedPane usersTabbedPane, List<Role> roleList, List<User> userList) {
        JPanel rolePanel = new JPanel();
        rolePanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 3;
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        JLabel roleLabel = new JLabel("<html><font size=\"+1\"><b>" + role.getName() + "</b></font></html>");
        roleLabel.setBorder(new EmptyBorder(4, 4, 0, 4));
        rolePanel.add((Component)roleLabel, c);
        ++c.gridy;
        ArrayList<PermissionOwner> owners = new ArrayList<PermissionOwner>(this._temporaryPermissionManager.getOwners());
        owners.sort((a, b) -> a.getName().compareTo(b.getName()));
        for (PermissionOwner owner : owners) {
            JLabel ownerLabel = new JLabel("<html><font size=\"0.5\"><b>" + owner.getName() + "</b></font></html>");
            ownerLabel.setBorder(new EmptyBorder(15, 4, 4, 4));
            rolePanel.add((Component)ownerLabel, c);
            ++c.gridy;
            ArrayList<Permission> permissions = new ArrayList<Permission>(this._temporaryPermissionManager.getPermissions(owner));
            permissions.sort((a, b) -> a.getName().compareTo(b.getName()));
            for (Permission permission : permissions) {
                PermissionSwing permissionSwing = PermissionSwingTools.getPermissionSwingForClass(permission);
                JLabel label = permissionSwing.getLabel(permission);
                if (label != null) {
                    c.gridwidth = 1;
                    c.gridx = 0;
                    rolePanel.add((Component)label, c);
                    c.gridx = 1;
                    rolePanel.add(Box.createHorizontalStrut(5), c);
                    c.gridx = 2;
                }
                rolePanel.add((Component)permissionSwing.getComponent(role, permission, this::setDirtyFlag), c);
                ++c.gridy;
                c.gridx = 0;
                c.gridwidth = 3;
            }
        }
        rolePanel.add(Box.createVerticalStrut(10));
        JButton removeRoleButton = new JButton(Bundle.getMessage("PermissionPreferencesPanel_RemoveRole"));
        removeRoleButton.addActionListener(evt -> {
            if (0 == JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("PermissionPreferencesPanel_RemoveRoleConfirmation", role.getName()), Bundle.getMessage("PermissionPreferencesPanel_RemoveRoleTitle"), 0)) {
                try {
                    this._temporaryPermissionManager.removeRole(role.getName());
                    rolesTabbedPane.remove(roleList.indexOf(role));
                    roleList.remove(role);
                    this.reloadUsersTabbedPane(usersTabbedPane, roleList, userList);
                    this.getFrame().pack();
                    this._dirty = true;
                }
                catch (PermissionManager.RoleDoesNotExistException e) {
                    log.error("Unexpected exception", (Throwable)e);
                }
            }
        });
        if (role.isSystemRole()) {
            removeRoleButton.setEnabled(false);
        }
        ++c.gridy;
        rolePanel.add(Box.createVerticalStrut(5), c);
        ++c.gridy;
        c.anchor = 10;
        rolePanel.add((Component)removeRoleButton, c);
        return rolePanel;
    }

    private void setDirtyFlag() {
        this._dirty = true;
    }

    private void reloadUsersTabbedPane(JTabbedPane usersTabbedPane, List<Role> roleList, List<User> userList) {
        usersTabbedPane.removeAll();
        for (User user : userList) {
            usersTabbedPane.addTab(user.getUserName(), new JScrollPane(this.getUserPanel(user, usersTabbedPane, roleList, userList)));
        }
    }

    private JPanel getUserPanel(User user, JTabbedPane usersTabbedPane, List<Role> roleList, List<User> userList) {
        JPanel userPanel = new JPanel();
        userPanel.setLayout(new BoxLayout(userPanel, 3));
        UserFields userFields = new UserFields();
        this._userFieldsMap.put(user, userFields);
        JLabel usernameLabel = new JLabel("<html><font size=\"+1\"><b>" + user.getUserName() + "</b></font></html>");
        usernameLabel.setBorder(new EmptyBorder(4, 4, 4, 4));
        userPanel.add(usernameLabel);
        userPanel.add(new JLabel(Bundle.getMessage("PermissionPreferencesPanel_Name")));
        userFields._nameTextField = new JTextField(20);
        userFields._nameTextField.setText(user.getName());
        userPanel.add(userFields._nameTextField);
        userPanel.add(new JLabel(Bundle.getMessage("PermissionPreferencesPanel_Comment")));
        userFields._commentTextField = new JTextField(40);
        userFields._commentTextField.setText(user.getComment());
        userPanel.add(userFields._commentTextField);
        userPanel.add(Box.createVerticalStrut(10));
        userPanel.add(new JLabel(Bundle.getMessage("PermissionPreferencesPanel_Roles")));
        userPanel.add(Box.createVerticalStrut(5));
        int lastPriority = 0;
        for (Role role : roleList) {
            if (role.getPriority() == 0 && lastPriority != 0) {
                userPanel.add(Box.createVerticalStrut(10));
            }
            JCheckBox checkBox = new JCheckBox(role.getName());
            checkBox.setSelected(user.getRoles().contains(role));
            checkBox.addActionListener(evt -> {
                if (checkBox.isSelected()) {
                    user.addRole(role);
                } else {
                    user.removeRole(role);
                }
                this._dirty = true;
            });
            userPanel.add(checkBox);
            lastPriority = role.getPriority();
        }
        userPanel.add(Box.createVerticalStrut(10));
        JButton changePasswordButton = new JButton(Bundle.getMessage("PermissionPreferencesPanel_ChangePassword"));
        changePasswordButton.setEnabled(!this._temporaryPermissionManager.isAGuestUser(user));
        changePasswordButton.addActionListener(evt -> new ChangeUserPasswordDialog(this._temporaryPermissionManager, this.getFrame(), user, () -> {
            this._dirty = true;
        }).setVisible(true));
        userPanel.add(changePasswordButton);
        JButton removeUserButton = new JButton(Bundle.getMessage("PermissionPreferencesPanel_RemoveUser"));
        removeUserButton.addActionListener(evt -> {
            if (0 == JmriJOptionPane.showConfirmDialog(null, Bundle.getMessage("PermissionPreferencesPanel_RemoveUserConfirmation", user.getUserName(), user.getName()), Bundle.getMessage("PermissionPreferencesPanel_RemoveUserTitle"), 0)) {
                try {
                    this._temporaryPermissionManager.removeUser(user.getUserName());
                    usersTabbedPane.remove(userList.indexOf(user));
                    userList.remove(user);
                    this._dirty = true;
                }
                catch (PermissionManager.UserDoesNotExistException e) {
                    log.error("Unexpected exception", (Throwable)e);
                }
            }
        });
        if (user.isSystemUser()) {
            removeUserButton.setEnabled(false);
        }
        userPanel.add(removeUserButton);
        return userPanel;
    }

    @Override
    public String getPreferencesItem() {
        return "PREFERENCES";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("MenuPermission");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return null;
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        for (Map.Entry<User, UserFields> entry : this._userFieldsMap.entrySet()) {
            entry.getKey().setName(entry.getValue()._nameTextField.getText());
            entry.getKey().setComment(entry.getValue()._commentTextField.getText());
        }
        this._temporaryPermissionManager.storePermissionSettings();
        this._dirty = false;
    }

    @Override
    public boolean isDirty() {
        return this._dirty;
    }

    @Override
    public boolean isRestartRequired() {
        return true;
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    @Override
    public BooleanSupplier getIsEnabled() {
        return () -> InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(PermissionsSystemAdmin.PERMISSION_EDIT_PREFERENCES, BooleanPermission.BooleanValue.TRUE);
    }

    private static class UserFields {
        JTextField _nameTextField;
        JTextField _commentTextField;

        private UserFields() {
        }
    }
}

