/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.picker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.beantable.AddNewDevicePanel;
import jmri.jmrit.picker.Bundle;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickSinglePanel<T extends NamedBean>
extends JPanel {
    private int ROW_HEIGHT;
    PickListModel<T> _model;
    JPanel _addPanel;
    JPanel _cantAddPanel;
    JTextField _sysNametext;
    JTextField _userNametext;
    JTable _table;
    JScrollPane _scroll;
    private static final Logger log = LoggerFactory.getLogger(PickSinglePanel.class);

    public PickSinglePanel(PickListModel<T> model) {
        this._model = model;
        this._table = this._model.makePickTable();
        this._table.setSelectionMode(0);
        this._table.setCellSelectionEnabled(true);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String username;
                int row = PickSinglePanel.this.getTable().getSelectedRow();
                int col = PickSinglePanel.this.getTable().getSelectedColumn();
                if (col != 1) {
                    return;
                }
                if (row >= 0 && (username = (String)PickSinglePanel.this._model.getTable().getValueAt(row, 1)) != null) {
                    return;
                }
                PickSinglePanel.this._model.getTable().setColumnSelectionInterval(0, 0);
            }
        });
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout(5, 5));
        p.add((Component)new JLabel(this._model.getName(), 0), "North");
        this._scroll = new JScrollPane(this._table);
        p.add((Component)this._scroll, "Center");
        this.ROW_HEIGHT = this._table.getRowHeight();
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)p, "Center");
        this.add((Component)this.makeAddToTablePanel(), "South");
        if (this._model.canAddBean()) {
            this._cantAddPanel.setVisible(false);
            this._addPanel.setVisible(true);
        } else {
            this._addPanel.setVisible(false);
            this._cantAddPanel.setVisible(true);
        }
    }

    public NamedBeanHandle<T> getSelectedBeanHandle() {
        T bean;
        int row = this.getTable().getSelectedRow();
        int col = this.getTable().getSelectedColumn();
        log.debug("PickSinglePanel: r = {}, c = {}", (Object)row, (Object)col);
        String sysname = this._model.getTable().getValueAt(row, 0).toString();
        String username = (String)this._model.getTable().getValueAt(row, 1);
        String beanName = sysname;
        if (col == 1 && username != null) {
            beanName = username;
        }
        if ((bean = this._model.addBean(sysname, username)) == null) {
            return null;
        }
        return InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(beanName, bean);
    }

    public JTable getTable() {
        return this._table;
    }

    private JPanel makeAddToTablePanel() {
        this._sysNametext = new JTextField();
        this._userNametext = new JTextField();
        ActionListener cancelListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
            }
        };
        ActionListener okListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                PickSinglePanel.this.addToTable();
            }
        };
        this._addPanel = new AddNewDevicePanel(this._sysNametext, this._userNametext, "addToTable", okListener, cancelListener);
        this._cantAddPanel = new JPanel();
        this._cantAddPanel.setLayout(new BorderLayout(5, 5));
        this._cantAddPanel.add((Component)new JLabel(Bundle.getMessage("CantAddNew"), 0), "North");
        this._cantAddPanel.add((Component)new JLabel(Bundle.getMessage("OpenToAdd"), 0), "South");
        JPanel p = new JPanel();
        p.add(this._addPanel);
        p.add(this._cantAddPanel);
        int width = Math.max(100, this.getPreferredSize().width);
        this._sysNametext.setPreferredSize(new Dimension(width, this._sysNametext.getPreferredSize().height));
        return p;
    }

    void addToTable() {
        String sysname = this._sysNametext.getText();
        if (sysname.length() > 1) {
            String uname = NamedBean.normalizeUserName(this._userNametext.getText());
            if (uname != null && uname.trim().length() == 0) {
                uname = null;
            }
            Object bean = null;
            try {
                bean = this._model.addBean(sysname, uname);
            }
            catch (IllegalArgumentException ex) {
                JmriJOptionPane.showMessageDialog(this.getRootPane(), Bundle.getMessage("PickAddFailed", ex.getMessage()), Bundle.getMessage("WarningTitle"), 2);
            }
            if (bean != null) {
                int setRow = this._model.getIndexOf(bean);
                this._model.getTable().setRowSelectionInterval(setRow, setRow);
                this._scroll.getVerticalScrollBar().setValue(setRow * this.ROW_HEIGHT);
                this._sysNametext.setText("");
            }
        }
    }
}

