/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.powerpanel;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import jmri.InstanceManager;
import jmri.PowerManager;
import jmri.jmrit.powerpanel.Bundle;

public class PowerButtonAction
extends AbstractAction
implements PropertyChangeListener {
    public PowerButtonAction(String title) {
        super(title);
        this.checkManager();
        this.updateLabel();
    }

    public PowerButtonAction() {
        this(Bundle.getMessage("ButtonPowerOnOff"));
    }

    void checkManager() {
        if (InstanceManager.getNullableDefault(PowerManager.class) == null) {
            this.setEnabled(false);
        } else {
            InstanceManager.getDefault(PowerManager.class).addPropertyChangeListener(this);
        }
    }

    void updateLabel() {
        PowerManager p = InstanceManager.getDefault(PowerManager.class);
        if (p.getPower() != 2) {
            this.putValue("Name", Bundle.getMessage("ButtonSetOn"));
        } else {
            this.putValue("Name", Bundle.getMessage("ButtonSetOff"));
        }
        this.firePropertyChange("Name", "", this.getValue("Name"));
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        this.updateLabel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            PowerManager p = InstanceManager.getNullableDefault(PowerManager.class);
            if (p == null) {
                return;
            }
            if (p.getPower() != 2) {
                p.setPower(2);
            } else {
                p.setPower(4);
            }
        }
        catch (Exception ex) {
            return;
        }
        this.updateLabel();
    }
}

