/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.powerpanel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.PowerManager;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.powerpanel.Bundle;
import jmri.swing.PowerManagerMenu;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerPane
extends JmriPanel {
    final PowerManagerMenu selectMenu;
    final JPanel contentP;
    final List<SinglePowerPane> mgrList = new ArrayList<SinglePowerPane>();
    private static final NamedIcon onIcon = new NamedIcon("resources/icons/throttles/power_green.png", "resources/icons/throttles/power_green.png");
    private static final NamedIcon offIcon = new NamedIcon("resources/icons/throttles/power_red.png", "resources/icons/throttles/power_red.png");
    private static final NamedIcon unknownIcon = new NamedIcon("resources/icons/throttles/power_yellow.png", "resources/icons/throttles/power_yellow.png");
    private static final Logger log = LoggerFactory.getLogger(PowerPane.class);

    public PowerPane() {
        this((PowerManager)null);
    }

    public PowerPane(PowerManager initialMgr) {
        this.contentP = new JPanel();
        this.selectMenu = new PowerManagerMenuImpl(initialMgr);
        this.contentP.setLayout(new BoxLayout(this.contentP, 1));
        this.add(this.contentP);
        this.managerChanged();
    }

    @Override
    public List<JMenu> getMenus() {
        ArrayList<JMenu> list = new ArrayList<JMenu>();
        list.add(this.selectMenu);
        return list;
    }

    @Override
    public String getHelpTarget() {
        return "package.jmri.jmrit.powerpanel.PowerPanelFrame";
    }

    @Override
    public String getTitle() {
        PowerManager mgr = this.selectMenu.getManager();
        return Bundle.getMessage("TitlePowerPanel") + " : " + (mgr == null ? Bundle.getMessage("AllConnections") : mgr.getUserName());
    }

    void managerChanged() {
        log.debug("manager changed to {}", (Object)this.selectMenu.getManager());
        this.mgrList.forEach(SinglePowerPane::dispose);
        this.mgrList.clear();
        this.contentP.removeAll();
        PowerManager mgr = this.selectMenu.getManager();
        if (mgr != null) {
            this.mgrList.add(new SinglePowerPane(mgr));
        } else {
            List<PowerManager> managers = InstanceManager.getList(PowerManager.class);
            Iterator<PowerManager> iterator = managers.iterator();
            while (iterator.hasNext()) {
                PowerManager pm = iterator.next();
                this.mgrList.add(new SinglePowerPane(pm));
            }
        }
        for (SinglePowerPane spp : this.mgrList) {
            this.contentP.add(spp);
        }
        JFrame f = (JFrame)SwingUtilities.windowForComponent(this);
        if (f != null) {
            f.pack();
            f.setTitle(this.getTitle());
        }
    }

    @Override
    public void dispose() {
        this.mgrList.forEach(SinglePowerPane::dispose);
    }

    class PowerManagerMenuImpl
    extends PowerManagerMenu {
        PowerManagerMenuImpl(PowerManager mgr) {
            super(true, mgr);
        }

        @Override
        protected void choiceChanged() {
            PowerPane.this.managerChanged();
        }
    }

    class SinglePowerPane
    extends JPanel
    implements PropertyChangeListener {
        private final PowerManager powerMgr;
        private final JLabel onOffStatus = new JLabel(Bundle.getMessage("LabelUnknown"));
        private final JLabel connLabel = new JLabel(Bundle.getMessage("LabelLayoutPower"));
        private final JButton onButton = new JButton(Bundle.getMessage("ButtonOn"));
        private final JButton offButton = new JButton(Bundle.getMessage("ButtonOff"));
        private final JButton idleButton = new JButton(Bundle.getMessage("ButtonIdle"));

        SinglePowerPane(PowerManager powerManager) {
            this.powerMgr = powerManager;
            this.onButton.addActionListener(e -> this.onButtonPushed());
            this.offButton.addActionListener(e -> this.offButtonPushed());
            this.idleButton.addActionListener(e -> this.idleButtonPushed());
            this.idleButton.setToolTipText(Bundle.getMessage("ToolTipIdleButton"));
            this.setLayout(new GridLayout(this.powerMgr.implementsIdle() ? 3 : 2, 2, 3, 5));
            Border border = BorderFactory.createLineBorder(Color.BLACK, 1);
            this.setBorder(BorderFactory.createTitledBorder(border, PowerManagerMenu.getManagerNameIncludeIfDefault(this.powerMgr)));
            this.onOffStatus.setPreferredSize(new Dimension(this.getLabelMinimumWidth(this.onOffStatus), this.onButton.getPreferredSize().height + 10));
            this.add(this.connLabel);
            this.add(this.onButton);
            this.add(this.onOffStatus);
            this.add(this.offButton);
            if (this.powerMgr.implementsIdle()) {
                this.add(new JLabel(""));
                this.add(this.idleButton);
            }
            this.powerMgr.addPropertyChangeListener(this);
            this.setStatus();
        }

        private void onButtonPushed() {
            if (this.mgrOK()) {
                try {
                    this.powerMgr.setPower(2);
                }
                catch (JmriException e) {
                    this.couldNotSetPower("Exception trying to turn power on", e);
                }
            }
        }

        private void offButtonPushed() {
            if (this.mgrOK()) {
                try {
                    this.powerMgr.setPower(4);
                }
                catch (JmriException e) {
                    this.couldNotSetPower("Exception trying to turn power off", e);
                }
            }
        }

        private void idleButtonPushed() {
            if (this.mgrOK() && this.powerMgr.implementsIdle()) {
                try {
                    this.powerMgr.setPower(8);
                }
                catch (JmriException e) {
                    this.couldNotSetPower("Exception trying to set power to idle", e);
                }
            }
        }

        private void couldNotSetPower(String action, JmriException e) {
            log.error("PowerPane {}", (Object)action, (Object)e);
            JmriJOptionPane.showMessageDialog(this, this.powerMgr.getUserName() + System.lineSeparator() + action + System.lineSeparator() + e.getMessage(), action, 0);
        }

        private int getLabelMinimumWidth(JLabel label) {
            String[] bundleStrings = new String[]{"StatusIdle", "StatusOn", "StatusOff", "StatusUnknown"};
            int a = 10;
            for (String bs : bundleStrings) {
                FontMetrics fm = label.getFontMetrics(label.getFont());
                int wi = fm.stringWidth(Bundle.getMessage(bs)) + onIcon.getIconWidth() + 5;
                a = Math.max(a, wi);
            }
            return a;
        }

        private void setStatus() {
            if (this.mgrOK()) {
                switch (this.powerMgr.getPower()) {
                    case 2: {
                        this.onOffStatus.setText(Bundle.getMessage("StatusOn"));
                        this.onOffStatus.setIcon(onIcon);
                        break;
                    }
                    case 4: {
                        this.onOffStatus.setText(Bundle.getMessage("StatusOff"));
                        this.onOffStatus.setIcon(offIcon);
                        break;
                    }
                    case 8: {
                        this.onOffStatus.setText(Bundle.getMessage("StatusIdle"));
                        this.onOffStatus.setIcon(unknownIcon);
                        break;
                    }
                    case 1: {
                        this.onOffStatus.setText(Bundle.getMessage("StatusUnknown"));
                        this.onOffStatus.setIcon(unknownIcon);
                        break;
                    }
                    default: {
                        this.onOffStatus.setText(Bundle.getMessage("StatusUnknown"));
                        this.onOffStatus.setIcon(unknownIcon);
                        log.error("Unexpected state value: {}", (Object)PowerPane.this.selectMenu.getManager());
                    }
                }
            }
        }

        private boolean mgrOK() {
            return InstanceManager.getList(PowerManager.class).contains(this.powerMgr);
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            this.setStatus();
        }

        void dispose() {
            this.powerMgr.removePropertyChangeListener(this);
        }
    }
}

