/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.progsupport;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.jmrit.progsupport.Bundle;
import jmri.jmrit.progsupport.ProgModeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgServiceModeComboBox
extends ProgModeSelector
implements PropertyChangeListener,
ActionListener {
    JLabel progLabel = new JLabel(Bundle.getMessage("ProgrammerLabel"));
    JComboBox<GlobalProgrammerManager> progBox;
    JComboBox<ProgrammingMode> modeBox;
    ArrayList<Integer> modes = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(ProgServiceModeComboBox.class);

    @Override
    public Programmer getProgrammer() {
        if (this.progBox == null) {
            log.trace("getProgrammer returns null with no progBox");
            return null;
        }
        GlobalProgrammerManager pm = (GlobalProgrammerManager)this.progBox.getSelectedItem();
        if (pm == null) {
            log.trace("getProgrammer returns null with no selection");
            return null;
        }
        log.trace("getProgrammer returns {}", (Object)pm.getGlobalProgrammer());
        return pm.getGlobalProgrammer();
    }

    @Override
    public boolean isSelected() {
        return true;
    }

    public ProgServiceModeComboBox() {
        this(0);
    }

    protected final List<GlobalProgrammerManager> getMgrList() {
        List<GlobalProgrammerManager> list = InstanceManager.getList(GlobalProgrammerManager.class);
        log.trace("gtMgrList returns {}", (Object)list.size());
        return list;
    }

    public ProgServiceModeComboBox(int direction) {
        log.trace("ctor starts");
        this.modeBox = new JComboBox();
        this.modeBox.addActionListener(this);
        this.setLayout(new BoxLayout(this, direction));
        this.progBox = new JComboBox();
        Vector<GlobalProgrammerManager> v = new Vector<GlobalProgrammerManager>();
        for (GlobalProgrammerManager pm : this.getMgrList()) {
            Programmer globProg = null;
            if (pm != null) {
                globProg = pm.getGlobalProgrammer();
            }
            if (globProg == null) continue;
            v.add(pm);
            log.debug("ProgServiceModeComboBox added programmer {} as item {}", pm != null ? pm.getClass() : "null", (Object)pm);
            globProg.addPropertyChangeListener(this);
        }
        this.add(this.progLabel);
        this.progBox = new JComboBox(v);
        this.add(this.progBox);
        this.progBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ProgrammerLabel"));
        this.progBox.setSelectedItem(InstanceManager.getDefault(GlobalProgrammerManager.class));
        this.progBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgServiceModeComboBox.this.programmerSelected();
            }
        });
        log.trace("progBox loadeded with {}", (Object)this.progBox.getItemCount());
        this.add(new JLabel(Bundle.getMessage("ProgrammingModeLabel")));
        this.add(this.modeBox);
        this.modeBox.getAccessibleContext().setAccessibleName(Bundle.getMessage("ProgrammingModeLabel"));
        this.programmerSelected();
        log.trace("ctor ends");
    }

    void programmerSelected() {
        DefaultComboBoxModel<ProgrammingMode> model = new DefaultComboBoxModel<ProgrammingMode>();
        Programmer p = this.getProgrammer();
        if (p != null) {
            for (ProgrammingMode mode : p.getSupportedModes()) {
                model.addElement(mode);
            }
        }
        log.trace("programmerSelected setting modes");
        this.modeBox.setModel(model);
        ProgrammingMode mode = p != null ? p.getMode() : null;
        log.trace("programmerSelected set mode {}", (Object)mode);
        this.modeBox.setSelectedItem(mode);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.debug("Selected mode: {}", this.modeBox.getSelectedItem());
        if (this.modeBox.getSelectedItem() != null) {
            this.getProgrammer().setMode((ProgrammingMode)this.modeBox.getSelectedItem());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("Mode".equals(e.getPropertyName()) && this.getProgrammer().equals(e.getSource()) && this.isSelected()) {
            this.modeBox.setSelectedItem(e.getNewValue());
        }
    }

    @Override
    public void dispose() {
    }
}

