/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.progsupport;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import jmri.GlobalProgrammerManager;
import jmri.InstanceManager;
import jmri.Programmer;
import jmri.ProgrammingMode;
import jmri.jmrit.progsupport.ProgModeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgServiceModePane
extends ProgModeSelector
implements PropertyChangeListener,
ActionListener {
    ButtonGroup modeGroup = new ButtonGroup();
    HashMap<ProgrammingMode, JRadioButton> buttonMap = new HashMap();
    JComboBox<GlobalProgrammerManager> progBox;
    ArrayList<JRadioButton> buttonPool = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(ProgServiceModePane.class);

    @Override
    public Programmer getProgrammer() {
        if (this.progBox.getSelectedItem() == null) {
            return null;
        }
        return ((GlobalProgrammerManager)this.progBox.getSelectedItem()).getGlobalProgrammer();
    }

    @Override
    public boolean isSelected() {
        for (JRadioButton button : this.buttonMap.values()) {
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    public ProgServiceModePane(int direction) {
        this(direction, new ButtonGroup());
    }

    @Nonnull
    public List<GlobalProgrammerManager> getMgrList() {
        return InstanceManager.getList(GlobalProgrammerManager.class);
    }

    public ProgServiceModePane(int direction, ButtonGroup group) {
        this.modeGroup = group;
        this.setLayout(new BoxLayout(this, direction));
        ArrayList<GlobalProgrammerManager> v = new ArrayList<GlobalProgrammerManager>();
        for (GlobalProgrammerManager pm : this.getMgrList()) {
            Programmer progrmr = pm.getGlobalProgrammer();
            if (progrmr == null) continue;
            v.add(pm);
            progrmr.addPropertyChangeListener(this);
        }
        this.progBox = new JComboBox<GlobalProgrammerManager>(v.toArray(new GlobalProgrammerManager[0]));
        this.add(this.progBox);
        if (this.progBox.getItemCount() < 2) {
            this.progBox.setVisible(false);
        } else {
            log.debug("Set combobox box selection to InstanceManager global default: {}", (Object)InstanceManager.getDefault(GlobalProgrammerManager.class));
            this.progBox.setSelectedItem(InstanceManager.getDefault(GlobalProgrammerManager.class));
            this.progBox.addActionListener(e -> this.programmerSelected());
        }
        this.add(Box.createHorizontalGlue());
        this.programmerSelected();
    }

    void programmerSelected() {
        log.debug("programmerSelected starts with {} buttons", (Object)this.buttonPool.size());
        for (JRadioButton button : this.buttonPool) {
            button.setVisible(false);
        }
        this.buttonMap.clear();
        int index = 0;
        if (this.getProgrammer() == null) {
            return;
        }
        List<ProgrammingMode> modes = this.getProgrammer().getSupportedModes();
        log.debug("   has {} modes", (Object)modes.size());
        for (ProgrammingMode mode : modes) {
            JRadioButton button;
            if (index >= this.buttonPool.size()) {
                log.debug("   add button");
                button = new JRadioButton();
                this.buttonPool.add(button);
                this.modeGroup.add(button);
                button.addActionListener(this);
                this.add(button);
            }
            log.debug("   set for {}", (Object)mode.toString());
            button = this.buttonPool.get(index++);
            button.setVisible(true);
            this.modeGroup.add(button);
            button.setText(mode.toString());
            this.buttonMap.put(mode, button);
        }
        this.setGuiFromProgrammer();
    }

    @Override
    public void actionPerformed(@Nonnull ActionEvent e) {
        log.debug("Selected button: {}", (Object)e.getActionCommand());
        for (ProgrammingMode mode : this.buttonMap.keySet()) {
            if (!mode.toString().equals(e.getActionCommand())) continue;
            log.debug("      set mode {} on {}", (Object)mode.toString(), (Object)this.getProgrammer());
            this.getProgrammer().setMode(mode);
            return;
        }
    }

    @Override
    public void propertyChange(@Nonnull PropertyChangeEvent e) {
        if ("Mode".equals(e.getPropertyName()) && this.getProgrammer().equals(e.getSource())) {
            log.debug("Mode propertyChange with {}", (Object)this.isSelected());
            if (this.isSelected()) {
                this.setGuiFromProgrammer();
            }
        }
    }

    void setGuiFromProgrammer() {
        ProgrammingMode mode = this.getProgrammer().getMode();
        JRadioButton button = this.buttonMap.get(mode);
        log.debug("  setting button for mode {}", (Object)mode);
        if (button == null) {
            log.debug("   didn't find button, returning");
            return;
        }
        button.setSelected(true);
    }

    @Override
    public void dispose() {
        for (GlobalProgrammerManager pm : this.getMgrList()) {
            Programmer gp = pm.getGlobalProgrammer();
            if (gp == null) continue;
            gp.removePropertyChangeListener(this);
        }
    }
}

