/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.revhistory.configurexml;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import jmri.InstanceManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.LoadAndStorePreferences;
import jmri.jmrit.revhistory.FileHistory;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHistoryXml
extends AbstractXmlAdapter {
    static int defaultDepth = 5;
    private static final Logger log = LoggerFactory.getLogger(FileHistoryXml.class);

    @Override
    public boolean load(Element shared, Element perNode) {
        return true;
    }

    public boolean loadDirectly(Element e) {
        if (!e.getName().equals("filehistory")) {
            log.error("Unexpected element name: {}", (Object)e.getName());
            return false;
        }
        FileHistory rmain = InstanceManager.getDefault(FileHistory.class);
        FileHistory r = FileHistoryXml.loadFileHistory(e);
        rmain.addOperation("Load", "", r);
        return true;
    }

    public static FileHistory loadFileHistory(Element e) {
        FileHistory r = new FileHistory();
        List list = e.getChildren("operation");
        for (int i = 0; i < list.size(); ++i) {
            FileHistoryXml.loadOperation(r, (Element)list.get(i));
        }
        return r;
    }

    public static void loadOperation(FileHistory r, Element e) {
        String type = null;
        Element s = e.getChild("type");
        if (s != null) {
            type = s.getText();
        }
        String date = null;
        s = e.getChild("date");
        if (s != null) {
            date = s.getText();
        }
        String filename = null;
        s = e.getChild("filename");
        if (s != null) {
            filename = s.getText();
        }
        FileHistory filehistory = null;
        s = e.getChild("filehistory");
        if (s != null) {
            filehistory = FileHistoryXml.loadFileHistory(s);
        }
        r.addOperation(type, date, filename, filehistory);
    }

    @Override
    public void load(Element e, Object o) {
        throw new UnsupportedOperationException("Method not coded");
    }

    @Override
    public Element store(Object o) {
        return FileHistoryXml.storeDirectly(o, "");
    }

    public static Element storeDirectly(Object o, String fileName) {
        FileHistory r = (FileHistory)o;
        if (r == null) {
            return null;
        }
        LoadAndStorePreferences loadAndStorePreferences = InstanceManager.getDefault(LoadAndStorePreferences.class);
        if (loadAndStorePreferences.isExcludeFileHistory()) {
            return null;
        }
        Element e = FileHistoryXml.historyElement(r, defaultDepth);
        final String name = fileName == null ? "" : fileName;
        FileHistory fileHistory = r;
        Objects.requireNonNull(fileHistory);
        FileHistory.OperationMemo rev = new FileHistory.OperationMemo(fileHistory){
            {
                this.type = "Store";
                this.date = new Date().toString();
                this.filename = name;
                this.history = null;
            }
        };
        e.addContent((Content)FileHistoryXml.operationElement(rev, 10));
        return e;
    }

    static Element historyElement(FileHistory r, int depth) {
        ArrayList<FileHistory.OperationMemo> list = r.getList();
        Element e = new Element("filehistory");
        for (int i = 0; i < list.size(); ++i) {
            Element operation = FileHistoryXml.operationElement(list.get(i), depth);
            e.addContent((Content)operation);
        }
        return e;
    }

    static Element operationElement(FileHistory.OperationMemo r, int depth) {
        Element rev = new Element("operation");
        Element revnumber = new Element("type");
        revnumber.addContent(r.type);
        rev.addContent((Content)revnumber);
        Element date = new Element("date");
        date.addContent(r.date);
        rev.addContent((Content)date);
        Element authorinitials = new Element("filename");
        authorinitials.addContent(r.filename);
        rev.addContent((Content)authorinitials);
        if (r.history != null && depth >= 1) {
            rev.addContent((Content)FileHistoryXml.historyElement(r.history, depth - 1));
        }
        return rev;
    }
}

