/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.roster;

import java.awt.Component;
import jmri.jmrit.roster.AbstractRosterItemAction;
import jmri.jmrit.roster.LocoFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.FileUtil;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportRosterItemAction
extends AbstractRosterItemAction {
    private static final Logger log = LoggerFactory.getLogger(ExportRosterItemAction.class);

    public ExportRosterItemAction(String pName, Component pWho) {
        super(pName, pWho);
    }

    @Override
    protected boolean selectFrom() {
        return this.selectExistingFromEntry();
    }

    @Override
    boolean selectTo() {
        return this.selectNewToFile();
    }

    @Override
    boolean doTransfer() {
        Element lroot;
        FileUtil.createDirectory(Roster.getDefault().getRosterFilesLocation());
        LocoFile lf = new LocoFile();
        try {
            lroot = lf.rootFromName(this.mFullFromFilename).clone();
        }
        catch (Exception e) {
            log.error("Exception while loading loco XML file: {}", (Object)this.mFullFromFilename, (Object)e);
            return false;
        }
        this.mToEntry = new RosterEntry(this.mFromEntry, this.mFromID);
        LocoFile newLocoFile = new LocoFile();
        this.mToEntry.setFileName(this.mToFilename);
        this.mToEntry.setId(this.mFromEntry.getId());
        newLocoFile.writeFile(this.mToFile, lroot, this.mToEntry);
        return true;
    }

    @Override
    void updateRoster() {
    }
}

